/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.fpcf;

import org.opalj.fpcf.analysis.FPCFAnalysisRunner;
import org.opalj.fpcf.analysis.FactoryMethodAnalysis$;
import org.opalj.fpcf.analysis.LibraryEntryPointsAnalysis$;
import org.opalj.fpcf.analysis.MethodAccessibilityAnalysis$;
import org.opalj.fpcf.analysis.SimpleInstantiabilityAnalysis$;
import org.opalj.fpcf.analysis.fields.FieldMutabilityAnalysis$;
import org.opalj.fpcf.analysis.methods.CallableFromClassesInOtherPackagesAnalysis$;
import org.opalj.fpcf.analysis.methods.PurityAnalysis$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.Map;

public final class FPCFAnalysesRegistry$ {
    public static final FPCFAnalysesRegistry$ MODULE$;
    private Map<String, FPCFAnalysisRunner> idToFactory;
    private Map<String, String> idToDescription;

    static {
        new FPCFAnalysesRegistry$();
    }

    public synchronized void register(String analysisID, String analysisDescription, FPCFAnalysisRunner analysisFactory) {
        this.idToFactory = this.idToFactory.$plus(new Tuple2((Object)analysisID, (Object)analysisFactory));
        this.idToDescription = this.idToDescription.$plus(new Tuple2((Object)analysisID, (Object)analysisDescription));
    }

    public synchronized Iterable<String> analysisIDs() {
        return this.idToFactory.keys();
    }

    public synchronized Iterable<String> analysisDescriptions() {
        return this.idToDescription.values();
    }

    public synchronized Iterable<FPCFAnalysisRunner> factories() {
        return this.idToFactory.values();
    }

    public synchronized FPCFAnalysisRunner factory(String id) {
        return (FPCFAnalysisRunner)this.idToFactory.apply((Object)id);
    }

    private FPCFAnalysesRegistry$() {
        MODULE$ = this;
        this.idToFactory = Predef$.MODULE$.Map().empty();
        this.idToDescription = Predef$.MODULE$.Map().empty();
        this.register("MethodAccessibilityAnalysis", "Computes the project accessibility property of methods w.r.t. clients.", MethodAccessibilityAnalysis$.MODULE$);
        this.register("FactoryMethodAnalysis", "Determines if a static method is an accessible factory method w.r.t. clients.", FactoryMethodAnalysis$.MODULE$);
        this.register("InstantiabilityAnalysis", "Computes if a class can (possibly) be instantiated.", SimpleInstantiabilityAnalysis$.MODULE$);
        this.register("CallableFromClassesInOtherPackagesAnalysis", "Computes whether a non-static method can be called via an super or subclass.", CallableFromClassesInOtherPackagesAnalysis$.MODULE$);
        this.register("LibraryEntryPointAnalysis", "Computes the entry points of a library.", LibraryEntryPointsAnalysis$.MODULE$);
        this.register("FieldMutabilityAnalysis", "Determines if fields are (effectively) final.", FieldMutabilityAnalysis$.MODULE$);
        this.register("PurityAnalysis", "Determines if a method is pure (~ has no side effects).", PurityAnalysis$.MODULE$);
    }
}

