/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.tac;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicInteger;
import org.opalj.ai.AIResult;
import org.opalj.ai.common.SimpleAIKey$;
import org.opalj.ai.domain.RecordDefUse;
import org.opalj.br.Code;
import org.opalj.br.Method;
import org.opalj.br.analyses.BasicReport;
import org.opalj.br.analyses.DefaultOneStepAnalysis;
import org.opalj.br.analyses.MethodInfo;
import org.opalj.br.analyses.Project;
import org.opalj.br.analyses.ProjectInformationKey;
import org.opalj.br.cfg.CFGNode;
import org.opalj.graphs.MutableNodeLike;
import org.opalj.graphs.package$;
import org.opalj.tac.DefaultTACAIKey$;
import org.opalj.tac.TACode;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.runtime.BoxesRunTime;

public final class TACAItoGraphs$
extends DefaultOneStepAnalysis {
    public static TACAItoGraphs$ MODULE$;

    static {
        new TACAItoGraphs$();
    }

    public String title() {
        return "CFG and Def/Use Creator";
    }

    public String description() {
        return "Creates for all methods of a given project the Control-flow Graph and the DefUse Graph.";
    }

    public String analysisSpecificParametersDescription() {
        return "-o=<the folder to which the generated graphs are written>";
    }

    public Seq<String> checkAnalysisSpecificParameters(Seq<String> parameters) {
        return parameters.size() == 1 && ((String)parameters.head()).startsWith("-o=") ? (Seq)Seq$.MODULE$.empty() : (parameters.isEmpty() ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"output folder is missing"})) : (Seq)((TraversableLike)parameters.filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.startsWith("-o=")))).map((Function1 & Serializable & scala.Serializable)x$2 -> new StringBuilder(19).append("unknown parameter: ").append((String)x$2).toString(), Seq$.MODULE$.canBuildFrom()));
    }

    public BasicReport doAnalyze(Project<URL> theProject, Seq<String> parameters, Function0<Object> isInterrupted) {
        AtomicInteger methodCount = new AtomicInteger(0);
        File folder = new File(((String)parameters.head()).substring(3));
        folder.mkdirs();
        String pathName = Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)folder.getAbsoluteFile()), File.separator);
        Function1 aiResults = (Function1)theProject.get((ProjectInformationKey)SimpleAIKey$.MODULE$);
        Function1 tacs = (Function1)theProject.get((ProjectInformationKey)DefaultTACAIKey$.MODULE$);
        theProject.parForeachMethodWithBody(theProject.parForeachMethodWithBody$default$1(), theProject.parForeachMethodWithBody$default$2(), (Function1 & Serializable & scala.Serializable)mi -> BoxesRunTime.boxToInteger((int)TACAItoGraphs$.$anonfun$doAnalyze$1(methodCount, pathName, aiResults, tacs, mi)));
        return new BasicReport(new StringBuilder(46).append("Created ").append(methodCount.get()).append(" def/use and control-flow graphs in: ").append(folder).append(".").toString());
    }

    private static final Set successors$1(int i, Map nodeToIdMap$1, Map idToNodeMap$1) {
        return ((TraversableOnce)((MutableNodeLike)idToNodeMap$1.apply((Object)BoxesRunTime.boxToInteger((int)i))).children().map((Function1)nodeToIdMap$1, List$.MODULE$.canBuildFrom())).toSet();
    }

    private static final Set successors$2(int i, Map nodeToIdMap$2, Map idToNodeMap$2) {
        return (Set)((CFGNode)idToNodeMap$2.apply((Object)BoxesRunTime.boxToInteger((int)i))).successors().map((Function1)nodeToIdMap$2, Set$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ int $anonfun$doAnalyze$1(AtomicInteger methodCount$1, String pathName$1, Function1 aiResults$1, Function1 tacs$1, MethodInfo mi) {
        Method m = mi.method();
        String methodName = m.toJava();
        String outputFileName = new StringBuilder(0).append(pathName$1).append(org.opalj.io.package$.MODULE$.sanitizeFileName(methodName)).toString();
        Set defUseGraph = ((RecordDefUse)((AIResult)aiResults$1.apply((Object)m)).domain()).createDefUseGraph((Code)m.body().get());
        Set nodeToId = (Set)defUseGraph.zipWithIndex(Set$.MODULE$.canBuildFrom());
        Map nodeToIdMap = nodeToId.toMap(Predef$.MODULE$.$conforms());
        Map idToNodeMap = ((TraversableOnce)nodeToId.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.swap(), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        int maxNodeId = nodeToIdMap.size() - 1;
        Path outputDUGFile = new File(new StringBuilder(8).append(outputFileName).append(".dug.csv").toString()).toPath();
        byte[] g = package$.MODULE$.toAdjacencyMatrix(maxNodeId, (Function1 & Serializable & scala.Serializable)i -> TACAItoGraphs$.successors$1(BoxesRunTime.unboxToInt((Object)i), nodeToIdMap, idToNodeMap));
        Predef$.MODULE$.println((Object)new StringBuilder(18).append("writing graph to: ").append(outputDUGFile).toString());
        Files.write(outputDUGFile, g, new OpenOption[0]);
        Map nodeToIdMap2 = ((TACode)tacs$1.apply((Object)m)).cfg().allNodes().zipWithIndex().toMap(Predef$.MODULE$.$conforms());
        Map idToNodeMap2 = nodeToIdMap2.iterator().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.swap()).toMap(Predef$.MODULE$.$conforms());
        int maxNodeId2 = nodeToIdMap2.size() - 1;
        Path outputCFGFile = new File(new StringBuilder(8).append(outputFileName).append(".cfg.csv").toString()).toPath();
        byte[] g2 = package$.MODULE$.toAdjacencyMatrix(maxNodeId2, (Function1 & Serializable & scala.Serializable)i -> TACAItoGraphs$.successors$2(BoxesRunTime.unboxToInt((Object)i), nodeToIdMap2, idToNodeMap2));
        Predef$.MODULE$.println((Object)new StringBuilder(18).append("writing graph to: ").append(outputCFGFile).toString());
        Files.write(outputCFGFile, g2, new OpenOption[0]);
        return methodCount$1.incrementAndGet();
    }

    private TACAItoGraphs$() {
        MODULE$ = this;
    }
}

