/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.fpcf.analyses;

import java.io.Serializable;
import java.net.URL;
import org.opalj.br.ClassFile;
import org.opalj.br.ObjectType;
import org.opalj.br.analyses.BasicReport;
import org.opalj.br.analyses.DefaultOneStepAnalysis;
import org.opalj.br.analyses.Project;
import org.opalj.br.analyses.ProjectInformationKey;
import org.opalj.fpcf.EPS;
import org.opalj.fpcf.Property;
import org.opalj.fpcf.PropertyKey;
import org.opalj.fpcf.PropertyKind;
import org.opalj.fpcf.PropertyStore;
import org.opalj.fpcf.PropertyStoreKey$;
import org.opalj.fpcf.analyses.L0SelfReferenceLeakageAnalysis$;
import org.opalj.fpcf.properties.DoesNotLeakSelfReference$;
import org.opalj.fpcf.properties.SelfReferenceLeakage$;
import org.opalj.util.Nanoseconds;
import org.opalj.util.Nanoseconds$;
import org.opalj.util.PerformanceEvaluation$;
import org.opalj.util.Seconds;
import org.opalj.util.Seconds$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.java8.JFunction0;

public final class SelfReferenceLeakageAnalysisDemo$
extends DefaultOneStepAnalysis {
    public static SelfReferenceLeakageAnalysisDemo$ MODULE$;

    static {
        new SelfReferenceLeakageAnalysisDemo$();
    }

    public String title() {
        return "Analyses whether a class leaks it self-reference this";
    }

    public String description() {
        return "Determines if a class leaks its self reference, if not, then the method which instantiates the object has full control.";
    }

    public BasicReport doAnalyze(Project<URL> project, Seq<String> parameters, Function0<Object> isInterrupted) {
        PropertyStore projectStore = (PropertyStore)project.get((ProjectInformationKey)PropertyStoreKey$.MODULE$);
        DoubleRef analysisTime = DoubleRef.create((double)Seconds$.MODULE$.None());
        PerformanceEvaluation$.MODULE$.time((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            projectStore.setupPhase((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new PropertyKind[]{new PropertyKey(SelfReferenceLeakage$.MODULE$.Key())})), projectStore.setupPhase$default$2());
            L0SelfReferenceLeakageAnalysis$.MODULE$.start(project, null);
            projectStore.waitOnPhaseCompletion();
        }, (Function1 & Serializable & scala.Serializable)t -> {
            analysisTime.elem = Nanoseconds$.MODULE$.toSeconds$extension(((Nanoseconds)t).timeSpan());
            return BoxedUnit.UNIT;
        });
        Iterator notLeakingEntities = projectStore.entities(SelfReferenceLeakage$.MODULE$.Key()).filter((Function1 & Serializable & scala.Serializable)eps -> BoxesRunTime.boxToBoolean((boolean)SelfReferenceLeakageAnalysisDemo$.$anonfun$doAnalyze$3(eps)));
        Iterator notLeakingClasses = notLeakingEntities.map((Function1 & Serializable & scala.Serializable)eps -> {
            ClassFile classFile = (ClassFile)eps.e();
            ObjectType classType = classFile.thisType();
            String className = classFile.thisType().toJava();
            return project.classHierarchy().isInterface(classType).isYes() ? new StringBuilder(10).append("interface ").append(className).toString() : new StringBuilder(6).append("class ").append(className).toString();
        });
        String leakageInfo = ((TraversableOnce)notLeakingClasses.toList().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\nClasses not leaking self reference:\n", "\n", new StringBuilder(9).append("\nTotal: ").append(notLeakingEntities.size()).append("\n").toString());
        return new BasicReport(new StringBuilder(16).append(leakageInfo).append(projectStore).append("\nAnalysis time: ").append(new Seconds(analysisTime.elem)).toString());
    }

    public static final /* synthetic */ boolean $anonfun$doAnalyze$3(EPS eps) {
        Property property = eps.lb();
        DoesNotLeakSelfReference$ doesNotLeakSelfReference$ = DoesNotLeakSelfReference$.MODULE$;
        return !(property != null ? !property.equals(doesNotLeakSelfReference$) : doesNotLeakSelfReference$ != null);
    }

    private SelfReferenceLeakageAnalysisDemo$() {
        MODULE$ = this;
    }
}

