/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.fpcf.analyses;

import java.io.Serializable;
import java.lang.management.MemoryMXBean;
import java.net.URL;
import org.opalj.br.ClassFile;
import org.opalj.br.analyses.BasicReport;
import org.opalj.br.analyses.DefaultOneStepAnalysis;
import org.opalj.br.analyses.Project;
import org.opalj.br.analyses.Project$;
import org.opalj.br.analyses.ProjectInformationKey;
import org.opalj.fpcf.EPS;
import org.opalj.fpcf.PropertyKey;
import org.opalj.fpcf.PropertyKind;
import org.opalj.fpcf.PropertyStore;
import org.opalj.fpcf.PropertyStoreKey$;
import org.opalj.fpcf.analyses.EagerClassImmutabilityAnalysis$;
import org.opalj.fpcf.analyses.EagerTypeImmutabilityAnalysis$;
import org.opalj.fpcf.analyses.LazyL0FieldMutabilityAnalysis$;
import org.opalj.fpcf.properties.ClassImmutability$;
import org.opalj.fpcf.properties.FieldMutability$;
import org.opalj.fpcf.properties.TypeImmutability$;
import org.opalj.util.Nanoseconds;
import org.opalj.util.Nanoseconds$;
import org.opalj.util.PerformanceEvaluation$;
import org.opalj.util.Seconds;
import org.opalj.util.Seconds$;
import org.opalj.util.package$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class ImmutabilityAnalysisDemo$
extends DefaultOneStepAnalysis {
    public static ImmutabilityAnalysisDemo$ MODULE$;
    private long setupTime;
    private long analysisTime;
    private Map<Nanoseconds, List<Nanoseconds>> performanceData;

    static {
        new ImmutabilityAnalysisDemo$();
    }

    public String title() {
        return "determines the immutability of objects and types";
    }

    public String description() {
        return "determines the immutability of objects and types";
    }

    public BasicReport doAnalyze(Project<URL> project, Seq<String> parameters, Function0<Object> isInterrupted) {
        ObjectRef r = ObjectRef.create(null);
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 4, 8, 16, 32, 64})).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)parallelismLevel -> {
            ImmutabilityAnalysisDemo$.MODULE$.performanceData = Predef$.MODULE$.Map().empty();
            MemoryMXBean x$2 = package$.MODULE$.gc$default$1();
            long x$3 = package$.MODULE$.gc$default$2();
            Option x$4 = package$.MODULE$.gc$default$3(x$2, x$3);
            package$.MODULE$.gc(x$2, x$3, x$4);
            Predef$.MODULE$.println((Object)new StringBuilder(34).append("\nRunning analysis with ").append(parallelismLevel).append(" thread(s):").toString());
            r$1.elem = (Function0)PerformanceEvaluation$.MODULE$.time(10, 50, 15, (Function0 & Serializable & scala.Serializable)() -> MODULE$.analyze(project, parallelismLevel), PerformanceEvaluation$.MODULE$.time$default$5(), (Function2 & Serializable & scala.Serializable)(t, ts) -> {
                this.handleResults$1(((Nanoseconds)t).timeSpan(), ts);
                return BoxedUnit.UNIT;
            });
            Predef$.MODULE$.println((Object)new StringBuilder(23).append("Results with ").append(parallelismLevel).append(" threads:\n").append(((TraversableOnce)((TraversableLike)ImmutabilityAnalysisDemo$.MODULE$.performanceData.values().map((Function1 & Serializable & scala.Serializable)v -> (List)v.map((Function1 & Serializable & scala.Serializable)x$1 -> Seconds$.MODULE$.toString$extension0(Nanoseconds$.MODULE$.toSeconds$extension(((Nanoseconds)x$1).timeSpan()), false), List$.MODULE$.canBuildFrom()), scala.collection.Iterable$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)v -> ((TraversableOnce)((List)new .colon.colon((Object)"setup\t", (List)new .colon.colon((Object)"analysis\t", (List)Nil$.MODULE$)).zip((GenIterable)v, List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)e -> new StringBuilder(0).append((String)e._1()).append(e._2()).toString(), List$.MODULE$.canBuildFrom())).mkString("", "\n", "\n"), scala.collection.Iterable$.MODULE$.canBuildFrom())).mkString("\n")).toString());
            MemoryMXBean x$5 = package$.MODULE$.gc$default$1();
            long x$6 = package$.MODULE$.gc$default$2();
            Option x$7 = package$.MODULE$.gc$default$3(x$5, x$6);
            package$.MODULE$.gc(x$5, x$6, x$7);
        });
        return new BasicReport((String)((Function0)r.elem).apply());
    }

    public Function0<String> analyze(Project<URL> theProject, int parallelismLevel) {
        String result = "Results:\n";
        Project project = Project$.MODULE$.recreate(theProject, Project$.MODULE$.recreate$default$2(), Project$.MODULE$.recreate$default$3());
        PropertyStore propertyStore = (PropertyStore)PerformanceEvaluation$.MODULE$.time((Function0 & Serializable & scala.Serializable)() -> {
            PropertyStoreKey$.MODULE$.parallelismLevel_$eq(parallelismLevel);
            return (PropertyStore)project.get((ProjectInformationKey)PropertyStoreKey$.MODULE$);
        }, (Function1 & Serializable & scala.Serializable)r -> {
            ImmutabilityAnalysisDemo$.MODULE$.setupTime = ((Nanoseconds)r).timeSpan();
            return BoxedUnit.UNIT;
        });
        PerformanceEvaluation$.MODULE$.time((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            propertyStore.setupPhase((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new PropertyKind[]{new PropertyKey(FieldMutability$.MODULE$.key()), new PropertyKey(ClassImmutability$.MODULE$.key()), new PropertyKey(TypeImmutability$.MODULE$.key())})), propertyStore.setupPhase$default$2());
            LazyL0FieldMutabilityAnalysis$.MODULE$.startLazily(project, propertyStore, null);
            EagerClassImmutabilityAnalysis$.MODULE$.start(project, propertyStore, null);
            EagerTypeImmutabilityAnalysis$.MODULE$.start(project, propertyStore, null);
            propertyStore.waitOnPhaseCompletion();
        }, (Function1 & Serializable & scala.Serializable)r -> {
            ImmutabilityAnalysisDemo$.MODULE$.analysisTime = ((Nanoseconds)r).timeSpan();
            return BoxedUnit.UNIT;
        });
        result = new StringBuilder(0).append(result).append(new StringBuilder(19).append("\t- analysis time: ").append(new Seconds(Nanoseconds$.MODULE$.toSeconds$extension(this.analysisTime))).append("\n").toString()).toString();
        return (Function0 & Serializable & scala.Serializable)() -> {
            Map immutableClasses = (Map)propertyStore.entities(ClassImmutability$.MODULE$.key()).filter((Function1 & Serializable & scala.Serializable)eps -> BoxesRunTime.boxToBoolean((boolean)ImmutabilityAnalysisDemo$.$anonfun$analyze$6(eps))).toBuffer().groupBy((Function1 & Serializable & scala.Serializable)eps -> eps.ub()).map((Function1 & Serializable & scala.Serializable)kv -> new Tuple2(kv._1(), ((TraversableOnce)kv._2()).toList().sortWith((Function2 & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)ImmutabilityAnalysisDemo$.$anonfun$analyze$9(a, b)))), Map$.MODULE$.canBuildFrom());
            String immutableClassesPerCategory = ((TraversableOnce)((TraversableOnce)immutableClasses.map((Function1 & Serializable & scala.Serializable)kv -> new StringBuilder(4).append("\t\t").append(kv._1()).append(": ").append(((SeqLike)kv._2()).size()).toString(), Iterable$.MODULE$.canBuildFrom())).toBuffer().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n");
            Map immutableTypes = (Map)propertyStore.entities(TypeImmutability$.MODULE$.key()).filter((Function1 & Serializable & scala.Serializable)eps -> BoxesRunTime.boxToBoolean((boolean)ImmutabilityAnalysisDemo$.$anonfun$analyze$11(eps))).toBuffer().groupBy((Function1 & Serializable & scala.Serializable)eps -> eps.ub()).map((Function1 & Serializable & scala.Serializable)kv -> new Tuple2(kv._1(), (Object)BoxesRunTime.boxToInteger((int)((SeqLike)kv._2()).size())), Map$.MODULE$.canBuildFrom());
            String immutableTypesPerCategory = ((TraversableOnce)((TraversableOnce)immutableTypes.map((Function1 & Serializable & scala.Serializable)kv -> new StringBuilder(4).append("\t\t").append(kv._1()).append(": ").append(kv._2$mcI$sp()).toString(), Iterable$.MODULE$.canBuildFrom())).toBuffer().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n");
            String immutableClassesInfo = ((TraversableOnce)((TraversableLike)((TraversableLike)immutableClasses.values().flatten((Function1)Predef$.MODULE$.$conforms())).filter((Function1 & Serializable & scala.Serializable)ep -> BoxesRunTime.boxToBoolean((boolean)ImmutabilityAnalysisDemo$.$anonfun$analyze$15(ep)))).map((Function1 & Serializable & scala.Serializable)eps -> new StringBuilder(8).append(((ClassFile)eps.e()).thisType().toJava()).append(" => ").append(eps.ub()).append(" => ").append(propertyStore.apply(eps.e(), TypeImmutability$.MODULE$.key()).ub()).toString(), scala.collection.Iterable$.MODULE$.canBuildFrom())).mkString("\t\timmutability:\n\t\t", "\n\t\t", "\n");
            return new StringBuilder(83).append("\t- details:\n").append(immutableClassesInfo).append("\nSummary (w.r.t classes):\n").append("\tObject Immutability:\n").append(immutableClassesPerCategory).append("\n").append("\tType Immutability:\n").append(immutableTypesPerCategory).append("\n").append("\n").append(propertyStore.toString(false)).toString();
        };
    }

    private final void handleResults$1(long t, Seq ts) {
        this.performanceData = this.performanceData.$plus(new Tuple2((Object)new Nanoseconds(t), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Nanoseconds[]{new Nanoseconds(this.setupTime), new Nanoseconds(this.analysisTime)}))));
        this.performanceData = (Map)this.performanceData.filter((Function1 & Serializable & scala.Serializable)t_ts -> BoxesRunTime.boxToBoolean((boolean)ts.contains(t_ts._1())));
    }

    public static final /* synthetic */ boolean $anonfun$analyze$6(EPS eps) {
        return !((ClassFile)eps.e()).isInterfaceDeclaration();
    }

    public static final /* synthetic */ boolean $anonfun$analyze$9(EPS a, EPS b) {
        ClassFile cfA = (ClassFile)a.e();
        ClassFile cfB = (ClassFile)b.e();
        return new StringOps(Predef$.MODULE$.augmentString(cfA.thisType().toJava())).$less((Object)cfB.thisType().toJava());
    }

    public static final /* synthetic */ boolean $anonfun$analyze$11(EPS eps) {
        return !((ClassFile)eps.e()).isInterfaceDeclaration();
    }

    public static final /* synthetic */ boolean $anonfun$analyze$15(EPS ep) {
        return !((ClassFile)ep.e()).isInterfaceDeclaration();
    }

    private ImmutabilityAnalysisDemo$() {
        MODULE$ = this;
        this.setupTime = Nanoseconds$.MODULE$.None();
        this.analysisTime = Nanoseconds$.MODULE$.None();
        this.performanceData = Predef$.MODULE$.Map().empty();
    }
}

