/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.de;

import java.io.File;
import java.io.Serializable;
import org.opalj.br.ClassFile;
import org.opalj.br.VirtualSourceElement;
import org.opalj.br.reader.Java8Framework$;
import org.opalj.de.DependencyExtractor;
import org.opalj.de.DependencyProcessor;
import org.opalj.de.DependencyProcessorAdapter;
import org.opalj.util.Nanoseconds;
import org.opalj.util.Nanoseconds$;
import org.opalj.util.PerformanceEvaluation$;
import org.opalj.util.Seconds;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;

public final class DependencyMatrix$ {
    public static DependencyMatrix$ MODULE$;

    static {
        new DependencyMatrix$();
    }

    private void printUsage() {
        Predef$.MODULE$.println((Object)"Loads all classes stored in the jar files and creates a dependency matrix.");
        Predef$.MODULE$.println((Object)"Usage: java \u2026DependencyMatrix <JAR file containing class files>+");
    }

    public void main(String[] args) {
        if (args.length == 0 || !new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).forall((Function1 & Serializable & scala.Serializable)arg -> BoxesRunTime.boxToBoolean((boolean)DependencyMatrix$.$anonfun$main$1(arg)))) {
            this.printUsage();
            throw package$.MODULE$.exit(1);
        }
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).foreach((Function1 & Serializable & scala.Serializable)arg -> {
            DependencyMatrix$.$anonfun$main$2(arg);
            return BoxedUnit.UNIT;
        });
        this.analyze(args);
        throw package$.MODULE$.exit(0);
    }

    public void analyze(String[] jarFiles) {
        Map dependencyMatrix = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        DependencyExtractor dependencyExtractor = new DependencyExtractor((DependencyProcessor)new DependencyProcessorAdapter(dependencyMatrix){
            private final Map dependencyMatrix$1;

            public void processDependency(VirtualSourceElement source, VirtualSourceElement target, Enumeration.Value dType) {
                Option option = this.dependencyMatrix$1.get((Object)source);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Set s = (Set)some.value();
                    s.$plus$eq((Object)new Tuple2((Object)target, (Object)dType));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (None$.MODULE$.equals(option)) {
                    this.dependencyMatrix$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)source), (Object)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)target, (Object)dType)}))));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)option);
                }
            }
            {
                this.dependencyMatrix$1 = dependencyMatrix$1;
            }
        });
        Predef$.MODULE$.println((Object)new StringBuilder(27).append("Reading all class files - ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])jarFiles)).mkString(", ")).append(".").toString());
        IntRef count = IntRef.create((int)0);
        PerformanceEvaluation$.MODULE$.time((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])jarFiles)).foreach((Function1 & Serializable & scala.Serializable)jarFile -> {
            DependencyMatrix$.$anonfun$analyze$2(dependencyExtractor, count, jarFile);
            return BoxedUnit.UNIT;
        }), (Function1 & Serializable & scala.Serializable)t -> {
            Predef$.MODULE$.println((Object)new StringBuilder(66).append("\nReading all ").append(count.elem).append(" class files and building the dependency matrix took ").append(new Seconds(Nanoseconds$.MODULE$.toSeconds$extension(((Nanoseconds)t).timeSpan()))).toString());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$main$1(String arg) {
        return arg.endsWith(".zip") || arg.endsWith(".jar");
    }

    public static final /* synthetic */ void $anonfun$main$2(String arg) {
        File file = new File(arg);
        if (!file.canRead() || file.isDirectory()) {
            Predef$.MODULE$.println((Object)new StringBuilder(29).append(arg).append(" is not a valid ZIP/Jar file.").toString());
            MODULE$.printUsage();
            throw package$.MODULE$.exit(1);
        }
    }

    public static final /* synthetic */ boolean $anonfun$analyze$3(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$analyze$4(DependencyExtractor dependencyExtractor$1, IntRef count$1, Tuple2 x$1) {
        ClassFile classFile;
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            classFile = (ClassFile)tuple2._1();
            ++count$1.elem;
        } else {
            throw new MatchError((Object)tuple2);
        }
        dependencyExtractor$1.process(classFile);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$analyze$2(DependencyExtractor dependencyExtractor$1, IntRef count$1, String jarFile) {
        Java8Framework$.MODULE$.ClassFiles(new File(jarFile), Java8Framework$.MODULE$.ClassFiles$default$2()).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)DependencyMatrix$.$anonfun$analyze$3(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            DependencyMatrix$.$anonfun$analyze$4(dependencyExtractor$1, count$1, x$1);
            return BoxedUnit.UNIT;
        });
    }

    private DependencyMatrix$() {
        MODULE$ = this;
    }
}

