/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.de;

import com.typesafe.config.Config;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import org.opalj.br.VirtualSourceElement;
import org.opalj.br.analyses.Analysis;
import org.opalj.br.analyses.AnalysisExecutor;
import org.opalj.br.analyses.BasicReport;
import org.opalj.br.analyses.OneStepAnalysis;
import org.opalj.br.analyses.ProgressManagement;
import org.opalj.br.analyses.Project;
import org.opalj.de.DependencyCountingDependencyProcessor;
import org.opalj.de.DependencyExtractor;
import org.opalj.de.DependencyProcessor;
import org.opalj.de.FilterSelfDependencies;
import org.opalj.log.LogContext;
import org.opalj.util.Nanoseconds;
import org.opalj.util.PerformanceEvaluation$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.immutable.StringOps;
import scala.collection.parallel.ParIterableLike;
import scala.io.StdIn$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class DependencyCounting$
implements AnalysisExecutor,
OneStepAnalysis<URL, BasicReport> {
    public static DependencyCounting$ MODULE$;
    private final DependencyCounting$ analysis;

    static {
        new DependencyCounting$();
    }

    public final Object analyze(Project project, Seq parameters, Function1 initProgressManagement) {
        return OneStepAnalysis.analyze$((OneStepAnalysis)this, (Project)project, (Seq)parameters, (Function1)initProgressManagement);
    }

    public Seq<String> doAnalyze$default$2() {
        return OneStepAnalysis.doAnalyze$default$2$((OneStepAnalysis)this);
    }

    public final Seq<String> analyze$default$2() {
        return OneStepAnalysis.analyze$default$2$((OneStepAnalysis)this);
    }

    public final Function1<Object, ProgressManagement> analyze$default$3() {
        return OneStepAnalysis.analyze$default$3$((OneStepAnalysis)this);
    }

    public Option<String> documentationUrl() {
        return Analysis.documentationUrl$((Analysis)this);
    }

    public String copyright() {
        return Analysis.copyright$((Analysis)this);
    }

    public String title() {
        return Analysis.title$((Analysis)this);
    }

    public String analysisSpecificParametersDescription() {
        return AnalysisExecutor.analysisSpecificParametersDescription$((AnalysisExecutor)this);
    }

    public Traversable<String> checkAnalysisSpecificParameters(Seq<String> parameters) {
        return AnalysisExecutor.checkAnalysisSpecificParameters$((AnalysisExecutor)this, parameters);
    }

    public void printUsage(LogContext logContext) {
        AnalysisExecutor.printUsage$((AnalysisExecutor)this, (LogContext)logContext);
    }

    public void main(String[] args) {
        AnalysisExecutor.main$((AnalysisExecutor)this, (String[])args);
    }

    public void handleParsingExceptions(Project<?> project, Traversable<Throwable> exceptions) {
        AnalysisExecutor.handleParsingExceptions$((AnalysisExecutor)this, project, exceptions);
    }

    public Project<URL> setupProject(Iterable<File> cpFiles, Iterable<File> libcpFiles, boolean completelyLoadLibraries, Enumeration.Value projectType, Config fallbackConfiguration, LogContext initialLogContext) {
        return AnalysisExecutor.setupProject$((AnalysisExecutor)this, cpFiles, libcpFiles, (boolean)completelyLoadLibraries, (Enumeration.Value)projectType, (Config)fallbackConfiguration, (LogContext)initialLogContext);
    }

    public DependencyCounting$ analysis() {
        return this.analysis;
    }

    public String description() {
        return "counts the number of inter-source element dependencies";
    }

    public BasicReport doAnalyze(Project<URL> project, Seq<String> parameters, Function0<Object> isInterrupted) {
        Predef$.MODULE$.println((Object)"Press enter to start the dependency collection.");
        StdIn$.MODULE$.readLine();
        DependencyCountingDependencyProcessor counter = (DependencyCountingDependencyProcessor)PerformanceEvaluation$.MODULE$.time((Function0 & Serializable & scala.Serializable)() -> {
            void var1_1;
            FilterSelfDependencies counter = new FilterSelfDependencies(){

                public /* synthetic */ void org$opalj$de$FilterSelfDependencies$$super$processDependency(VirtualSourceElement source, VirtualSourceElement target, Enumeration.Value dType) {
                    super.processDependency(source, target, dType);
                }

                public void processDependency(VirtualSourceElement source, VirtualSourceElement target, Enumeration.Value dType) {
                    FilterSelfDependencies.processDependency$((FilterSelfDependencies)this, (VirtualSourceElement)source, (VirtualSourceElement)target, (Enumeration.Value)dType);
                }
                {
                    FilterSelfDependencies.$init$((FilterSelfDependencies)this);
                }
            };
            DependencyExtractor extractor = new DependencyExtractor((DependencyProcessor)counter);
            ((ParIterableLike)project.allClassFiles().par()).foreach((Function1 & Serializable & scala.Serializable)classFile -> {
                extractor.process(classFile);
                return BoxedUnit.UNIT;
            });
            return var1_1;
        }, (Function1 & Serializable & scala.Serializable)t -> {
            Predef$.MODULE$.println((Object)new StringBuilder(39).append("[info] Time to count the dependencies: ").append(new Nanoseconds(((Nanoseconds)t).timeSpan())).toString());
            return BoxedUnit.UNIT;
        });
        int arg$macro$1 = counter.currentDependencyCount();
        int arg$macro$2 = counter.currentDependencyOnPrimitivesCount();
        int arg$macro$3 = counter.currentDependencyOnArraysCount();
        return new BasicReport(new StringBuilder(0).append(new StringOps("Number of inter source-element dependencies: %,9d%n").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)arg$macro$1)}))).append(new StringOps("Number of dependencies on primitive types:   %,9d%n").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)arg$macro$2)}))).append(new StringOps("Number of dependencies on array types:       %,9d%n").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)arg$macro$3)}))).toString());
    }

    private DependencyCounting$() {
        MODULE$ = this;
        AnalysisExecutor.$init$((AnalysisExecutor)this);
        Analysis.$init$((Analysis)this);
        OneStepAnalysis.$init$((OneStepAnalysis)this);
        this.analysis = this;
    }
}

