/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.br.analyses.observers;

import java.io.Serializable;
import java.net.URL;
import org.opalj.br.ArrayType;
import org.opalj.br.ArrayType$;
import org.opalj.br.ClassFile;
import org.opalj.br.ClassHierarchy;
import org.opalj.br.ClassTypeSignature;
import org.opalj.br.Code;
import org.opalj.br.Field;
import org.opalj.br.FieldType;
import org.opalj.br.FieldTypeSignature;
import org.opalj.br.JVMMethod;
import org.opalj.br.Method;
import org.opalj.br.ObjectType;
import org.opalj.br.SimpleGenericType$;
import org.opalj.br.analyses.BasicReport;
import org.opalj.br.analyses.DefaultOneStepAnalysis;
import org.opalj.br.analyses.Project;
import org.opalj.br.instructions.FieldReadAccess;
import org.opalj.br.instructions.FieldReadAccess$;
import org.opalj.br.instructions.Instruction;
import org.opalj.collection.immutable.ConstArray;
import org.opalj.collection.immutable.ConstArray$;
import org.opalj.collection.immutable.RefArray;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class ObserverPatternUsage$
extends DefaultOneStepAnalysis {
    public static ObserverPatternUsage$ MODULE$;

    static {
        new ObserverPatternUsage$();
    }

    public String description() {
        return "Loads all classes stored in the jar files and analyses the usage of the observer pattern.";
    }

    public BasicReport doAnalyze(Project<URL> project, Seq<String> parameters, Function0<Object> isInterrupted) {
        ConstArray appClassFiles = project.allProjectClassFiles();
        ConstArray libClassFiles = project.allLibraryClassFiles();
        Predef$.MODULE$.println((Object)new StringBuilder(22).append("Application:\n\tClasses:").append(appClassFiles.size()).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(9).append("\tMethods:").append(appClassFiles.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable & scala.Serializable)(x$1, x$2) -> BoxesRunTime.boxToInteger((int)ObserverPatternUsage$.$anonfun$doAnalyze$1(BoxesRunTime.unboxToInt((Object)x$1), x$2)))).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(18).append("\tNon-final Fields:").append(appClassFiles.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable & scala.Serializable)(x$4, x$5) -> BoxesRunTime.boxToInteger((int)ObserverPatternUsage$.$anonfun$doAnalyze$3(BoxesRunTime.unboxToInt((Object)x$4), x$5)))).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(18).append("Library:\n\tClasses:").append(libClassFiles.size()).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(8).append("Overall ").append(project.statistics()).toString());
        Set appTypes = ((TraversableOnce)appClassFiles.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.thisType(), ConstArray$.MODULE$.canBuildFrom())).toSet();
        ClassHierarchy classHierarchy = project.classHierarchy();
        ObjectRef allObserverInterfaces = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
        ObjectRef appObserverInterfaces = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
        ObjectRef appObserverClasses = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
        ObjectRef observers = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
        classHierarchy.foreachKnownType((Function1 & Serializable & scala.Serializable)objectType -> {
            ObserverPatternUsage$.$anonfun$doAnalyze$6(appTypes, classHierarchy, allObserverInterfaces, appObserverInterfaces, appObserverClasses, observers, objectType);
            return BoxedUnit.UNIT;
        });
        Set allObservers = (Set)observers.elem;
        Set allObserverTypes = (Set)((Set)allObserverInterfaces.elem).$plus$plus((GenTraversableOnce)allObservers.filter((Function1 & Serializable & scala.Serializable)observerType -> BoxesRunTime.boxToBoolean((boolean)ObserverPatternUsage$.$anonfun$doAnalyze$8(project, allObserverInterfaces, observerType))));
        ObjectRef observerFields = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
        appTypes.foreach((Function1 & Serializable & scala.Serializable)appType -> {
            ObserverPatternUsage$.$anonfun$doAnalyze$12(project, allObserverTypes, observerFields, appType);
            return BoxedUnit.UNIT;
        });
        Set observerFields2 = (Set)observerFields.elem;
        Set observables = (Set)observerFields2.map((Function1 & Serializable & scala.Serializable)x$9 -> (ClassFile)x$9._1(), Set$.MODULE$.canBuildFrom());
        ObjectRef observerManagementMethods = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
        ObjectRef observerNotificationMethods = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
        ((IterableLike)observables.map((Function1 & Serializable & scala.Serializable)observable -> {
            ObjectType observableType = observable.thisType();
            Set omFieldNames = (Set)((SetLike)observerFields2.filter((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)ObserverPatternUsage$.$anonfun$doAnalyze$18(observable, x$10)))).map((Function1 & Serializable & scala.Serializable)x$11 -> ((Field)x$11._2()).name(), Set$.MODULE$.canBuildFrom());
            return new Tuple3(observable, (Object)observableType, (Object)omFieldNames);
        }, Set$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$12 -> {
            ObserverPatternUsage$.$anonfun$doAnalyze$20(allObserverInterfaces, observerManagementMethods, observerNotificationMethods, x$12);
            return BoxedUnit.UNIT;
        });
        return new BasicReport(new StringBuilder(38).append("\u001b[1mObserver types in project (").append(allObserverTypes.size()).append("): ").append("\u001b[0m").append(((TraversableOnce)allObserverTypes.map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.toJava(), Set$.MODULE$.canBuildFrom())).mkString(", ")).append(new StringBuilder(47).append("\u001b[1mObserver interfaces in application (").append(((Set)appObserverInterfaces.elem).size()).append("): ").append("\u001b[0m").append(((TraversableOnce)((Set)appObserverInterfaces.elem).map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.toJava(), Set$.MODULE$.canBuildFrom())).mkString(", ")).toString()).append(new StringBuilder(44).append("\u001b[1mObserver classes in application (").append(((Set)appObserverClasses.elem).size()).append("): ").append("\u001b[0m").append(((TraversableOnce)((Set)appObserverClasses.elem).map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.toJava(), Set$.MODULE$.canBuildFrom())).mkString(", ")).toString()).append(new StringBuilder(53).append("\u001b[1mFields to store observers in application (").append(observerFields2.size()).append("): ").append("\u001b[0m").append(((TraversableOnce)observerFields2.map((Function1 & Serializable & scala.Serializable)e -> new StringBuilder(5).append(((ClassFile)e._1()).thisType().toJava()).append("{ ").append(((Field)e._2()).fieldType().toJava()).append(" ").append(((Field)e._2()).name()).append(" }").toString(), Set$.MODULE$.canBuildFrom())).mkString(", ")).toString()).append(new StringBuilder(55).append("\u001b[1mMethods to manage observers in application (").append(((Set)observerManagementMethods.elem).size()).append("): ").append("\u001b[0m").append(((TraversableOnce)((Set)observerManagementMethods.elem).map((Function1 & Serializable & scala.Serializable)e -> new StringBuilder(4).append(((ClassFile)e._1()).thisType().toJava()).append("{ ").append(((JVMMethod)e._2()).signatureToJava(false)).append(" }").toString(), Set$.MODULE$.canBuildFrom())).mkString(", ")).toString()).append(new StringBuilder(65).append("\u001b[1mMethods that are related to observers in application (").append(((Set)observerNotificationMethods.elem).size()).append("): ").append("\u001b[0m").append(((TraversableOnce)((Set)observerNotificationMethods.elem).map((Function1 & Serializable & scala.Serializable)e -> new StringBuilder(4).append(((ClassFile)e._1()).thisType().toJava()).append("{ ").append(((JVMMethod)e._2()).signatureToJava(false)).append(" }").toString(), Set$.MODULE$.canBuildFrom())).mkString(", ")).toString()).toString());
    }

    public static final /* synthetic */ boolean $anonfun$doAnalyze$2(Method x$3) {
        return !x$3.isSynthetic();
    }

    public static final /* synthetic */ int $anonfun$doAnalyze$1(int x$1, ClassFile x$2) {
        return x$1 + x$2.methods().filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ObserverPatternUsage$.$anonfun$doAnalyze$2(x$3))).size();
    }

    public static final /* synthetic */ boolean $anonfun$doAnalyze$4(Field x$6) {
        return !x$6.isFinal();
    }

    public static final /* synthetic */ int $anonfun$doAnalyze$3(int x$4, ClassFile x$5) {
        return x$4 + x$5.fields().filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ObserverPatternUsage$.$anonfun$doAnalyze$4(x$6))).size();
    }

    public static final /* synthetic */ void $anonfun$doAnalyze$7(Set appTypes$1, ClassHierarchy classHierarchy$1, ObjectRef allObserverInterfaces$1, ObjectRef appObserverInterfaces$1, ObjectRef appObserverClasses$1, ObjectType objectType) {
        block1: {
            block0: {
                if (!classHierarchy$1.isInterface(objectType).isYes()) break block0;
                allObserverInterfaces$1.elem = (Set)((Set)allObserverInterfaces$1.elem).$plus((Object)objectType);
                if (!appTypes$1.contains((Object)objectType)) break block1;
                appObserverInterfaces$1.elem = (Set)((Set)appObserverInterfaces$1.elem).$plus((Object)objectType);
                break block1;
            }
            if (!appTypes$1.contains((Object)objectType)) break block1;
            appObserverClasses$1.elem = (Set)((Set)appObserverClasses$1.elem).$plus((Object)objectType);
        }
    }

    public static final /* synthetic */ void $anonfun$doAnalyze$6(Set appTypes$1, ClassHierarchy classHierarchy$1, ObjectRef allObserverInterfaces$1, ObjectRef appObserverInterfaces$1, ObjectRef appObserverClasses$1, ObjectRef observers$1, ObjectType objectType2) {
        block0: {
            String fqn = objectType2.fqn();
            if (((Set)observers$1.elem).contains((Object)objectType2) || !fqn.endsWith("Observer") && !fqn.endsWith("Listener")) break block0;
            Set observerTypes = classHierarchy$1.allSubtypes(objectType2, true);
            observers$1.elem = (Set)((Set)observers$1.elem).$plus$plus((GenTraversableOnce)observerTypes);
            observerTypes.foreach((Function1 & Serializable & scala.Serializable)objectType -> {
                ObserverPatternUsage$.$anonfun$doAnalyze$7(appTypes$1, classHierarchy$1, allObserverInterfaces$1, appObserverInterfaces$1, appObserverClasses$1, objectType);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ boolean $anonfun$doAnalyze$9(ObjectRef allObserverInterfaces$1, ObjectType x$8) {
        return ((Set)allObserverInterfaces$1.elem).contains((Object)x$8);
    }

    public static final /* synthetic */ boolean $anonfun$doAnalyze$11(Project project$1, Method method$1, ObjectType observerInterface) {
        return project$1.classFile(observerInterface).isDefined() && project$1.resolveInterfaceMethodReference(observerInterface, method$1.name(), method$1.descriptor()).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$doAnalyze$10(Project project$1, RefArray implObsIntfs$1, Method method) {
        return method.isInitializer() || method.isSynthetic() || implObsIntfs$1.exists((Function1 & Serializable & scala.Serializable)observerInterface -> BoxesRunTime.boxToBoolean((boolean)ObserverPatternUsage$.$anonfun$doAnalyze$11(project$1, method, observerInterface)));
    }

    public static final /* synthetic */ boolean $anonfun$doAnalyze$8(Project project$1, ObjectRef allObserverInterfaces$1, ObjectType observerType) {
        RefArray implObsIntfs;
        ClassFile observerClassFile;
        return project$1.classFile(observerType).isDefined() ? (!(observerClassFile = (ClassFile)project$1.classFile(observerType).get()).isInterfaceDeclaration() ? (implObsIntfs = observerClassFile.interfaceTypes().filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ObserverPatternUsage$.$anonfun$doAnalyze$9(allObserverInterfaces$1, x$8)))).nonEmpty() && observerClassFile.methods().forall((Function1 & Serializable & scala.Serializable)method -> BoxesRunTime.boxToBoolean((boolean)ObserverPatternUsage$.$anonfun$doAnalyze$10(project$1, implObsIntfs, method))) : false) : false;
    }

    public static final /* synthetic */ boolean $anonfun$doAnalyze$14(Field field) {
        return field.fieldType().isReferenceType();
    }

    public static final /* synthetic */ void $anonfun$doAnalyze$15(Set allObserverTypes$1, ObjectRef observerFields$2, ClassFile classFile$1, Field field) {
        ObjectType objectType;
        FieldType ot;
        ArrayType arrayType;
        Option option;
        FieldType fieldType = field.fieldType();
        if (fieldType instanceof ArrayType && !(option = ArrayType$.MODULE$.unapply(arrayType = (ArrayType)fieldType)).isEmpty() && (ot = (FieldType)option.get()) instanceof ObjectType && allObserverTypes$1.contains((Object)(objectType = (ObjectType)ot))) {
            observerFields$2.elem = (Set)((Set)observerFields$2.elem).$plus((Object)new Tuple2((Object)classFile$1, (Object)field));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (fieldType instanceof ObjectType) {
            BoxedUnit boxedUnit;
            ObjectType objectType2 = (ObjectType)fieldType;
            if (allObserverTypes$1.contains((Object)objectType2)) {
                observerFields$2.elem = (Set)((Set)observerFields$2.elem).$plus((Object)new Tuple2((Object)classFile$1, (Object)field));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                ObjectType objectType3;
                ObjectType ot2;
                ClassTypeSignature classTypeSignature;
                Option option2;
                Some some;
                FieldTypeSignature fieldTypeSignature;
                Option option3 = field.fieldTypeSignature();
                if (option3 instanceof Some && (fieldTypeSignature = (FieldTypeSignature)(some = (Some)option3).value()) instanceof ClassTypeSignature && !(option2 = SimpleGenericType$.MODULE$.unapply(classTypeSignature = (ClassTypeSignature)fieldTypeSignature)).isEmpty() && (ot2 = (ObjectType)((Tuple2)option2.get())._2()) != null && allObserverTypes$1.contains((Object)(objectType3 = ot2))) {
                    observerFields$2.elem = (Set)((Set)observerFields$2.elem).$plus((Object)new Tuple2((Object)classFile$1, (Object)field));
                    BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit4 = boxedUnit;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$doAnalyze$13(Set allObserverTypes$1, ObjectRef observerFields$2, ClassFile classFile) {
        classFile.fields().withFilter((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)ObserverPatternUsage$.$anonfun$doAnalyze$14(field))).foreach((Function1 & Serializable & scala.Serializable)field -> {
            ObserverPatternUsage$.$anonfun$doAnalyze$15(allObserverTypes$1, observerFields$2, classFile, field);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$doAnalyze$12(Project project$1, Set allObserverTypes$1, ObjectRef observerFields$2, ObjectType appType) {
        project$1.classFile(appType).foreach((Function1 & Serializable & scala.Serializable)classFile -> {
            ObserverPatternUsage$.$anonfun$doAnalyze$13(allObserverTypes$1, observerFields$2, classFile);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$doAnalyze$18(ClassFile observable$2, Tuple2 x$10) {
        Object object = x$10._1();
        ClassFile classFile = observable$2;
        return !(object != null ? !object.equals(classFile) : classFile != null);
    }

    public static final /* synthetic */ boolean $anonfun$doAnalyze$22(ObjectRef allObserverInterfaces$1, FieldType pt) {
        return pt.isObjectType() && ((Set)allObserverInterfaces$1.elem).contains((Object)pt.asObjectType());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$doAnalyze$23(ObjectType observableType$1, Set omFieldNames$1, Instruction x0$1) {
        Instruction instruction = x0$1;
        if (!(instruction instanceof FieldReadAccess)) return false;
        FieldReadAccess fieldReadAccess = (FieldReadAccess)instruction;
        Option option = FieldReadAccess$.MODULE$.unapply(fieldReadAccess);
        if (option.isEmpty()) return false;
        ObjectType objectType = (ObjectType)((Tuple3)option.get())._1();
        String name = (String)((Tuple3)option.get())._2();
        ObjectType objectType2 = observableType$1;
        ObjectType objectType3 = objectType;
        if (objectType2 == null) {
            if (objectType3 != null) {
                return false;
            }
        } else if (!objectType2.equals(objectType3)) return false;
        if (!omFieldNames$1.contains((Object)name)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$doAnalyze$21(ObjectRef allObserverInterfaces$1, ObjectRef observerManagementMethods$1, ObjectRef observerNotificationMethods$1, ClassFile observable$1, ObjectType observableType$1, Set omFieldNames$1, Method method) {
        block1: {
            block0: {
                boolean hasMethodObserverParameter = method.parameterTypes().exists((Function1 & Serializable & scala.Serializable)pt -> BoxesRunTime.boxToBoolean((boolean)ObserverPatternUsage$.$anonfun$doAnalyze$22(allObserverInterfaces$1, pt)));
                if (!hasMethodObserverParameter) break block0;
                observerManagementMethods$1.elem = (Set)((Set)observerManagementMethods$1.elem).$plus((Object)new Tuple2((Object)observable$1, (Object)method));
                break block1;
            }
            if (!method.body().isDefined() || !new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((Code)method.body().get()).instructions())).exists((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ObserverPatternUsage$.$anonfun$doAnalyze$23(observableType$1, omFieldNames$1, x0$1)))) break block1;
            observerNotificationMethods$1.elem = (Set)((Set)observerNotificationMethods$1.elem).$plus((Object)new Tuple2((Object)observable$1, (Object)method));
        }
    }

    public static final /* synthetic */ void $anonfun$doAnalyze$20(ObjectRef allObserverInterfaces$1, ObjectRef observerManagementMethods$1, ObjectRef observerNotificationMethods$1, Tuple3 x$12) {
        Tuple3 tuple3 = x$12;
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        ClassFile observable = (ClassFile)tuple3._1();
        ObjectType observableType = (ObjectType)tuple3._2();
        Set omFieldNames = (Set)tuple3._3();
        observable.methods().foreach((Function1 & Serializable & scala.Serializable)method -> {
            ObserverPatternUsage$.$anonfun$doAnalyze$21(allObserverInterfaces$1, observerManagementMethods$1, observerNotificationMethods$1, observable, observableType, omFieldNames, method);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private ObserverPatternUsage$() {
        MODULE$ = this;
    }
}

