/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.br.analyses;

import java.io.Serializable;
import org.opalj.br.BooleanType$;
import org.opalj.br.ClassFile;
import org.opalj.br.FieldType;
import org.opalj.br.JVMMethod;
import org.opalj.br.Method;
import org.opalj.br.Method$;
import org.opalj.br.MethodDescriptor;
import org.opalj.br.MethodDescriptor$;
import org.opalj.br.ObjectType;
import org.opalj.br.ObjectType$;
import org.opalj.br.Type;
import org.opalj.br.analyses.Analysis;
import org.opalj.br.analyses.OneStepAnalysis;
import org.opalj.br.analyses.ProgressManagement;
import org.opalj.br.analyses.Project;
import org.opalj.collection.immutable.RefArray;
import org.opalj.issues.ClassLocation;
import org.opalj.issues.ClassLocation$;
import org.opalj.issues.Issue;
import org.opalj.issues.Issue$;
import org.opalj.issues.Relevance$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001a3A!\u0001\u0002\u0001\u0017\ta2i\u001c<be&\fg\u000e^#rk\u0006d7/T3uQ>$G)\u001a4j]\u0016$'BA\u0002\u0005\u0003!\tg.\u00197zg\u0016\u001c(BA\u0003\u0007\u0003\t\u0011'O\u0003\u0002\b\u0011\u0005)q\u000e]1mU*\t\u0011\"A\u0002pe\u001e\u001c\u0001!\u0006\u0002\r3M\u0019\u0001!D\n\u0011\u00059\tR\"A\b\u000b\u0003A\tQa]2bY\u0006L!AE\b\u0003\r\u0005s\u0017PU3g!\u0011!Rc\u0006\u0012\u000e\u0003\tI!A\u0006\u0002\u0003\u001f=sWm\u0015;fa\u0006s\u0017\r\\=tSN\u0004\"\u0001G\r\r\u0001\u0011)!\u0004\u0001b\u00017\t11k\\;sG\u0016\f\"\u0001H\u0010\u0011\u00059i\u0012B\u0001\u0010\u0010\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"A\u0004\u0011\n\u0005\u0005z!aA!osB\u00191e\u000b\u0018\u000f\u0005\u0011JcBA\u0013)\u001b\u00051#BA\u0014\u000b\u0003\u0019a$o\\8u}%\t\u0001#\u0003\u0002+\u001f\u00059\u0001/Y2lC\u001e,\u0017B\u0001\u0017.\u0005!IE/\u001a:bE2,'B\u0001\u0016\u0010!\ty#'D\u00011\u0015\t\td!\u0001\u0004jgN,Xm]\u0005\u0003gA\u0012Q!S:tk\u0016DQ!\u000e\u0001\u0005\u0002Y\na\u0001P5oSRtD#A\u001c\u0011\u0007Q\u0001q\u0003C\u0003:\u0001\u0011\u0005#(A\u0006eKN\u001c'/\u001b9uS>tW#A\u001e\u0011\u0005q\u0002eBA\u001f?!\t)s\"\u0003\u0002@\u001f\u00051\u0001K]3eK\u001aL!!\u0011\"\u0003\rM#(/\u001b8h\u0015\tyt\u0002C\u0003E\u0001\u0011\u0005Q)A\u0005e_\u0006s\u0017\r\\={KR!!ER&Q\u0011\u001595\t1\u0001I\u0003\u001d\u0001(o\u001c6fGR\u00042\u0001F%\u0018\u0013\tQ%AA\u0004Qe>TWm\u0019;\t\u000f1\u001b\u0005\u0013!a\u0001\u001b\u0006Q\u0001/\u0019:b[\u0016$XM]:\u0011\u0007\rr5(\u0003\u0002P[\t\u00191+Z9\t\u000bE\u001b\u0005\u0019\u0001*\u0002\u001b%\u001c\u0018J\u001c;feJ,\b\u000f^3e!\rq1+V\u0005\u0003)>\u0011\u0011BR;oGRLwN\u001c\u0019\u0011\u000591\u0016BA,\u0010\u0005\u001d\u0011un\u001c7fC:\u0004")
public class CovariantEqualsMethodDefined<Source>
implements OneStepAnalysis<Source, Iterable<Issue>> {
    public final Object analyze(Project project, Seq parameters, Function1 initProgressManagement) {
        return OneStepAnalysis.analyze$((OneStepAnalysis)this, (Project)project, (Seq)parameters, (Function1)initProgressManagement);
    }

    public Seq<String> doAnalyze$default$2() {
        return OneStepAnalysis.doAnalyze$default$2$((OneStepAnalysis)this);
    }

    public final Seq<String> analyze$default$2() {
        return OneStepAnalysis.analyze$default$2$((OneStepAnalysis)this);
    }

    public final Function1<Object, ProgressManagement> analyze$default$3() {
        return OneStepAnalysis.analyze$default$3$((OneStepAnalysis)this);
    }

    public Option<String> documentationUrl() {
        return Analysis.documentationUrl$((Analysis)this);
    }

    public String copyright() {
        return Analysis.copyright$((Analysis)this);
    }

    public String title() {
        return Analysis.title$((Analysis)this);
    }

    public String description() {
        return "Finds classes that just define a co-variant equals method.";
    }

    public Iterable<Issue> doAnalyze(Project<Source> project, Seq<String> parameters, Function0<Object> isInterrupted) {
        Object mutex = new Object();
        ObjectRef reports = ObjectRef.create((Object)Nil$.MODULE$);
        project.parForeachClassFile(isInterrupted, (Function1 & Serializable & scala.Serializable)classFile -> {
            CovariantEqualsMethodDefined.$anonfun$doAnalyze$1(project, mutex, reports, classFile);
            return BoxedUnit.UNIT;
        });
        return (List)reports.elem;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$doAnalyze$2(Method check$ifrefutable$1) {
        Method method = check$ifrefutable$1;
        Option option = Method$.MODULE$.unapply((JVMMethod)method);
        if (option.isEmpty()) return false;
        String string = (String)((Tuple3)option.get())._2();
        MethodDescriptor methodDescriptor = (MethodDescriptor)((Tuple3)option.get())._3();
        if (!"equals".equals(string)) return false;
        Option option2 = MethodDescriptor$.MODULE$.unapply(methodDescriptor);
        if (option2.isEmpty()) return false;
        RefArray refArray = (RefArray)((Tuple2)option2.get())._1();
        Type type = (Type)((Tuple2)option2.get())._2();
        Some some = Seq$.MODULE$.unapplySeq((Seq)refArray);
        if (some.isEmpty()) return false;
        if (some.get() == null) return false;
        if (((SeqLike)some.get()).lengthCompare(1) != 0) return false;
        if (!BooleanType$.MODULE$.equals(type)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$doAnalyze$3(BooleanRef definesEqualsMethod$1, BooleanRef definesCovariantEqualsMethod$1, Method x$1) {
        BoxedUnit boxedUnit;
        Option option;
        Method method = x$1;
        Option option2 = Method$.MODULE$.unapply((JVMMethod)method);
        if (option2.isEmpty()) throw new MatchError((Object)method);
        String string = (String)((Tuple3)option2.get())._2();
        MethodDescriptor methodDescriptor = (MethodDescriptor)((Tuple3)option2.get())._3();
        if (!"equals".equals(string) || (option = MethodDescriptor$.MODULE$.unapply(methodDescriptor)).isEmpty()) throw new MatchError((Object)method);
        RefArray refArray = (RefArray)((Tuple2)option.get())._1();
        Type type = (Type)((Tuple2)option.get())._2();
        Some some = Seq$.MODULE$.unapplySeq((Seq)refArray);
        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(1) != 0) throw new MatchError((Object)method);
        FieldType ot = (FieldType)((SeqLike)some.get()).apply(0);
        if (!BooleanType$.MODULE$.equals(type)) throw new MatchError((Object)method);
        FieldType fieldType = ot;
        ObjectType objectType = ObjectType$.MODULE$.Object();
        if (!(fieldType != null ? !fieldType.equals(objectType) : objectType != null)) {
            definesEqualsMethod$1.elem = true;
            boxedUnit = BoxedUnit.UNIT;
        } else {
            definesCovariantEqualsMethod$1.elem = true;
            boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ void $anonfun$doAnalyze$1(Project project$1, Object mutex$1, ObjectRef reports$1, ClassFile classFile) {
        BooleanRef definesEqualsMethod = BooleanRef.create((boolean)false);
        BooleanRef definesCovariantEqualsMethod = BooleanRef.create((boolean)false);
        classFile.methods().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)CovariantEqualsMethodDefined.$anonfun$doAnalyze$2(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            CovariantEqualsMethodDefined.$anonfun$doAnalyze$3(definesEqualsMethod, definesCovariantEqualsMethod, x$1);
            return BoxedUnit.UNIT;
        });
        if (definesCovariantEqualsMethod.elem && !definesEqualsMethod.elem) {
            Object object = mutex$1;
            synchronized (object) {
                Issue issue = new Issue("CovariantEqualsMethodDefined", Relevance$.MODULE$.Moderate(), "defines a covariant equals method, but does not also define the standard equals method", (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"correctness"})), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"method missing"})), (Seq)new .colon.colon((Object)new ClassLocation((Option)None$.MODULE$, project$1, classFile, ClassLocation$.MODULE$.$lessinit$greater$default$4()), (List)Nil$.MODULE$), Issue$.MODULE$.apply$default$7());
                reports$1.elem = ((List)reports$1.elem).$colon$colon((Object)issue);
            }
        }
    }

    public CovariantEqualsMethodDefined() {
        Analysis.$init$((Analysis)this);
        OneStepAnalysis.$init$((OneStepAnalysis)this);
    }
}

