/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.br;

import com.typesafe.config.Config;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URL;
import org.opalj.br.ClassFile;
import org.opalj.br.FieldType;
import org.opalj.br.Method;
import org.opalj.br.PublicMethodsInNonRestrictedPackagesCounter$;
import org.opalj.br.analyses.Analysis;
import org.opalj.br.analyses.AnalysisExecutor;
import org.opalj.br.analyses.BasicReport;
import org.opalj.br.analyses.OneStepAnalysis;
import org.opalj.br.analyses.ProgressManagement;
import org.opalj.br.analyses.Project;
import org.opalj.log.LogContext;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Seq$;
import scala.collection.parallel.ParIterable$;
import scala.collection.parallel.ParIterableLike;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

public final class PublicMethodsInNonRestrictedPackagesCounter$
implements AnalysisExecutor {
    public static PublicMethodsInNonRestrictedPackagesCounter$ MODULE$;
    private final List<String> restrictedPackages;
    private final OneStepAnalysis<URL, BasicReport> analysis;

    static {
        new PublicMethodsInNonRestrictedPackagesCounter$();
    }

    public String analysisSpecificParametersDescription() {
        return AnalysisExecutor.analysisSpecificParametersDescription$((AnalysisExecutor)this);
    }

    public Traversable<String> checkAnalysisSpecificParameters(Seq<String> parameters) {
        return AnalysisExecutor.checkAnalysisSpecificParameters$((AnalysisExecutor)this, parameters);
    }

    public void printUsage(LogContext logContext) {
        AnalysisExecutor.printUsage$((AnalysisExecutor)this, (LogContext)logContext);
    }

    public void main(String[] args) {
        AnalysisExecutor.main$((AnalysisExecutor)this, (String[])args);
    }

    public void handleParsingExceptions(Project<?> project, Traversable<Throwable> exceptions) {
        AnalysisExecutor.handleParsingExceptions$((AnalysisExecutor)this, project, exceptions);
    }

    public Project<URL> setupProject(Iterable<File> cpFiles, Iterable<File> libcpFiles, boolean completelyLoadLibraries, Enumeration.Value projectType, Config fallbackConfiguration, LogContext initialLogContext) {
        return AnalysisExecutor.setupProject$((AnalysisExecutor)this, cpFiles, libcpFiles, (boolean)completelyLoadLibraries, (Enumeration.Value)projectType, (Config)fallbackConfiguration, (LogContext)initialLogContext);
    }

    public List<String> restrictedPackages() {
        return this.restrictedPackages;
    }

    public OneStepAnalysis<URL, BasicReport> analysis() {
        return this.analysis;
    }

    private PublicMethodsInNonRestrictedPackagesCounter$() {
        MODULE$ = this;
        AnalysisExecutor.$init$((AnalysisExecutor)this);
        this.restrictedPackages = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sun/", "com/sun/xml/internal/", "com/sun/imageio/", "com/sun/istack/internal/", "com/sun/jmx/", "com/sun/proxy/", "com/sun/org/apache/bcel/internal/", "com/sun/org/apache/regexp/internal/", "com/sun/org/apache/xerces/internal/", "com/sun/org/apache/xpath/internal/", "com/sun/org/apache/xalan/internal/extensions/", "com/sun/org/apache/xalan/internal/lib/", "com/sun/org/apache/xalan/internal/res/", "com/sun/org/apache/xalan/internal/templates/", "com/sun/org/apache/xalan/internal/utils/", "com/sun/org/apache/xalan/internal/xslt/", "com/sun/org/apache/xalan/internal/xsltc/cmdline/", "com/sun/org/apache/xalan/internal/xsltc/compiler/", "com/sun/org/apache/xalan/internal/xsltc/trax/", "com/sun/org/apache/xalan/internal/xsltc/util/", "com/sun/org/apache/xml/internal/res/", "com/sun/org/apache/xml/internal/serializer/utils/", "com/sun/org/apache/xml/internal/utils/", "com/sun/org/apache/xml/internal/security/", "com/sun/org/glassfish/", "org/jcp/xml/dsig/internal/", "com/sun/java/accessibility/"}));
        this.analysis = new OneStepAnalysis<URL, BasicReport>(){

            public final Object analyze(Project project, Seq parameters, Function1 initProgressManagement) {
                return OneStepAnalysis.analyze$((OneStepAnalysis)this, (Project)project, (Seq)parameters, (Function1)initProgressManagement);
            }

            public Seq<String> doAnalyze$default$2() {
                return OneStepAnalysis.doAnalyze$default$2$((OneStepAnalysis)this);
            }

            public final Seq<String> analyze$default$2() {
                return OneStepAnalysis.analyze$default$2$((OneStepAnalysis)this);
            }

            public final Function1<Object, ProgressManagement> analyze$default$3() {
                return OneStepAnalysis.analyze$default$3$((OneStepAnalysis)this);
            }

            public Option<String> documentationUrl() {
                return Analysis.documentationUrl$((Analysis)this);
            }

            public String copyright() {
                return Analysis.copyright$((Analysis)this);
            }

            public String title() {
                return Analysis.title$((Analysis)this);
            }

            public String description() {
                return "Counts the number of public/protected methods in non-restricted packages.";
            }

            public BasicReport doAnalyze(Project<URL> project, Seq<String> parameters, Function0<Object> isInterrupted) {
                Iterable methods = ((ParIterableLike)((ParIterableLike)project.allClassFiles().par()).withFilter((Function1 & Serializable & scala.Serializable)classFile -> BoxesRunTime.boxToBoolean((boolean)anon.1.$anonfun$doAnalyze$1(classFile))).withFilter((Function1 & Serializable & scala.Serializable)classFile -> BoxesRunTime.boxToBoolean((boolean)anon.1.$anonfun$doAnalyze$2(classFile))).flatMap((Function1 & Serializable & scala.Serializable)classFile -> (scala.collection.immutable.Seq)((TraversableLike)classFile.methods().withFilter((Function1 & Serializable & scala.Serializable)method -> BoxesRunTime.boxToBoolean((boolean)anon.1.$anonfun$doAnalyze$5(method))).withFilter((Function1 & Serializable & scala.Serializable)method -> BoxesRunTime.boxToBoolean((boolean)anon.1.$anonfun$doAnalyze$6(classFile, method))).map((Function1 & Serializable & scala.Serializable)method -> {
                    int referenceParametersCount = method.parameterTypes().count((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)anon.1.$anonfun$doAnalyze$8(x$2)));
                    return new Tuple2(method, (Object)BoxesRunTime.boxToInteger((int)referenceParametersCount));
                }, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$3 -> {
                    Tuple2 tuple2 = x$3;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Method method = (Method)tuple2._1();
                    int referenceParametersCount = tuple2._2$mcI$sp();
                    String string = method.toJava(((Object)BoxesRunTime.boxToInteger((int)referenceParametersCount)).toString());
                    return string;
                }, Seq$.MODULE$.canBuildFrom()), (CanBuildFrom)ParIterable$.MODULE$.canBuildFrom())).seq();
                return new BasicReport(new StringBuilder(64).append(methods.size()).append(" public and protected methods in non-restricted packages found:\n").append(methods.mkString("\t", "\n\t", "\n")).toString());
            }

            public static final /* synthetic */ boolean $anonfun$doAnalyze$1(ClassFile classFile) {
                return classFile.isPublic();
            }

            public static final /* synthetic */ boolean $anonfun$doAnalyze$3(ClassFile classFile$1, String x$1) {
                return classFile$1.fqn().startsWith(x$1);
            }

            public static final /* synthetic */ boolean $anonfun$doAnalyze$2(ClassFile classFile) {
                return !PublicMethodsInNonRestrictedPackagesCounter$.MODULE$.restrictedPackages().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)anon.1.$anonfun$doAnalyze$3(classFile, x$1)));
            }

            public static final /* synthetic */ boolean $anonfun$doAnalyze$5(Method method) {
                return method.body().isDefined();
            }

            public static final /* synthetic */ boolean $anonfun$doAnalyze$6(ClassFile classFile$2, Method method) {
                return method.isPublic() || method.isProtected() && !classFile$2.isFinal();
            }

            public static final /* synthetic */ boolean $anonfun$doAnalyze$8(FieldType x$2) {
                return x$2.isReferenceType();
            }
            {
                Analysis.$init$((Analysis)this);
                OneStepAnalysis.$init$((OneStepAnalysis)this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$doAnalyze$1$adapted(org.opalj.br.ClassFile ), $anonfun$doAnalyze$2$adapted(org.opalj.br.ClassFile ), $anonfun$doAnalyze$4(org.opalj.br.ClassFile ), $anonfun$doAnalyze$3$adapted(org.opalj.br.ClassFile java.lang.String ), $anonfun$doAnalyze$8$adapted(org.opalj.br.FieldType ), $anonfun$doAnalyze$5$adapted(org.opalj.br.Method ), $anonfun$doAnalyze$6$adapted(org.opalj.br.ClassFile org.opalj.br.Method ), $anonfun$doAnalyze$7(org.opalj.br.Method ), $anonfun$doAnalyze$9(scala.Tuple2 )}, serializedLambda);
            }
        };
    }
}

