/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.br;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigMergeable;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.opalj.br.BootstrapMethod;
import org.opalj.br.ClassFile;
import org.opalj.br.Code;
import org.opalj.br.Method;
import org.opalj.br.MethodDescriptor;
import org.opalj.br.PCAndInstruction;
import org.opalj.br.PCAndInstruction$;
import org.opalj.br.analyses.AnalysisExecutor;
import org.opalj.br.analyses.BasicReport;
import org.opalj.br.analyses.DefaultOneStepAnalysis;
import org.opalj.br.analyses.MethodInfo;
import org.opalj.br.analyses.Project;
import org.opalj.br.instructions.INVOKEDYNAMIC;
import org.opalj.br.instructions.INVOKEDYNAMIC$;
import org.opalj.br.instructions.Instruction;
import org.opalj.br.reader.InvokedynamicRewriting$;
import org.opalj.log.LogContext;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class InvokedynamicPrinter$
extends DefaultOneStepAnalysis {
    public static InvokedynamicPrinter$ MODULE$;

    static {
        new InvokedynamicPrinter$();
    }

    public Project<URL> setupProject(Iterable<File> cpFiles, Iterable<File> libcpFiles, boolean completelyLoadLibraries, Enumeration.Value projectType, Config fallbackConfiguration, LogContext initialLogContext) {
        Config baseConfig = InvokedynamicRewriting$.MODULE$.defaultConfig(false, true);
        Config config = baseConfig.withFallback((ConfigMergeable)fallbackConfiguration);
        return AnalysisExecutor.setupProject$((AnalysisExecutor)this, cpFiles, libcpFiles, (boolean)completelyLoadLibraries, (Enumeration.Value)projectType, (Config)config, (LogContext)initialLogContext);
    }

    public String description() {
        return "Prints information about invokedynamic instructions.";
    }

    public BasicReport doAnalyze(Project<URL> project, Seq<String> parameters, Function0<Object> isInterrupted) {
        ConcurrentLinkedQueue invokedynamics = new ConcurrentLinkedQueue();
        project.parForeachMethodWithBody(isInterrupted, project.parForeachMethodWithBody$default$2(), (Function1 & Serializable & scala.Serializable)mi -> BoxesRunTime.boxToBoolean((boolean)InvokedynamicPrinter$.$anonfun$doAnalyze$1(invokedynamics, mi)));
        Seq result = (Seq)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(invokedynamics).asScala()).toSeq().sorted((Ordering)Ordering.String$.MODULE$);
        return new BasicReport(result.mkString(new StringBuilder(35).append(result.size()).append(" invokedynamic instructions found:\n").toString(), "\n", "\n"));
    }

    public static final /* synthetic */ boolean $anonfun$doAnalyze$1(ConcurrentLinkedQueue invokedynamics$1, MethodInfo mi) {
        Method method = mi.method();
        ClassFile classFile = method.classFile();
        Code body2 = (Code)method.body().get();
        return invokedynamics$1.addAll((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)body2.collectWithIndex((PartialFunction)new scala.Serializable(method, classFile){
            public static final long serialVersionUID = 0L;
            private final Method method$1;
            private final ClassFile classFile$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends PCAndInstruction, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                Option option = PCAndInstruction$.MODULE$.unapply(A1);
                if (!option.isEmpty()) {
                    INVOKEDYNAMIC iNVOKEDYNAMIC;
                    Some some;
                    int pc = ((Tuple2)option.get())._1$mcI$sp();
                    Instruction instruction = (Instruction)((Tuple2)option.get())._2();
                    if (instruction instanceof INVOKEDYNAMIC && !(some = INVOKEDYNAMIC$.MODULE$.unapply(iNVOKEDYNAMIC = (INVOKEDYNAMIC)instruction)).isEmpty()) {
                        BootstrapMethod bootstrap = (BootstrapMethod)((Tuple3)some.get())._1();
                        String name = (String)((Tuple3)some.get())._2();
                        MethodDescriptor descriptor = (MethodDescriptor)((Tuple3)some.get())._3();
                        object = new StringBuilder(14).append(this.classFile$1.thisType().toJava()).append(" {\n  ").append(this.method$1.signatureToJava(this.method$1.signatureToJava$default$1())).append("{ ").append(pc).append(": \n").append(new StringBuilder(5).append("    ").append(bootstrap.toJava()).append("\n").toString()).append(bootstrap.arguments().mkString("    Arguments: {", ",", "}\n")).append(new StringBuilder(16).append("    Calling:   ").append(descriptor.toJava(name)).append("\n").toString()).append("} }\n").toString();
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(PCAndInstruction x1) {
                INVOKEDYNAMIC iNVOKEDYNAMIC;
                Some some;
                Instruction instruction;
                PCAndInstruction pCAndInstruction = x1;
                Option option = PCAndInstruction$.MODULE$.unapply(pCAndInstruction);
                boolean bl = !option.isEmpty() && (instruction = (Instruction)((Tuple2)option.get())._2()) instanceof INVOKEDYNAMIC && !(some = INVOKEDYNAMIC$.MODULE$.unapply(iNVOKEDYNAMIC = (INVOKEDYNAMIC)instruction)).isEmpty();
                return bl;
            }
            {
                this.method$1 = method$1;
                this.classFile$1 = classFile$1;
            }
        }, ClassTag$.MODULE$.apply(String.class)).toList()).asJava());
    }

    private InvokedynamicPrinter$() {
        MODULE$ = this;
    }
}

