/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.br;

import java.io.Serializable;
import java.net.URL;
import org.opalj.br.Method;
import org.opalj.br.ObjectType;
import org.opalj.br.ObjectType$;
import org.opalj.br.analyses.BasicReport;
import org.opalj.br.analyses.DefaultOneStepAnalysis;
import org.opalj.br.analyses.FieldAccessInformation;
import org.opalj.br.analyses.FieldAccessInformationKey$;
import org.opalj.br.analyses.Project;
import org.opalj.br.analyses.ProjectInformationKey;
import org.opalj.collection.immutable.IntTrieSet;
import org.opalj.util.PerformanceEvaluation$;
import org.opalj.util.package$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction1;

public final class FieldAccessInformationAnalysis$
extends DefaultOneStepAnalysis {
    public static FieldAccessInformationAnalysis$ MODULE$;

    static {
        new FieldAccessInformationAnalysis$();
    }

    public String description() {
        return "provides information about field accesses";
    }

    public String analysisSpecificParametersDescription() {
        return "[-field=\"<The field for which we want read/write access information (e.g., -field=\"java.util.HashMap entrySet\">\"]";
    }

    public Seq<String> checkAnalysisSpecificParameters(Seq<String> parameters) {
        return parameters.isEmpty() || parameters.size() == 1 && ((String)parameters.head()).startsWith("-field=") ? (Seq)Seq$.MODULE$.empty() : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(20).append("unknown parameters: ").append(parameters.mkString(" ")).toString()}));
    }

    public BasicReport doAnalyze(Project<URL> project, Seq<String> parameters, Function0<Object> isInterrupted) {
        BasicReport basicReport;
        ObjectRef memoryUsage = ObjectRef.create((Object)"");
        Function0 & Serializable & scala.Serializable x$3 = (Function0 & Serializable & scala.Serializable)() -> (FieldAccessInformation)project.get((ProjectInformationKey)FieldAccessInformationKey$.MODULE$);
        JFunction1.mcVJ.sp & Serializable & scala.Serializable x$4 = (JFunction1.mcVJ.sp & Serializable & scala.Serializable)m -> {
            memoryUsage$1.elem = package$.MODULE$.asMB(m);
        };
        Option x$5 = PerformanceEvaluation$.MODULE$.memory$default$3((Function0)x$3, (Function1)x$4);
        FieldAccessInformation accessInformation = (FieldAccessInformation)PerformanceEvaluation$.MODULE$.memory((Function0)x$3, (Function1)x$4, x$5);
        if (parameters.nonEmpty()) {
            String[] stringArray = new StringOps(Predef$.MODULE$.augmentString(((String)parameters.head()).substring(7).replace('.', '/'))).split(' ');
            Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
            if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(2) != 0) {
                throw new MatchError((Object)stringArray);
            }
            String declaringClassName = (String)((SeqLike)option.get()).apply(0);
            String fieldName = (String)((SeqLike)option.get()).apply(1);
            Tuple2 tuple2 = new Tuple2((Object)declaringClassName, (Object)fieldName);
            Tuple2 tuple22 = tuple2;
            String declaringClassName2 = (String)tuple22._1();
            String fieldName2 = (String)tuple22._2();
            ObjectType declaringClassType = ObjectType$.MODULE$.apply(declaringClassName2);
            Seq writes = accessInformation.writeAccesses(declaringClassType, fieldName2);
            Seq reads = accessInformation.readAccesses(declaringClassType, fieldName2);
            basicReport = new BasicReport(new StringBuilder(17).append(declaringClassName2).append(" ").append(fieldName2).append("\n").append("writes:\n").append(FieldAccessInformationAnalysis$.accessInformationToString$1(writes)).append("reads:\n").append(FieldAccessInformationAnalysis$.accessInformationToString$1(reads)).toString());
        } else {
            basicReport = new BasicReport(accessInformation.statistics().mkString(new StringBuilder(47).append("determing field access information required ").append((String)memoryUsage.elem).append(" :\n").toString(), "\n", "\n"));
        }
        return basicReport;
    }

    private static final String accessInformationToString$1(Seq data) {
        return ((TraversableOnce)data.map((Function1 & Serializable & scala.Serializable)e -> {
            Tuple2 tuple2 = e;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Method method = (Method)tuple2._1();
            IntTrieSet pcs = (IntTrieSet)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)method, (Object)pcs);
            Tuple2 tuple23 = tuple22;
            Method method2 = (Method)tuple23._1();
            IntTrieSet pcs2 = (IntTrieSet)tuple23._2();
            return method2.toJava(pcs2.mkString("pcs: ", ", ", ""));
        }, Seq$.MODULE$.canBuildFrom())).mkString("\t ", "\n\t ", "\n");
    }

    private FieldAccessInformationAnalysis$() {
        MODULE$ = this;
    }
}

