/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.ai.domain.l1;

import java.io.Serializable;
import java.net.URL;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.opalj.ai.AIResult;
import org.opalj.ai.Domain;
import org.opalj.ai.InterruptableAI;
import org.opalj.ai.domain.RecordDefUse;
import org.opalj.ai.domain.TheMethod;
import org.opalj.ai.domain.l1.DefaultDomainWithCFGAndDefUse;
import org.opalj.br.Method;
import org.opalj.br.analyses.BasicReport;
import org.opalj.br.analyses.DefaultOneStepAnalysis;
import org.opalj.br.analyses.Project;
import org.opalj.br.instructions.Instruction;
import org.opalj.br.instructions.MethodInvocationInstruction;
import org.opalj.collection.immutable.IntTrieSet;
import org.opalj.util.Nanoseconds;
import org.opalj.util.Nanoseconds$;
import org.opalj.util.PerformanceEvaluation$;
import org.opalj.util.Seconds;
import org.opalj.util.Seconds$;
import scala.Function0;
import scala.Function1;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.ListSet;
import scala.collection.immutable.ListSet$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction1;

public final class SimpleDefUseAnalysis$
extends DefaultOneStepAnalysis {
    public static SimpleDefUseAnalysis$ MODULE$;

    static {
        new SimpleDefUseAnalysis$();
    }

    public String title() {
        return "Identifies unused variables and unnecessary calculations";
    }

    public String description() {
        return "Identifies variable declarations or assignments that are not used again locally";
    }

    public BasicReport doAnalyze(Project<URL> theProject, Seq<String> parameters, Function0<Object> isInterrupted) {
        DoubleRef analysisTime = DoubleRef.create((double)Seconds$.MODULE$.None());
        Iterable unusedDefUseNodes = (Iterable)PerformanceEvaluation$.MODULE$.time((Function0 & Serializable & scala.Serializable)() -> {
            ConcurrentLinkedQueue results = new ConcurrentLinkedQueue();
            InterruptableAI ai = new InterruptableAI();
            theProject.parForeachMethodWithBody(theProject.parForeachMethodWithBody$default$1(), theProject.parForeachMethodWithBody$default$2(), (Function1 & Serializable & scala.Serializable)m -> {
                Object object;
                Method method = m.method();
                if (!method.isSynthetic()) {
                    DefaultDomainWithCFGAndDefUse domain = new DefaultDomainWithCFGAndDefUse(theProject, method);
                    AIResult result = ai.apply(method, (Domain)domain);
                    Instruction[] instructions = ((TheMethod)result.domain()).code().instructions();
                    IntTrieSet unused = ((RecordDefUse)result.domain()).unused();
                    if (unused.nonEmpty()) {
                        ObjectRef values = ObjectRef.create((Object)((ListSet)ListSet$.MODULE$.empty()));
                        int implicitParameterOffset = !method.isStatic() ? 1 : 0;
                        unused.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)vo -> {
                            block5: {
                                block3: {
                                    block4: {
                                        if (vo >= 0) break block3;
                                        if (method.isStatic() || method.isPrivate()) break block4;
                                        String string = method.name();
                                        String string2 = "<init>";
                                        if (string != null ? !string.equals(string2) : string2 != null) break block5;
                                    }
                                    values$1.elem = vo == -1 ? ((ListSet)values$1.elem).$plus((Object)"this") : ((ListSet)values$1.elem).$plus((Object)new StringBuilder(6).append("param:").append(-(vo + implicitParameterOffset)).toString());
                                    break block5;
                                }
                                Instruction instruction = instructions[vo];
                                int n = instruction.opcode();
                                switch (n) {
                                    case 182: 
                                    case 183: 
                                    case 184: 
                                    case 185: {
                                        MethodInvocationInstruction invoke = (MethodInvocationInstruction)instruction;
                                        values$1.elem = ((ListSet)values$1.elem).$plus((Object)new StringBuilder(13).append(((Object)BoxesRunTime.boxToInteger((int)vo)).toString()).append(": invoke ").append(invoke.declaringClass().toJava()).append("{ ").append(invoke.methodDescriptor().toJava(invoke.name())).append(" }").toString());
                                        break;
                                    }
                                    default: {
                                        values$1.elem = ((ListSet)values$1.elem).$plus((Object)new StringBuilder(2).append(((Object)BoxesRunTime.boxToInteger((int)vo)).toString()).append(": ").append(instruction.toString(vo)).toString());
                                        break;
                                    }
                                }
                            }
                        });
                        object = ((ListSet)values.elem).nonEmpty() ? BoxesRunTime.boxToBoolean((boolean)results.add(method.toJava(((ListSet)values.elem).mkString("{", ",", "}")))) : BoxedUnit.UNIT;
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                } else {
                    object = BoxedUnit.UNIT;
                }
                return object;
            });
            return (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(results).asScala();
        }, (Function1 & Serializable & scala.Serializable)t -> {
            analysisTime.elem = Nanoseconds$.MODULE$.toSeconds$extension(((Nanoseconds)t).timeSpan());
            return BoxedUnit.UNIT;
        });
        return new BasicReport(new StringBuilder(36).append(unusedDefUseNodes.mkString("Methods with unused values:\n", "\n", "\n")).append("The analysis took ").append(new Seconds(analysisTime.elem)).append(" and found ").append(unusedDefUseNodes.size()).append(" issues").toString());
    }

    private SimpleDefUseAnalysis$() {
        MODULE$ = this;
    }
}

