/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.ai.domain.l1;

import java.io.Serializable;
import java.net.URL;
import org.opalj.ai.AIResult;
import org.opalj.ai.Domain;
import org.opalj.ai.InterruptableAI;
import org.opalj.ai.ValuesDomain;
import org.opalj.ai.domain.l1.MethodReturnValuesAnalysis;
import org.opalj.ai.domain.l1.RefinedReturnType;
import org.opalj.br.Method;
import org.opalj.br.Type;
import org.opalj.br.analyses.BasicReport;
import org.opalj.br.analyses.DefaultOneStepAnalysis;
import org.opalj.br.analyses.Project;
import org.opalj.collection.immutable.UIDSet;
import org.opalj.collection.immutable.UIDSet$;
import org.opalj.util.Nanoseconds;
import org.opalj.util.Nanoseconds$;
import org.opalj.util.PerformanceEvaluation$;
import org.opalj.util.Seconds;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.Seq$;
import scala.collection.parallel.ParIterable;
import scala.collection.parallel.ParIterable$;
import scala.collection.parallel.ParIterableLike;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class MethodReturnValuesAnalysis$
extends DefaultOneStepAnalysis {
    public static MethodReturnValuesAnalysis$ MODULE$;

    static {
        new MethodReturnValuesAnalysis$();
    }

    public String title() {
        return "Derives Information About Returned Values";
    }

    public String description() {
        return "Identifies methods where we can \u2013 statically \u2013 derive more precise return type/value information.";
    }

    public BasicReport doAnalyze(Project<URL> theProject, Seq<String> parameters, Function0<Object> isInterrupted) {
        ParIterable methodsWithRefinedReturnTypes = (ParIterable)PerformanceEvaluation$.MODULE$.time((Function0 & Serializable & scala.Serializable)() -> (ParIterable)((ParIterableLike)theProject.allClassFiles().par()).flatMap((Function1 & Serializable & scala.Serializable)classFile -> (scala.collection.immutable.Seq)((TraversableLike)((TraversableLike)((TraversableLike)classFile.methods().withFilter((Function1 & Serializable & scala.Serializable)method -> BoxesRunTime.boxToBoolean((boolean)MethodReturnValuesAnalysis$.$anonfun$doAnalyze$3(method))).map((Function1 & Serializable & scala.Serializable)method -> {
            Type originalType = method.returnType();
            return new Tuple2(method, (Object)originalType);
        }, Seq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MethodReturnValuesAnalysis$.$anonfun$doAnalyze$5(x$1))).map((Function1 & Serializable & scala.Serializable)x$3 -> {
            Tuple2 tuple2 = x$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Method method = (Method)tuple2._1();
            InterruptableAI ai = new InterruptableAI();
            MethodReturnValuesAnalysis.AnalysisDomain domain = new MethodReturnValuesAnalysis.AnalysisDomain(theProject, ai, method);
            AIResult result = ai.apply(method, (Domain)domain);
            Tuple4 tuple4 = new Tuple4((Object)tuple2, (Object)ai, (Object)domain, (Object)result);
            return tuple4;
        }, Seq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)MethodReturnValuesAnalysis$.$anonfun$doAnalyze$7(x$4))).map((Function1 & Serializable & scala.Serializable)x$6 -> {
            MethodReturnValuesAnalysis.AnalysisDomain domain;
            Tuple4 tuple4;
            block3: {
                block2: {
                    tuple4 = x$6;
                    if (tuple4 == null) break block2;
                    Tuple2 tuple2 = (Tuple2)tuple4._1();
                    domain = (MethodReturnValuesAnalysis.AnalysisDomain)tuple4._3();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple4);
            }
            Option<ValuesDomain.Value> returnedValue = domain.returnedValue();
            Tuple2 tuple2 = new Tuple2((Object)tuple4, returnedValue);
            return tuple2;
        }, Seq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)MethodReturnValuesAnalysis$.$anonfun$doAnalyze$9(x$7))).map((Function1 & Serializable & scala.Serializable)x$8 -> {
            MethodReturnValuesAnalysis.AnalysisDomain domain;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    Tuple4 tuple4;
                    tuple22 = x$8;
                    if (tuple22 == null || (tuple4 = (Tuple4)tuple22._1()) == null) break block2;
                    tuple2 = (Tuple2)tuple4._1();
                    domain = (MethodReturnValuesAnalysis.AnalysisDomain)tuple4._3();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            Method method = (Method)tuple2._1();
            RefinedReturnType refinedReturnType = new RefinedReturnType(method, domain.returnedValue());
            return refinedReturnType;
        }, Seq$.MODULE$.canBuildFrom()), (CanBuildFrom)ParIterable$.MODULE$.canBuildFrom()), (Function1 & Serializable & scala.Serializable)ns -> {
            Predef$.MODULE$.println((Object)new StringBuilder(18).append("the analysis took ").append(new Seconds(Nanoseconds$.MODULE$.toSeconds$extension(((Nanoseconds)ns).timeSpan()))).toString());
            return BoxedUnit.UNIT;
        });
        return new BasicReport(methodsWithRefinedReturnTypes.mkString(new StringBuilder(39).append("Methods with refined return types (").append(methodsWithRefinedReturnTypes.size()).append("): \n").toString(), "\n", "\n"));
    }

    public static final /* synthetic */ boolean $anonfun$doAnalyze$3(Method method) {
        return method.body().isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$doAnalyze$5(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Method method = (Method)tuple2._1();
        boolean bl = method.returnType().isReferenceType();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$doAnalyze$7(Tuple4 x$4) {
        AIResult result;
        block3: {
            Tuple4 tuple4;
            block2: {
                tuple4 = x$4;
                if (tuple4 == null) break block2;
                Tuple2 tuple2 = (Tuple2)tuple4._1();
                result = (AIResult)tuple4._4();
                if (tuple2 != null) break block3;
            }
            throw new MatchError((Object)tuple4);
        }
        boolean bl = !result.wasAborted();
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$doAnalyze$9(Tuple2 x$7) {
        Tuple2 tuple2 = x$7;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Tuple4 tuple4 = (Tuple4)tuple2._1();
        Option returnedValue = (Option)tuple2._2();
        if (tuple4 == null) throw new MatchError((Object)tuple2);
        Tuple2 tuple22 = (Tuple2)tuple4._1();
        if (tuple22 == null) throw new MatchError((Object)tuple2);
        Type originalType = (Type)tuple22._2();
        if (returnedValue.isEmpty()) return true;
        UIDSet uIDSet = ((ValuesDomain.Value)returnedValue.get()).asDomainReferenceValue().upperTypeBound();
        UIDSet uIDSet2 = UIDSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Type[]{originalType}));
        if (uIDSet == null) {
            if (uIDSet2 == null) return false;
            return true;
        } else if (uIDSet.equals(uIDSet2)) return false;
        return true;
    }

    private MethodReturnValuesAnalysis$() {
        MODULE$ = this;
    }
}

