/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.ai.domain.l0;

import java.io.Serializable;
import java.net.URL;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.opalj.ai.AIResult;
import org.opalj.ai.Domain;
import org.opalj.ai.InterruptableAI;
import org.opalj.ai.domain.RecordDefUse;
import org.opalj.ai.domain.TheMethod;
import org.opalj.ai.domain.l0.BaseDomainWithDefUse;
import org.opalj.ai.package$;
import org.opalj.br.Method;
import org.opalj.br.MethodDescriptor;
import org.opalj.br.analyses.BasicReport;
import org.opalj.br.analyses.DefaultOneStepAnalysis;
import org.opalj.br.analyses.MethodInfo;
import org.opalj.br.analyses.Project;
import org.opalj.br.instructions.Instruction;
import org.opalj.collection.immutable.IntTrieSet;
import org.opalj.util.Nanoseconds;
import org.opalj.util.Nanoseconds$;
import org.opalj.util.PerformanceEvaluation$;
import org.opalj.util.Seconds;
import org.opalj.util.Seconds$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;

public final class ParameterUsageAnalysis$
extends DefaultOneStepAnalysis {
    public static ParameterUsageAnalysis$ MODULE$;

    static {
        new ParameterUsageAnalysis$();
    }

    public String title() {
        return "Identifies methods which return a given parameter";
    }

    public String description() {
        return "Identifies parameters that are - at least on some paths - directly returned";
    }

    public BasicReport doAnalyze(Project<URL> theProject, Seq<String> parameters, Function0<Object> isInterrupted) {
        DoubleRef analysisTime = DoubleRef.create((double)Seconds$.MODULE$.None());
        Tuple2 tuple2 = (Tuple2)PerformanceEvaluation$.MODULE$.time((Function0 & Serializable & scala.Serializable)() -> {
            ConcurrentLinkedQueue unusedParameters = new ConcurrentLinkedQueue();
            ConcurrentLinkedQueue returnedParameters = new ConcurrentLinkedQueue();
            InterruptableAI ai = new InterruptableAI();
            theProject.parForeachMethodWithBody(theProject.parForeachMethodWithBody$default$1(), theProject.parForeachMethodWithBody$default$2(), (Function1 & Serializable & scala.Serializable)m -> {
                ParameterUsageAnalysis$.$anonfun$doAnalyze$2(theProject, unusedParameters, returnedParameters, ai, m);
                return BoxedUnit.UNIT;
            });
            return new Tuple2(((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(returnedParameters).asScala()).toList().sorted((Ordering)Ordering.String$.MODULE$), ((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(unusedParameters).asScala()).toList().sorted((Ordering)Ordering.String$.MODULE$));
        }, (Function1 & Serializable & scala.Serializable)t -> {
            analysisTime.elem = Nanoseconds$.MODULE$.toSeconds$extension(((Nanoseconds)t).timeSpan());
            return BoxedUnit.UNIT;
        });
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List returnedParameters = (List)tuple2._1();
        List unusedParameters = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)returnedParameters, (Object)unusedParameters);
        Tuple2 tuple23 = tuple22;
        List returnedParameters2 = (List)tuple23._1();
        List unusedParameters2 = (List)tuple23._2();
        int occurences = returnedParameters2.size();
        return new BasicReport(new StringBuilder(0).append(returnedParameters2.mkString("Directly returned parameters:\n", "\n", "\n\n")).append(unusedParameters2.mkString("Unused parameters:\n", "\n", "\n\n")).append(new StringBuilder(45).append("\nThe analysis took ").append(new Seconds(analysisTime.elem)).append(" and found ").append(occurences).append(" direct returns").toString()).toString());
    }

    public static final /* synthetic */ Object $anonfun$doAnalyze$3(ConcurrentLinkedQueue returnedParameters$1, Instruction[] instructions$1, String methodSignature$1, int valueOrigin$1, int usage) {
        Object object;
        if (instructions$1[usage].isReturnInstruction()) {
            String use = new StringBuilder(42).append(" the argument with origin ").append(valueOrigin$1).append(" is returned by ").append(usage).toString();
            object = BoxesRunTime.boxToBoolean((boolean)returnedParameters$1.add(new StringBuilder(0).append(methodSignature$1).append(use).toString()));
        } else {
            object = BoxedUnit.UNIT;
        }
        return object;
    }

    private static final void validateArgument$1(int valueOrigin, ConcurrentLinkedQueue unusedParameters$1, ConcurrentLinkedQueue returnedParameters$1, AIResult result$1, Instruction[] instructions$1, String methodSignature$1) {
        IntTrieSet usedBy = ((RecordDefUse)result$1.domain()).usedBy(valueOrigin);
        if (usedBy == null) {
            String use = new StringBuilder(35).append(" the value with origin ").append(valueOrigin).append(" is not used").toString();
            unusedParameters$1.add(new StringBuilder(0).append(methodSignature$1).append(use).toString());
        } else {
            usedBy.foreach((Function1 & Serializable & scala.Serializable)usage -> ParameterUsageAnalysis$.$anonfun$doAnalyze$3(returnedParameters$1, instructions$1, methodSignature$1, valueOrigin, BoxesRunTime.unboxToInt((Object)usage)));
        }
    }

    public static final /* synthetic */ void $anonfun$doAnalyze$2(Project theProject$1, ConcurrentLinkedQueue unusedParameters$1, ConcurrentLinkedQueue returnedParameters$1, InterruptableAI ai$1, MethodInfo m) {
        block2: {
            Method method = m.method();
            int psCount = method.actualArgumentsCount();
            if (psCount <= 0) break block2;
            boolean isStatic = method.isStatic();
            MethodDescriptor descriptor = method.descriptor();
            BaseDomainWithDefUse domain = new BaseDomainWithDefUse(theProject$1, method);
            AIResult result = ai$1.apply(method, (Domain)domain);
            Instruction[] instructions = ((TheMethod)result.domain()).code().instructions();
            String methodSignature = method.toJava();
            for (int pIndex = method.descriptor().parametersCount() - 1; pIndex >= 0; --pIndex) {
                ParameterUsageAnalysis$.validateArgument$1(package$.MODULE$.parameterIndexToValueOrigin(isStatic, descriptor, pIndex), unusedParameters$1, returnedParameters$1, result, instructions, methodSignature);
            }
            if (!isStatic) {
                ParameterUsageAnalysis$.validateArgument$1(-1, unusedParameters$1, returnedParameters$1, result, instructions, methodSignature);
            }
        }
    }

    private ParameterUsageAnalysis$() {
        MODULE$ = this;
    }
}

