/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.ai;

import java.io.Serializable;
import java.net.URL;
import java.util.concurrent.atomic.AtomicInteger;
import org.opalj.ai.AIResult;
import org.opalj.ai.ValuesDomain;
import org.opalj.ai.domain.PerformAI$;
import org.opalj.ai.domain.TheProject;
import org.opalj.ai.domain.l1.DefaultDomain;
import org.opalj.ai.domain.l1.ReferenceValues;
import org.opalj.ai.package$;
import org.opalj.br.ClassHierarchy;
import org.opalj.br.Code;
import org.opalj.br.FieldType;
import org.opalj.br.Method;
import org.opalj.br.MethodDescriptor;
import org.opalj.br.analyses.BasicReport;
import org.opalj.br.analyses.DefaultOneStepAnalysis;
import org.opalj.br.analyses.Project;
import org.opalj.br.instructions.Instruction;
import org.opalj.br.instructions.MethodInvocationInstruction;
import org.opalj.collection.immutable.Chain;
import org.opalj.collection.immutable.RefArray;
import org.opalj.collection.immutable.UIDSet;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class MethodCallInformation$
extends DefaultOneStepAnalysis {
    public static MethodCallInformation$ MODULE$;

    static {
        new MethodCallInformation$();
    }

    public String title() {
        return "Extracting Actual Method Parameter Information";
    }

    public String description() {
        return "Analyzes the parameters of called methods to determine if we have more precise type information.";
    }

    public BasicReport doAnalyze(Project<URL> theProject, Seq<String> parameters, Function0<Object> isInterrupted) {
        AtomicInteger callsCount = new AtomicInteger();
        AtomicInteger refinedCallsCount = new AtomicInteger();
        ClassHierarchy ch = theProject.classHierarchy();
        theProject.parForeachMethodWithBody(isInterrupted, theProject.parForeachMethodWithBody$default$2(), (Function1 & Serializable & scala.Serializable)mi -> {
            MethodCallInformation$.analyzeMethod$1(mi.method(), theProject, callsCount, refinedCallsCount, ch);
            return BoxedUnit.UNIT;
        });
        return new BasicReport(new StringBuilder(70).append("Found ").append(refinedCallsCount.get()).append("/").append(callsCount.get()).append(" calls where we were able to get more precise type information.").toString());
    }

    public static final /* synthetic */ boolean $anonfun$doAnalyze$2(ClassHierarchy ch$1, FieldType t) {
        return t.isArrayType() || t.isObjectType() && ch$1.hasSubtypes(t.asObjectType()).isYesOrUnknown();
    }

    private static final boolean isPotentiallyRefinable$1(MethodDescriptor methodDescriptor, ClassHierarchy ch$1) {
        return methodDescriptor.parametersCount() > 0 && methodDescriptor.parameterTypes().exists((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)MethodCallInformation$.$anonfun$doAnalyze$2(ch$1, t)));
    }

    public static final /* synthetic */ boolean $anonfun$doAnalyze$3(RefArray parameterTypes$1, IntRef index$1, ValuesDomain.Value op) {
        ReferenceValues.ReferenceValue referenceValue;
        UIDSet utb;
        ValuesDomain.Value value = op;
        boolean bl = value instanceof ReferenceValues.ReferenceValue ? !(utb = (referenceValue = (ReferenceValues.ReferenceValue)value).upperTypeBound()).isSingletonSet() || utb.head() != parameterTypes$1.apply(index$1.elem) : false;
        boolean foundMorePreciseType = bl;
        ++index$1.elem;
        return foundMorePreciseType;
    }

    public static final /* synthetic */ Object $anonfun$doAnalyze$1(AtomicInteger callsCount$1, AtomicInteger refinedCallsCount$1, ClassHierarchy ch$1, int pc, Instruction instruction, Chain ops) {
        BoxedUnit boxedUnit;
        MethodInvocationInstruction methodInvocationInstruction;
        Instruction instruction2 = instruction;
        if (instruction2 instanceof MethodInvocationInstruction && MethodCallInformation$.isPotentiallyRefinable$1((methodInvocationInstruction = (MethodInvocationInstruction)instruction2).methodDescriptor(), ch$1)) {
            callsCount$1.incrementAndGet();
            MethodDescriptor methodDescriptor = methodInvocationInstruction.methodDescriptor();
            RefArray parameterTypes = methodDescriptor.parameterTypes();
            Chain operands = ops.take(methodDescriptor.parametersCount()).reverse();
            IntRef index = IntRef.create((int)0);
            boolean hasMorePreciseType = operands.exists((Function1 & Serializable & scala.Serializable)op -> BoxesRunTime.boxToBoolean((boolean)MethodCallInformation$.$anonfun$doAnalyze$3(parameterTypes, index, op)));
            boxedUnit = hasMorePreciseType ? BoxesRunTime.boxToInteger((int)refinedCallsCount$1.incrementAndGet()) : BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return boxedUnit;
    }

    private static final void analyzeMethod$1(Method method, Project theProject$1, AtomicInteger callsCount$1, AtomicInteger refinedCallsCount$1, ClassHierarchy ch$1) {
        DefaultDomain domain = new DefaultDomain(theProject$1, method);
        AIResult result = PerformAI$.MODULE$.apply((TheProject)domain);
        Code code = (Code)method.body().get();
        package$.MODULE$.foreachPCWithOperands((ValuesDomain)domain, code, result.operandsArray(), (Function3 & Serializable & scala.Serializable)(pc, instruction, ops) -> MethodCallInformation$.$anonfun$doAnalyze$1(callsCount$1, refinedCallsCount$1, ch$1, BoxesRunTime.unboxToInt((Object)pc), instruction, ops));
    }

    private MethodCallInformation$() {
        MODULE$ = this;
    }
}

