/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.ai;

import java.io.Serializable;
import java.net.URL;
import org.opalj.ai.AIResult;
import org.opalj.ai.BaseAI$;
import org.opalj.ai.Domain;
import org.opalj.ai.InfiniteRecursion;
import org.opalj.ai.InfiniteRecursionsDomain;
import org.opalj.ai.IntegerValuesFactory;
import org.opalj.ai.ValuesDomain;
import org.opalj.ai.domain.l1.DefaultIntegerRangeValues;
import org.opalj.ai.domain.l1.DefaultLongSetValues;
import org.opalj.ai.domain.l1.ReferenceValues;
import org.opalj.ai.package$;
import org.opalj.br.Code;
import org.opalj.br.FieldType;
import org.opalj.br.Method;
import org.opalj.br.MethodDescriptor;
import org.opalj.br.ObjectType;
import org.opalj.br.ReferenceType;
import org.opalj.br.analyses.BasicReport;
import org.opalj.br.analyses.DefaultOneStepAnalysis;
import org.opalj.br.analyses.Project;
import org.opalj.br.instructions.INVOKEINTERFACE;
import org.opalj.br.instructions.INVOKESPECIAL;
import org.opalj.br.instructions.INVOKESTATIC;
import org.opalj.br.instructions.INVOKEVIRTUAL;
import org.opalj.br.instructions.Instruction;
import org.opalj.collection.immutable.Chain;
import org.opalj.collection.immutable.Chain$;
import org.opalj.collection.mutable.Locals;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.parallel.ParIterable;
import scala.collection.parallel.ParIterable$;
import scala.collection.parallel.ParIterableLike;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction1;

public final class InfiniteRecursions$
extends DefaultOneStepAnalysis {
    public static InfiniteRecursions$ MODULE$;

    static {
        new InfiniteRecursions$();
    }

    public String title() {
        return "infinite recursions analysis";
    }

    public String description() {
        return "identifies method which calls themselves using infinite recursion";
    }

    public BasicReport doAnalyze(Project<URL> project, Seq<String> parameters, Function0<Object> isInterrupted) {
        int maxRecursionDepth = 3;
        ParIterable result = (ParIterable)((ParIterableLike)project.allClassFiles().par()).flatMap((Function1 & Serializable & scala.Serializable)classFile -> classFile.methods().flatMap((Function1 & Serializable & scala.Serializable)method -> (Seq)((TraversableLike)((TraversableLike)Option$.MODULE$.option2Iterable(method.body()).toSeq().map((Function1 & Serializable & scala.Serializable)body2 -> {
            MethodDescriptor descriptor = method.descriptor();
            return new Tuple2(body2, (Object)descriptor);
        }, Seq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)InfiniteRecursions$.$anonfun$doAnalyze$4(x$5))).map((Function1 & Serializable & scala.Serializable)x$7 -> {
            Tuple2 tuple2 = x$7;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Code body2 = (Code)tuple2._1();
            MethodDescriptor descriptor = (MethodDescriptor)tuple2._2();
            ObjectType classType = classFile.thisType();
            String name = method.name();
            Chain pcs = (Chain)body2.foldLeft((Object)Chain$.MODULE$.empty(), (Function3 & Serializable & scala.Serializable)(invokes, pc, instruction) -> InfiniteRecursions$.$anonfun$doAnalyze$7(descriptor, classType, name, invokes, BoxesRunTime.unboxToInt((Object)pc), instruction));
            Tuple4 tuple4 = new Tuple4((Object)tuple2, (Object)classType, (Object)name, (Object)pcs);
            return tuple4;
        }, Seq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)InfiniteRecursions$.$anonfun$doAnalyze$8(x$8))).flatMap((Function1 & Serializable & scala.Serializable)x$9 -> {
            Chain pcs;
            block3: {
                Tuple4 tuple4;
                block2: {
                    tuple4 = x$9;
                    if (tuple4 == null) break block2;
                    Tuple2 tuple2 = (Tuple2)tuple4._1();
                    pcs = (Chain)tuple4._4();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple4);
            }
            Iterable iterable = Option$.MODULE$.option2Iterable(MODULE$.inifiniteRecursions(maxRecursionDepth, project, (Method)method, (Chain<Object>)pcs).map((Function1 & Serializable & scala.Serializable)result -> result));
            return iterable;
        }, Seq$.MODULE$.canBuildFrom())), (CanBuildFrom)ParIterable$.MODULE$.canBuildFrom());
        return new BasicReport(((ParIterableLike)result.map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.toString(), (CanBuildFrom)ParIterable$.MODULE$.canBuildFrom())).mkString("\n"));
    }

    public Seq<String> doAnalyze$default$2() {
        return List$.MODULE$.empty();
    }

    public Option<InfiniteRecursion> inifiniteRecursions(int maxRecursionDepth, Project<?> project, Method method, Chain<Object> pcs) {
        Option option;
        Object object = new Object();
        try {
            Predef$.MODULE$.assert(maxRecursionDepth > 1);
            Predef$.MODULE$.assert(pcs.toSet().size() == pcs.size(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("the seq ").append(pcs).append(" contains duplicates").toString());
            Code body2 = (Code)method.body().get();
            int parametersCount = method.descriptor().parametersCount() + (method.isStatic() ? 0 : 1);
            InfiniteRecursionsDomain domain = new InfiniteRecursionsDomain(project, method);
            ObjectRef previousCallOperandsList = ObjectRef.create((Object)((Seq)Seq$.MODULE$.empty()));
            Chain[] initialOperandsArray = BaseAI$.MODULE$.apply(method, (Domain)domain).operandsArray();
            previousCallOperandsList.elem = InfiniteRecursions$.reduceCallOperands$1(initialOperandsArray, pcs, parametersCount);
            ((Seq)previousCallOperandsList.elem).foreach((Function1 & Serializable & scala.Serializable)callOperands -> {
                InfiniteRecursions$.$anonfun$inifiniteRecursions$11(maxRecursionDepth, method, pcs, body2, parametersCount, domain, previousCallOperandsList, object, callOperands);
                return BoxedUnit.UNIT;
            });
            option = None$.MODULE$;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                option = (Option)ex.value();
            }
            throw ex;
        }
        return option;
    }

    public static final /* synthetic */ boolean $anonfun$doAnalyze$5(FieldType t) {
        return t.isReferenceType() || t.isLongType() || t.isIntegerType();
    }

    public static final /* synthetic */ boolean $anonfun$doAnalyze$4(Tuple2 x$5) {
        Tuple2 tuple2 = x$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        MethodDescriptor descriptor = (MethodDescriptor)tuple2._2();
        boolean bl = descriptor.parameterTypes().forall((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)InfiniteRecursions$.$anonfun$doAnalyze$5(t)));
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ Chain $anonfun$doAnalyze$7(MethodDescriptor descriptor$1, ObjectType classType$1, String name$1, Chain invokes, int pc, Instruction instruction) {
        Instruction instruction2 = instruction;
        if (instruction2 instanceof INVOKEVIRTUAL) {
            INVOKEVIRTUAL iNVOKEVIRTUAL = (INVOKEVIRTUAL)instruction2;
            ReferenceType referenceType = iNVOKEVIRTUAL.declaringClass();
            String string = iNVOKEVIRTUAL.name();
            MethodDescriptor methodDescriptor = iNVOKEVIRTUAL.methodDescriptor();
            ObjectType objectType = classType$1;
            ReferenceType referenceType2 = referenceType;
            if (!(objectType != null ? !objectType.equals(referenceType2) : referenceType2 != null)) {
                String string2 = name$1;
                String string3 = string;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    MethodDescriptor methodDescriptor2 = descriptor$1;
                    MethodDescriptor methodDescriptor3 = methodDescriptor;
                    if (!(methodDescriptor2 != null ? !methodDescriptor2.equals(methodDescriptor3) : methodDescriptor3 != null)) {
                        int n = pc;
                        return invokes.$colon$amp$colon(n, Predef$.MODULE$.$conforms());
                    }
                }
            }
        }
        if (instruction2 instanceof INVOKESTATIC) {
            INVOKESTATIC iNVOKESTATIC = (INVOKESTATIC)instruction2;
            ObjectType objectType = iNVOKESTATIC.declaringClass();
            String string = iNVOKESTATIC.name();
            MethodDescriptor methodDescriptor = iNVOKESTATIC.methodDescriptor();
            ObjectType objectType2 = classType$1;
            ObjectType objectType3 = objectType;
            if (!(objectType2 != null ? !objectType2.equals(objectType3) : objectType3 != null)) {
                String string4 = name$1;
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    MethodDescriptor methodDescriptor4 = descriptor$1;
                    MethodDescriptor methodDescriptor5 = methodDescriptor;
                    if (!(methodDescriptor4 != null ? !methodDescriptor4.equals(methodDescriptor5) : methodDescriptor5 != null)) {
                        int n = pc;
                        return invokes.$colon$amp$colon(n, Predef$.MODULE$.$conforms());
                    }
                }
            }
        }
        if (instruction2 instanceof INVOKESPECIAL) {
            INVOKESPECIAL iNVOKESPECIAL = (INVOKESPECIAL)instruction2;
            ObjectType objectType = iNVOKESPECIAL.declaringClass();
            String string = iNVOKESPECIAL.name();
            MethodDescriptor methodDescriptor = iNVOKESPECIAL.methodDescriptor();
            ObjectType objectType4 = classType$1;
            ObjectType objectType5 = objectType;
            if (!(objectType4 != null ? !objectType4.equals(objectType5) : objectType5 != null)) {
                String string6 = name$1;
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    MethodDescriptor methodDescriptor6 = descriptor$1;
                    MethodDescriptor methodDescriptor7 = methodDescriptor;
                    if (!(methodDescriptor6 != null ? !methodDescriptor6.equals(methodDescriptor7) : methodDescriptor7 != null)) {
                        int n = pc;
                        return invokes.$colon$amp$colon(n, Predef$.MODULE$.$conforms());
                    }
                }
            }
        }
        if (!(instruction2 instanceof INVOKEINTERFACE)) return invokes;
        INVOKEINTERFACE iNVOKEINTERFACE = (INVOKEINTERFACE)instruction2;
        ObjectType objectType = iNVOKEINTERFACE.declaringClass();
        String string = iNVOKEINTERFACE.name();
        MethodDescriptor methodDescriptor = iNVOKEINTERFACE.methodDescriptor();
        ObjectType objectType6 = classType$1;
        ObjectType objectType7 = objectType;
        if (objectType6 == null) {
            if (objectType7 != null) {
                return invokes;
            }
        } else if (!objectType6.equals(objectType7)) return invokes;
        String string8 = name$1;
        String string9 = string;
        if (string8 == null) {
            if (string9 != null) {
                return invokes;
            }
        } else if (!string8.equals(string9)) return invokes;
        MethodDescriptor methodDescriptor8 = descriptor$1;
        MethodDescriptor methodDescriptor9 = methodDescriptor;
        if (methodDescriptor8 == null) {
            if (methodDescriptor9 != null) {
                return invokes;
            }
        } else if (!methodDescriptor8.equals(methodDescriptor9)) return invokes;
        int n = pc;
        return invokes.$colon$amp$colon(n, Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ boolean $anonfun$doAnalyze$8(Tuple4 x$8) {
        Chain pcs;
        block3: {
            Tuple4 tuple4;
            block2: {
                tuple4 = x$8;
                if (tuple4 == null) break block2;
                Tuple2 tuple2 = (Tuple2)tuple4._1();
                pcs = (Chain)tuple4._4();
                if (tuple2 != null) break block3;
            }
            throw new MatchError((Object)tuple4);
        }
        boolean bl = pcs.nonEmpty();
        return bl;
    }

    public static final /* synthetic */ Tuple2 $anonfun$inifiniteRecursions$3(int parametersCount$1, Chain[] operandsArray$1, int pc) {
        Chain nextCallOperands = operandsArray$1[pc].take(parametersCount$1);
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)pc), (Object)nextCallOperands);
    }

    public static final /* synthetic */ boolean $anonfun$inifiniteRecursions$5(Chain x2$1, Chain x$11) {
        Chain chain = x$11;
        Chain chain2 = x2$1;
        return !(chain != null ? !chain.equals(chain2) : chain2 != null);
    }

    public static final /* synthetic */ void $anonfun$inifiniteRecursions$4(ObjectRef callOperandsList$1, Tuple2 x$13) {
        BoxedUnit boxedUnit;
        Chain nextCallOperands;
        Tuple2 tuple2 = x$13;
        if (tuple2 != null && (nextCallOperands = (Chain)tuple2._2()) != null) {
            Chain chain = nextCallOperands;
            if (!((List)callOperandsList$1.elem).exists((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)InfiniteRecursions$.$anonfun$inifiniteRecursions$5(chain, x$11)))) {
                Chain chain2 = chain;
                callOperandsList$1.elem = ((List)callOperandsList$1.elem).$colon$colon((Object)chain2);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    private static final Seq reduceCallOperands$1(Chain[] operandsArray, Chain pcs$1, int parametersCount$1) {
        ObjectRef callOperandsList = ObjectRef.create((Object)List$.MODULE$.empty());
        ((Chain)pcs$1.withFilter$mcI$sp((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)pc -> operandsArray[pc] != null).map((Function1 & Serializable & scala.Serializable)pc -> InfiniteRecursions$.$anonfun$inifiniteRecursions$3(parametersCount$1, operandsArray, BoxesRunTime.unboxToInt((Object)pc)), Chain$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$13 -> {
            InfiniteRecursions$.$anonfun$inifiniteRecursions$4(callOperandsList, x$13);
            return BoxedUnit.UNIT;
        });
        return (List)callOperandsList.elem;
    }

    public static final /* synthetic */ boolean $anonfun$inifiniteRecursions$8(DefaultIntegerRangeValues.AnIntegerValue x3$1, ValuesDomain.Value x$14) {
        return x$14 == x3$1;
    }

    public static final /* synthetic */ boolean $anonfun$inifiniteRecursions$9(DefaultLongSetValues.ALongValue x4$1, ValuesDomain.Value x$15) {
        return x$15 == x4$1;
    }

    public static final /* synthetic */ boolean $anonfun$inifiniteRecursions$7(Code body$1, InfiniteRecursionsDomain domain$1, Locals[] localsArray$1, ValuesDomain.Value x0$1) {
        DefaultLongSetValues.ALongValue aLongValue;
        DefaultIntegerRangeValues.AnIntegerValue anIntegerValue;
        ReferenceValues.SingleOriginReferenceValue v;
        ValuesDomain.Value value = x0$1;
        Option option = domain$1.DomainSingleOriginReferenceValueTag().unapply((Object)value);
        boolean bl = !option.isEmpty() ? (v = (ReferenceValues.SingleOriginReferenceValue)option.get()).origin() < 0 || body$1.instructions()[v.origin()].opcode() == 187 : (value instanceof DefaultIntegerRangeValues.AnIntegerValue ? localsArray$1[0].exists(arg_0 -> InfiniteRecursions$.$anonfun$inifiniteRecursions$8$adapted(anIntegerValue = (DefaultIntegerRangeValues.AnIntegerValue)value, arg_0)) : (value instanceof DefaultLongSetValues.ALongValue ? localsArray$1[0].exists(arg_0 -> InfiniteRecursions$.$anonfun$inifiniteRecursions$9$adapted(aLongValue = (DefaultLongSetValues.ALongValue)value, arg_0)) : (value instanceof DefaultLongSetValues.LongSet ? true : value instanceof DefaultIntegerRangeValues.IntegerRange)));
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$inifiniteRecursions$6(Method method$1, Code body$1, InfiniteRecursionsDomain domain$1, ObjectRef previousCallOperandsList$1, Locals[] localsArray$1, Object nonLocalReturnKey1$1, Chain callOperands) {
        boolean bl;
        if (((Seq)previousCallOperandsList$1.elem).contains((Object)callOperands)) {
            if (callOperands.forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)InfiniteRecursions$.$anonfun$inifiniteRecursions$7(body$1, domain$1, localsArray$1, x0$1)))) {
                throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)new InfiniteRecursion(method$1, callOperands)));
            }
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    public static final /* synthetic */ void $anonfun$inifiniteRecursions$10(int maxRecursionDepth$2, Method method$1, Chain pcs$1, Code body$1, int parametersCount$1, InfiniteRecursionsDomain domain$1, ObjectRef previousCallOperandsList$1, int depth$1, Object nonLocalReturnKey1$1, Chain callOperands) {
        Option result = InfiniteRecursions$.analyze$1(depth$1 + 1, callOperands, maxRecursionDepth$2, method$1, pcs$1, body$1, parametersCount$1, domain$1, previousCallOperandsList$1);
        if (result.nonEmpty()) {
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)result);
        }
    }

    private static final Option analyze$1(int depth, Chain callOperands2, int maxRecursionDepth$2, Method method$1, Chain pcs$1, Code body$1, int parametersCount$1, InfiniteRecursionsDomain domain$1, ObjectRef previousCallOperandsList$1) {
        Option option;
        Object object = new Object();
        try {
            if (depth > maxRecursionDepth$2) {
                return None$.MODULE$;
            }
            Locals parameters = package$.MODULE$.mapOperandsToParameters(callOperands2, method$1, (IntegerValuesFactory)domain$1);
            AIResult aiResult = BaseAI$.MODULE$.performInterpretation(body$1, (Domain)domain$1, Chain$.MODULE$.empty(), parameters);
            Chain[] operandsArray = aiResult.operandsArray();
            Locals[] localsArray = aiResult.localsArray();
            Seq callOperandsList = (Seq)InfiniteRecursions$.reduceCallOperands$1(operandsArray, pcs$1, parametersCount$1).filter((Function1 & Serializable & scala.Serializable)callOperands -> BoxesRunTime.boxToBoolean((boolean)InfiniteRecursions$.$anonfun$inifiniteRecursions$6(method$1, body$1, domain$1, previousCallOperandsList$1, localsArray, object, callOperands)));
            callOperandsList.foreach((Function1 & Serializable & scala.Serializable)callOperands -> {
                InfiniteRecursions$.$anonfun$inifiniteRecursions$10(maxRecursionDepth$2, method$1, pcs$1, body$1, parametersCount$1, domain$1, previousCallOperandsList$1, depth, object, callOperands);
                return BoxedUnit.UNIT;
            });
            option = None$.MODULE$;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                option = (Option)ex.value();
            }
            throw ex;
        }
        return option;
    }

    public static final /* synthetic */ void $anonfun$inifiniteRecursions$11(int maxRecursionDepth$2, Method method$1, Chain pcs$1, Code body$1, int parametersCount$1, InfiniteRecursionsDomain domain$1, ObjectRef previousCallOperandsList$1, Object nonLocalReturnKey2$1, Chain callOperands) {
        Option result = InfiniteRecursions$.analyze$1(0, callOperands, maxRecursionDepth$2, method$1, pcs$1, body$1, parametersCount$1, domain$1, previousCallOperandsList$1);
        if (result.nonEmpty()) {
            throw new NonLocalReturnControl(nonLocalReturnKey2$1, (Object)result);
        }
    }

    private InfiniteRecursions$() {
        MODULE$ = this;
    }

    public static final /* synthetic */ Object $anonfun$inifiniteRecursions$8$adapted(DefaultIntegerRangeValues.AnIntegerValue x3$1, ValuesDomain.Value x$14) {
        return BoxesRunTime.boxToBoolean((boolean)InfiniteRecursions$.$anonfun$inifiniteRecursions$8(x3$1, x$14));
    }

    public static final /* synthetic */ Object $anonfun$inifiniteRecursions$9$adapted(DefaultLongSetValues.ALongValue x4$1, ValuesDomain.Value x$15) {
        return BoxesRunTime.boxToBoolean((boolean)InfiniteRecursions$.$anonfun$inifiniteRecursions$9(x4$1, x$15));
    }
}

