/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.util;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import org.opalj.log.GlobalLogContext$;
import org.opalj.log.LogContext;
import org.opalj.log.OPALLogger$;
import org.opalj.util.Nanoseconds;
import org.opalj.util.Nanoseconds$;
import org.opalj.util.package$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.math.Numeric;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

public final class PerformanceEvaluation$ {
    public static PerformanceEvaluation$ MODULE$;

    static {
        new PerformanceEvaluation$();
    }

    public <T> T memory(Function0<T> f, Function1<Object, BoxedUnit> mu, Option<LogContext> logContext) {
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        package$.MODULE$.gc(memoryMXBean, package$.MODULE$.gc$default$2(), logContext);
        long usedBefore = memoryMXBean.getHeapMemoryUsage().getUsed();
        Object r = f.apply();
        package$.MODULE$.gc(memoryMXBean, package$.MODULE$.gc$default$2(), logContext);
        long usedAfter = memoryMXBean.getHeapMemoryUsage().getUsed();
        mu.apply$mcVJ$sp(usedAfter - usedBefore);
        return (T)r;
    }

    public <T> Option<LogContext> memory$default$3(Function0<T> f, Function1<Object, BoxedUnit> mu) {
        return None$.MODULE$;
    }

    public <T> T time(Function0<T> f, Function1<Nanoseconds, BoxedUnit> r) {
        Object object;
        long startTime = System.nanoTime();
        try {
            object = f.apply();
        }
        finally {
            long endTime = System.nanoTime();
            r.apply((Object)new Nanoseconds(Nanoseconds$.MODULE$.TimeSpan(startTime, endTime)));
        }
        Object result = object;
        return (T)result;
    }

    public <T> Tuple2<Nanoseconds, T> timed(Function0<T> f) {
        long startTime = System.nanoTime();
        Object result = f.apply();
        return new Tuple2((Object)new Nanoseconds(Nanoseconds$.MODULE$.TimeSpan(startTime, System.nanoTime())), result);
    }

    public <T> T time(int epsilon, int consideredRunsEpsilon, int minimalNumberOfRelevantRuns, Function0<T> f, boolean runGC, Function2<Nanoseconds, Seq<Nanoseconds>, BoxedUnit> r) {
        Object object;
        Object object2 = new Object();
        try {
            Predef$.MODULE$.require(minimalNumberOfRelevantRuns >= 3);
            Predef$.MODULE$.require(consideredRunsEpsilon > epsilon, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("epsilon (").append(epsilon).append(") < consideredRunsEpsilon (").append(consideredRunsEpsilon).append(")").toString());
            ObjectRef result = ObjectRef.create((Object)BoxesRunTime.boxToInteger((int)0));
            double e = (double)epsilon / 100.0;
            double filterE = (double)(consideredRunsEpsilon + 100) / 100.0;
            IntRef runsSinceLastUpdate = IntRef.create((int)0);
            ObjectRef times = ObjectRef.create((Object)List$.MODULE$.empty());
            if (runGC) {
                MemoryMXBean x$7 = package$.MODULE$.gc$default$1();
                long x$8 = package$.MODULE$.gc$default$2();
                Option<LogContext> x$9 = package$.MODULE$.gc$default$3(x$7, x$8);
                package$.MODULE$.gc(x$7, x$8, x$9);
            }
            this.time(f, (Function1<Nanoseconds, BoxedUnit>)(Function1 & Serializable & scala.Serializable)t -> {
                PerformanceEvaluation$.$anonfun$time$3(r, result, times, object2, ((Nanoseconds)t).timeSpan());
                return BoxedUnit.UNIT;
            });
            DoubleRef avg = DoubleRef.create((double)((Nanoseconds)((List)times.elem).head()).timeSpan());
            do {
                if (runGC) {
                    MemoryMXBean x$10 = package$.MODULE$.gc$default$1();
                    long x$11 = package$.MODULE$.gc$default$2();
                    Option<LogContext> x$12 = package$.MODULE$.gc$default$3(x$10, x$11);
                    package$.MODULE$.gc(x$10, x$11, x$12);
                }
                this.time((Function0<T>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    result$1.elem = f.apply();
                }, (Function1<Nanoseconds, BoxedUnit>)(Function1 & Serializable & scala.Serializable)t -> {
                    PerformanceEvaluation$.$anonfun$time$5(minimalNumberOfRelevantRuns, r, filterE, runsSinceLastUpdate, times, avg, ((Nanoseconds)t).timeSpan());
                    return BoxedUnit.UNIT;
                });
            } while (((List)times.elem).size() < minimalNumberOfRelevantRuns || Math.abs(avg.elem - (double)((Nanoseconds)((List)times.elem).head()).timeSpan()) > avg.elem * e);
            object = result.elem;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object2) {
                object = ex.value();
            }
            throw ex;
        }
        return (T)object;
    }

    public <T> boolean time$default$5() {
        return false;
    }

    public <T, X> X run(Function0<T> f, Function2<Nanoseconds, T, X> r) {
        long startTime = System.nanoTime();
        Object result = f.apply();
        long endTime = System.nanoTime();
        return (X)r.apply((Object)new Nanoseconds(Nanoseconds$.MODULE$.TimeSpan(startTime, endTime)), result);
    }

    public static final /* synthetic */ void $anonfun$time$3(Function2 r$1, ObjectRef result$1, ObjectRef times$1, Object nonLocalReturnKey1$1, long t) {
        long l = t;
        times$1.elem = ((List)times$1.elem).$colon$colon((Object)new Nanoseconds(l));
        if (t <= 199999L) {
            r$1.apply((Object)new Nanoseconds(t), (Object)((List)times$1.elem));
            OPALLogger$.MODULE$.warn("common", new StringBuilder(81).append("the time required by the function (").append(Nanoseconds$.MODULE$.toString$extension1(t)).append(") ").append("is too small to get meaningful measurements.").toString(), GlobalLogContext$.MODULE$);
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, result$1.elem);
        }
    }

    public static final /* synthetic */ boolean $anonfun$time$6(double filterE$1, long t$1, long x$2) {
        return (double)x$2 <= (double)t$1 * filterE$1;
    }

    public static final /* synthetic */ void $anonfun$time$5(int minimalNumberOfRelevantRuns$1, Function2 r$1, double filterE$1, IntRef runsSinceLastUpdate$1, ObjectRef times$1, DoubleRef avg$1, long t) {
        if ((double)t <= avg$1.elem * filterE$1) {
            long l = t;
            times$1.elem = ((List)((List)times$1.elem).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)PerformanceEvaluation$.$anonfun$time$6(filterE$1, t, ((Nanoseconds)x$2).timeSpan())))).$colon$colon((Object)new Nanoseconds(l));
            avg$1.elem = (double)BoxesRunTime.unboxToLong((Object)((TraversableOnce)((List)times$1.elem).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)((Nanoseconds)x$4).timeSpan()), List$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / (double)((List)times$1.elem).size();
            runsSinceLastUpdate$1.elem = 0;
        } else {
            ++runsSinceLastUpdate$1.elem;
            if (runsSinceLastUpdate$1.elem > minimalNumberOfRelevantRuns$1 * 2) {
                long l = t;
                times$1.elem = ((List)times$1.elem).$colon$colon((Object)new Nanoseconds(l));
                avg$1.elem = (double)BoxesRunTime.unboxToLong((Object)((TraversableOnce)((List)times$1.elem).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)((Nanoseconds)x$6).timeSpan()), List$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / (double)((List)times$1.elem).size();
                runsSinceLastUpdate$1.elem = 0;
            }
        }
        r$1.apply((Object)new Nanoseconds(t), (Object)((List)times$1.elem));
    }

    private PerformanceEvaluation$() {
        MODULE$ = this;
    }
}

