/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.io;

import java.awt.Desktop;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.GZIPOutputStream;
import org.opalj.io.OpeningFileFailedException;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.TraversableOnce$;
import scala.collection.immutable.StringOps;
import scala.io.Source;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.xml.Node;

public final class package$ {
    public static package$ MODULE$;

    static {
        new package$();
    }

    public String sanitizeFileName(String fileName) {
        return (String)new StringOps(Predef$.MODULE$.augmentString(((String)new StringOps(Predef$.MODULE$.augmentString(fileName)).filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)package$.$anonfun$sanitizeFileName$1(BoxesRunTime.unboxToChar((Object)x$1))))).replaceAll("[\\/:*?\"<>|\\[\\]=!@,]", "_"))).take(192);
    }

    public File writeAndOpen(Node node, String filenamePrefix, String filenameSuffix) throws IOException, OpeningFileFailedException {
        String data = node.toString();
        return this.writeAndOpen(data, filenamePrefix, filenameSuffix);
    }

    public File writeAndOpen(String data, String filenamePrefix, String filenameSuffix) throws IOException, OpeningFileFailedException {
        File file = this.write(data, filenamePrefix, filenameSuffix).toFile();
        this.open(file);
        return file;
    }

    public void open(File file) {
        try {
            Desktop.getDesktop().open(file);
        }
        catch (Throwable t) {
            throw new OpeningFileFailedException(file, t);
        }
    }

    public Path write(String data, String filenamePrefix, String filenameSuffix) {
        return this.write((TraversableOnce<String>)((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{data}))), filenamePrefix, filenameSuffix);
    }

    public Path write(TraversableOnce<String> data, String filenamePrefix, String filenameSuffix) {
        Path path = Files.createTempFile(this.sanitizeFileName(filenamePrefix), this.sanitizeFileName(filenameSuffix), new FileAttribute[0]);
        this.write((TraversableOnce<byte[]>)TraversableOnce$.MODULE$.MonadOps(data).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getBytes("UTF-8")), path);
        return path;
    }

    public Path writeGZip(String data, String filenamePrefix, String filenameSuffix) {
        return this.writeGZip((TraversableOnce<String>)((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{data}))), filenamePrefix, filenameSuffix);
    }

    public Path writeGZip(TraversableOnce<String> data, String filenamePrefix, String filenameSuffix) {
        Path path = Files.createTempFile(this.sanitizeFileName(filenamePrefix), this.sanitizeFileName(filenameSuffix), new FileAttribute[0]);
        this.writeGZip((TraversableOnce<byte[]>)TraversableOnce$.MODULE$.MonadOps(data).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getBytes("UTF-8")), path);
        return path;
    }

    public void write(byte[] data, Path path) {
        Files.write(path, data, new OpenOption[0]);
    }

    public void write(TraversableOnce<byte[]> data, Path path) {
        try (FileOutputStream out = new FileOutputStream(path.toFile());){
            data.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                out.write(x$1);
                return BoxedUnit.UNIT;
            });
        }
    }

    public void writeGZip(byte[] data, Path path) {
        this.writeGZip((TraversableOnce<byte[]>)((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{data}))), path);
    }

    public void writeGZip(TraversableOnce<byte[]> data, Path path) {
        try (GZIPOutputStream out = new GZIPOutputStream(new FileOutputStream(path.toFile()));){
            data.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                out.write(x$1);
                return BoxedUnit.UNIT;
            });
        }
    }

    public <C extends Closeable, T> T process(C closable, Function1<C, T> r) {
        Object object;
        try {
            object = r.apply(closable);
        }
        finally {
            if (closable != null) {
                closable.close();
            }
        }
        return (T)object;
    }

    public <C extends Source, T> T processSource(C source, Function1<C, T> r) {
        Object object;
        try {
            object = r.apply(source);
        }
        finally {
            if (source != null) {
                source.close();
            }
        }
        return (T)object;
    }

    public static final /* synthetic */ boolean $anonfun$sanitizeFileName$1(char x$1) {
        return x$1 == ' ';
    }

    private package$() {
        MODULE$ = this;
    }
}

