/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.concurrent;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.opalj.concurrent.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00193A!\u0001\u0002\u0001\u0013\t1r\nU!M)\"\u0014X-\u00193Q_>dW\t_3dkR|'O\u0003\u0002\u0004\t\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005\u00151\u0011!B8qC2T'\"A\u0004\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001Q\u0001CA\u0006\u0012\u001b\u0005a!BA\u0002\u000e\u0015\tqq\"\u0001\u0003vi&d'\"\u0001\t\u0002\t)\fg/Y\u0005\u0003%1\u0011!\u0003\u00165sK\u0006$\u0007k\\8m\u000bb,7-\u001e;pe\"AA\u0003\u0001B\u0001B\u0003%Q#A\u0001o!\t1\u0012$D\u0001\u0018\u0015\u0005A\u0012!B:dC2\f\u0017B\u0001\u000e\u0018\u0005\rIe\u000e\u001e\u0005\t9\u0001\u0011)\u0019!C\u0001;\u0005)qM]8vaV\ta\u0004\u0005\u0002 E5\t\u0001E\u0003\u0002\"\u001f\u0005!A.\u00198h\u0013\t\u0019\u0003EA\u0006UQJ,\u0017\rZ$s_V\u0004\b\u0002C\u0013\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0010\u0002\r\u001d\u0014x.\u001e9!\u0011\u00159\u0003\u0001\"\u0001)\u0003\u0019a\u0014N\\5u}Q\u0019\u0011f\u000b\u0017\u0011\u0005)\u0002Q\"\u0001\u0002\t\u000bQ1\u0003\u0019A\u000b\t\u000bq1\u0003\u0019\u0001\u0010\t\u000b9\u0002A\u0011I\u0018\u0002\u0019\u00054G/\u001a:Fq\u0016\u001cW\u000f^3\u0015\u0007A\u001a\u0004\b\u0005\u0002\u0017c%\u0011!g\u0006\u0002\u0005+:LG\u000fC\u00035[\u0001\u0007Q'A\u0001s!\tyb'\u0003\u00028A\tA!+\u001e8oC\ndW\rC\u0003:[\u0001\u0007!(A\u0001u!\tY4I\u0004\u0002=\u0003:\u0011Q\bQ\u0007\u0002})\u0011q\bC\u0001\u0007yI|w\u000e\u001e \n\u0003aI!AQ\f\u0002\u000fA\f7m[1hK&\u0011A)\u0012\u0002\n)\"\u0014xn^1cY\u0016T!AQ\f")
public class OPALThreadPoolExecutor
extends ThreadPoolExecutor {
    private final ThreadGroup group;

    public ThreadGroup group() {
        return this.group;
    }

    @Override
    public void afterExecute(Runnable r, Throwable t) {
        block6: {
            Object object;
            super.afterExecute(r, t);
            Throwable e = t;
            if (e == null && r instanceof Future) {
                try {
                    object = ((Future)((Object)r)).get();
                }
                catch (CancellationException ce) {
                    e = ce;
                    object = BoxedUnit.UNIT;
                }
                catch (ExecutionException ee) {
                    e = ee.getCause();
                    object = BoxedUnit.UNIT;
                }
                catch (InterruptedException ie) {
                    e = ie;
                    Thread.currentThread().interrupt();
                    object = BoxedUnit.UNIT;
                }
            } else {
                object = BoxedUnit.UNIT;
            }
            if (e == null) break block6;
            package$.MODULE$.handleUncaughtException(e);
        }
    }

    public OPALThreadPoolExecutor(int n, ThreadGroup group) {
        this.group = group;
        super(n, n, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(n, group){
            private final AtomicLong nextID;
            private final int n$1;
            private final ThreadGroup group$1;

            public AtomicLong nextID() {
                return this.nextID;
            }

            public Thread newThread(Runnable r) {
                String id = String.valueOf(BoxesRunTime.boxToLong((long)this.nextID().incrementAndGet()));
                String name = new StringBuilder(32).append("org.opalj.ThreadPool[N=").append(this.n$1).append("]-Thread ").append(id).toString();
                Thread t = new Thread(this.group$1, r, name);
                t.setDaemon(true);
                t.setUncaughtExceptionHandler(package$.MODULE$.UncaughtExceptionHandler());
                return t;
            }
            {
                this.n$1 = n$1;
                this.group$1 = group$1;
                this.nextID = new AtomicLong(0L);
            }
        });
    }
}

