/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.collection.immutable;

import java.io.Serializable;
import java.util.Arrays;
import org.opalj.collection.immutable.Chain;
import org.opalj.collection.immutable.EmptyIntArraySet$;
import org.opalj.collection.immutable.IntArraySet;
import org.opalj.collection.immutable.IntArraySet1;
import org.opalj.collection.immutable.IntArraySet2;
import org.opalj.collection.immutable.IntArraySet3;
import org.opalj.collection.immutable.IntArraySetBuilder$;
import org.opalj.collection.immutable.IntArraySetN;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.Growable;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Builder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001E4A!\u0001\u0002\u0001\u0017\t\u0011\u0012J\u001c;BeJ\f\u0017pU3u\u0005VLG\u000eZ3s\u0015\t\u0019A!A\u0005j[6,H/\u00192mK*\u0011QAB\u0001\u000bG>dG.Z2uS>t'BA\u0004\t\u0003\u0015y\u0007/\u00197k\u0015\u0005I\u0011aA8sO\u000e\u00011c\u0001\u0001\r%A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001a\u0004BaE\f\u001a95\tAC\u0003\u0002\u0016-\u00059Q.\u001e;bE2,'BA\u0003\u000f\u0013\tABCA\u0004Ck&dG-\u001a:\u0011\u00055Q\u0012BA\u000e\u000f\u0005\rIe\u000e\u001e\t\u0003;yi\u0011AA\u0005\u0003?\t\u00111\"\u00138u\u0003J\u0014\u0018-_*fi\"A\u0011\u0005\u0001B\u0001B\u0003&!%\u0001\u0002jgB\u0019QbI\r\n\u0005\u0011r!!B!se\u0006L\b\u0002\u0003\u0014\u0001\u0005\u0003\u0005\u000b\u0015B\r\u0002\tML'0\u001a\u0005\u0007Q\u0001!\tAA\u0015\u0002\rqJg.\u001b;?)\rQ3\u0006\f\t\u0003;\u0001AQ!I\u0014A\u0002\tBQAJ\u0014A\u0002eAQ\u0001\u000b\u0001\u0005\u00029\"\u0012A\u000b\u0005\u0006Q\u0001!\t\u0001\r\u000b\u0003UEBQAM\u0018A\u0002e\t1\"\u001b8ji&\fGnU5{K\")A\u0007\u0001C!k\u0005AA\u0005\u001d7vg\u0012*\u0017\u000f\u0006\u00027o5\t\u0001\u0001C\u00039g\u0001\u0007\u0011$\u0001\u0003fY\u0016l\u0007\"\u0002\u001e\u0001\t\u0003Y\u0014!\u0004\u0013qYV\u001cH\u0005\u001d7vg\u0012*\u0017\u000f\u0006\u00027y!)Q(\u000fa\u00019\u0005)Q\r\\3ng\")q\b\u0001C!\u0001\u0006)1\r\\3beR\t\u0011\t\u0005\u0002\u000e\u0005&\u00111I\u0004\u0002\u0005+:LG\u000fC\u0003F\u0001\u0011\u0005c)\u0001\u0004sKN,H\u000e\u001e\u000b\u00029!)\u0001\n\u0001C!\u0013\u0006AAo\\*ue&tw\rF\u0001K!\tY%K\u0004\u0002M!B\u0011QJD\u0007\u0002\u001d*\u0011qJC\u0001\u0007yI|w\u000e\u001e \n\u0005Es\u0011A\u0002)sK\u0012,g-\u0003\u0002T)\n11\u000b\u001e:j]\u001eT!!\u0015\b\b\u000bY\u0013\u0001\u0012A,\u0002%%sG/\u0011:sCf\u001cV\r\u001e\"vS2$WM\u001d\t\u0003;a3Q!\u0001\u0002\t\u0002e\u001b\"\u0001\u0017\u0007\t\u000b!BF\u0011A.\u0015\u0003]CQ!\u0018-\u0005\u0002y\u000bQ!\u00199qYf$\"AK0\t\u000b\u0001d\u0006\u0019A1\u0002\u0005Y\u001c\bcA\u0007c3%\u00111M\u0004\u0002\u000byI,\u0007/Z1uK\u0012t\u0004\"B/Y\t\u0003)GC\u0001\u0016g\u0011\u0015\u0001G\r1\u0001h!\rY\u0005.G\u0005\u0003SR\u00131aU3u\u0011\u0015i\u0006\f\"\u0001l)\tQC\u000eC\u0003nU\u0002\u0007a.A\u0001d!\rir.G\u0005\u0003a\n\u0011Qa\u00115bS:\u0004")
public class IntArraySetBuilder
implements Builder<Object, IntArraySet> {
    private int[] is;
    private int size;

    public static IntArraySetBuilder apply(Chain<Object> chain) {
        return IntArraySetBuilder$.MODULE$.apply(chain);
    }

    public static IntArraySetBuilder apply(Set<Object> set) {
        return IntArraySetBuilder$.MODULE$.apply(set);
    }

    public static IntArraySetBuilder apply(Seq<Object> seq) {
        return IntArraySetBuilder$.MODULE$.apply(seq);
    }

    public void sizeHint(int size) {
        Builder.sizeHint$((Builder)this, (int)size);
    }

    public void sizeHint(TraversableLike<?, ?> coll) {
        Builder.sizeHint$((Builder)this, coll);
    }

    public void sizeHint(TraversableLike<?, ?> coll, int delta) {
        Builder.sizeHint$((Builder)this, coll, (int)delta);
    }

    public void sizeHintBounded(int size, TraversableLike<?, ?> boundingColl) {
        Builder.sizeHintBounded$((Builder)this, (int)size, boundingColl);
    }

    public <NewTo> Builder<Object, NewTo> mapResult(Function1<IntArraySet, NewTo> f) {
        return Builder.mapResult$((Builder)this, f);
    }

    public Growable $plus$eq(Object elem1, Object elem2, Seq elems) {
        return Growable.$plus$eq$((Growable)this, (Object)elem1, (Object)elem2, (Seq)elems);
    }

    public Growable<Object> $plus$plus$eq(TraversableOnce<Object> xs) {
        return Growable.$plus$plus$eq$((Growable)this, xs);
    }

    public IntArraySetBuilder $plus$eq(int elem) {
        block2: {
            int index = Arrays.binarySearch(this.is, 0, this.size, elem);
            if (index >= 0) break block2;
            ++this.size;
            int insertionPoint = -index - 1;
            if (this.size <= this.is.length) {
                System.arraycopy(this.is, insertionPoint, this.is, insertionPoint + 1, this.size - 1 - insertionPoint);
                this.is[insertionPoint] = elem;
            } else {
                int[] targetIs = new int[this.is.length * 2];
                System.arraycopy(this.is, 0, targetIs, 0, insertionPoint);
                targetIs[insertionPoint] = elem;
                int count = this.is.length - insertionPoint;
                System.arraycopy(this.is, insertionPoint, targetIs, insertionPoint + 1, count);
                this.is = targetIs;
            }
        }
        return this;
    }

    public IntArraySetBuilder $plus$plus$eq(IntArraySet elems) {
        elems.foreach((Function1 & Serializable & scala.Serializable)elem -> this.$plus$eq(BoxesRunTime.unboxToInt((Object)elem)));
        return this;
    }

    public void clear() {
        this.is = new int[4];
        this.size = 0;
    }

    public IntArraySet result() {
        IntArraySet intArraySet;
        int n = this.size;
        switch (n) {
            case 0: {
                intArraySet = EmptyIntArraySet$.MODULE$;
                break;
            }
            case 1: {
                intArraySet = new IntArraySet1(this.is[0]);
                break;
            }
            case 2: {
                intArraySet = new IntArraySet2(this.is[0], this.is[1]);
                break;
            }
            case 3: {
                intArraySet = new IntArraySet3(this.is[0], this.is[1], this.is[2]);
                break;
            }
            default: {
                if (this.size == this.is.length) {
                    intArraySet = new IntArraySetN(this.is);
                    break;
                }
                int[] targetIs = new int[this.size];
                System.arraycopy(this.is, 0, targetIs, 0, this.size);
                intArraySet = new IntArraySetN(targetIs);
                break;
            }
        }
        return intArraySet;
    }

    public String toString() {
        return new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.is)).mkString(new StringBuilder(33).append("IntArraySetBuilder(size=").append(this.size).append(";values={").toString(), ",", "})");
    }

    public IntArraySetBuilder(int[] is, int size) {
        this.is = is;
        this.size = size;
        Growable.$init$((Growable)this);
        Builder.$init$((Builder)this);
        Predef$.MODULE$.require(size <= is.length);
    }

    public IntArraySetBuilder() {
        this(new int[4], 0);
    }

    public IntArraySetBuilder(int initialSize) {
        this(new int[Math.max(initialSize, 4)], 0);
    }
}

