/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.concurrent;

import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.opalj.concurrent.ConcurrentExceptions;
import org.opalj.concurrent.OPALThreadPoolExecutor;
import org.opalj.log.GlobalLogContext$;
import org.opalj.log.OPALLogger$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.parallel.ExecutionContextTaskSupport;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Try;
import scala.util.control.ControlThrowable;

public final class package$ {
    public static package$ MODULE$;
    private final Function0<Object> defaultIsInterrupted;
    private final int NumberOfThreadsForCPUBoundTasks;
    private final int NumberOfThreadsForIOBoundTasks;
    private final Thread.UncaughtExceptionHandler UncaughtExceptionHandler;
    private final OPALThreadPoolExecutor ThreadPool;
    private final ExecutionContext OPALExecutionContext;
    private final ExecutionContextTaskSupport OPALExecutionContextTaskSupport;

    static {
        new package$();
    }

    private GlobalLogContext$ logContext() {
        return GlobalLogContext$.MODULE$;
    }

    public final Function0<Object> defaultIsInterrupted() {
        return this.defaultIsInterrupted;
    }

    public final void handleUncaughtException(Throwable t) {
        OPALLogger$.MODULE$.error("internal", "uncaught exception", t, this.logContext());
    }

    public final void handleUncaughtException(Thread t, Throwable e) {
        OPALLogger$.MODULE$.error("internal", new StringBuilder(28).append("uncaught exception (Thread=").append(t.getName()).append(")").toString(), e, this.logContext());
    }

    public final int NumberOfThreadsForCPUBoundTasks() {
        return this.NumberOfThreadsForCPUBoundTasks;
    }

    public final int NumberOfThreadsForIOBoundTasks() {
        return this.NumberOfThreadsForIOBoundTasks;
    }

    public final Thread.UncaughtExceptionHandler UncaughtExceptionHandler() {
        return this.UncaughtExceptionHandler;
    }

    /*
     * WARNING - void declaration
     */
    public OPALThreadPoolExecutor ThreadPoolN(int n) {
        void var3_3;
        ThreadGroup group = new ThreadGroup(new StringBuilder(21).append("org.opalj.ThreadPool ").append(System.nanoTime()).toString());
        OPALThreadPoolExecutor tp = new OPALThreadPoolExecutor(n, group);
        tp.allowCoreThreadTimeOut(true);
        tp.prestartAllCoreThreads();
        return var3_3;
    }

    public ExecutionContext ExecutionContextN(int n) {
        return ExecutionContext$.MODULE$.fromExecutorService((ExecutorService)this.ThreadPoolN(n));
    }

    public final OPALThreadPoolExecutor ThreadPool() {
        return this.ThreadPool;
    }

    public final ExecutionContext OPALExecutionContext() {
        return this.OPALExecutionContext;
    }

    public final ExecutionContextTaskSupport OPALExecutionContextTaskSupport() {
        return this.OPALExecutionContextTaskSupport;
    }

    public <T, U> void parForeachArrayElement(Object data, int parallelizationLevel, Function0<Object> isInterrupted, Function1<T, U> f) throws ConcurrentExceptions {
        ConcurrentExceptions exceptions = new ConcurrentExceptions();
        if (parallelizationLevel == 1) {
            Predef$.MODULE$.genericArrayOps(data).forall((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)package$.$anonfun$parForeachArrayElement$1(isInterrupted, f, exceptions, e)));
            if (exceptions.getSuppressed().length > 0) {
                throw exceptions;
            }
            return;
        }
        int max = ScalaRunTime$.MODULE$.array_length(data);
        AtomicInteger index = new AtomicInteger(0);
        Future[] futures = new Future[parallelizationLevel];
        try {
            for (int t = 0; t < parallelizationLevel; ++t) {
                futures[t] = Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    int i = -1;
                    while ((i = index.getAndIncrement()) < max && !isInterrupted.apply$mcZ$sp()) {
                        Object object;
                        Object e = ScalaRunTime$.MODULE$.array_apply(data, i);
                        try {
                            object = f.apply(e);
                        }
                        catch (Throwable throwable) {
                            BoxedUnit boxedUnit;
                            Throwable throwable2 = throwable;
                            if (throwable2 instanceof ControlThrowable) {
                                ControlThrowable controlThrowable = (ControlThrowable)throwable2;
                                Throwable t = new Throwable("unsupported non-local return", (Throwable)controlThrowable);
                                exceptions.addSuppressed(t);
                                boxedUnit = BoxedUnit.UNIT;
                            } else if (throwable2 != null) {
                                Throwable throwable3 = throwable2;
                                exceptions.addSuppressed(throwable3);
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                throw throwable;
                            }
                            object = boxedUnit;
                        }
                    }
                }, this.OPALExecutionContext());
            }
            for (int t = 0; t < parallelizationLevel; ++t) {
                BoxedUnit boxedUnit;
                Future future = futures[t];
                Try try_ = (Try)((Future)Await$.MODULE$.ready((Awaitable)future, (Duration)Duration$.MODULE$.Inf())).value().get();
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable exception = failure.exception();
                    exceptions.addSuppressed(exception);
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        }
        catch (Throwable t) {
            exceptions.addSuppressed(t);
        }
        if (exceptions.getSuppressed().length > 0) {
            throw exceptions;
        }
    }

    public <T, U> int parForeachArrayElement$default$2() {
        return this.NumberOfThreadsForCPUBoundTasks();
    }

    public <T, U> Function0<Object> parForeachArrayElement$default$3() {
        return (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> Thread.currentThread().isInterrupted();
    }

    public static final /* synthetic */ boolean $anonfun$parForeachArrayElement$1(Function0 isInterrupted$1, Function1 f$1, ConcurrentExceptions exceptions$1, Object e) {
        Object object;
        try {
            object = f$1.apply(e);
        }
        catch (Throwable throwable) {
            BoxedUnit boxedUnit;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ControlThrowable) {
                ControlThrowable controlThrowable = (ControlThrowable)throwable2;
                Throwable t = new Throwable("unsupported non-local return", (Throwable)controlThrowable);
                exceptions$1.addSuppressed(t);
                boxedUnit = BoxedUnit.UNIT;
            } else if (throwable2 != null) {
                Throwable throwable3 = throwable2;
                exceptions$1.addSuppressed(throwable3);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                throw throwable;
            }
            object = boxedUnit;
        }
        return !isInterrupted$1.apply$mcZ$sp();
    }

    /*
     * WARNING - void declaration
     */
    private package$() {
        int n;
        int n2;
        MODULE$ = this;
        this.defaultIsInterrupted = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> Thread.currentThread().isInterrupted();
        String maxCPUBoundTasks = System.getProperty("org.opalj.threads.CPUBoundTasks");
        if (maxCPUBoundTasks != null) {
            void var2_2;
            int t = Integer.parseInt(maxCPUBoundTasks);
            if (t <= 0) {
                String message = new StringBuilder(65).append("org.opalj.threads.CPUBoundTasks must be larger than 0 (current: ").append(t).append(")").toString();
                throw new IllegalArgumentException(message);
            }
            n2 = var2_2;
        } else {
            OPALLogger$.MODULE$.warn("OPAL", "the property org.opalj.threads.CPUBoundTasks is unspecified", this.logContext());
            n2 = Runtime.getRuntime().availableProcessors();
        }
        this.NumberOfThreadsForCPUBoundTasks = n2;
        OPALLogger$.MODULE$.info("OPAL", new StringBuilder(198).append("using ").append(this.NumberOfThreadsForCPUBoundTasks()).append(" thread(s) for CPU bound tasks ").append("(can be changed by setting the system property org.opalj.threads.CPUBoundTasks; ").append("the number should be equal to the number of physical \u2013 not hyperthreaded \u2013 cores)").toString(), this.logContext());
        String maxIOBoundTasks = System.getProperty("org.opalj.threads.IOBoundTasks");
        if (maxIOBoundTasks != null) {
            int s = Integer.parseInt(maxIOBoundTasks);
            if (s < this.NumberOfThreadsForCPUBoundTasks()) {
                throw new IllegalArgumentException(new StringBuilder(54).append("org.opalj.threads.IOBoundTasks===").append(s).append(" must be larger than ").append(new StringBuilder(34).append("org.opalj.threads.CPUBoundTasks===").append(this.NumberOfThreadsForCPUBoundTasks()).toString()).toString());
            }
            n = s;
        } else {
            OPALLogger$.MODULE$.warn("OPAL", "the property org.opalj.threads.IOBoundTasks is unspecified", this.logContext());
            n = Runtime.getRuntime().availableProcessors() * 2;
        }
        this.NumberOfThreadsForIOBoundTasks = n;
        OPALLogger$.MODULE$.info("OPAL", new StringBuilder(203).append("using at most ").append(this.NumberOfThreadsForIOBoundTasks()).append(" thread(s) for IO bound tasks ").append("(can be changed by setting the system property org.opalj.threads.IOBoundTasks; ").append("the number should be betweeen 1 and 2 times the number of (hyperthreaded) cores)").toString(), this.logContext());
        this.UncaughtExceptionHandler = new Thread.UncaughtExceptionHandler(){

            public void uncaughtException(Thread t, Throwable e) {
                try {
                    package$.MODULE$.handleUncaughtException(e);
                }
                catch (Throwable t2) {
                    Console$.MODULE$.err().println("Fatal internal error when reporting errors:");
                    t2.printStackTrace(Console$.MODULE$.err());
                }
            }
        };
        this.ThreadPool = this.ThreadPoolN(this.NumberOfThreadsForIOBoundTasks());
        this.OPALExecutionContext = ExecutionContext$.MODULE$.fromExecutorService((ExecutorService)this.ThreadPool());
        this.OPALExecutionContextTaskSupport = new ExecutionContextTaskSupport(){

            public int parallelismLevel() {
                return package$.MODULE$.NumberOfThreadsForCPUBoundTasks();
            }
        };
    }
}

