/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.log;

import org.opalj.log.ConsoleOPALLogger;
import org.opalj.log.ConsoleOPALLogger$;
import org.opalj.log.Error$;
import org.opalj.log.GlobalLogContext$;
import org.opalj.log.Info$;
import org.opalj.log.LogContext;
import org.opalj.log.LogMessage;
import org.opalj.log.OPALLogger;
import org.opalj.log.Warn$;
import scala.Function0;

public final class OPALLogger$
implements OPALLogger {
    public static OPALLogger$ MODULE$;
    private volatile OPALLogger[] loggers;
    private int nextId;

    static {
        new OPALLogger$();
    }

    @Override
    public final void logOnce(LogMessage message, LogContext ctx) {
        OPALLogger.logOnce$(this, message, ctx);
    }

    @Override
    public synchronized void updateLogger(LogContext ctx, OPALLogger logger) {
        int id = ctx.id();
        this.loggers[id] = logger;
    }

    @Override
    public synchronized void register(LogContext ctx, OPALLogger logger) {
        int id;
        if (ctx.id() == -1) {
            id = this.nextId();
            if (this.nextId() == this.loggers.length) {
                OPALLogger[] newLoggers = new OPALLogger[this.loggers.length * 2 + 1];
                System.arraycopy(this.loggers, 0, newLoggers, 0, this.loggers.length);
                this.loggers = newLoggers;
            }
        } else {
            if (ctx.id() >= 0) {
                throw new RuntimeException("reregistration of a log context is not supported");
            }
            throw new RuntimeException("log contexts cannot be reregistered");
        }
        this.loggers[id] = logger;
        ctx.id_$eq(id);
        this.nextId_$eq(this.nextId() + 1);
    }

    @Override
    public OPALLogger register$default$2() {
        return new ConsoleOPALLogger(true, ConsoleOPALLogger$.MODULE$.$lessinit$greater$default$2());
    }

    @Override
    public synchronized void unregister(LogContext ctx) {
        LogContext logContext = ctx;
        GlobalLogContext$ globalLogContext$ = GlobalLogContext$.MODULE$;
        if (!(logContext != null ? !logContext.equals(globalLogContext$) : globalLogContext$ != null)) {
            String message = "unregistering the core global log context is not supported";
            throw new IllegalArgumentException(message);
        }
        int ctxId = ctx.id();
        if (ctxId + 1 == this.nextId()) {
            this.nextId_$eq(ctxId);
        }
        this.loggers[ctxId] = null;
        ctx.id_$eq(-2);
    }

    @Override
    public synchronized boolean isUnregistered(LogContext ctx) {
        return ctx.id() == -2;
    }

    @Override
    public synchronized OPALLogger logger(LogContext ctx) {
        return this.loggers[ctx.id()];
    }

    @Override
    public synchronized OPALLogger globalLogger() {
        return this.loggers[GlobalLogContext$.MODULE$.id()];
    }

    public int nextId() {
        return this.nextId;
    }

    public void nextId_$eq(int x$1) {
        this.nextId = x$1;
    }

    @Override
    public void log(LogMessage message, LogContext ctx) {
        this.logger(ctx).log(message, ctx);
    }

    @Override
    public final void debug(String category, String message, LogContext ctx) {
    }

    @Override
    public final void debug(Function0<Object> p, String category, Function0<String> message, LogContext ctx) {
    }

    @Override
    public final void info(String category, String message, LogContext ctx) {
        this.log(Info$.MODULE$.apply(category, message), ctx);
    }

    @Override
    public final void progress(String message, LogContext ctx) {
        this.log(Info$.MODULE$.apply("progress", message), ctx);
    }

    @Override
    public final void warn(String category, String message, LogContext ctx) {
        this.log(Warn$.MODULE$.apply(category, message), ctx);
    }

    @Override
    public final void error(String category, String message, LogContext ctx) {
        this.log(Error$.MODULE$.apply(category, message), ctx);
    }

    @Override
    public final void error(String category, String message, Throwable t, LogContext ctx) {
        this.log(Error$.MODULE$.apply(category, message, t), ctx);
    }

    private OPALLogger$() {
        MODULE$ = this;
        OPALLogger.$init$(this);
        this.loggers = new OPALLogger[32];
        this.nextId = 0;
    }
}

