/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.concurrent;

import java.io.Serializable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.opalj.concurrent.OPALThreadPoolExecutor;
import org.opalj.log.GlobalLogContext$;
import org.opalj.log.OPALLogger$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.parallel.ExecutionContextTaskSupport;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Try;
import scala.util.control.ControlThrowable;

public final class package$ {
    public static package$ MODULE$;
    private final Function0<Object> defaultIsInterrupted;
    private final int NumberOfThreadsForCPUBoundTasks;
    private final int NumberOfThreadsForIOBoundTasks;
    private final Thread.UncaughtExceptionHandler UncaughtExceptionHandler;
    private final OPALThreadPoolExecutor ThreadPool;
    private final ExecutionContext OPALExecutionContext;
    private final ExecutionContextTaskSupport OPALExecutionContextTaskSupport;

    static {
        new package$();
    }

    private GlobalLogContext$ logContext() {
        return GlobalLogContext$.MODULE$;
    }

    public final Function0<Object> defaultIsInterrupted() {
        return this.defaultIsInterrupted;
    }

    public final void handleUncaughtException(Throwable t) {
        OPALLogger$.MODULE$.error("internal", "uncaught exception", t, this.logContext());
    }

    public final void handleUncaughtException(Thread t, Throwable e) {
        OPALLogger$.MODULE$.error("internal", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"uncaught exception (Thread=", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t.getName()})), e, this.logContext());
    }

    public final int NumberOfThreadsForCPUBoundTasks() {
        return this.NumberOfThreadsForCPUBoundTasks;
    }

    public final int NumberOfThreadsForIOBoundTasks() {
        return this.NumberOfThreadsForIOBoundTasks;
    }

    public final Thread.UncaughtExceptionHandler UncaughtExceptionHandler() {
        return this.UncaughtExceptionHandler;
    }

    /*
     * WARNING - void declaration
     */
    public OPALThreadPoolExecutor ThreadPoolN(int n) {
        void var3_3;
        ThreadGroup group = new ThreadGroup(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"org.opalj.ThreadPool ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)System.nanoTime())})));
        OPALThreadPoolExecutor tp = new OPALThreadPoolExecutor(n, group);
        tp.allowCoreThreadTimeOut(true);
        tp.prestartAllCoreThreads();
        return var3_3;
    }

    public ExecutionContext ExecutionContextN(int n) {
        return ExecutionContext$.MODULE$.fromExecutorService((ExecutorService)this.ThreadPoolN(n));
    }

    public final OPALThreadPoolExecutor ThreadPool() {
        return this.ThreadPool;
    }

    public final ExecutionContext OPALExecutionContext() {
        return this.OPALExecutionContext;
    }

    public final ExecutionContextTaskSupport OPALExecutionContextTaskSupport() {
        return this.OPALExecutionContextTaskSupport;
    }

    public <T, U> Iterable<Throwable> parForeachArrayElement(Object data, int parallelizationLevel, Function0<Object> isInterrupted, Function1<T, U> f) {
        ConcurrentLinkedQueue exceptions = new ConcurrentLinkedQueue();
        if (parallelizationLevel == 1) {
            Predef$.MODULE$.genericArrayOps(data).forall((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)package$.$anonfun$parForeachArrayElement$1(isInterrupted, f, exceptions, e)));
            return (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(exceptions).asScala();
        }
        int max = ScalaRunTime$.MODULE$.array_length(data);
        AtomicInteger index = new AtomicInteger(0);
        Future[] futures = new Future[parallelizationLevel];
        for (int t = 0; t < parallelizationLevel; ++t) {
            futures[t] = Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                int i = -1;
                while ((i = index.getAndIncrement()) < max && !isInterrupted.apply$mcZ$sp()) {
                    Object object;
                    Object e = ScalaRunTime$.MODULE$.array_apply(data, i);
                    try {
                        object = f.apply(e);
                    }
                    catch (Throwable throwable) {
                        Boolean bl;
                        Throwable throwable2 = throwable;
                        if (throwable2 instanceof ControlThrowable) {
                            ControlThrowable controlThrowable = (ControlThrowable)throwable2;
                            OPALLogger$.MODULE$.error("internal - fatal", "unsupported non-local return is used", MODULE$.logContext());
                            bl = BoxesRunTime.boxToBoolean((boolean)exceptions.add(controlThrowable));
                        } else if (throwable2 != null) {
                            Throwable throwable3 = throwable2;
                            bl = BoxesRunTime.boxToBoolean((boolean)exceptions.add(throwable3));
                        } else {
                            throw throwable;
                        }
                        object = bl;
                    }
                }
            }, this.OPALExecutionContext());
        }
        for (int t = 0; t < parallelizationLevel; ++t) {
            Future future = futures[t];
            if (!((Try)((Future)Await$.MODULE$.ready((Awaitable)future, (Duration)Duration$.MODULE$.Inf())).value().get()).isFailure()) continue;
            OPALLogger$.MODULE$.error("internal - fatal", "concurrent execution failed: " + future.value().get(), this.logContext());
        }
        return (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(exceptions).asScala();
    }

    public <T, U> int parForeachArrayElement$default$2() {
        return this.NumberOfThreadsForCPUBoundTasks();
    }

    public <T, U> Function0<Object> parForeachArrayElement$default$3() {
        return (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> Thread.currentThread().isInterrupted();
    }

    public static final /* synthetic */ boolean $anonfun$parForeachArrayElement$1(Function0 isInterrupted$1, Function1 f$1, ConcurrentLinkedQueue exceptions$1, Object e) {
        boolean bl;
        block7: {
            try {
                if (!isInterrupted$1.apply$mcZ$sp()) {
                    f$1.apply(e);
                    bl = true;
                    break block7;
                }
                bl = false;
            }
            catch (Throwable throwable) {
                boolean bl2;
                Throwable throwable2 = throwable;
                if (throwable2 instanceof ControlThrowable) {
                    ControlThrowable controlThrowable = (ControlThrowable)throwable2;
                    OPALLogger$.MODULE$.error("internal - fatal", "unsupported non-local return is used", MODULE$.logContext());
                    bl2 = exceptions$1.add(controlThrowable);
                } else if (throwable2 != null) {
                    Throwable throwable3 = throwable2;
                    bl2 = exceptions$1.add(throwable3);
                } else {
                    throw throwable;
                }
                bl = bl2;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private package$() {
        int n;
        int n2;
        MODULE$ = this;
        this.defaultIsInterrupted = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> Thread.currentThread().isInterrupted();
        String maxCPUBoundTasks = System.getProperty("org.opalj.threads.CPUBoundTasks");
        if (maxCPUBoundTasks != null) {
            void var2_2;
            int t = Integer.parseInt(maxCPUBoundTasks);
            if (t <= 0) {
                String message = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"org.opalj.threads.CPUBoundTasks must be larger than 0 (current: ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)t)}));
                throw new IllegalArgumentException(message);
            }
            n2 = var2_2;
        } else {
            OPALLogger$.MODULE$.warn("OPAL", "the property org.opalj.threads.CPUBoundTasks is unspecified", this.logContext());
            n2 = Runtime.getRuntime().availableProcessors();
        }
        this.NumberOfThreadsForCPUBoundTasks = n2;
        OPALLogger$.MODULE$.info("OPAL", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"using ", " thread(s) for CPU bound tasks "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.NumberOfThreadsForCPUBoundTasks())})) + "(can be changed by setting the system property org.opalj.threads.CPUBoundTasks; " + "the number should be equal to the number of physical \u2013 not hyperthreaded \u2013 cores)", this.logContext());
        String maxIOBoundTasks = System.getProperty("org.opalj.threads.IOBoundTasks");
        if (maxIOBoundTasks != null) {
            int s = Integer.parseInt(maxIOBoundTasks);
            if (s < this.NumberOfThreadsForCPUBoundTasks()) {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"org.opalj.threads.IOBoundTasks===", " must be larger than "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)s)})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"org.opalj.threads.CPUBoundTasks===", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.NumberOfThreadsForCPUBoundTasks())})));
            }
            n = s;
        } else {
            OPALLogger$.MODULE$.warn("OPAL", "the property org.opalj.threads.IOBoundTasks is unspecified", this.logContext());
            n = Runtime.getRuntime().availableProcessors() * 2;
        }
        this.NumberOfThreadsForIOBoundTasks = n;
        OPALLogger$.MODULE$.info("OPAL", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"using at most ", " thread(s) for IO bound tasks "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.NumberOfThreadsForIOBoundTasks())})) + "(can be changed by setting the system property org.opalj.threads.IOBoundTasks; " + "the number should be betweeen 1 and 2 times the number of (hyperthreaded) cores)", this.logContext());
        this.UncaughtExceptionHandler = new Thread.UncaughtExceptionHandler(){

            public void uncaughtException(Thread t, Throwable e) {
                package$.MODULE$.handleUncaughtException(e);
            }
        };
        this.ThreadPool = this.ThreadPoolN(this.NumberOfThreadsForIOBoundTasks());
        this.OPALExecutionContext = ExecutionContext$.MODULE$.fromExecutorService((ExecutorService)this.ThreadPool());
        this.OPALExecutionContextTaskSupport = new ExecutionContextTaskSupport(){

            public int parallelismLevel() {
                return package$.MODULE$.NumberOfThreadsForCPUBoundTasks();
            }
        };
    }
}

