/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.br.instructions;

import org.opalj.br.ConstantValue;
import org.opalj.br.MethodDescriptor;
import org.opalj.br.MethodHandle;
import org.opalj.br.ReferenceType;
import org.opalj.br.instructions.LDC;
import org.opalj.br.instructions.LoadClass;
import org.opalj.br.instructions.LoadConstantInstruction;
import org.opalj.br.instructions.LoadFloat;
import org.opalj.br.instructions.LoadInt;
import org.opalj.br.instructions.LoadMethodHandle;
import org.opalj.br.instructions.LoadMethodType;
import org.opalj.br.instructions.LoadString;
import org.opalj.bytecode.BytecodeProcessingFailedException;
import scala.Option;
import scala.Some;
import scala.runtime.BoxesRunTime;

public final class LDC$ {
    public static LDC$ MODULE$;

    static {
        new LDC$();
    }

    public LDC<?> apply(ConstantValue<?> constantValue) {
        LoadConstantInstruction loadConstantInstruction;
        Object obj = constantValue.value();
        if (obj instanceof Integer) {
            int n = BoxesRunTime.unboxToInt(obj);
            loadConstantInstruction = new LoadInt(n);
        } else if (obj instanceof Float) {
            float f = BoxesRunTime.unboxToFloat(obj);
            loadConstantInstruction = new LoadFloat(f);
        } else if (obj instanceof ReferenceType) {
            ReferenceType referenceType = (ReferenceType)obj;
            loadConstantInstruction = new LoadClass(referenceType);
        } else if (obj instanceof String) {
            String string = (String)obj;
            loadConstantInstruction = new LoadString(string);
        } else if (obj instanceof MethodHandle) {
            MethodHandle methodHandle = (MethodHandle)obj;
            loadConstantInstruction = new LoadMethodHandle(methodHandle);
        } else if (obj instanceof MethodDescriptor) {
            MethodDescriptor methodDescriptor = (MethodDescriptor)obj;
            loadConstantInstruction = new LoadMethodType(methodDescriptor);
        } else {
            throw new BytecodeProcessingFailedException(new StringBuilder(28).append("unsupported constant value: ").append(constantValue).toString());
        }
        return loadConstantInstruction;
    }

    public <T> Option<T> unapply(LDC<T> ldc) {
        return new Some(((LoadConstantInstruction)((Object)ldc)).value());
    }

    public final int opcode() {
        return 18;
    }

    private LDC$() {
        MODULE$ = this;
    }
}

