/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.br.analyses;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.opalj.br.DeclaredMethod;
import org.opalj.br.DefinedMethod;
import org.opalj.br.Method;
import org.opalj.br.MethodDescriptor;
import org.opalj.br.MethodDescriptor$;
import org.opalj.br.ObjectType;
import org.opalj.br.ObjectType$;
import org.opalj.br.ReferenceType;
import org.opalj.br.VirtualDeclaredMethod;
import org.opalj.br.analyses.DeclaredMethodsKey;
import org.opalj.br.analyses.DeclaredMethodsKey$MethodContext$;
import org.opalj.br.analyses.Project;
import org.opalj.log.LogContext;
import org.opalj.log.OPALLogger$;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005b\u0001B\u0006\r\u0001UA\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006I!\b\u0005\tK\u0001\u0011\t\u0011)A\u0005M!A!\n\u0001B\u0001B\u0003&1\n\u0003\u0005O\u0001\t\u0005\t\u0015)\u0003P\u0011\u0015\u0011\u0006\u0001\"\u0001T\u0011\u0019I\u0006\u0001)A\u00075\")\u0001\r\u0001C\u0001C\")\u0001\r\u0001C\u0001u\"1\u0001\r\u0001C\u0001\u0003\u000fAq!!\u0004\u0001\t\u0003\tyAA\bEK\u000ed\u0017M]3e\u001b\u0016$\bn\u001c3t\u0015\tia\"\u0001\u0005b]\u0006d\u0017p]3t\u0015\ty\u0001#\u0001\u0002ce*\u0011\u0011CE\u0001\u0006_B\fGN\u001b\u0006\u0002'\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0006\t\u0003/ii\u0011\u0001\u0007\u0006\u00023\u0005)1oY1mC&\u00111\u0004\u0007\u0002\u0007\u0003:L(+\u001a4\u0002\u0003A\u0004\"A\b\u0012\u000f\u0005}\u0001S\"\u0001\u0007\n\u0005\u0005b\u0011a\u00029bG.\fw-Z\u0005\u0003G\u0011\u00121bU8nKB\u0013xN[3di*\u0011\u0011\u0005D\u0001\u0005I\u0006$\u0018\r\u0005\u0003(]A\"T\"\u0001\u0015\u000b\u0005%R\u0013AC2p]\u000e,(O]3oi*\u00111\u0006L\u0001\u0005kRLGNC\u0001.\u0003\u0011Q\u0017M^1\n\u0005=B#!E\"p]\u000e,(O]3oi\"\u000b7\u000f['baB\u0011\u0011GM\u0007\u0002\u001d%\u00111G\u0004\u0002\u000e%\u00164WM]3oG\u0016$\u0016\u0010]3\u0011\t\u001drSg\u0012\t\u0003m\u0011s!a\u000e\"\u000f\u0005a\neBA\u001dA\u001d\tQtH\u0004\u0002<}5\tAH\u0003\u0002>)\u00051AH]8pizJ\u0011aE\u0005\u0003#II!a\u0004\t\n\u00055q\u0011BA\"\r\u0003I!Um\u00197be\u0016$W*\u001a;i_\u0012\u001c8*Z=\n\u0005\u00153%!D'fi\"|GmQ8oi\u0016DHO\u0003\u0002D\u0019A\u0011\u0011\u0007S\u0005\u0003\u0013:\u0011a\u0002R3dY\u0006\u0014X\rZ'fi\"|G-A\u0005jIJjW\r\u001e5pIB\u0019q\u0003T$\n\u00055C\"!B!se\u0006L\u0018!C5e\u0007>,h\u000e^3s!\t9\u0002+\u0003\u0002R1\t\u0019\u0011J\u001c;\u0002\rqJg.\u001b;?)\u0015!VKV,Y!\ty\u0002\u0001C\u0003\u001d\u000b\u0001\u0007Q\u0004C\u0003&\u000b\u0001\u0007a\u0005C\u0003K\u000b\u0001\u00071\nC\u0003O\u000b\u0001\u0007q*\u0001\u0003m_\u000e\\\u0007CA._\u001b\u0005a&BA/)\u0003\u0015awnY6t\u0013\tyFL\u0001\fSK\u0016tGO]1oiJ+\u0017\rZ,sSR,Gj\\2l\u0003\u0015\t\u0007\u000f\u001d7z)\u00199%mZ9tk\")1m\u0002a\u0001I\u0006aA-Z2mCJ,G\rV=qKB\u0011\u0011'Z\u0005\u0003M:\u0011!b\u00142kK\u000e$H+\u001f9f\u0011\u0015Aw\u00011\u0001j\u0003-\u0001\u0018mY6bO\u0016t\u0015-\\3\u0011\u0005)tgBA6m!\tY\u0004$\u0003\u0002n1\u00051\u0001K]3eK\u001aL!a\u001c9\u0003\rM#(/\u001b8h\u0015\ti\u0007\u0004C\u0003s\u000f\u0001\u0007A-A\u0006sk:$\u0018.\\3UsB,\u0007\"\u0002;\b\u0001\u0004I\u0017\u0001\u00028b[\u0016DQA^\u0004A\u0002]\f!\u0002Z3tGJL\u0007\u000f^8s!\t\t\u00040\u0003\u0002z\u001d\t\u0001R*\u001a;i_\u0012$Um]2sSB$xN\u001d\u000b\u0003wz\u0004\"!\r?\n\u0005ut!!\u0004#fM&tW\rZ'fi\"|G\r\u0003\u0004\u0000\u0011\u0001\u0007\u0011\u0011A\u0001\u0007[\u0016$\bn\u001c3\u0011\u0007E\n\u0019!C\u0002\u0002\u00069\u0011a!T3uQ>$GcA$\u0002\n!1\u00111B\u0005A\u0002=\u000b\u0001\"\\3uQ>$\u0017\nZ\u0001\u0010I\u0016\u001cG.\u0019:fI6+G\u000f[8egV\u0011\u0011\u0011\u0003\t\u0006\u0003'\tYb\u0012\b\u0005\u0003+\tIBD\u0002<\u0003/I\u0011!G\u0005\u0003CaIA!!\b\u0002 \tA\u0011\n^3sCR|'O\u0003\u0002\"1\u0001")
public class DeclaredMethods {
    private final Project<?> p;
    private final ConcurrentHashMap<ReferenceType, ConcurrentHashMap<DeclaredMethodsKey.MethodContext, DeclaredMethod>> data;
    private DeclaredMethod[] id2method;
    private int idCounter;
    private final ReentrantReadWriteLock lock;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DeclaredMethod apply(ObjectType declaredType, String packageName, ObjectType runtimeType, String name, MethodDescriptor descriptor) {
        DeclaredMethodsKey.MethodContextQuery context;
        ConcurrentHashMap dmSet = this.data.computeIfAbsent(runtimeType, x$1 -> new ConcurrentHashMap());
        DeclaredMethod method = (DeclaredMethod)dmSet.get(context = new DeclaredMethodsKey.MethodContextQuery(this.p, declaredType, packageName, name, descriptor));
        if (method != null) {
            return method;
        }
        if (this.p.isSignaturePolymorphic(runtimeType, name, descriptor)) {
            MethodDescriptor methodDescriptor;
            if (runtimeType == ObjectType$.MODULE$.VarHandle()) {
                String string = name;
                String string2 = "compareAndSet";
                if (!(string == null ? string2 != null : !string.equals(string2)) || name.startsWith("weak")) {
                    methodDescriptor = MethodDescriptor$.MODULE$.SignaturePolymorphicMethodBoolean();
                } else if (name.startsWith("set")) {
                    methodDescriptor = MethodDescriptor$.MODULE$.SignaturePolymorphicMethodVoid();
                } else {
                    if (!name.startsWith("get") && !name.startsWith("compare")) throw new IllegalArgumentException(new StringBuilder(40).append("Unexpected signature polymorphic method ").append(name).toString());
                    methodDescriptor = MethodDescriptor$.MODULE$.SignaturePolymorphicMethodObject();
                }
            } else {
                if (runtimeType != ObjectType$.MODULE$.MethodHandle()) throw new IllegalArgumentException(new StringBuilder(40).append("Unexpected signature polymorphic method ").append(name).toString());
                String string = name;
                String string3 = "invoke";
                if (string == null ? string3 != null : !string.equals(string3)) {
                    String string4 = name;
                    String string5 = "invokeExact";
                    if (string4 != null ? !string4.equals(string5) : string5 != null) throw new IllegalArgumentException(new StringBuilder(40).append("Unexpected signature polymorphic method ").append(name).toString());
                }
                methodDescriptor = MethodDescriptor$.MODULE$.SignaturePolymorphicMethodObject();
            }
            MethodDescriptor signaturePolymorphicMethodDescriptor = methodDescriptor;
            method = (DeclaredMethod)dmSet.get(new DeclaredMethodsKey.MethodContextQuery(this.p, declaredType, packageName, name, signaturePolymorphicMethodDescriptor));
            if (method != null) {
                return method;
            }
        }
        if (dmSet.contains(context)) return (DeclaredMethod)dmSet.get(context);
        this.lock.writeLock().lock();
        try {
            if (dmSet.contains(context)) return (DeclaredMethod)dmSet.get(context);
            VirtualDeclaredMethod vm = new VirtualDeclaredMethod(runtimeType, name, descriptor, this.idCounter);
            ++this.idCounter;
            dmSet.put(DeclaredMethodsKey$MethodContext$.MODULE$.apply(this.p, runtimeType, "", name, descriptor, false), vm);
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.id2method)).size() <= vm.id()) {
                LogContext logContext = this.p.logContext();
                OPALLogger$.MODULE$.info("project", "too many virtual declared methods; extended the underlying array", logContext);
                DeclaredMethod[] id2methodExt = new DeclaredMethod[this.id2method.length + 1000];
                Array$.MODULE$.copy((Object)this.id2method, 0, (Object)id2methodExt, 0, this.id2method.length);
                this.id2method = id2methodExt;
            }
            this.id2method[vm.id()] = vm;
            return (DeclaredMethod)dmSet.get(context);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public DefinedMethod apply(Method method) {
        ObjectType classType = method.classFile().thisType();
        return (DefinedMethod)this.data.get(classType).get(DeclaredMethodsKey$MethodContext$.MODULE$.apply(this.p, classType, method));
    }

    public DeclaredMethod apply(int methodId) {
        DeclaredMethod declaredMethod;
        this.lock.readLock().lock();
        try {
            declaredMethod = this.id2method[methodId];
        }
        finally {
            this.lock.readLock().unlock();
        }
        return declaredMethod;
    }

    public Iterator<DeclaredMethod> declaredMethods() {
        return ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.data.values()).asScala()).iterator().flatMap((Function1 & Serializable & scala.Serializable)x$2 -> (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(x$2.values()).asScala());
    }

    public DeclaredMethods(Project<?> p, ConcurrentHashMap<ReferenceType, ConcurrentHashMap<DeclaredMethodsKey.MethodContext, DeclaredMethod>> data, DeclaredMethod[] id2method, int idCounter) {
        this.p = p;
        this.data = data;
        this.id2method = id2method;
        this.idCounter = idCounter;
        this.lock = new ReentrantReadWriteLock();
    }
}

