/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.br.analyses;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import org.opalj.br.ClassFile;
import org.opalj.br.analyses.Analysis;
import org.opalj.br.analyses.InconsistentProjectException;
import org.opalj.br.analyses.ProgressManagement$;
import org.opalj.br.analyses.Project;
import org.opalj.br.analyses.Project$;
import org.opalj.br.analyses.ReportableAnalysisResult;
import org.opalj.br.reader.Java16FrameworkWithDynamicRewritingAndCaching;
import org.opalj.br.reader.Java9LibraryFramework$;
import org.opalj.log.GlobalLogContext$;
import org.opalj.log.LogContext;
import org.opalj.log.LogMessage$;
import org.opalj.log.OPALLogger;
import org.opalj.log.OPALLogger$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0001\u0005%baB\u0005\u000b!\u0003\r\ta\u0005\u0005\u00065\u0001!\ta\u0007\u0005\b?\u0001\u0011\rQ\"\u0001!\u0011\u0015\u0001\u0004\u0001\"\u00012\u0011\u0015i\u0004\u0001\"\u0001?\u0011\u0015i\u0005\u0001\"\u0005O\u0011\u00159\u0006\u0001\"\u0001Y\u0011\u0015q\u0006\u0001\"\u0005`\u0011\u0015q\u0007\u0001\"\u0001p\u0005M\te.\u00197zg&\u001c\u0018\t\u001d9mS\u000e\fG/[8o\u0015\tYA\"\u0001\u0005b]\u0006d\u0017p]3t\u0015\tia\"\u0001\u0002ce*\u0011q\u0002E\u0001\u0006_B\fGN\u001b\u0006\u0002#\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0006\t\u0003+ai\u0011A\u0006\u0006\u0002/\u0005)1oY1mC&\u0011\u0011D\u0006\u0002\u0007\u0003:L(+\u001a4\u0002\r\u0011Jg.\u001b;%)\u0005a\u0002CA\u000b\u001e\u0013\tqbC\u0001\u0003V]&$\u0018\u0001C1oC2L8/[:\u0016\u0003\u0005\u0002BAI\u0012&[5\t!\"\u0003\u0002%\u0015\tA\u0011I\\1msNL7\u000f\u0005\u0002'W5\tqE\u0003\u0002)S\u0005\u0019a.\u001a;\u000b\u0003)\nAA[1wC&\u0011Af\n\u0002\u0004+Jc\u0005C\u0001\u0012/\u0013\ty#B\u0001\rSKB|'\u000f^1cY\u0016\fe.\u00197zg&\u001c(+Z:vYR\fQ%\u00198bYf\u001c\u0018n]*qK\u000eLg-[2QCJ\fW.\u001a;feN$Um]2sSB$\u0018n\u001c8\u0016\u0003I\u0002\"a\r\u001e\u000f\u0005QB\u0004CA\u001b\u0017\u001b\u00051$BA\u001c\u0013\u0003\u0019a$o\\8u}%\u0011\u0011HF\u0001\u0007!J,G-\u001a4\n\u0005mb$AB*ue&twM\u0003\u0002:-\u0005y2\r[3dW\u0006s\u0017\r\\=tSN\u001c\u0006/Z2jM&\u001c\u0007+\u0019:b[\u0016$XM]:\u0015\u0005}B\u0005c\u0001!Fe9\u0011\u0011i\u0011\b\u0003k\tK\u0011aF\u0005\u0003\tZ\tq\u0001]1dW\u0006<W-\u0003\u0002G\u000f\nYAK]1wKJ\u001c\u0018M\u00197f\u0015\t!e\u0003C\u0003J\t\u0001\u0007!*\u0001\u0006qCJ\fW.\u001a;feN\u00042\u0001Q&3\u0013\tauIA\u0002TKF\f!\u0002\u001d:j]R,6/Y4f)\tar\nC\u0003Q\u000b\u0001\u000f\u0011+\u0001\u0006m_\u001e\u001cuN\u001c;fqR\u0004\"AU+\u000e\u0003MS!\u0001\u0016\b\u0002\u00071|w-\u0003\u0002W'\nQAj\\4D_:$X\r\u001f;\u0002\t5\f\u0017N\u001c\u000b\u00039eCQA\u0017\u0004A\u0002m\u000bA!\u0019:hgB\u0019Q\u0003\u0018\u001a\n\u0005u3\"!B!se\u0006L\u0018a\u00065b]\u0012dW\rU1sg&tw-\u0012=dKB$\u0018n\u001c8t)\ra\u0002\r\u001b\u0005\u0006C\u001e\u0001\rAY\u0001\baJ|'.Z2u!\t\u0019WM\u0004\u0002#I&\u0011AIC\u0005\u0003M\u001e\u00141bU8nKB\u0013xN[3di*\u0011AI\u0003\u0005\u0006S\u001e\u0001\rA[\u0001\u000bKb\u001cW\r\u001d;j_:\u001c\bc\u0001!FWB\u0011\u0001\t\\\u0005\u0003[\u001e\u0013\u0011\u0002\u00165s_^\f'\r\\3\u0002\u0019M,G/\u001e9Qe>TWm\u0019;\u0015\u0011A4\u00181AA\u0004\u0003#!\"!\u001d;\u0011\u0007\t\u0012X%\u0003\u0002t\u0015\t9\u0001K]8kK\u000e$\b\"B;\t\u0001\b\t\u0016!E5oSRL\u0017\r\u001c'pO\u000e{g\u000e^3yi\")q\u000f\u0003a\u0001q\u000691\r\u001d$jY\u0016\u001c\bc\u0001!zw&\u0011!p\u0012\u0002\t\u0013R,'/\u00192mKB\u0011Ap`\u0007\u0002{*\u0011a0K\u0001\u0003S>L1!!\u0001~\u0005\u00111\u0015\u000e\\3\t\r\u0005\u0015\u0001\u00021\u0001y\u0003)a\u0017NY2q\r&dWm\u001d\u0005\b\u0003\u0013A\u0001\u0019AA\u0006\u0003]\u0019w.\u001c9mKR,G.\u001f'pC\u0012d\u0015N\u0019:be&,7\u000fE\u0002\u0016\u0003\u001bI1!a\u0004\u0017\u0005\u001d\u0011un\u001c7fC:Dq!a\u0005\t\u0001\u0004\t)\"\u0001\td_:4\u0017nZ;sK\u0012\u001cuN\u001c4jOB!\u0011qCA\u0013\u001b\t\tIB\u0003\u0003\u0002\u001c\u0005u\u0011AB2p]\u001aLwM\u0003\u0003\u0002 \u0005\u0005\u0012\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0005\u0005\r\u0012aA2p[&!\u0011qEA\r\u0005\u0019\u0019uN\u001c4jO\u0002")
public interface AnalysisApplication {
    public Analysis<URL, ReportableAnalysisResult> analysis();

    public static /* synthetic */ String analysisSpecificParametersDescription$(AnalysisApplication $this) {
        return $this.analysisSpecificParametersDescription();
    }

    default public String analysisSpecificParametersDescription() {
        return "";
    }

    public static /* synthetic */ Traversable checkAnalysisSpecificParameters$(AnalysisApplication $this, Seq parameters) {
        return $this.checkAnalysisSpecificParameters((Seq<String>)parameters);
    }

    default public Traversable<String> checkAnalysisSpecificParameters(Seq<String> parameters) {
        return parameters.isEmpty() ? Nil$.MODULE$ : (Traversable)parameters.map((Function1 & Serializable & scala.Serializable)x$1 -> new StringBuilder(19).append("unknown parameter: ").append((String)x$1).toString(), Seq$.MODULE$.canBuildFrom());
    }

    public static /* synthetic */ void printUsage$(AnalysisApplication $this, LogContext logContext) {
        $this.printUsage(logContext);
    }

    default public void printUsage(LogContext logContext) {
        OPALLogger$.MODULE$.info("usage", new StringBuilder(332).append("java ").append(this.getClass().getName()).append("\n").append("[-help (prints this help and exits)]\n").append("[-renderConfig (prints the configuration)]\n").append("[-cp=<Directories or JAR/class files> (Default: the current folder.)]\n").append("[-libcp=<Directories or JAR/class files>]\n").append("[-projectConfig=<project type specific configuration options)>]\n").append("[-completelyLoadLibraries (the bodies of library methods are loaded)]\n").append(this.analysisSpecificParametersDescription()).toString(), logContext);
        OPALLogger$.MODULE$.info("general", new StringBuilder(13).append("description: ").append(this.analysis().description()).toString(), logContext);
        OPALLogger$.MODULE$.info("general", new StringBuilder(11).append("copyright: ").append(this.analysis().copyright()).toString(), logContext);
    }

    public static /* synthetic */ void main$(AnalysisApplication $this, String[] args) {
        $this.main(args);
    }

    default public void main(String[] args) {
        Project<URL> project;
        Traversable<String> issues;
        GlobalLogContext$ logContext = GlobalLogContext$.MODULE$;
        ObjectRef unknownArgs = ObjectRef.create((Object)List$.MODULE$.empty());
        ObjectRef cp = ObjectRef.create((Object)((IndexedSeq)package$.MODULE$.IndexedSeq().empty()));
        ObjectRef libcp = ObjectRef.create((Object)((IndexedSeq)package$.MODULE$.IndexedSeq().empty()));
        ObjectRef projectConfig = ObjectRef.create((Object)None$.MODULE$);
        BooleanRef completelyLoadLibraries = BooleanRef.create((boolean)false);
        BooleanRef renderConfig = BooleanRef.create((boolean)false);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).foreach(arg_0 -> AnalysisApplication.$anonfun$main$1$adapted(this, (LogContext)logContext, cp, libcp, completelyLoadLibraries, projectConfig, renderConfig, unknownArgs, arg_0));
        if (((IndexedSeq)cp.elem).isEmpty()) {
            cp.elem = Predef$.MODULE$.wrapRefArray((Object[])new String[]{System.getProperty("user.dir")});
        }
        OPALLogger$.MODULE$.info("project configuration", new StringBuilder(17).append("the classpath is ").append(((IndexedSeq)cp.elem).mkString()).toString(), (LogContext)logContext);
        Seq cpFiles = AnalysisApplication.verifyFiles$1((IndexedSeq)cp.elem, (LogContext)logContext);
        if (cpFiles.isEmpty()) {
            AnalysisApplication.showError$1("Nothing to analyze.", (LogContext)logContext);
            this.printUsage((LogContext)logContext);
            throw scala.sys.package$.MODULE$.exit(1);
        }
        Seq libcpFiles = AnalysisApplication.verifyFiles$1((IndexedSeq)libcp.elem, (LogContext)logContext);
        if (((List)unknownArgs.elem).nonEmpty()) {
            OPALLogger$.MODULE$.info("project configuration", new StringBuilder(30).append("analysis specific parameters: ").append(((List)unknownArgs.elem).mkString(", ")).toString(), (LogContext)logContext);
        }
        if ((issues = this.checkAnalysisSpecificParameters((Seq<String>)((List)unknownArgs.elem))).nonEmpty()) {
            issues.foreach(arg_0 -> AnalysisApplication.$anonfun$main$3$adapted((LogContext)logContext, arg_0));
            this.printUsage((LogContext)logContext);
            throw scala.sys.package$.MODULE$.exit(2);
        }
        try {
            Config config = ((Option)projectConfig.elem).isEmpty() ? ConfigFactory.load() : ConfigFactory.load((String)((String)((Option)projectConfig.elem).get()));
            project = this.setupProject((Iterable<File>)cpFiles, (Iterable<File>)libcpFiles, completelyLoadLibraries.elem, config, (LogContext)logContext);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ControlThrowable) {
                ControlThrowable controlThrowable = (ControlThrowable)throwable2;
                throw (Throwable)controlThrowable;
            }
            if (throwable2 != null) {
                Throwable throwable3 = throwable2;
                OPALLogger$.MODULE$.error("fatal", "setting up the project failed", throwable3, (LogContext)logContext);
                this.printUsage((LogContext)logContext);
                throw scala.sys.package$.MODULE$.exit(2);
            }
            throw throwable;
        }
        Project<URL> project2 = project;
        if (renderConfig.elem) {
            String effectiveConfiguration = new StringBuilder(25).append("Effective configuration:\n").append(org.opalj.util.package$.MODULE$.renderConfig(project2.config(), org.opalj.util.package$.MODULE$.renderConfig$default$2())).toString();
            OPALLogger$.MODULE$.info("project configuration", effectiveConfiguration, (LogContext)logContext);
        }
        OPALLogger$.MODULE$.info("info", new StringBuilder(21).append("executing analysis: ").append(this.analysis().title()).append(".").toString(), (LogContext)logContext);
        ReportableAnalysisResult result = this.analysis().analyze(project2, (Seq<String>)((List)unknownArgs.elem).toSeq(), ProgressManagement$.MODULE$.None());
        OPALLogger$.MODULE$.log(LogMessage$.MODULE$.plainInfo(result.toConsoleString()), (LogContext)logContext);
    }

    public static /* synthetic */ void handleParsingExceptions$(AnalysisApplication $this, Project project, Traversable exceptions) {
        $this.handleParsingExceptions(project, (Traversable<Throwable>)exceptions);
    }

    default public void handleParsingExceptions(Project<?> project, Traversable<Throwable> exceptions) {
        if (exceptions.isEmpty()) {
            return;
        }
        LogContext logContext = project.logContext();
        exceptions.foreach((Function1 & Serializable & scala.Serializable)exception -> {
            OPALLogger$.MODULE$.error("creating project", "ignoring invalid class file", exception, logContext);
            return BoxedUnit.UNIT;
        });
    }

    public static /* synthetic */ Project setupProject$(AnalysisApplication $this, Iterable cpFiles, Iterable libcpFiles, boolean completelyLoadLibraries, Config configuredConfig, LogContext initialLogContext) {
        return $this.setupProject((Iterable<File>)cpFiles, (Iterable<File>)libcpFiles, completelyLoadLibraries, configuredConfig, initialLogContext);
    }

    default public Project<URL> setupProject(Iterable<File> cpFiles, Iterable<File> libcpFiles, boolean completelyLoadLibraries, Config configuredConfig, LogContext initialLogContext) {
        Tuple2<Iterable<Tuple2<ClassFile, URL>>, List<Throwable>> tuple2;
        Tuple2<Iterable<Tuple2<ClassFile, URL>>, List<Throwable>> tuple22;
        OPALLogger$.MODULE$.info("creating project", "reading project class files", initialLogContext);
        Java16FrameworkWithDynamicRewritingAndCaching JavaClassFileReader = Project$.MODULE$.JavaClassFileReader(initialLogContext, configuredConfig);
        Tuple2<Iterable<Tuple2<ClassFile, URL>>, List<Throwable>> tuple23 = org.opalj.br.reader.package$.MODULE$.readClassFiles(cpFiles, (Function2<File, Function2<Object, Throwable, BoxedUnit>, Iterable<Tuple2<ClassFile, URL>>>)(Function2 & Serializable & scala.Serializable)(file, exceptionHandler) -> JavaClassFileReader.ClassFiles((File)file, (Function2<Object, Throwable, BoxedUnit>)exceptionHandler), (Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)file -> {
            OPALLogger$.MODULE$.info("creating project", new StringBuilder(7).append("\tfile: ").append(file).toString(), initialLogContext);
            return BoxedUnit.UNIT;
        });
        if (tuple23 == null) {
            throw new MatchError(tuple23);
        }
        Iterable classFiles = (Iterable)tuple23._1();
        List exceptions1 = (List)tuple23._2();
        Tuple2 tuple24 = new Tuple2((Object)classFiles, (Object)exceptions1);
        Tuple2 tuple25 = tuple24;
        Iterable classFiles2 = (Iterable)tuple25._1();
        List exceptions12 = (List)tuple25._2();
        if (libcpFiles.nonEmpty()) {
            OPALLogger$.MODULE$.info("creating project", "reading library class files", initialLogContext);
            tuple22 = org.opalj.br.reader.package$.MODULE$.readClassFiles(libcpFiles, (Function2<File, Function2<Object, Throwable, BoxedUnit>, Iterable<Tuple2<ClassFile, URL>>>)(completelyLoadLibraries ? (Function2 & Serializable & scala.Serializable)(file, exceptionHandler) -> JavaClassFileReader.ClassFiles((File)file, (Function2<Object, Throwable, BoxedUnit>)exceptionHandler) : (Function2 & Serializable & scala.Serializable)(file, exceptionHandler) -> Java9LibraryFramework$.MODULE$.ClassFiles((File)file, (Function2<Object, Throwable, BoxedUnit>)exceptionHandler)), (Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)file -> {
                OPALLogger$.MODULE$.info("creating project", new StringBuilder(7).append("\tfile: ").append(file).toString(), initialLogContext);
                return BoxedUnit.UNIT;
            });
        } else {
            tuple22 = tuple2 = new Tuple2<Iterable<Tuple2<ClassFile, URL>>, List<Throwable>>((Object)package$.MODULE$.Iterable().empty(), (Object)List$.MODULE$.empty());
        }
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Iterable libraryClassFiles = (Iterable)tuple2._1();
        List exceptions2 = (List)tuple2._2();
        Tuple2 tuple26 = new Tuple2((Object)libraryClassFiles, (Object)exceptions2);
        Tuple2 tuple27 = tuple26;
        Iterable libraryClassFiles2 = (Iterable)tuple27._1();
        List exceptions22 = (List)tuple27._2();
        Iterable x$1 = classFiles2;
        Iterable x$2 = libraryClassFiles2;
        boolean x$3 = !completelyLoadLibraries;
        Traversable x$4 = (Traversable)package$.MODULE$.Traversable().empty();
        Function2<LogContext, InconsistentProjectException, BoxedUnit> x$5 = Project$.MODULE$.apply$default$5();
        Config x$6 = configuredConfig;
        OPALLogger x$7 = Project$.MODULE$.apply$default$7(x$1, x$2, x$3, (Traversable<ClassFile>)x$4, x$5);
        Project<URL> project = Project$.MODULE$.apply(x$1, x$2, x$3, (Traversable<ClassFile>)x$4, x$5, x$6, x$7);
        this.handleParsingExceptions(project, (Traversable<Throwable>)((Traversable)exceptions12.$plus$plus((GenTraversableOnce)exceptions22, List$.MODULE$.canBuildFrom())));
        String statistics = ((List)((TraversableOnce)project.statistics().map((Function1 & Serializable & scala.Serializable)kv -> new StringBuilder(4).append("- ").append(kv._1()).append(": ").append(kv._2$mcI$sp()).toString(), Iterable$.MODULE$.canBuildFrom())).toList().sorted((Ordering)Ordering.String$.MODULE$)).reverse().mkString("project statistics:\n\t", "\n\t", "\n");
        OPALLogger$.MODULE$.info("project", statistics, project.logContext());
        return project;
    }

    private static void showError$1(String message, LogContext logContext$1) {
        OPALLogger$.MODULE$.error("project configuration", message, logContext$1);
    }

    private static String[] splitCPath$1(String path) {
        return path.substring(path.indexOf(61) + 1).split(File.pathSeparator);
    }

    private static String[] splitLibCPath$1(String path) {
        return path.substring(path.indexOf(61) + 1).split(File.pathSeparator);
    }

    public static /* synthetic */ void $anonfun$main$1(AnalysisApplication $this, LogContext logContext$1, ObjectRef cp$1, ObjectRef libcp$1, BooleanRef completelyLoadLibraries$1, ObjectRef projectConfig$1, BooleanRef renderConfig$1, ObjectRef unknownArgs$1, String arg) {
        String string = arg;
        String string2 = "-help";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            $this.printUsage(logContext$1);
            throw scala.sys.package$.MODULE$.exit(0);
        }
        if (arg.startsWith("-cp=")) {
            cp$1.elem = (IndexedSeq)((IndexedSeq)cp$1.elem).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])AnalysisApplication.splitCPath$1(arg))), IndexedSeq$.MODULE$.canBuildFrom());
        } else if (arg.startsWith("-libcp=")) {
            libcp$1.elem = (IndexedSeq)((IndexedSeq)libcp$1.elem).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])AnalysisApplication.splitLibCPath$1(arg))), IndexedSeq$.MODULE$.canBuildFrom());
        } else {
            String string3 = arg;
            String string4 = "-completelyLoadLibraries";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                completelyLoadLibraries$1.elem = true;
            } else if (arg.startsWith("-projectConfig=")) {
                projectConfig$1.elem = new Some((Object)arg.substring(arg.indexOf(61) + 1));
            } else {
                String string5 = arg;
                String string6 = "-renderConfig";
                if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                    renderConfig$1.elem = true;
                } else {
                    unknownArgs$1.elem = ((List)unknownArgs$1.elem).$colon$colon((Object)arg);
                }
            }
        }
    }

    private static String workingDirectory$1() {
        return new StringBuilder(21).append("(working directory: ").append(System.getProperty("user.dir")).append(")").toString();
    }

    private static Option verifyFile$1(String filename, LogContext logContext$1) {
        Some some;
        File file = new File(filename);
        if (!file.exists()) {
            AnalysisApplication.showError$1(new StringBuilder(23).append("File does not exist: ").append(file).append(" ").append(AnalysisApplication.workingDirectory$1()).append(".").toString(), logContext$1);
            some = None$.MODULE$;
        } else if (!file.canRead()) {
            AnalysisApplication.showError$1(new StringBuilder(15).append("Cannot read: ").append(file).append(" ").append(AnalysisApplication.workingDirectory$1()).append(".").toString(), logContext$1);
            some = None$.MODULE$;
        } else if (!(file.isDirectory() || filename.endsWith(".jar") || filename.endsWith(".ear") || filename.endsWith(".war") || filename.endsWith(".zip") || filename.endsWith(".jmod") || filename.endsWith(".class"))) {
            AnalysisApplication.showError$1(new StringBuilder(65).append("Input file is neither a directory nor a class or JAR/JMod file: ").append(file).append(".").toString(), logContext$1);
            some = None$.MODULE$;
        } else {
            some = new Some((Object)file);
        }
        return some;
    }

    private static Seq verifyFiles$1(IndexedSeq filenames, LogContext logContext$1) {
        return (Seq)filenames.flatMap((Function1 & Serializable & scala.Serializable)filename -> Option$.MODULE$.option2Iterable(AnalysisApplication.verifyFile$1(filename, logContext$1)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public static void $init$(AnalysisApplication $this) {
    }

    public static /* synthetic */ Object $anonfun$main$1$adapted(AnalysisApplication $this, LogContext logContext$1, ObjectRef cp$1, ObjectRef libcp$1, BooleanRef completelyLoadLibraries$1, ObjectRef projectConfig$1, BooleanRef renderConfig$1, ObjectRef unknownArgs$1, String arg) {
        AnalysisApplication.$anonfun$main$1($this, logContext$1, cp$1, libcp$1, completelyLoadLibraries$1, projectConfig$1, renderConfig$1, unknownArgs$1, arg);
        return BoxedUnit.UNIT;
    }

    public static /* synthetic */ Object $anonfun$main$3$adapted(LogContext logContext$1, String i) {
        OPALLogger$.MODULE$.error("project configuration", i, logContext$1);
        return BoxedUnit.UNIT;
    }
}

