/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.br;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.opalj.br.ArrayType;
import org.opalj.br.FieldType;
import org.opalj.br.ObjectType$;
import scala.Option;
import scala.Some;

public final class ArrayType$ {
    public static ArrayType$ MODULE$;
    private volatile ArrayType[] arrayTypes;
    private final WeakHashMap<FieldType, WeakReference<ArrayType>> cache;
    private final AtomicInteger nextId;
    private final ArrayType ArrayOfObject;
    private final ArrayType ArrayOfMethodHandle;

    static {
        new ArrayType$();
    }

    private void updateArrayTypes() {
        block3: {
            if (-this.nextId.get() <= this.arrayTypes.length) break block3;
            ArrayType[] newArrayTypes = (ArrayType[])Arrays.copyOf((Object[])this.arrayTypes, -this.nextId.get());
            WeakHashMap<FieldType, WeakReference<ArrayType>> weakHashMap = this.cache;
            synchronized (weakHashMap) {
                this.cache.values().forEach(wat -> {
                    block0: {
                        ArrayType at = (ArrayType)wat.get();
                        if (at == null || -at.id() >= newArrayTypes.length) break block0;
                        newArrayTypes$1[-at.id()] = at;
                    }
                });
            }
            this.arrayTypes = newArrayTypes;
        }
    }

    public ArrayType lookup(int atId) {
        ArrayType arrayType;
        int id = -atId;
        ArrayType[] arrayTypes = this.arrayTypes;
        if (id < arrayTypes.length) {
            ArrayType at = arrayTypes[id];
            if (at == null) {
                throw new IllegalArgumentException(new StringBuilder(11).append(atId).append(" is unknown").toString());
            }
            arrayType = at;
        } else {
            this.updateArrayTypes();
            arrayTypes = this.arrayTypes;
            if (id < arrayTypes.length) {
                ArrayType at = arrayTypes[id];
                if (at == null) {
                    throw new IllegalArgumentException(new StringBuilder(11).append(atId).append(" is unknown").toString());
                }
                arrayType = at;
            } else {
                throw new IllegalArgumentException(new StringBuilder(66).append(atId).append(" belongs to ArrayType created after the creation of the lookup map").toString());
            }
        }
        return arrayType;
    }

    public ArrayType apply(FieldType componentType) {
        ArrayType arrayType;
        block5: {
            WeakHashMap<FieldType, WeakReference<ArrayType>> weakHashMap = this.cache;
            synchronized (weakHashMap) {
                ArrayType arrayType2;
                block4: {
                    ArrayType AT;
                    WeakReference<ArrayType> wrAT = this.cache.get(componentType);
                    if (wrAT != null && (AT = (ArrayType)wrAT.get()) != null) {
                        arrayType2 = AT;
                        break block4;
                    }
                    ArrayType newAT = new ArrayType(this.nextId.getAndDecrement(), componentType);
                    WeakReference<ArrayType> wrNewAT = new WeakReference<ArrayType>(newAT);
                    this.cache.put(componentType, wrNewAT);
                    arrayType = newAT;
                    break block5;
                }
                return arrayType2;
            }
        }
        return arrayType;
    }

    public ArrayType apply(int dimension, FieldType componentType) {
        ArrayType at;
        while (true) {
            at = this.apply(componentType);
            if (dimension <= 1) break;
            componentType = at;
            --dimension;
        }
        return at;
    }

    public Option<FieldType> unapply(ArrayType at) {
        return new Some((Object)at.componentType());
    }

    public final ArrayType ArrayOfObject() {
        return this.ArrayOfObject;
    }

    public final ArrayType ArrayOfMethodHandle() {
        return this.ArrayOfMethodHandle;
    }

    private ArrayType$() {
        MODULE$ = this;
        this.arrayTypes = new ArrayType[0];
        this.cache = new WeakHashMap();
        this.nextId = new AtomicInteger(-1);
        this.ArrayOfObject = this.apply(ObjectType$.MODULE$.Object());
        this.ArrayOfMethodHandle = this.apply(ObjectType$.MODULE$.MethodHandle());
    }
}

