/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.fpcf.analysis;

import org.opalj.br.ClassHierarchy;
import org.opalj.br.Code;
import org.opalj.br.Method;
import org.opalj.br.ObjectType;
import org.opalj.br.analyses.Project;
import org.opalj.br.instructions.INVOKESPECIAL;
import org.opalj.br.instructions.Instruction;
import org.opalj.fpcf.FPCFAnalysis;
import org.opalj.fpcf.FPCFAnalysis$class;
import org.opalj.fpcf.FPCFAnalysisRunner;
import org.opalj.fpcf.ImmediateResult;
import org.opalj.fpcf.Property;
import org.opalj.fpcf.PropertyComputationResult;
import org.opalj.fpcf.PropertyKind;
import org.opalj.fpcf.PropertyStore;
import org.opalj.fpcf.analysis.FactoryMethodAnalysis$;
import org.opalj.fpcf.properties.IsFactoryMethod$;
import org.opalj.fpcf.properties.NotFactoryMethod$;
import org.opalj.log.LogContext;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\r4A!\u0001\u0002\u0001\u0017\t)b)Y2u_JLX*\u001a;i_\u0012\fe.\u00197zg&\u001c(BA\u0002\u0005\u0003!\tg.\u00197zg&\u001c(BA\u0003\u0007\u0003\u00111\u0007o\u00194\u000b\u0005\u001dA\u0011!B8qC2T'\"A\u0005\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001a!\u0003\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\t\u0003'Qi\u0011\u0001B\u0005\u0003+\u0011\u0011AB\u0012)D\r\u0006s\u0017\r\\=tSND\u0001b\u0006\u0001\u0003\u0006\u0004%\t\u0001G\u0001\baJ|'.Z2u+\u0005I\u0002C\u0001\u000e-\u001d\tY\u0012F\u0004\u0002\u001dM9\u0011Q\u0004\n\b\u0003=\rr!a\b\u0012\u000e\u0003\u0001R!!\t\u0006\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0011BA\u0004\t\u0013\t)c!\u0001\u0002ce&\u0011q\u0005K\u0001\tC:\fG._:fg*\u0011QEB\u0005\u0003U-\nq\u0001]1dW\u0006<WM\u0003\u0002(Q%\u0011QF\f\u0002\f'>lW\r\u0015:pU\u0016\u001cGO\u0003\u0002+W!A\u0001\u0007\u0001B\u0001B\u0003%\u0011$\u0001\u0005qe>TWm\u0019;!\u0011\u0015\u0011\u0004\u0001\"\u00034\u0003\u0019a\u0014N\\5u}Q\u0011AG\u000e\t\u0003k\u0001i\u0011A\u0001\u0005\u0006/E\u0002\r!\u0007\u0005\u0006q\u0001!\t!O\u0001\u0012I\u0016$XM]7j]\u0016\u0004&o\u001c9feRLHC\u0001\u001e>!\t\u00192(\u0003\u0002=\t\tI\u0002K]8qKJ$\u0018pQ8naV$\u0018\r^5p]J+7/\u001e7u\u0011\u0015qt\u00071\u0001@\u0003\u0019iW\r\u001e5pIB\u0011\u0001)Q\u0007\u0002Q%\u0011!\t\u000b\u0002\u0007\u001b\u0016$\bn\u001c3\b\u000b\u0011\u0013\u0001\u0012A#\u0002+\u0019\u000b7\r^8ss6+G\u000f[8e\u0003:\fG._:jgB\u0011QG\u0012\u0004\u0006\u0003\tA\taR\n\u0004\r2A\u0005CA\nJ\u0013\tQEA\u0001\nG!\u000e3\u0015I\\1msNL7OU;o]\u0016\u0014\b\"\u0002\u001aG\t\u0003aE#A#\t\u000b93E\u0011A(\u0002#\u0011,'/\u001b<fIB\u0013x\u000e]3si&,7/F\u0001Q!\r\tFk\u0016\b\u0003\u001bIK!a\u0015\b\u0002\rA\u0013X\rZ3g\u0013\t)fKA\u0002TKRT!a\u0015\b\u0011\u0005MA\u0016BA-\u0005\u00051\u0001&o\u001c9feRL8*\u001b8e\u0011\u0019Yf\t\"\u0005\u00059\u0006)1\u000f^1siR\u0019!#\u00180\t\u000b]Q\u0006\u0019A\r\t\u000b}S\u0006\u0019\u00011\u0002\u001bA\u0014x\u000e]3sif\u001cFo\u001c:f!\t\u0019\u0012-\u0003\u0002c\t\ti\u0001K]8qKJ$\u0018p\u0015;pe\u0016\u0004")
public class FactoryMethodAnalysis
implements FPCFAnalysis {
    private final Project<?> project;
    private final ClassHierarchy classHierarchy;
    private final PropertyStore propertyStore;
    private final LogContext logContext;

    public static Set<FPCFAnalysisRunner> recommendations() {
        return FactoryMethodAnalysis$.MODULE$.recommendations();
    }

    public static Set<FPCFAnalysisRunner> requirements() {
        return FactoryMethodAnalysis$.MODULE$.requirements();
    }

    public static String name() {
        return FactoryMethodAnalysis$.MODULE$.name();
    }

    public static void org$opalj$fpcf$FPCFAnalysisRunner$_setter_$uniqueId_$eq(int n) {
        FactoryMethodAnalysis$.MODULE$.org$opalj$fpcf$FPCFAnalysisRunner$_setter_$uniqueId_$eq(n);
    }

    public static int uniqueId() {
        return FactoryMethodAnalysis$.MODULE$.uniqueId();
    }

    public static Set<PropertyKind> derivedProperties() {
        return FactoryMethodAnalysis$.MODULE$.derivedProperties();
    }

    @Override
    public final ClassHierarchy classHierarchy() {
        return this.classHierarchy;
    }

    @Override
    public final PropertyStore propertyStore() {
        return this.propertyStore;
    }

    @Override
    public final LogContext logContext() {
        return this.logContext;
    }

    @Override
    public final void org$opalj$fpcf$FPCFAnalysis$_setter_$classHierarchy_$eq(ClassHierarchy x$1) {
        this.classHierarchy = x$1;
    }

    @Override
    public final void org$opalj$fpcf$FPCFAnalysis$_setter_$propertyStore_$eq(PropertyStore x$1) {
        this.propertyStore = x$1;
    }

    @Override
    public final void org$opalj$fpcf$FPCFAnalysis$_setter_$logContext_$eq(LogContext x$1) {
        this.logContext = x$1;
    }

    @Override
    public final PropertyStore ps() {
        return FPCFAnalysis$class.ps(this);
    }

    @Override
    public final boolean isOpenLibrary() {
        return FPCFAnalysis$class.isOpenLibrary(this);
    }

    @Override
    public final boolean isClosedLibrary() {
        return FPCFAnalysis$class.isClosedLibrary(this);
    }

    @Override
    public final boolean isDesktopApplication() {
        return FPCFAnalysis$class.isDesktopApplication(this);
    }

    @Override
    public final boolean isJEEApplication() {
        return FPCFAnalysis$class.isJEEApplication(this);
    }

    @Override
    public Project<?> project() {
        return this.project;
    }

    public PropertyComputationResult determineProperty(Method method) {
        if (method.isNative()) {
            return new ImmediateResult((Object)method, (Property)IsFactoryMethod$.MODULE$);
        }
        ObjectType classType = this.project().classFile(method).thisType();
        Code body = (Code)method.body().get();
        Instruction[] instructions = body.instructions();
        int max = instructions.length;
        int pc = 0;
        while (pc < max) {
            Instruction instruction = instructions[pc];
            if (instruction.opcode() == 183) {
                Instruction instruction2 = instruction;
                if (instruction2 instanceof INVOKESPECIAL) {
                    INVOKESPECIAL iNVOKESPECIAL = (INVOKESPECIAL)instruction2;
                    ObjectType objectType2 = iNVOKESPECIAL.declaringClass();
                    String string = iNVOKESPECIAL.name();
                    ObjectType objectType3 = classType;
                    ObjectType objectType4 = objectType2;
                    if (!(objectType3 != null ? !((Object)objectType3).equals(objectType4) : objectType4 != null) && "<init>".equals(string)) {
                        return new ImmediateResult((Object)method, (Property)IsFactoryMethod$.MODULE$);
                    }
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            pc = body.pcOfNextInstruction(pc);
        }
        return new ImmediateResult((Object)method, (Property)NotFactoryMethod$.MODULE$);
    }

    public FactoryMethodAnalysis(Project<?> project) {
        this.project = project;
        FPCFAnalysis$class.$init$(this);
    }
}

