/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.br.analyses;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.File;
import java.net.URL;
import org.opalj.AnalysisModes$;
import org.opalj.br.ClassFile;
import org.opalj.br.analyses.AnalysisExecutor;
import org.opalj.br.analyses.InconsistentProjectException;
import org.opalj.br.analyses.ProgressManagement$;
import org.opalj.br.analyses.Project;
import org.opalj.br.analyses.Project$;
import org.opalj.br.analyses.ReportableAnalysisResult;
import org.opalj.br.reader.Java9FrameworkWithLambdaExpressionsSupportAndCaching;
import org.opalj.br.reader.Java9LibraryFramework$;
import org.opalj.log.GlobalLogContext$;
import org.opalj.log.LogContext;
import org.opalj.log.OPALLogger;
import org.opalj.log.OPALLogger$;
import scala.Array$;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.SortedSet$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.collection.mutable.WrappedArray;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.ControlThrowable;

public abstract class AnalysisExecutor$class {
    public static String analysisSpecificParametersDescription(AnalysisExecutor $this) {
        return "";
    }

    public static Traversable checkAnalysisSpecificParameters(AnalysisExecutor $this, Seq parameters) {
        return parameters.isEmpty() ? Nil$.MODULE$ : (Traversable)parameters.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$1) {
                return new StringBuilder().append((Object)"unknown parameter: ").append((Object)x$1).toString();
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static void printUsage(AnalysisExecutor $this, LogContext logContext) {
        String analysisModes = ((TraversableOnce)AnalysisModes$.MODULE$.values().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(Enumeration.Value x$2) {
                return x$2.toString().replace(" ", "_");
            }
        }, SortedSet$.MODULE$.newCanBuildFrom((Ordering)Ordering.String$.MODULE$))).mkString(",");
        OPALLogger$.MODULE$.info("usage", new StringBuilder().append((Object)"java ").append((Object)$this.getClass().getName()).append((Object)"\n").append((Object)"[-cp=<Directories or JAR/class files> (If no class path is specified the current folder is used.)]\n").append((Object)"[-libcp=<Directories or JAR/class files>]\n").append((Object)"[-analysisMode=<the kind of project (").append((Object)analysisModes).append((Object)")>]\n").append((Object)"[-completelyLoadLibraries=<true|false> (The default is false.)]\n").append((Object)$this.analysisSpecificParametersDescription()).toString(), logContext);
        OPALLogger$.MODULE$.info("general", new StringBuilder().append((Object)"description: ").append((Object)$this.analysis().description()).toString(), logContext);
        OPALLogger$.MODULE$.info("general", new StringBuilder().append((Object)"copyright: ").append((Object)$this.analysis().copyright()).toString(), logContext);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(AnalysisExecutor $this, String[] args) {
        Tuple2 tuple22;
        block16: {
            Project<URL> project;
            Traversable<String> issues;
            Tuple2 tuple213;
            Tuple2 tuple210;
            Tuple2 tuple27;
            Tuple2 tuple23;
            Seq cpFiles;
            GlobalLogContext$ logContext;
            block14: {
                block15: {
                    block13: {
                        String[] stringArray;
                        Option option;
                        Tuple2 tuple24;
                        logContext = GlobalLogContext$.MODULE$;
                        if (Predef$.MODULE$.refArrayOps((Object[])args).contains((Object)"-help")) {
                            $this.printUsage((LogContext)logContext);
                            throw scala.sys.package$.MODULE$.exit(0);
                        }
                        Tuple2 tuple2 = AnalysisExecutor$class.liftedTree1$1($this, logContext, args);
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        String[] cp = (String[])tuple2._1();
                        String[] args1 = (String[])tuple2._2();
                        Tuple2 tuple25 = tuple24 = new Tuple2((Object)cp, (Object)args1);
                        String[] cp2 = (String[])tuple25._1();
                        String[] args12 = (String[])tuple25._2();
                        OPALLogger$.MODULE$.info("project configuration", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"the classpath is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])cp2).mkString()})), (LogContext)logContext);
                        cpFiles = AnalysisExecutor$class.verifyFiles$1($this, cp2, logContext);
                        if (cpFiles.isEmpty()) {
                            AnalysisExecutor$class.showError$1($this, "Nothing to analyze.", logContext);
                            $this.printUsage((LogContext)logContext);
                            throw scala.sys.package$.MODULE$.exit(1);
                        }
                        tuple22 = Predef$.MODULE$.refArrayOps((Object[])args12).partition((Function1)new Serializable($this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(String x$5) {
                                return x$5.startsWith("-libcp=");
                            }
                        });
                        if (tuple22 == null || (option = Array$.MODULE$.unapplySeq((Object)(stringArray = (String[])tuple22._1()))).isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(0) != 0) break block13;
                        tuple23 = tuple22;
                        break block14;
                    }
                    if (tuple22 == null) break block15;
                    String[] stringArray = (String[])tuple22._1();
                    String[] args2 = (String[])tuple22._2();
                    Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
                    if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0) break block15;
                    String libParam = (String)((SeqLike)option.get()).apply(0);
                    tuple23 = new Tuple2((Object)AnalysisExecutor$class.splitLibCPath$1($this, libParam), (Object)args2);
                    break block14;
                }
                if (tuple22 == null) break block16;
                String[] libParams = (String[])tuple22._1();
                String[] args2 = (String[])tuple22._2();
                if (libParams == null) break block16;
                String[] stringArray = libParams;
                tuple23 = new Tuple2(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])stringArray).map((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ AnalysisExecutor $outer;

                    public final String[] apply(String path) {
                        return AnalysisExecutor$class.splitLibCPath$1(this.$outer, path);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))))).flatten((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final WrappedArray<String> apply(String[] xs) {
                        return Predef$.MODULE$.wrapRefArray((Object[])xs);
                    }
                }, ClassTag$.MODULE$.apply(String.class)), (Object)args2);
            }
            Tuple2 tuple26 = tuple23;
            if (tuple26 == null) {
                throw new MatchError((Object)tuple26);
            }
            String[] libcp = (String[])tuple26._1();
            String[] args2 = (String[])tuple26._2();
            Tuple2 tuple28 = tuple27 = new Tuple2((Object)libcp, (Object)args2);
            String[] libcp2 = (String[])tuple28._1();
            String[] args22 = (String[])tuple28._2();
            Seq libcpFiles = AnalysisExecutor$class.verifyFiles$1($this, libcp2, logContext);
            Tuple2 tuple29 = AnalysisExecutor$class.liftedTree2$1($this, logContext, args22);
            if (tuple29 == null) {
                throw new MatchError((Object)tuple29);
            }
            Enumeration.Value analysisMode = (Enumeration.Value)tuple29._1();
            String[] args3 = (String[])tuple29._2();
            Tuple2 tuple211 = tuple210 = new Tuple2((Object)analysisMode, (Object)args3);
            Enumeration.Value analysisMode2 = (Enumeration.Value)tuple211._1();
            String[] args32 = (String[])tuple211._2();
            OPALLogger$.MODULE$.info("project configuration", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"the analysis mode is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{analysisMode2})), (LogContext)logContext);
            Tuple2 tuple212 = AnalysisExecutor$class.liftedTree3$1($this, logContext, args32);
            if (tuple212 == null) {
                throw new MatchError((Object)tuple212);
            }
            boolean completelyLoadLibraries = tuple212._1$mcZ$sp();
            String[] args4 = (String[])tuple212._2();
            Tuple2 tuple214 = tuple213 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)completelyLoadLibraries), (Object)args4);
            boolean completelyLoadLibraries2 = tuple214._1$mcZ$sp();
            String[] args42 = (String[])tuple214._2();
            if (Predef$.MODULE$.refArrayOps((Object[])args42).nonEmpty()) {
                OPALLogger$.MODULE$.info("project configuration", new StringBuilder().append((Object)"analysis specific paramters: ").append((Object)Predef$.MODULE$.refArrayOps((Object[])args42).mkString(",")).toString(), (LogContext)logContext);
            }
            if ((issues = $this.checkAnalysisSpecificParameters((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args42))).nonEmpty()) {
                issues.foreach((Function1)new Serializable($this, logContext){
                    public static final long serialVersionUID = 0L;
                    private final GlobalLogContext$ logContext$1;

                    public final void apply(String i) {
                        OPALLogger$.MODULE$.error("project configuration", i, (LogContext)this.logContext$1);
                    }
                    {
                        this.logContext$1 = logContext$1;
                    }
                });
                $this.printUsage((LogContext)logContext);
                throw scala.sys.package$.MODULE$.exit(2);
            }
            try {
                project = $this.setupProject((Iterable<File>)cpFiles, (Iterable<File>)libcpFiles, completelyLoadLibraries2, analysisMode2, ConfigFactory.load(), (LogContext)logContext);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof ControlThrowable) {
                    ControlThrowable controlThrowable = (ControlThrowable)throwable2;
                    throw (Throwable)controlThrowable;
                }
                if (throwable2 != null) {
                    void var2_2;
                    Throwable throwable3 = throwable2;
                    OPALLogger$.MODULE$.error("fatal", "setting up the project failed", throwable3, (LogContext)var2_2);
                    $this.printUsage((LogContext)var2_2);
                    throw scala.sys.package$.MODULE$.exit(2);
                }
                throw throwable;
            }
            OPALLogger$.MODULE$.info("info", new StringBuilder().append((Object)"executing analysis: ").append((Object)$this.analysis().title()).append((Object)".").toString(), (LogContext)logContext);
            ReportableAnalysisResult result = $this.analysis().analyze(project, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args22), ProgressManagement$.MODULE$.None());
            OPALLogger$.MODULE$.progress(new StringBuilder().append((Object)"Result:\n").append((Object)result.toConsoleString()).toString(), (LogContext)logContext);
            return;
        }
        throw new MatchError((Object)tuple22);
    }

    public static void handleParsingExceptions(AnalysisExecutor $this, Project project, Traversable exceptions) {
        if (exceptions.isEmpty()) {
            return;
        }
        LogContext logContext = project.logContext();
        exceptions.foreach((Function1)new Serializable($this, logContext){
            public static final long serialVersionUID = 0L;
            private final LogContext logContext$2;

            public final void apply(Throwable exception) {
                OPALLogger$.MODULE$.error("creating project", "ignoring invalid class file", exception, this.logContext$2);
            }
            {
                this.logContext$2 = logContext$2;
            }
        });
    }

    public static Project setupProject(AnalysisExecutor $this, Iterable cpFiles, Iterable libcpFiles, boolean completelyLoadLibraries, Enumeration.Value analysisMode, Config fallbackConfiguration, LogContext initialLogContext) {
        String analysisModeSpecification = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"org.opalj.analysisMode", analysisMode}));
        Config analysisModeConfig = ConfigFactory.parseString((String)analysisModeSpecification);
        Config configuredConfig = analysisModeConfig.withFallback((ConfigMergeable)fallbackConfiguration);
        OPALLogger$.MODULE$.info("creating project", "reading project class files", initialLogContext);
        Config x$13 = configuredConfig;
        LogContext x$14 = Project$.MODULE$.JavaClassFileReader$default$1();
        Java9FrameworkWithLambdaExpressionsSupportAndCaching JavaClassFileReader = Project$.MODULE$.JavaClassFileReader(x$14, x$13);
        Tuple2<Iterable<Tuple2<ClassFile, URL>>, List<Throwable>> tuple2 = org.opalj.br.reader.package$.MODULE$.readClassFiles((Iterable<File>)cpFiles, (Function2<File, Function2<Object, Throwable, BoxedUnit>, Iterable<Tuple2<ClassFile, URL>>>)new Serializable($this, JavaClassFileReader){
            public static final long serialVersionUID = 0L;
            private final Java9FrameworkWithLambdaExpressionsSupportAndCaching JavaClassFileReader$1;

            public final List<Tuple2<ClassFile, URL>> apply(File file, Function2<Object, Throwable, BoxedUnit> exceptionHandler) {
                return this.JavaClassFileReader$1.ClassFiles(file, exceptionHandler);
            }
            {
                this.JavaClassFileReader$1 = JavaClassFileReader$1;
            }
        }, (Function1<File, BoxedUnit>)new Serializable($this, initialLogContext){
            public static final long serialVersionUID = 0L;
            private final LogContext initialLogContext$1;

            public final void apply(File file) {
                OPALLogger$.MODULE$.info("creating project", new StringBuilder().append((Object)"\tfile: ").append((Object)file).toString(), this.initialLogContext$1);
            }
            {
                this.initialLogContext$1 = initialLogContext$1;
            }
        });
        if (tuple2 != null) {
            Tuple2<Iterable<Tuple2<ClassFile, URL>>, List<Throwable>> tuple22;
            Tuple2<Iterable<Tuple2<ClassFile, URL>>, List<Throwable>> tuple23;
            Tuple2 tuple24;
            Iterable classFiles = (Iterable)tuple2._1();
            List exceptions1 = (List)tuple2._2();
            Tuple2 tuple25 = tuple24 = new Tuple2((Object)classFiles, (Object)exceptions1);
            Iterable classFiles2 = (Iterable)tuple25._1();
            List exceptions12 = (List)tuple25._2();
            if (libcpFiles.nonEmpty()) {
                OPALLogger$.MODULE$.info("creating project", "reading library class files", initialLogContext);
                tuple23 = org.opalj.br.reader.package$.MODULE$.readClassFiles((Iterable<File>)libcpFiles, (Function2<File, Function2<Object, Throwable, BoxedUnit>, Iterable<Tuple2<ClassFile, URL>>>)(completelyLoadLibraries ? new Serializable($this, JavaClassFileReader){
                    public static final long serialVersionUID = 0L;
                    private final Java9FrameworkWithLambdaExpressionsSupportAndCaching JavaClassFileReader$1;

                    public final List<Tuple2<ClassFile, URL>> apply(File file, Function2<Object, Throwable, BoxedUnit> exceptionHandler) {
                        return this.JavaClassFileReader$1.ClassFiles(file, exceptionHandler);
                    }
                    {
                        this.JavaClassFileReader$1 = JavaClassFileReader$1;
                    }
                } : new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final List<Tuple2<ClassFile, URL>> apply(File file, Function2<Object, Throwable, BoxedUnit> exceptionHandler) {
                        return Java9LibraryFramework$.MODULE$.ClassFiles(file, exceptionHandler);
                    }
                }), (Function1<File, BoxedUnit>)new Serializable($this, initialLogContext){
                    public static final long serialVersionUID = 0L;
                    private final LogContext initialLogContext$1;

                    public final void apply(File file) {
                        OPALLogger$.MODULE$.info("creating project", new StringBuilder().append((Object)"\tfile: ").append((Object)file).toString(), this.initialLogContext$1);
                    }
                    {
                        this.initialLogContext$1 = initialLogContext$1;
                    }
                });
            } else {
                tuple23 = tuple22 = new Tuple2<Iterable<Tuple2<ClassFile, URL>>, List<Throwable>>((Object)package$.MODULE$.Iterable().empty(), (Object)List$.MODULE$.empty());
            }
            if (tuple22 != null) {
                Tuple2 tuple26;
                Iterable libraryClassFiles = (Iterable)tuple22._1();
                List exceptions2 = (List)tuple22._2();
                Tuple2 tuple27 = tuple26 = new Tuple2((Object)libraryClassFiles, (Object)exceptions2);
                Iterable libraryClassFiles2 = (Iterable)tuple27._1();
                List exceptions22 = (List)tuple27._2();
                Iterable x$15 = classFiles2;
                Iterable x$16 = libraryClassFiles2;
                boolean x$17 = !completelyLoadLibraries;
                Traversable x$18 = (Traversable)package$.MODULE$.Traversable().empty();
                Function2<LogContext, InconsistentProjectException, BoxedUnit> x$19 = Project$.MODULE$.apply$default$5();
                Config x$20 = configuredConfig;
                OPALLogger x$21 = Project$.MODULE$.apply$default$7(x$15, x$16, x$17, (Traversable<ClassFile>)x$18, x$19);
                Project project = Project$.MODULE$.apply(x$15, x$16, x$17, (Traversable<ClassFile>)x$18, x$19, x$20, x$21);
                $this.handleParsingExceptions(project, (Traversable<Throwable>)((Traversable)exceptions12.$plus$plus((GenTraversableOnce)exceptions22, List$.MODULE$.canBuildFrom())));
                OPALLogger$.MODULE$.info("project", ((List)((TraversableOnce)project.statistics().map((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Tuple2<String, Object> kv) {
                        return new StringBuilder().append((Object)"- ").append(kv._1()).append((Object)": ").append((Object)BoxesRunTime.boxToInteger((int)kv._2$mcI$sp())).toString();
                    }
                }, Iterable$.MODULE$.canBuildFrom())).toList().sorted((Ordering)Ordering.String$.MODULE$)).reverse().mkString("project statistics:\n\t", "\n\t", "\n"), project.logContext());
                return project;
            }
            throw new MatchError((Object)tuple22);
        }
        throw new MatchError(tuple2);
    }

    private static final void showError$1(AnalysisExecutor $this, String message, GlobalLogContext$ logContext$1) {
        OPALLogger$.MODULE$.error("project configuration", message, (LogContext)logContext$1);
    }

    private static final String workingDirectory$1(AnalysisExecutor $this) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(working directory: ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{System.getProperty("user.dir")}));
    }

    public static final Option verifyFile$1(AnalysisExecutor $this, String filename, GlobalLogContext$ logContext$1) {
        Some some;
        File file = new File(filename);
        if (file.exists()) {
            if (file.canRead()) {
                if (file.isDirectory() || filename.endsWith(".jar") || filename.endsWith(".ear") || filename.endsWith(".war") || filename.endsWith(".zip") || filename.endsWith(".class")) {
                    some = new Some((Object)file);
                } else {
                    AnalysisExecutor$class.showError$1($this, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Input file is neither a directory nor a class or JAR file: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file})), logContext$1);
                    some = None$.MODULE$;
                }
            } else {
                AnalysisExecutor$class.showError$1($this, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot read: ", " ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file, AnalysisExecutor$class.workingDirectory$1($this)})), logContext$1);
                some = None$.MODULE$;
            }
        } else {
            AnalysisExecutor$class.showError$1($this, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"File does not exist: ", " ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file, AnalysisExecutor$class.workingDirectory$1($this)})), logContext$1);
            some = None$.MODULE$;
        }
        return some;
    }

    private static final Seq verifyFiles$1(AnalysisExecutor $this, String[] filenames, GlobalLogContext$ logContext$1) {
        return (Seq)((GenericTraversableTemplate)Predef$.MODULE$.refArrayOps((Object[])filenames).toSeq().map((Function1)new Serializable($this, logContext$1){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AnalysisExecutor $outer;
            private final GlobalLogContext$ logContext$1;

            public final Option<File> apply(String filename) {
                return AnalysisExecutor$class.verifyFile$1(this.$outer, filename, this.logContext$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.logContext$1 = logContext$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).flatten((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Iterable<File> apply(Option<File> xo) {
                return Option$.MODULE$.option2Iterable(xo);
            }
        });
    }

    public static final String[] splitCPath$1(AnalysisExecutor $this, String path) {
        return path.substring(4).split(File.pathSeparator);
    }

    private static final Tuple2 liftedTree1$1(AnalysisExecutor $this, GlobalLogContext$ logContext$1, String[] args$1) {
        try {
            Tuple2 tuple2;
            block10: {
                Tuple2 tuple22;
                block8: {
                    block9: {
                        block7: {
                            tuple2 = Predef$.MODULE$.refArrayOps((Object[])args$1).partition((Function1)new Serializable($this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(String x$3) {
                                    return x$3.startsWith("-cp=");
                                }
                            });
                            if (tuple2 == null) break block7;
                            String[] stringArray = (String[])tuple2._1();
                            String[] notCPArgs = (String[])tuple2._2();
                            Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
                            if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(0) != 0) break block7;
                            tuple22 = new Tuple2((Object)new String[]{System.getProperty("user.dir")}, (Object)notCPArgs);
                            break block8;
                        }
                        if (tuple2 == null) break block9;
                        String[] stringArray = (String[])tuple2._1();
                        String[] notCPArgs = (String[])tuple2._2();
                        Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
                        if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0) break block9;
                        String cpParam = (String)((SeqLike)option.get()).apply(0);
                        tuple22 = new Tuple2((Object)AnalysisExecutor$class.splitCPath$1($this, cpParam), (Object)notCPArgs);
                        break block8;
                    }
                    if (tuple2 == null) break block10;
                    String[] cpParams = (String[])tuple2._1();
                    String[] notCPArgs = (String[])tuple2._2();
                    if (cpParams == null) break block10;
                    String[] stringArray = cpParams;
                    tuple22 = new Tuple2(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])stringArray).map((Function1)new Serializable($this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ AnalysisExecutor $outer;

                        public final String[] apply(String path) {
                            return AnalysisExecutor$class.splitCPath$1(this.$outer, path);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))))).flatten((Function1)new Serializable($this){
                        public static final long serialVersionUID = 0L;

                        public final WrappedArray<String> apply(String[] xs) {
                            return Predef$.MODULE$.wrapRefArray((Object[])xs);
                        }
                    }, ClassTag$.MODULE$.apply(String.class)), (Object)notCPArgs);
                }
                return tuple22;
            }
            throw new MatchError((Object)tuple2);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ControlThrowable) {
                ControlThrowable controlThrowable = (ControlThrowable)throwable2;
                throw (Throwable)controlThrowable;
            }
            if (throwable2 != null) {
                Throwable throwable3 = throwable2;
                OPALLogger$.MODULE$.error("fatal", "failed parsing the classpath", throwable3, (LogContext)logContext$1);
                throw scala.sys.package$.MODULE$.exit(2);
            }
            throw throwable;
        }
    }

    public static final String[] splitLibCPath$1(AnalysisExecutor $this, String path) {
        return path.substring(7).split(File.pathSeparator);
    }

    private static final Tuple2 liftedTree2$1(AnalysisExecutor $this, GlobalLogContext$ logContext$1, String[] args2$1) {
        try {
            Tuple2 tuple2;
            block9: {
                Tuple2 tuple22;
                block8: {
                    block7: {
                        tuple2 = Predef$.MODULE$.refArrayOps((Object[])args2$1).partition((Function1)new Serializable($this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(String x$7) {
                                return x$7.startsWith("-analysisMode=");
                            }
                        });
                        if (tuple2 == null) break block7;
                        String[] stringArray = (String[])tuple2._1();
                        String[] args3 = (String[])tuple2._2();
                        Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
                        if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(0) != 0) break block7;
                        tuple22 = new Tuple2((Object)AnalysisModes$.MODULE$.DesktopApplication(), (Object)args3);
                        break block8;
                    }
                    if (tuple2 == null) break block9;
                    String[] stringArray = (String[])tuple2._1();
                    String[] args3 = (String[])tuple2._2();
                    Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
                    if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0) break block9;
                    String analysisModeParameter = (String)((SeqLike)option.get()).apply(0);
                    String analysisMode = analysisModeParameter.substring(14).replace("_", " ");
                    tuple22 = new Tuple2((Object)AnalysisModes$.MODULE$.withName(analysisMode), (Object)args3);
                }
                return tuple22;
            }
            throw new MatchError((Object)tuple2);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ControlThrowable) {
                ControlThrowable controlThrowable = (ControlThrowable)throwable2;
                throw (Throwable)controlThrowable;
            }
            if (throwable2 != null) {
                Throwable throwable3 = throwable2;
                OPALLogger$.MODULE$.error("project configuration", "failed parsing the analysis mode", throwable3, (LogContext)logContext$1);
                $this.printUsage((LogContext)logContext$1);
                throw scala.sys.package$.MODULE$.exit(2);
            }
            throw throwable;
        }
    }

    private static final Tuple2 liftedTree3$1(AnalysisExecutor $this, GlobalLogContext$ logContext$1, String[] args3$1) {
        try {
            Tuple2 tuple2;
            block9: {
                Tuple2 tuple22;
                block8: {
                    block7: {
                        tuple2 = Predef$.MODULE$.refArrayOps((Object[])args3$1).partition((Function1)new Serializable($this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(String x$9) {
                                return x$9.startsWith("-completelyLoadLibraries=");
                            }
                        });
                        if (tuple2 == null) break block7;
                        String[] stringArray = (String[])tuple2._1();
                        String[] args4 = (String[])tuple2._2();
                        Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
                        if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(0) != 0) break block7;
                        tuple22 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)args4);
                        break block8;
                    }
                    if (tuple2 == null) break block9;
                    String[] stringArray = (String[])tuple2._1();
                    String[] args4 = (String[])tuple2._2();
                    Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
                    if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0) break block9;
                    String completelyLoadLibrariesParameter = (String)((SeqLike)option.get()).apply(0);
                    boolean completelyLoadLibraries = new StringOps(Predef$.MODULE$.augmentString(completelyLoadLibrariesParameter.substring(25))).toBoolean();
                    tuple22 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)completelyLoadLibraries), (Object)args4);
                }
                return tuple22;
            }
            throw new MatchError((Object)tuple2);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ControlThrowable) {
                ControlThrowable controlThrowable = (ControlThrowable)throwable2;
                throw (Throwable)controlThrowable;
            }
            if (throwable2 != null) {
                Throwable throwable3 = throwable2;
                OPALLogger$.MODULE$.error("project configuration", "failed parsing completelyLoadLibraries", throwable3, (LogContext)logContext$1);
                $this.printUsage((LogContext)logContext$1);
                throw scala.sys.package$.MODULE$.exit(2);
            }
            throw throwable;
        }
    }

    public static void $init$(AnalysisExecutor $this) {
    }
}

