/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.bi.reader;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.text.similarity.LevenshteinDistance;
import org.opalj.bi.AttributesParent$;
import org.opalj.bi.reader.ClassFileReaderConfiguration;
import org.opalj.bi.reader.ConstantPoolEntry;
import org.opalj.bi.reader.Constant_PoolAbstractions;
import org.opalj.bytecode.BytecodeProcessingFailedException;
import org.opalj.collection.immutable.IntArray$;
import org.opalj.collection.immutable.RefArray;
import org.opalj.collection.immutable.RefArray$;
import org.opalj.io.package$;
import org.opalj.log.OPALLogger$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.Traversable$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.collection.parallel.TaskSupport;
import scala.collection.parallel.immutable.ParSeq;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0001\r5aaB\u0001\u0003!\u0003\r\ta\u0003\u0002\u0010\u00072\f7o\u001d$jY\u0016\u0014V-\u00193fe*\u00111\u0001B\u0001\u0007e\u0016\fG-\u001a:\u000b\u0005\u00151\u0011A\u00012j\u0015\t9\u0001\"A\u0003pa\u0006d'NC\u0001\n\u0003\ry'oZ\u0002\u0001'\u0011\u0001AB\u0005\f\u0011\u00055\u0001R\"\u0001\b\u000b\u0003=\tQa]2bY\u0006L!!\u0005\b\u0003\r\u0005s\u0017PU3g!\t\u0019B#D\u0001\u0003\u0013\t)\"A\u0001\u000fDY\u0006\u001c8OR5mKJ+\u0017\rZ3s\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0011\u0005M9\u0012B\u0001\r\u0003\u0005e\u0019uN\\:uC:$x\fU8pY\u0006\u00137\u000f\u001e:bGRLwN\\:\t\u000bi\u0001A\u0011A\u000e\u0002\r\u0011Jg.\u001b;%)\u0005a\u0002CA\u0007\u001e\u0013\tqbB\u0001\u0003V]&$H!\u0002\u0011\u0001\u0005\u0003\t#!C\"mCN\u001ch)\u001b7f#\t\u0011S\u0005\u0005\u0002\u000eG%\u0011AE\u0004\u0002\b\u001d>$\b.\u001b8h!\tia%\u0003\u0002(\u001d\t\u0019\u0011I\\=\u0006\t%\u0002!A\u000b\u0002\u000b\u0013:$XM\u001d4bG\u0016\u001c\bcA\u0007,[%\u0011AF\u0004\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003]=j\u0011\u0001A\u0005\u0003a]\u00111cQ8ogR\fg\u000e^0Q_>dw,\u00138eKb$QA\r\u0001\u0003\u0002\u0005\u0012aAR5fY\u0012\u001cH!\u0002\u001b\u0001\u0005\u0003\t#aB'fi\"|Gm\u001d\u0003\u0006m\u0001\u0011\t!\t\u0002\u000b\u0003R$(/\u001b2vi\u0016\u001c\b\"\u0002\u001d\u0001\r#I\u0014!D\"p]N$\u0018M\u001c;`!>|G\u000e\u0006\u0002;{A\u0011afO\u0005\u0003y]\u0011QbQ8ogR\fg\u000e^0Q_>d\u0007\"\u0002 8\u0001\u0004y\u0014AA5o!\t\u0001U)D\u0001B\u0015\t\u00115)\u0001\u0002j_*\tA)\u0001\u0003kCZ\f\u0017B\u0001$B\u0005=!\u0015\r^1J]B,Ho\u0015;sK\u0006l\u0007\"\u0002%\u0001\r#I\u0015A\u0002$jK2$7\u000fF\u0002K\u00176\u0003\"AL\u0019\t\u000b1;\u0005\u0019\u0001\u001e\u0002\u0005\r\u0004\b\"\u0002 H\u0001\u0004y\u0004\"B(\u0001\r#\u0001\u0016aB'fi\"|Gm\u001d\u000b\u0004#J\u001b\u0006C\u0001\u00184\u0011\u0015ae\n1\u0001;\u0011\u0015qd\n1\u0001@\u0011\u0015)\u0006A\"\u0005W\u0003)\tE\u000f\u001e:jEV$Xm\u001d\u000b\u0007/bK6-Z4\u0011\u00059*\u0004\"\u0002'U\u0001\u0004Q\u0004\"\u0002.U\u0001\u0004Y\u0016AA1q!\ta\u0006M\u0004\u0002^=6\tA!\u0003\u0002`\t\u00059\u0001/Y2lC\u001e,\u0017BA1c\u0005=\tE\u000f\u001e:jEV$X\rU1sK:$(BA0\u0005\u0011\u0015!G\u000b1\u0001.\u00035\t\u0007o\u00188b[\u0016|\u0016N\u001c3fq\")a\r\u0016a\u0001[\u0005\u0019\u0012\r]0eKN\u001c'/\u001b9u_J|\u0016N\u001c3fq\")a\b\u0016a\u0001\u007f!)\u0011\u000e\u0001D\tU\u0006I1\t\\1tg\u001aKG.\u001a\u000b\rW2l'\u000f\u001e<yuv|\u00181\u0001\t\u0003]}AQ\u0001\u00145A\u0002iBQA\u001c5A\u0002=\fQ\"\\5o_J|f/\u001a:tS>t\u0007CA\u0007q\u0013\t\thBA\u0002J]RDQa\u001d5A\u0002=\fQ\"\\1k_J|f/\u001a:tS>t\u0007\"B;i\u0001\u0004y\u0017\u0001D1dG\u0016\u001c8o\u00184mC\u001e\u001c\b\"B<i\u0001\u0004i\u0013A\u0003;iSN|6\r\\1tg\")\u0011\u0010\u001ba\u0001[\u0005Y1/\u001e9fe~\u001bG.Y:t\u0011\u0015Y\b\u000e1\u0001}\u0003)Ig\u000e^3sM\u0006\u001cWm\u001d\t\u0003]!BQA 5A\u0002)\u000baAZ5fY\u0012\u001c\bBBA\u0001Q\u0002\u0007\u0011+A\u0004nKRDw\u000eZ:\t\r\u0005\u0015\u0001\u000e1\u0001X\u0003)\tG\u000f\u001e:jEV$Xm\u001d\u0005\n\u0003\u0013\u0001!\u0019!C\u0003\u0003\u0017\tq\u0003Z3gCVdG/\u0012=dKB$\u0018n\u001c8IC:$G.\u001a:\u0016\u0005\u00055\u0001\u0003BA\b\u0003Cq1aEA\t\u000f\u001d\t\u0019B\u0001E\u0001\u0003+\tqb\u00117bgN4\u0015\u000e\\3SK\u0006$WM\u001d\t\u0004'\u0005]aAB\u0001\u0003\u0011\u0003\tIbE\u0002\u0002\u00181A\u0001\"!\b\u0002\u0018\u0011\u0005\u0011qD\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u0005UQaBA\u0012\u0003/\u0001\u0011Q\u0005\u0002\u0011\u000bb\u001cW\r\u001d;j_:D\u0015M\u001c3mKJ\u0004r!DA\u0014\u0019\u0005-B$C\u0002\u0002*9\u0011\u0011BR;oGRLwN\u001c\u001a\u0011\t\u00055\u00121\b\b\u0005\u0003_\tID\u0004\u0003\u00022\u0005]RBAA\u001a\u0015\r\t)DC\u0001\u0007yI|w\u000e\u001e \n\u0003=I!a\u0018\b\n\t\u0005u\u0012q\b\u0002\n)\"\u0014xn^1cY\u0016T!a\u0018\b\t\u0013\u0005\r\u0003\u00011Q\u0005\n\u0005\u0015\u0013aF2mCN\u001ch)\u001b7f!>\u001cH\u000f\u0015:pG\u0016\u001c8o\u001c:t+\t\t9\u0005\u0005\u0004\u0002J\u0005M\u0013qK\u0007\u0003\u0003\u0017RA!!\u0014\u0002P\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0004\u0003#2\u0011AC2pY2,7\r^5p]&!\u0011QKA&\u0005!\u0011VMZ!se\u0006L\bcB\u0007\u0002Z\u0005u\u0013QL\u0005\u0004\u00037r!!\u0003$v]\u000e$\u0018n\u001c82!\u0015\ti#a\u0018l\u0013\u0011\t\t'a\u0010\u0003\t1K7\u000f\u001e\u0005\n\u0003K\u0002\u0001\u0019)C\u0005\u0003O\n1d\u00197bgN4\u0015\u000e\\3Q_N$\bK]8dKN\u001cxN]:`I\u0015\fHc\u0001\u000f\u0002j!Q\u00111NA2\u0003\u0003\u0005\r!a\u0012\u0002\u0007a$\u0013\u0007C\u0004\u0002p\u0001!\t!!\u001d\u0002=I,w-[:uKJ\u001cE.Y:t\r&dW\rU8tiB\u0013xnY3tg>\u0014Hc\u0001\u000f\u0002t!A\u0011QOA7\u0001\u0004\t9&A\u0001q\u0011\u0019I\u0007\u0001\"\u0001\u0002zQ!\u0011QLA>\u0011\u0019q\u0014q\u000fa\u0001\u007f!1\u0011\u000e\u0001C\u0001\u0003\u007f\"B!!\u0018\u0002\u0002\"A\u00111QA?\u0001\u0004\t))\u0001\u0004de\u0016\fG/\u001a\t\u0006\u001b\u0005\u001d\u00151R\u0005\u0004\u0003\u0013s!!\u0003$v]\u000e$\u0018n\u001c81!\r\u0001\u0015QR\u0005\u0004\u0003\u001f\u000b%aC%oaV$8\u000b\u001e:fC6Dq!a%\u0001\t\u0003\t)*A\u000bjg\u000ec\u0017m]:GS2,'+\u001a9pg&$xN]=\u0015\r\u0005]\u0015QTAY!\ri\u0011\u0011T\u0005\u0004\u00037s!a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003?\u000b\t\n1\u0001\u0002\"\u0006Aa-\u001b7f]\u0006lW\r\u0005\u0003\u0002$\u0006-f\u0002BAS\u0003O\u00032!!\r\u000f\u0013\r\tIKD\u0001\u0007!J,G-\u001a4\n\t\u00055\u0016q\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005%f\u0002\u0003\u0005\u00024\u0006E\u0005\u0019AA[\u00035\u0019wN\u001c;bS:,'OT1nKB)Q\"a.\u0002\"&\u0019\u0011\u0011\u0018\b\u0003\r=\u0003H/[8o\u0011\u001dI\u0007\u0001)C\t\u0003{#b!!\u0018\u0002@\u0006M\u0007\u0002CAa\u0003w\u0003\r!a1\u0002\u000f)\f'OR5mKB!\u0011QYAh\u001b\t\t9M\u0003\u0003\u0002J\u0006-\u0017a\u0001>ja*\u0019\u0011QZ\"\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003#\f9MA\u0004[SB4\u0015\u000e\\3\t\u0011\u0005U\u00171\u0018a\u0001\u0003/\f\u0001B[1s\u000b:$(/\u001f\t\u0005\u0003\u000b\fI.\u0003\u0003\u0002\\\u0006\u001d'\u0001\u0003.ja\u0016sGO]=\t\r%\u0004A\u0011AAp)\u0019\ti&!9\u0002j\"A\u0011\u0011YAo\u0001\u0004\t\u0019\u000fE\u0002A\u0003KL1!a:B\u0005\u00111\u0015\u000e\\3\t\u0011\u0005-\u0018Q\u001ca\u0001\u0003C\u000b\u0001C[1s\r&dW-\u00128ueft\u0015-\\3)\r\u0005u\u0017q^A~!\u0015i\u0011\u0011_A{\u0013\r\t\u0019P\u0004\u0002\u0007i\"\u0014xn^:\u0011\u0007\u0001\u000b90C\u0002\u0002z\u0006\u00131\"S(Fq\u000e,\u0007\u000f^5p]\u0006\u0012\u0011Q`\u00012S\u001a\u0004C\u000f[3!M&dW\rI5tA\u0015l\u0007\u000f^=!_J\u0004C\u000f[3!K:$(/\u001f\u0011dC:tw\u000e\u001e\u0011cK\u00022w.\u001e8e\u0011\u0019I\u0007\u0001\"\u0001\u0003\u0002Q1\u0011Q\fB\u0002\u0005\u000fA\u0001B!\u0002\u0002\u0000\u0002\u0007\u0011\u0011U\u0001\fU\u0006\u0014h)\u001b7f\u001d\u0006lW\r\u0003\u0005\u0002l\u0006}\b\u0019AAQQ\u0019\ty0a<\u0002|\"9!Q\u0002\u0001\u0005\u0002\t=\u0011AC\"mCN\u001ch)\u001b7fgR1!\u0011\u0003B\u0013\u0005O\u0001b!!\f\u0002`\tM\u0001CB\u0007\u0003\u0016-\u0014I\"C\u0002\u0003\u00189\u0011a\u0001V;qY\u0016\u0014\u0004\u0003\u0002B\u000e\u0005Ci!A!\b\u000b\u0007\t}1)A\u0002oKRLAAa\t\u0003\u001e\t\u0019QK\u0015'\t\u0011\u0005\u0005'1\u0002a\u0001\u0003\u0007D\u0001B!\u000b\u0003\f\u0001\u0007\u0011QB\u0001\u0011Kb\u001cW\r\u001d;j_:D\u0015M\u001c3mKJDqA!\u0004\u0001\t\u0003\u0011i\u0003\u0006\u0003\u00030\tM\u0002CBA\u0017\u0003?\u0012\t\u0004\u0005\u0004\u000e\u0005+Y\u0017\u0011\u0015\u0005\t}\t-B\u00111\u0001\u00036A)QBa\u000e\u0003<%\u0019!\u0011\b\b\u0003\u0011q\u0012\u0017P\\1nKz\u0002BA!\u0010\u0003D5\u0011!q\b\u0006\u0005\u0005\u0003\nY-A\u0002kCJLAA!\u0012\u0003@\tq!*\u0019:J]B,Ho\u0015;sK\u0006l\u0007b\u0002B\u0007\u0001\u0011\u0005!\u0011\n\u000b\b9\t-#q\nB+\u0011!\u0011iEa\u0012A\u0002\u0005\r\u0017a\u0002>ja\u001aKG.\u001a\u0005\t\u0005#\u00129\u00051\u0001\u0003T\u0005\u00012\r\\1tg\u001aKG.\u001a%b]\u0012dWM\u001d\t\b\u001b\u0005\u001d2N!\u0007\u001d\u0011!\u0011ICa\u0012A\u0002\u00055\u0001b\u0002B\u0007\u0001\u0011%!\u0011\f\u000b\n9\tm#q\fB1\u0005GB\u0001B!\u0018\u0003X\u0001\u0007\u0011\u0011U\u0001\u000bU\u0006\u0014h)\u001b7f+Jc\u0005\u0002CAa\u0005/\u0002\r!a1\t\u0011\tE#q\u000ba\u0001\u0005'B\u0001B!\u000b\u0003X\u0001\u0007\u0011Q\u0002\u0005\b\u0005\u001b\u0001A\u0011\u0002B4)%a\"\u0011\u000eB6\u0005o\u0012I\b\u0003\u0005\u0003^\t\u0015\u0004\u0019AAQ\u0011!\u0011iG!\u001aA\u0002\t=\u0014a\u00026be\u0012\u000bG/\u0019\t\u0005\u001b-\u0012\t\bE\u0002\u000e\u0005gJ1A!\u001e\u000f\u0005\u0011\u0011\u0015\u0010^3\t\u0011\tE#Q\ra\u0001\u0005'B\u0001B!\u000b\u0003f\u0001\u0007\u0011Q\u0002\u0005\t\u0005{\u0002\u0001\u0015\"\u0003\u0003\u0000\u0005Q\u0001O]8dKN\u001c(*\u0019:\u0015\r\tE!\u0011\u0011BC\u0011!\u0011\u0019Ia\u001fA\u0002\u0005\r\u0018\u0001\u00024jY\u0016D!B!\u000b\u0003|A\u0005\t\u0019AA\u0007\u0011!\u0011I\t\u0001Q\u0005\n\t-\u0015\u0001\u00059s_\u000e,7o]\"mCN\u001ch)\u001b7f)\u0019\u0011\tB!$\u0003\u0010\"A!1\u0011BD\u0001\u0004\t\u0019\u000f\u0003\u0006\u0003*\t\u001d\u0005\u0013!a\u0001\u0003\u001bAqA!\u0004\u0001\t\u0003\u0011\u0019\n\u0006\u0004\u0003\u0012\tU%q\u0013\u0005\t\u0005\u0007\u0013\t\n1\u0001\u0002d\"Q!\u0011\u0006BI!\u0003\u0005\r!!\u0004\t\u000f\tm\u0005\u0001\"\u0001\u0003\u001e\u0006i\u0011\t\u001c7DY\u0006\u001c8OR5mKN$bAa(\u0003&\n-\u0006CBA\u0017\u0005C\u0013\u0019\"\u0003\u0003\u0003$\u0006}\"a\u0003+sCZ,'o]1cY\u0016D\u0001Ba*\u0003\u001a\u0002\u0007!\u0011V\u0001\u0006M&dWm\u001d\t\u0007\u0003[\u0011\t+a9\t\u0015\t%\"\u0011\u0014I\u0001\u0002\u0004\ti\u0001C\u0004\u00030\u0002!\tA!-\u0002\u001b)\u0013Fk\u00117bgN4\u0015\u000e\\3t+\t\u0011\u0019\f\u0005\u0004\u0002.\tU&\u0011X\u0005\u0005\u0005o\u000byD\u0001\u0005Ji\u0016\u0014\u0018M\u00197f!\u001di!QCAQ\u0005#AqA!0\u0001\t\u0003\u0011y,A\u0007gS:$7\t\\1tg\u001aKG.\u001a\u000b\r\u0005\u0003\u0014iMa4\u0003V\nm'\u0011\u001d\t\t\u0003[\u0011\u0019Ma\u0005\u0003H&!!QYA \u0005\u0019)\u0015\u000e\u001e5feB1\u00111\u0015Be\u0003CKAAa3\u00020\n\u00191+\u001a;\t\u0011\t\u001d&1\u0018a\u0001\u0005SC\u0001B!5\u0003<\u0002\u0007!1[\u0001\u0011aJ|wM]3tgJ+\u0007o\u001c:uKJ\u0004b!DA-\u0003Gd\u0002\u0002\u0003Bl\u0005w\u0003\rA!7\u0002\u001f\rd\u0017m]:GS2,g)\u001b7uKJ\u0004b!DA-W\u0006]\u0005\u0002\u0003Bo\u0005w\u0003\rAa8\u0002\u0013\rd\u0017m]:OC6,\u0007CB\u0007\u0002Z-\f\t\u000b\u0003\u0006\u0003*\tm\u0006\u0013!a\u0001\u0003\u001bA\u0011B!:\u0001#\u0003%\tAa:\u0002)\rc\u0017m]:GS2,7\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011IO\u000b\u0003\u0002\u000e\t-8F\u0001Bw!\u0011\u0011yO!?\u000e\u0005\tE(\u0002\u0002Bz\u0005k\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t]h\"\u0001\u0006b]:|G/\u0019;j_:LAAa?\u0003r\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\t}\b!%A\u0005\n\t\u001d\u0018\u0001\u00069s_\u000e,7o\u001d&be\u0012\"WMZ1vYR$#\u0007C\u0005\u0004\u0004\u0001\t\n\u0011\"\u0003\u0003h\u0006Q\u0002O]8dKN\u001c8\t\\1tg\u001aKG.\u001a\u0013eK\u001a\fW\u000f\u001c;%e!I1q\u0001\u0001\u0012\u0002\u0013\u0005!q]\u0001\u0018\u00032d7\t\\1tg\u001aKG.Z:%I\u00164\u0017-\u001e7uIIB\u0011ba\u0003\u0001#\u0003%\tAa:\u0002/\u0019Lg\u000eZ\"mCN\u001ch)\u001b7fI\u0011,g-Y;mi\u0012*\u0004")
public interface ClassFileReader
extends ClassFileReaderConfiguration,
Constant_PoolAbstractions {
    public void org$opalj$bi$reader$ClassFileReader$_setter_$defaultExceptionHandler_$eq(Function2<Object, Throwable, BoxedUnit> var1);

    public ConstantPoolEntry[] Constant_Pool(DataInputStream var1);

    public Object Fields(ConstantPoolEntry[] var1, DataInputStream var2);

    public Object Methods(ConstantPoolEntry[] var1, DataInputStream var2);

    public Object Attributes(ConstantPoolEntry[] var1, Enumeration.Value var2, int var3, int var4, DataInputStream var5);

    public Object ClassFile(ConstantPoolEntry[] var1, int var2, int var3, int var4, int var5, int var6, int[] var7, Object var8, Object var9, Object var10);

    public Function2<Object, Throwable, BoxedUnit> defaultExceptionHandler();

    public RefArray<Function1<List<Object>, List<Object>>> org$opalj$bi$reader$ClassFileReader$$classFilePostProcessors();

    public void org$opalj$bi$reader$ClassFileReader$$classFilePostProcessors_$eq(RefArray<Function1<List<Object>, List<Object>>> var1);

    public static /* synthetic */ void registerClassFilePostProcessor$(ClassFileReader $this, Function1 p) {
        $this.registerClassFilePostProcessor((Function1<List<Object>, List<Object>>)p);
    }

    default public void registerClassFilePostProcessor(Function1<List<Object>, List<Object>> p) {
        this.org$opalj$bi$reader$ClassFileReader$$classFilePostProcessors_$eq((RefArray<Function1<List<Object>, List<Object>>>)this.org$opalj$bi$reader$ClassFileReader$$classFilePostProcessors().$colon$plus(p));
    }

    public static /* synthetic */ List ClassFile$(ClassFileReader $this, DataInputStream in) {
        return $this.ClassFile(in);
    }

    default public List<Object> ClassFile(DataInputStream in) {
        int[] nArray;
        int readMagic = in.readInt();
        if (-889275714 != readMagic) {
            throw new BytecodeProcessingFailedException("the file does not start with 0xCAFEBABE");
        }
        int minor_version = in.readUnsignedShort();
        int major_version = in.readUnsignedShort();
        if (major_version < 45 || major_version >= 54 && (major_version != 54 || minor_version != 0)) {
            throw new BytecodeProcessingFailedException(new StringBuilder(85).append("unsupported class file version: ").append(major_version).append(".").append(minor_version).append(" (Supported: 45(Java 1.1) <= version <= 54(Java 10))").toString());
        }
        ConstantPoolEntry[] cp = this.Constant_Pool(in);
        int access_flags = in.readUnsignedShort();
        int this_class = in.readUnsignedShort();
        int super_class = in.readUnsignedShort();
        int interfaces_count = in.readUnsignedShort();
        int size = interfaces_count;
        if (size == 0) {
            nArray = IntArray$.MODULE$.EmptyArrayOfInt();
        } else {
            int[] array = new int[size];
            for (int i = 0; i < size; ++i) {
                int value;
                array[i] = value = in.readUnsignedShort();
            }
            nArray = array;
        }
        int[] interfaces = nArray;
        Object fields = this.Fields(cp, in);
        Object methods = this.Methods(cp, in);
        Object attributes = this.Attributes(cp, AttributesParent$.MODULE$.ClassFile(), this_class, -1, in);
        Object classFile = this.ClassFile(cp, minor_version, major_version, access_flags, this_class, super_class, interfaces, fields, methods, attributes);
        classFile = this.applyDeferredActions(cp, classFile);
        return (List)this.org$opalj$bi$reader$ClassFileReader$$classFilePostProcessors().foldLeft((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{classFile})), (Function2 & Serializable & scala.Serializable)(classFiles, postProcessor) -> (List)postProcessor.apply(classFiles));
    }

    public static /* synthetic */ List ClassFile$(ClassFileReader $this, Function0 create) {
        return $this.ClassFile((Function0<InputStream>)create);
    }

    default public List<Object> ClassFile(Function0<InputStream> create) {
        return (List)package$.MODULE$.process((Closeable)create.apply(), (Function1 & Serializable & scala.Serializable)x0$1 -> {
            List<Object> list;
            InputStream inputStream = x0$1;
            if (inputStream == null) {
                throw new IllegalArgumentException("the created stream is null");
            }
            if (inputStream instanceof DataInputStream) {
                DataInputStream dataInputStream = (DataInputStream)inputStream;
                list = this.ClassFile(dataInputStream);
            } else if (inputStream instanceof BufferedInputStream) {
                BufferedInputStream bufferedInputStream = (BufferedInputStream)inputStream;
                list = this.ClassFile(new DataInputStream(bufferedInputStream));
            } else if (inputStream instanceof ByteArrayInputStream) {
                ByteArrayInputStream byteArrayInputStream = (ByteArrayInputStream)inputStream;
                list = this.ClassFile(new DataInputStream(byteArrayInputStream));
            } else {
                list = this.ClassFile(new DataInputStream(new BufferedInputStream(inputStream)));
            }
            return list;
        });
    }

    public static /* synthetic */ boolean isClassFileRepository$(ClassFileReader $this, String filename, Option containerName) {
        return $this.isClassFileRepository(filename, (Option<String>)containerName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public boolean isClassFileRepository(String filename, Option<String> containerName) {
        String ending;
        int containerNameLength;
        if (containerName.isDefined() && (containerNameLength = ((String)containerName.get()).length()) > 5 && ((String)containerName.get()).endsWith(".jmod")) {
            return false;
        }
        int filenameLength = filename.length();
        if (filenameLength <= 4) return false;
        String string = ending = filename.substring(filenameLength - 4, filenameLength).toLowerCase();
        String string2 = "jmod";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            if (filename.charAt(filenameLength - 5) == '.') return true;
        }
        String string3 = ending;
        String string4 = ".jar";
        if (string3 == null) {
            if (string4 == null) return true;
        } else if (string3.equals(string4)) return true;
        String string5 = ending;
        String string6 = ".zip";
        if (string5 == null) {
            if (string6 == null) return true;
        } else if (string5.equals(string6)) return true;
        String string7 = ending;
        String string8 = ".war";
        if (string7 == null) {
            if (string8 == null) return true;
        } else if (string7.equals(string8)) return true;
        String string9 = ending;
        String string10 = ".ear";
        if (string9 != null) {
            if (!string9.equals(string10)) return false;
            return true;
        }
        if (string10 == null) return true;
        return false;
    }

    public static /* synthetic */ List ClassFile$(ClassFileReader $this, ZipFile jarFile, ZipEntry jarEntry) {
        return $this.ClassFile(jarFile, jarEntry);
    }

    default public List<Object> ClassFile(ZipFile jarFile, ZipEntry jarEntry) {
        return (List)package$.MODULE$.process((Closeable)jarFile.getInputStream(jarEntry), (Function1 & Serializable & scala.Serializable)in -> this.ClassFile(new DataInputStream(new BufferedInputStream((InputStream)in))));
    }

    public static /* synthetic */ List ClassFile$(ClassFileReader $this, File jarFile, String jarFileEntryName) {
        return $this.ClassFile(jarFile, jarFileEntryName);
    }

    default public List<Object> ClassFile(File jarFile, String jarFileEntryName) throws IOException {
        if (jarFile.length() == 0L) {
            throw new IOException(new StringBuilder(18).append("the file ").append(jarFile).append(" is empty").toString());
        }
        LevenshteinDistance levenshteinDistance = new LevenshteinDistance();
        return (List)package$.MODULE$.process((Closeable)new ZipFile(jarFile), (Function1 & Serializable & scala.Serializable)zf -> {
            ZipEntry jarEntry = zf.getEntry(jarFileEntryName);
            if (jarEntry == null) {
                Nil$ names = Nil$.MODULE$;
                Enumeration<? extends ZipEntry> zfEntries = zf.entries();
                while (zfEntries.hasMoreElements()) {
                    ZipEntry zfEntry = zfEntries.nextElement();
                    String zfEntryName = zfEntry.getName();
                    int distance = levenshteinDistance.apply((CharSequence)zfEntryName, (CharSequence)jarFileEntryName);
                    Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)distance), (Object)zfEntryName);
                    names = names.$colon$colon((Object)tuple2);
                }
                List mostRelatedNames = ((List)((List)names.sortWith((Function2 & Serializable & scala.Serializable)(l, r) -> BoxesRunTime.boxToBoolean((boolean)ClassFileReader.$anonfun$ClassFile$5(l, r)))).map((Function1 & Serializable & scala.Serializable)x$2 -> (String)x$2._2(), List$.MODULE$.canBuildFrom())).take(15);
                String ending = mostRelatedNames.length() > 15 ? ", ...)" : ")";
                String messageHeader = new StringBuilder(27).append("the file ").append(jarFile).append(" does not contain ").append(jarFileEntryName).toString();
                String message = mostRelatedNames.mkString(new StringBuilder(11).append(messageHeader).append(" (similar: ").toString(), ", ", ending);
                throw new IOException(message);
            }
            return this.ClassFile((ZipFile)zf, jarEntry);
        });
    }

    public static /* synthetic */ List ClassFile$(ClassFileReader $this, String jarFileName, String jarFileEntryName) {
        return $this.ClassFile(jarFileName, jarFileEntryName);
    }

    default public List<Object> ClassFile(String jarFileName, String jarFileEntryName) throws IOException {
        return this.ClassFile(new File(jarFileName), jarFileEntryName);
    }

    public static /* synthetic */ List ClassFiles$(ClassFileReader $this, ZipFile jarFile, Function2 exceptionHandler) {
        return $this.ClassFiles(jarFile, (Function2<Object, Throwable, BoxedUnit>)exceptionHandler);
    }

    default public List<Tuple2<Object, URL>> ClassFiles(ZipFile jarFile, Function2<Object, Throwable, BoxedUnit> exceptionHandler) {
        Object Lock = new Object();
        ObjectRef classFiles = ObjectRef.create((Object)Nil$.MODULE$);
        this.ClassFiles(jarFile, (Function2<Object, URL, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(cf, url) -> {
            ClassFileReader.addClassFile$1(cf, url, Lock, classFiles);
            return BoxedUnit.UNIT;
        }, exceptionHandler);
        return (List)classFiles.elem;
    }

    public static /* synthetic */ List ClassFiles$(ClassFileReader $this, Function0 in) {
        return $this.ClassFiles((Function0<JarInputStream>)in);
    }

    default public List<Tuple2<Object, String>> ClassFiles(Function0<JarInputStream> in2) {
        return (List)package$.MODULE$.process((Closeable)in2.apply(), (Function1 & Serializable & scala.Serializable)in -> {
            JarEntry je = in.getNextJarEntry();
            Nil$ futures = Nil$.MODULE$;
            while (je != null) {
                String entryName = je.getName();
                if (entryName.endsWith(".class") || entryName.endsWith(".jar")) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    byte[] buffer = new byte[32768];
                    scala.package$.MODULE$.Stream().continually((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> in.read(buffer)).takeWhile((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$3 -> x$3 > 0).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)bytesRead -> {
                        baos.write(buffer, 0, bytesRead);
                        baos.flush();
                    });
                    byte[] entryBytes = baos.toByteArray();
                    futures = futures.$colon$colon((Object)Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                        List<Tuple2<Object, String>> list;
                        if (entryName.endsWith(".class")) {
                            List<Object> cfs = this.ClassFile(new DataInputStream(new ByteArrayInputStream(entryBytes)));
                            list = (List<Tuple2<Object, String>>)cfs.map((Function1 & Serializable & scala.Serializable)cf -> new Tuple2(cf, (Object)entryName), List$.MODULE$.canBuildFrom());
                        } else {
                            OPALLogger$.MODULE$.info("class file reader", new StringBuilder(18).append("reading inner jar ").append(entryName).toString(), this.logContext());
                            list = this.ClassFiles((Function0<JarInputStream>)(Function0 & Serializable & scala.Serializable)() -> new JarInputStream(new ByteArrayInputStream(entryBytes)));
                        }
                        return list;
                    }, (ExecutionContext)ExecutionContext$.MODULE$.global()));
                }
                je = in.getNextJarEntry();
            }
            return (List)futures.flatMap((Function1 & Serializable & scala.Serializable)f -> (List)Await$.MODULE$.result((Awaitable)f, (Duration)Duration$.MODULE$.Inf()), List$.MODULE$.canBuildFrom());
        });
    }

    public static /* synthetic */ void ClassFiles$(ClassFileReader $this, ZipFile zipFile, Function2 classFileHandler, Function2 exceptionHandler) {
        $this.ClassFiles(zipFile, (Function2<Object, URL, BoxedUnit>)classFileHandler, (Function2<Object, Throwable, BoxedUnit>)exceptionHandler);
    }

    default public void ClassFiles(ZipFile zipFile, Function2<Object, URL, BoxedUnit> classFileHandler, Function2<Object, Throwable, BoxedUnit> exceptionHandler) {
        String zipFileURL = new File(zipFile.getName()).toURI().toURL().toExternalForm();
        String jarFileName = new StringBuilder(6).append("jar:").append(zipFileURL).append("!/").toString();
        this.ClassFiles(jarFileName, zipFile, classFileHandler, exceptionHandler);
    }

    private void ClassFiles(String jarFileURL, ZipFile jarFile, Function2<Object, URL, BoxedUnit> classFileHandler, Function2<Object, Throwable, BoxedUnit> exceptionHandler) {
        int futureIndex;
        ConcurrentLinkedQueue innerJarEntries = new ConcurrentLinkedQueue();
        ZipEntry[] jarEntries = (ZipEntry[])((TraversableOnce)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(jarFile.entries()).asScala()).toArray(ClassTag$.MODULE$.apply(ZipEntry.class));
        AtomicInteger nextEntryIndex = new AtomicInteger(jarEntries.length - 1);
        int parallelismLevel = org.opalj.concurrent.package$.MODULE$.NumberOfThreadsForIOBoundTasks();
        Future[] futures = new Future[parallelismLevel];
        for (futureIndex = 0; futureIndex < parallelismLevel; ++futureIndex) {
            futures[futureIndex] = Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                int index = -1;
                while ((index = nextEntryIndex.getAndDecrement()) >= 0) {
                    Object object;
                    ZipEntry jarEntry = jarEntries[index];
                    if (!jarEntry.isDirectory() && jarEntry.getSize() > 0L) {
                        String jarEntryName = jarEntry.getName();
                        if (jarEntryName.endsWith(".class")) {
                            try {
                                URL url = new URL(new StringBuilder(0).append(jarFileURL).append(jarEntry.getName()).toString());
                                List<Object> classFiles = this.ClassFile(jarFile, jarEntry);
                                classFiles.foreach((Function1 & Serializable & scala.Serializable)classFile -> {
                                    classFileHandler.apply(classFile, (Object)url);
                                    return BoxedUnit.UNIT;
                                });
                            }
                            catch (Throwable throwable) {
                                Throwable throwable2 = throwable;
                                if (throwable2 instanceof ControlThrowable) {
                                    ControlThrowable controlThrowable = (ControlThrowable)throwable2;
                                    throw (Throwable)controlThrowable;
                                }
                                if (throwable2 != null) {
                                    Throwable throwable3 = throwable2;
                                    BoxedUnit boxedUnit = (BoxedUnit)exceptionHandler.apply((Object)jarEntryName, (Object)throwable3);
                                }
                                throw throwable;
                            }
                            object = BoxedUnit.UNIT;
                            continue;
                        }
                        if (this.isClassFileRepository(jarEntryName, (Option<String>)new Some((Object)jarFile.getName()))) {
                            object = BoxesRunTime.boxToBoolean((boolean)innerJarEntries.add(jarEntry));
                            continue;
                        }
                        object = BoxedUnit.UNIT;
                        continue;
                    }
                    object = BoxedUnit.UNIT;
                }
            }, org.opalj.concurrent.package$.MODULE$.OPALExecutionContext());
        }
        while (--futureIndex >= 0) {
            Await$.MODULE$.ready((Awaitable)futures[futureIndex], (Duration)Duration$.MODULE$.Inf());
        }
        innerJarEntries.iterator().forEachRemaining(jarEntry -> {
            String nextJarFileURL = new StringBuilder(6).append(jarFileURL).append("jar:").append(jarEntry.getName()).append("!/").toString();
            try {
                byte[] jarData = new byte[(int)jarEntry.getSize()];
                DataInputStream din = new DataInputStream(jarFile.getInputStream((ZipEntry)jarEntry));
                din.readFully(jarData);
                din.close();
                this.ClassFiles(nextJarFileURL, jarData, classFileHandler, exceptionHandler);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof ControlThrowable) {
                    ControlThrowable controlThrowable = (ControlThrowable)throwable2;
                    throw (Throwable)controlThrowable;
                }
                if (throwable2 != null) {
                    Throwable throwable3 = throwable2;
                    BoxedUnit boxedUnit = (BoxedUnit)exceptionHandler.apply((Object)nextJarFileURL, (Object)throwable3);
                }
                throw throwable;
            }
        });
    }

    private void ClassFiles(String jarFileURL, byte[] jarData, Function2<Object, URL, BoxedUnit> classFileHandler, Function2<Object, Throwable, BoxedUnit> exceptionHandler) {
        String pathToEntry = jarFileURL.substring(0, jarFileURL.length() - 3);
        String entry = pathToEntry.substring(pathToEntry.lastIndexOf(47) + 1);
        try {
            File jarFile = File.createTempFile(entry, ".zip");
            package$.MODULE$.process((Closeable)new FileOutputStream(jarFile), (Function1 & Serializable & scala.Serializable)fout -> {
                fout.write(jarData);
                return BoxedUnit.UNIT;
            });
            this.ClassFiles(jarFileURL, new ZipFile(jarFile), classFileHandler, exceptionHandler);
            jarFile.delete();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ControlThrowable) {
                ControlThrowable controlThrowable = (ControlThrowable)throwable2;
                throw (Throwable)controlThrowable;
            }
            if (throwable2 != null) {
                Throwable throwable3 = throwable2;
                BoxedUnit boxedUnit = (BoxedUnit)exceptionHandler.apply((Object)pathToEntry, (Object)throwable3);
            }
            throw throwable;
        }
    }

    private List<Tuple2<Object, URL>> processJar(File file, Function2<Object, Throwable, BoxedUnit> exceptionHandler) {
        Nil$ nil$;
        try {
            nil$ = (List)package$.MODULE$.process((Closeable)new ZipFile(file), (Function1 & Serializable & scala.Serializable)zf -> this.ClassFiles((ZipFile)zf, exceptionHandler));
        }
        catch (Exception e) {
            exceptionHandler.apply((Object)file, (Object)e);
            nil$ = Nil$.MODULE$;
        }
        return nil$;
    }

    private Function2<Object, Throwable, BoxedUnit> processJar$default$2() {
        return this.defaultExceptionHandler();
    }

    private List<Tuple2<Object, URL>> processClassFile(File file, Function2<Object, Throwable, BoxedUnit> exceptionHandler) {
        Nil$ nil$;
        try {
            nil$ = (List)package$.MODULE$.process((Closeable)new DataInputStream(new BufferedInputStream(new FileInputStream(file))), (Function1 & Serializable & scala.Serializable)in -> (List)this.ClassFile((DataInputStream)in).map((Function1 & Serializable & scala.Serializable)classFile -> new Tuple2(classFile, (Object)file.toURI().toURL()), List$.MODULE$.canBuildFrom()));
        }
        catch (Exception e) {
            exceptionHandler.apply((Object)file, (Object)e);
            nil$ = Nil$.MODULE$;
        }
        return nil$;
    }

    private Function2<Object, Throwable, BoxedUnit> processClassFile$default$2() {
        return this.defaultExceptionHandler();
    }

    public static /* synthetic */ List ClassFiles$(ClassFileReader $this, File file, Function2 exceptionHandler) {
        return $this.ClassFiles(file, (Function2<Object, Throwable, BoxedUnit>)exceptionHandler);
    }

    default public List<Tuple2<Object, URL>> ClassFiles(File file, Function2<Object, Throwable, BoxedUnit> exceptionHandler) {
        Object object;
        if (!file.exists()) {
            object = Nil$.MODULE$;
        } else if (file.isFile()) {
            String filename = file.getName();
            object = file.length() == 0L ? Nil$.MODULE$ : (this.isClassFileRepository(filename, (Option<String>)None$.MODULE$) ? this.processJar(file, this.processJar$default$2()) : (filename.endsWith(".class") ? this.processClassFile(file, this.processClassFile$default$2()) : Nil$.MODULE$));
        } else if (file.isDirectory()) {
            ObjectRef jarFiles = ObjectRef.create((Object)List$.MODULE$.empty());
            ObjectRef classFiles = ObjectRef.create((Object)List$.MODULE$.empty());
            this.collectFiles$1(file.listFiles(), jarFiles, classFiles);
            ObjectRef allClassFiles = ObjectRef.create((Object)List$.MODULE$.empty());
            if (((List)classFiles.elem).nonEmpty()) {
                ConcurrentLinkedQueue theClassFiles = new ConcurrentLinkedQueue();
                ParSeq parClassFiles = (ParSeq)((List)classFiles.elem).par();
                parClassFiles.tasksupport_$eq((TaskSupport)org.opalj.concurrent.package$.MODULE$.OPALExecutionContextTaskSupport());
                parClassFiles.foreach((Function1 & Serializable & scala.Serializable)classFile -> BoxesRunTime.boxToBoolean((boolean)theClassFiles.addAll((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(this.processClassFile(classFile, (Function2<Object, Throwable, BoxedUnit>)exceptionHandler)).asJava())));
                allClassFiles.elem = (List)((List)allClassFiles.elem).$plus$plus((GenTraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(theClassFiles).asScala(), List$.MODULE$.canBuildFrom());
            }
            ((List)jarFiles.elem).foreach((Function1 & Serializable & scala.Serializable)jarFile -> {
                allClassFiles.elem = (List)((List)allClassFiles.elem).$plus$plus(this.processJar(jarFile, this.processJar$default$2()), List$.MODULE$.canBuildFrom());
                return BoxedUnit.UNIT;
            });
            object = (List)allClassFiles.elem;
        } else {
            throw new UnknownError(new StringBuilder(34).append(file).append(" is neither a file nor a directory").toString());
        }
        return object;
    }

    public static /* synthetic */ Function2 ClassFiles$default$2$(ClassFileReader $this) {
        return $this.ClassFiles$default$2();
    }

    default public Function2<Object, Throwable, BoxedUnit> ClassFiles$default$2() {
        return this.defaultExceptionHandler();
    }

    public static /* synthetic */ Traversable AllClassFiles$(ClassFileReader $this, Traversable files, Function2 exceptionHandler) {
        return $this.AllClassFiles((Traversable<File>)files, (Function2<Object, Throwable, BoxedUnit>)exceptionHandler);
    }

    default public Traversable<Tuple2<Object, URL>> AllClassFiles(Traversable<File> files, Function2<Object, Throwable, BoxedUnit> exceptionHandler) {
        return (Traversable)files.flatMap((Function1 & Serializable & scala.Serializable)file -> this.ClassFiles((File)file, exceptionHandler), Traversable$.MODULE$.canBuildFrom());
    }

    public static /* synthetic */ Function2 AllClassFiles$default$2$(ClassFileReader $this) {
        return $this.AllClassFiles$default$2();
    }

    default public Function2<Object, Throwable, BoxedUnit> AllClassFiles$default$2() {
        return this.defaultExceptionHandler();
    }

    public static /* synthetic */ Iterable JRTClassFiles$(ClassFileReader $this) {
        return $this.JRTClassFiles();
    }

    default public Iterable<Tuple2<String, List<Tuple2<Object, URL>>>> JRTClassFiles() {
        Path allModulesPath = FileSystems.getFileSystem(URI.create("jrt:/")).getPath("/modules", new String[0]);
        return (Iterable)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(Files.newDirectoryStream(allModulesPath, "*")).asScala()).withFilter((Function1 & Serializable & scala.Serializable)modulePath -> BoxesRunTime.boxToBoolean((boolean)ClassFileReader.$anonfun$JRTClassFiles$4(modulePath))).map((Function1 & Serializable & scala.Serializable)modulePath -> new Tuple2((Object)((Object)modulePath.getFileName()).toString(), (Object)this.traverseModule$1((Path)modulePath)), Iterable$.MODULE$.canBuildFrom());
    }

    public static /* synthetic */ Either findClassFile$(ClassFileReader $this, Traversable files, Function1 progressReporter, Function1 classFileFilter, Function1 className, Function2 exceptionHandler) {
        return $this.findClassFile((Traversable<File>)files, (Function1<File, BoxedUnit>)progressReporter, (Function1<Object, Object>)classFileFilter, (Function1<Object, String>)className, (Function2<Object, Throwable, BoxedUnit>)exceptionHandler);
    }

    default public Either<Tuple2<Object, URL>, Set<String>> findClassFile(Traversable<File> files, Function1<File, BoxedUnit> progressReporter, Function1<Object, Object> classFileFilter, Function1<Object, String> className, Function2<Object, Throwable, BoxedUnit> exceptionHandler) {
        Either either;
        Object object = new Object();
        try {
            ObjectRef classNames = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
            ((GenericTraversableTemplate)files.filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.exists()))).foreach((Function1 & Serializable & scala.Serializable)file -> {
                ClassFileReader.$anonfun$findClassFile$2(this, progressReporter, classFileFilter, className, exceptionHandler, classNames, object, file);
                return BoxedUnit.UNIT;
            });
            either = scala.package$.MODULE$.Right().apply((Object)((Set)classNames.elem));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                either = (Either)ex.value();
            }
            throw ex;
        }
        return either;
    }

    public static /* synthetic */ Function2 findClassFile$default$5$(ClassFileReader $this) {
        return $this.findClassFile$default$5();
    }

    default public Function2<Object, Throwable, BoxedUnit> findClassFile$default$5() {
        return this.defaultExceptionHandler();
    }

    public static /* synthetic */ boolean $anonfun$ClassFile$5(Tuple2 l, Tuple2 r) {
        return l._1$mcI$sp() < r._1$mcI$sp();
    }

    private static void addClassFile$1(Object cf, URL url, Object Lock$1, ObjectRef classFiles$1) {
        Object object = Lock$1;
        synchronized (object) {
            classFiles$1.elem = ((List)classFiles$1.elem).$colon$colon((Object)new Tuple2(cf, (Object)url));
        }
    }

    private void collectFiles$1(File[] files, ObjectRef jarFiles$1, ObjectRef classFiles$2) {
        if (files == null) {
            return;
        }
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).foreach((Function1 & Serializable & scala.Serializable)file -> {
            Nil$ nil$;
            String filename = file.getName();
            if (file.isFile()) {
                if (file.length() == 0L) {
                    nil$ = Nil$.MODULE$;
                } else if (this.isClassFileRepository(filename, (Option<String>)None$.MODULE$)) {
                    jarFiles$1.elem = ((List)jarFiles$1.elem).$colon$colon(file);
                    nil$ = BoxedUnit.UNIT;
                } else if (filename.endsWith(".class")) {
                    classFiles$2.elem = ((List)classFiles$2.elem).$colon$colon(file);
                    nil$ = BoxedUnit.UNIT;
                } else {
                    nil$ = BoxedUnit.UNIT;
                }
            } else if (file.isDirectory()) {
                this.collectFiles$1(file.listFiles(), jarFiles$1, classFiles$2);
                nil$ = BoxedUnit.UNIT;
            } else {
                throw new UnknownError(new StringBuilder(34).append(file).append(" is neither a file nor a directory").toString());
            }
            return nil$;
        });
    }

    private void traversePath$1(Path p, ObjectRef allClassFiles$2) {
        block3: {
            block2: {
                if (!Files.isDirectory(p, new LinkOption[0])) break block2;
                try {
                    ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(Files.newDirectoryStream(p, "*")).asScala()).foreach((Function1 & Serializable & scala.Serializable)subPath -> {
                        this.traversePath$1(subPath, allClassFiles$2);
                        return BoxedUnit.UNIT;
                    });
                }
                catch (Exception e) {
                    OPALLogger$.MODULE$.error("class file reader", "failed processing Java 9+ Runtime Image (jrt:/)", (Throwable)e, this.logContext());
                }
                break block3;
            }
            if (!((Object)p.getFileName()).toString().endsWith(".class")) break block3;
            List<Object> cf = this.ClassFile((Function0<InputStream>)(Function0 & Serializable & scala.Serializable)() -> Files.newInputStream(p, new OpenOption[0]));
            List list = (List)cf.map((Function1 & Serializable & scala.Serializable)c -> new Tuple2(c, (Object)p.toUri().toURL()), List$.MODULE$.canBuildFrom());
            allClassFiles$2.elem = (List)((List)allClassFiles$2.elem).$plus$plus$colon((Traversable)list, List$.MODULE$.canBuildFrom());
        }
    }

    private List traverseModule$1(Path module) {
        ObjectRef allClassFiles = ObjectRef.create((Object)List$.MODULE$.empty());
        this.traversePath$1(module, allClassFiles);
        return (List)allClassFiles.elem;
    }

    public static /* synthetic */ boolean $anonfun$JRTClassFiles$4(Path modulePath) {
        return Files.isDirectory(modulePath, new LinkOption[0]);
    }

    public static /* synthetic */ boolean $anonfun$findClassFile$3(Function1 classFileFilter$1, Function1 className$1, ObjectRef classNames$1, Tuple2 cfSource) {
        Object cf;
        Tuple2 tuple2 = cfSource;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Object object = cf = tuple2._1();
        Object cf2 = object;
        classNames$1.elem = (Set)((Set)classNames$1.elem).$plus(className$1.apply(cf2));
        return BoxesRunTime.unboxToBoolean((Object)classFileFilter$1.apply(cf2));
    }

    public static /* synthetic */ void $anonfun$findClassFile$6(ClassFileReader $this, Function1 progressReporter$1, Function1 classFileFilter$1, Function1 className$1, Function2 exceptionHandler$5, ObjectRef classNames$1, Object nonLocalReturnKey1$1, File f) {
        Either<Tuple2<Object, URL>, Set<String>> either = $this.findClassFile((Traversable<File>)new .colon.colon((Object)f, (List)Nil$.MODULE$), (Function1<File, BoxedUnit>)progressReporter$1, (Function1<Object, Object>)classFileFilter$1, (Function1<Object, String>)className$1, (Function2<Object, Throwable, BoxedUnit>)exceptionHandler$5);
        if (either instanceof Left) {
            Left left = (Left)either;
            Tuple2 cf = (Tuple2)left.value();
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)scala.package$.MODULE$.Left().apply((Object)cf));
        }
        if (!(either instanceof Right)) {
            throw new MatchError(either);
        }
        Right right = (Right)either;
        Set moreClassNames = (Set)right.value();
        classNames$1.elem = (Set)((Set)classNames$1.elem).$plus$plus((GenTraversableOnce)moreClassNames);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static /* synthetic */ void $anonfun$findClassFile$2(ClassFileReader $this, Function1 progressReporter$1, Function1 classFileFilter$1, Function1 className$1, Function2 exceptionHandler$5, ObjectRef classNames$1, Object nonLocalReturnKey1$1, File file) {
        block7: {
            block6: {
                List<Tuple2<Object, URL>> list;
                if (!file.isFile() || file.length() <= 0L) break block6;
                String filename = file.getName();
                if ($this.isClassFileRepository(filename, (Option<String>)None$.MODULE$)) {
                    if (!filename.endsWith("-javadoc.jar") && !filename.endsWith("-sources.jar")) {
                        progressReporter$1.apply((Object)file);
                        list = $this.processJar(file, $this.processJar$default$2());
                    } else {
                        list = Nil$.MODULE$;
                    }
                } else if (filename.endsWith(".class")) {
                    progressReporter$1.apply((Object)file);
                    list = $this.processClassFile(file, $this.processClassFile$default$2());
                } else {
                    list = Nil$.MODULE$;
                }
                ((List)list.filter((Function1 & Serializable & scala.Serializable)cfSource -> BoxesRunTime.boxToBoolean((boolean)ClassFileReader.$anonfun$findClassFile$3(classFileFilter$1, className$1, classNames$1, cfSource)))).foreach((Function1 & Serializable & scala.Serializable)e -> {
                    throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)scala.package$.MODULE$.Left().apply(e));
                });
                break block7;
            }
            if (!file.isDirectory()) break block7;
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])file.listFiles((dir, name) -> dir.isDirectory() || $this.isClassFileRepository(file.toString(), (Option<String>)None$.MODULE$)))).foreach((Function1 & Serializable & scala.Serializable)f -> {
                ClassFileReader.$anonfun$findClassFile$6($this, progressReporter$1, classFileFilter$1, className$1, exceptionHandler$5, classNames$1, nonLocalReturnKey1$1, f);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static void $init$(ClassFileReader $this) {
        $this.org$opalj$bi$reader$ClassFileReader$_setter_$defaultExceptionHandler_$eq((Function2<Object, Throwable, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(source, t) -> {
            OPALLogger$.MODULE$.error("class file reader", new StringBuilder(18).append("processing ").append(source).append(" failed").toString(), t, $this.logContext());
            return BoxedUnit.UNIT;
        });
        $this.org$opalj$bi$reader$ClassFileReader$$classFilePostProcessors_$eq((RefArray<Function1<List<Object>, List<Object>>>)RefArray$.MODULE$.empty());
    }
}

