/* BSD 2-Clause License:
 * Copyright (c) 2009 - 2017
 * Software Technology Group
 * Department of Computer Science
 * Technische Universität Darmstadt
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  - Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *  - Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package org.opalj
package bi
package reader

import com.typesafe.config.Config
import com.typesafe.config.ConfigFactory

import org.opalj.log.GlobalLogContext
import org.opalj.log.LogContext

/**
 * Defines various settings related to reading/processing class files. To change
 * the default confiration, override the respective `val` using '''early initializers'''!
 *
 * @example
 * {{{
 * class ConfiguredFramework extends {
 *      override implicit val logContext: LogContext = theLogContext
 *      override implicit val config: Config = theConfig
 * } with Java9FrameworkWithLambdaExpressionsSupportAndCaching(cache)
 * new ConfiguredFramework
 * }}}
 *
 * @author Michael Eichberg
 */
trait ClassFileReaderConfiguration {

    /**
     * The [[org.opalj.log.LogContext]] that should be used to log rewritings.
     *
     * @note    The [[org.opalj.log.LogContext]] is typically either the
     *          [[org.opalj.log.GlobalLogContext]] or a project specific log context.
     */
    implicit val logContext: LogContext = GlobalLogContext

    /**
     * The `Config` object that will be used to read the configuration settings for
     * reading in class files.
     */
    implicit val config: Config = ConfigFactory.load()

    /**
     * If `true` method bodies are never loaded.
     */
    def loadsInterfacesOnly: Boolean

}
