/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.da;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.lang3.StringUtils;
import org.opalj.da.ClassFile;
import org.opalj.da.ClassFile$;
import org.opalj.da.ClassFileReader$;
import org.opalj.io.package$;
import org.opalj.log.ConsoleOPALLogger;
import org.opalj.log.Error$;
import org.opalj.log.GlobalLogContext$;
import org.opalj.log.Level;
import org.opalj.log.LogContext;
import org.opalj.log.OPALLogger;
import org.opalj.log.OPALLogger$;
import scala.Console$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class Disassembler$ {
    public static Disassembler$ MODULE$;

    static {
        new Disassembler$();
    }

    private final String Usage() {
        return "Usage: java \u2026Disassembler \n       [-help will print this help and terminate.]\n       [-o <File> the name of the file to which the generated html page should be written]\n       [-open the generated html page will be opened in a browser]\n       [-source <File> a class or jar file or a directory containing jar or class files;\n                       if no source files/folders are specified the current folder will be\n                       searched for class files]*\n       [-sourceJDK the current JDK/JRE is added as a source folder]\n       [-noDefaultCSS the generated html page will have no CSS styling]\n       [-noMethodsFilter the generated html page will have no embedded means to filter methods\n                         (as a whole, the file will not contain any JavaScript code)]\n       [-noHeader the generated output will have no header; \n                  the top level element will be <div class=\"class_file\">...</div>\n                  (automatically activates \"-noMethodsFilter\" and \"-noDefaultCSS\")]\n       [-css <Source> the path (URL) of a CSS file (\".csss\")\n                      which will be referenced from the generated HTML page]\n       [-js <Source> the path (URL) of a JavaScript file (\".js\")\n                     which will be referenced from the generated HTML page]\n       [-showProgress shows the progress when searching for the class file]\n       [<ClassName> name of the class for which we want to create the HTML page;\n                    if not specified the first class that is found on the given path is taken;\n                    this is particularly useful if the source identifies a particular \".class\" file]\n\nNote:   \n       If no parameters are specified, the first class file found in the current folder\n       or any subfolder of it will be disassembled.\nExample:\n       java \u2026Disassembler -source /Library/jre/lib/rt.jar java.util.ArrayList";
    }

    public Nothing$ handleError(String error, boolean showUsage) {
        block0: {
            Console$.MODULE$.err().println("Error: " + error);
            if (!showUsage) break block0;
            Console$.MODULE$.out().println("Usage: java \u2026Disassembler \n       [-help will print this help and terminate.]\n       [-o <File> the name of the file to which the generated html page should be written]\n       [-open the generated html page will be opened in a browser]\n       [-source <File> a class or jar file or a directory containing jar or class files;\n                       if no source files/folders are specified the current folder will be\n                       searched for class files]*\n       [-sourceJDK the current JDK/JRE is added as a source folder]\n       [-noDefaultCSS the generated html page will have no CSS styling]\n       [-noMethodsFilter the generated html page will have no embedded means to filter methods\n                         (as a whole, the file will not contain any JavaScript code)]\n       [-noHeader the generated output will have no header; \n                  the top level element will be <div class=\"class_file\">...</div>\n                  (automatically activates \"-noMethodsFilter\" and \"-noDefaultCSS\")]\n       [-css <Source> the path (URL) of a CSS file (\".csss\")\n                      which will be referenced from the generated HTML page]\n       [-js <Source> the path (URL) of a JavaScript file (\".js\")\n                     which will be referenced from the generated HTML page]\n       [-showProgress shows the progress when searching for the class file]\n       [<ClassName> name of the class for which we want to create the HTML page;\n                    if not specified the first class that is found on the given path is taken;\n                    this is particularly useful if the source identifies a particular \".class\" file]\n\nNote:   \n       If no parameters are specified, the first class file found in the current folder\n       or any subfolder of it will be disassembled.\nExample:\n       java \u2026Disassembler -source /Library/jre/lib/rt.jar java.util.ArrayList");
        }
        return scala.sys.package$.MODULE$.exit(1);
    }

    public boolean handleError$default$2() {
        return true;
    }

    public void main(String[] args) {
        None$ htmlCSS;
        None$ none$;
        Tuple2 cfSource;
        Function1 & Serializable & scala.Serializable classFileFilter;
        List sourceFiles;
        Either<Tuple2<Object, URL>, Set<String>> either;
        boolean toStdOut = true;
        None$ toFile = None$.MODULE$;
        boolean openHTMLFile = false;
        List sources = List$.MODULE$.empty();
        boolean noDefaultCSS = false;
        boolean noHeader = false;
        boolean noMethodsFilter = false;
        None$ css = None$.MODULE$;
        None$ js = None$.MODULE$;
        boolean showProgress = false;
        ObjectRef className = ObjectRef.create(null);
        IntRef i = IntRef.create((int)0);
        while (i.elem < args.length) {
            BoxedUnit boxedUnit;
            String string = args[i.elem];
            boolean bl = "-help".equals(string) ? true : "--help".equals(string);
            if (bl) {
                Console$.MODULE$.out().println("Usage: java \u2026Disassembler \n       [-help will print this help and terminate.]\n       [-o <File> the name of the file to which the generated html page should be written]\n       [-open the generated html page will be opened in a browser]\n       [-source <File> a class or jar file or a directory containing jar or class files;\n                       if no source files/folders are specified the current folder will be\n                       searched for class files]*\n       [-sourceJDK the current JDK/JRE is added as a source folder]\n       [-noDefaultCSS the generated html page will have no CSS styling]\n       [-noMethodsFilter the generated html page will have no embedded means to filter methods\n                         (as a whole, the file will not contain any JavaScript code)]\n       [-noHeader the generated output will have no header; \n                  the top level element will be <div class=\"class_file\">...</div>\n                  (automatically activates \"-noMethodsFilter\" and \"-noDefaultCSS\")]\n       [-css <Source> the path (URL) of a CSS file (\".csss\")\n                      which will be referenced from the generated HTML page]\n       [-js <Source> the path (URL) of a JavaScript file (\".js\")\n                     which will be referenced from the generated HTML page]\n       [-showProgress shows the progress when searching for the class file]\n       [<ClassName> name of the class for which we want to create the HTML page;\n                    if not specified the first class that is found on the given path is taken;\n                    this is particularly useful if the source identifies a particular \".class\" file]\n\nNote:   \n       If no parameters are specified, the first class file found in the current folder\n       or any subfolder of it will be disassembled.\nExample:\n       java \u2026Disassembler -source /Library/jre/lib/rt.jar java.util.ArrayList");
                return;
            }
            if ("-o".equals(string)) {
                toFile = new Some((Object)this.readNextArg$1(args, i));
                toStdOut = false;
                boxedUnit = BoxedUnit.UNIT;
            } else if ("-open".equals(string)) {
                openHTMLFile = true;
                toStdOut = false;
                boxedUnit = BoxedUnit.UNIT;
            } else if ("-noDefaultCSS".equals(string)) {
                noDefaultCSS = true;
                boxedUnit = BoxedUnit.UNIT;
            } else if ("-noMethodsFilter".equals(string)) {
                noMethodsFilter = true;
                boxedUnit = BoxedUnit.UNIT;
            } else if ("-noHeader".equals(string)) {
                noHeader = true;
                noMethodsFilter = true;
                noDefaultCSS = true;
                boxedUnit = BoxedUnit.UNIT;
            } else if ("-css".equals(string)) {
                css = new Some((Object)this.readNextArg$1(args, i));
                boxedUnit = BoxedUnit.UNIT;
            } else if ("-js".equals(string)) {
                js = new Some((Object)this.readNextArg$1(args, i));
                boxedUnit = BoxedUnit.UNIT;
            } else if ("-source".equals(string)) {
                sources = sources.$colon$colon((Object)this.readNextArg$1(args, i));
                boxedUnit = BoxedUnit.UNIT;
            } else if ("-sourceJDK".equals(string)) {
                sources = sources.$colon$colon((Object)org.opalj.bytecode.package$.MODULE$.JRELibraryFolder().toString());
                boxedUnit = BoxedUnit.UNIT;
            } else if ("-showProgress".equals(string)) {
                showProgress = true;
                boxedUnit = BoxedUnit.UNIT;
            } else {
                className.elem = string.replace('/', '.');
                boxedUnit = BoxedUnit.UNIT;
            }
            ++i.elem;
        }
        if (noHeader) {
            if (css.nonEmpty()) {
                throw this.handleError("specifying -noHeader and a css file is not supported", this.handleError$default$2());
            }
            if (js.nonEmpty()) {
                throw this.handleError("specifying -noHeader and a js file is not supported", this.handleError$default$2());
            }
        }
        if (sources.isEmpty()) {
            sources = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{System.getProperty("user.dir")}));
        }
        if (!((either = ClassFileReader$.MODULE$.findClassFile((Traversable<File>)(sourceFiles = (List)sources.map((Function1 & Serializable & scala.Serializable)src -> {
            void var1_1;
            File f = new File((String)src);
            if (!f.exists()) {
                throw MODULE$.handleError("file does not exist: " + src, false);
            }
            if (!f.canRead()) {
                throw MODULE$.handleError("cannot read: " + src, false);
            }
            return var1_1;
        }, List$.MODULE$.canBuildFrom())), (Function1<File, BoxedUnit>)(showProgress ? (Function1 & Serializable & scala.Serializable)x -> {
            Predef$.MODULE$.println(x);
            return BoxedUnit.UNIT;
        } : (Function1 & Serializable & scala.Serializable)f -> {
            Disassembler$.$anonfun$main$5(f);
            return BoxedUnit.UNIT;
        }), (Function1<Object, Object>)(classFileFilter = (String)className.elem == null ? (Function1 & Serializable & scala.Serializable)cf -> BoxesRunTime.boxToBoolean((boolean)Disassembler$.$anonfun$main$2(cf)) : (Function1 & Serializable & scala.Serializable)cf -> BoxesRunTime.boxToBoolean((boolean)Disassembler$.$anonfun$main$3(className, cf))), (Function1<Object, String>)(Function1 & Serializable & scala.Serializable)cf -> cf.thisType().asJava(), ClassFileReader$.MODULE$.findClassFile$default$5())) instanceof Left)) {
            if (either instanceof Right) {
                Right right = (Right)either;
                Set altClassNames = (Set)right.value();
                if (altClassNames.isEmpty()) {
                    throw this.handleError(sources.mkString("cannot find class files in: ", ", ", ""), this.handleError$default$2());
                }
                List allClassNames = ((TraversableOnce)altClassNames.map((Function1 & Serializable & scala.Serializable)cf -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)StringUtils.getLevenshteinDistance((CharSequence)((String)className$1.elem), (CharSequence)cf)), cf), Set$.MODULE$.canBuildFrom())).toList();
                List mostRelated = ((List)((List)allClassNames.sortWith((Function2 & Serializable & scala.Serializable)(l, r) -> BoxesRunTime.boxToBoolean((boolean)Disassembler$.$anonfun$main$8(l, r)))).map((Function1 & Serializable & scala.Serializable)x$1 -> (String)x$1._2(), List$.MODULE$.canBuildFrom())).take(15);
                String ending = mostRelated.length() > 15 ? ", ...)" : ")";
                String messageHeader = "can't find: " + (String)className.elem;
                String message = mostRelated.mkString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " (similar: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{messageHeader})), ", ", ending);
                throw this.handleError(message, false);
            }
            throw new MatchError(either);
        }
        Left left = (Left)either;
        Tuple2 tuple2 = cfSource = (Tuple2)left.value();
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        ClassFile classFile = (ClassFile)tuple22._1();
        URL source = (URL)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)classFile, (Object)source);
        Tuple2 tuple24 = tuple23;
        ClassFile classFile2 = (ClassFile)tuple24._1();
        URL source2 = (URL)tuple24._2();
        String classNameAsFileName = package$.MODULE$.sanitizeFileName(classFile2.thisType().asJava());
        if (openHTMLFile) {
            if (toFile.isEmpty()) {
                none$ = new Some((Object)File.createTempFile(classNameAsFileName, ".html"));
            } else {
                File f2 = new File((String)toFile.get());
                if (f2.exists() && !f2.canWrite()) {
                    throw this.handleError("cannot update: " + f2, this.handleError$default$2());
                }
                none$ = new Some((Object)f2);
            }
        } else if (toFile.isDefined()) {
            File f3 = new File((String)toFile.get());
            if (f3.exists() && !f3.canWrite()) {
                throw this.handleError("cannot update: " + f3, this.handleError$default$2());
            }
            none$ = new Some((Object)f3);
        } else {
            none$ = None$.MODULE$;
        }
        None$ targetFile = none$;
        Object object = htmlCSS = noDefaultCSS ? None$.MODULE$ : new Some((Object)ClassFile$.MODULE$.TheCSS());
        String xHTML = noHeader ? classFile2.classFileToXHTML((Option<Object>)new Some((Object)source2)).toString() : classFile2.toXHTML((Option<Object>)new Some((Object)source2), (Option<String>)htmlCSS, (Option<String>)css, (Option<String>)js, !noMethodsFilter).toString();
        None$ none$2 = targetFile;
        if (none$2 instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)none$2;
            File f4 = (File)some.value();
            Files.write(f4.toPath(), xHTML.toString().getBytes("UTF-8"), new OpenOption[0]);
            Predef$.MODULE$.println((Object)("wrote: " + f4));
            if (openHTMLFile) {
                package$.MODULE$.open(f4);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (None$.MODULE$.equals(none$2)) {
            Console$.MODULE$.out().println(xHTML);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)none$2);
        }
    }

    private final String readNextArg$1(String[] args$1, IntRef i$1) {
        ++i$1.elem;
        if (i$1.elem >= args$1.length) {
            throw this.handleError(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args$1)).mkString("missing argument: ", " ", ""), this.handleError$default$2());
        }
        return args$1[i$1.elem];
    }

    public static final /* synthetic */ boolean $anonfun$main$2(ClassFile cf) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$main$3(ObjectRef className$1, ClassFile cf) {
        String string = cf.thisType().asJava();
        String string2 = (String)className$1.elem;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$main$5(File f) {
    }

    public static final /* synthetic */ boolean $anonfun$main$8(Tuple2 l, Tuple2 r) {
        return l._1$mcI$sp() < r._1$mcI$sp();
    }

    private Disassembler$() {
        MODULE$ = this;
        OPALLogger$.MODULE$.updateLogger((LogContext)GlobalLogContext$.MODULE$, (OPALLogger)new ConsoleOPALLogger(true, (Level)Error$.MODULE$));
    }
}

