/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.da;

import java.io.File;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.lang3.StringUtils;
import org.opalj.da.ClassFile;
import org.opalj.da.ClassFile$;
import org.opalj.da.ClassFileReader$;
import org.opalj.io.package$;
import org.opalj.log.ConsoleOPALLogger;
import org.opalj.log.Error$;
import org.opalj.log.GlobalLogContext$;
import org.opalj.log.Level;
import org.opalj.log.LogContext;
import org.opalj.log.OPALLogger;
import org.opalj.log.OPALLogger$;
import scala.Console$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.Traversable$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;

public final class Disassembler$ {
    public static final Disassembler$ MODULE$;
    private final String Usage;

    static {
        new Disassembler$();
    }

    private final String Usage() {
        return "Usage: java \u2026Disassembler \n       [-o <File> the name of the file to which the generated html page should be written]\n       [-open the generated html page will be opened in a browser]\n       [-source <File> a class or jar file or a directory containg jar or class files]*\n       [-noDefaultCSS the generated html page will have on CSS styling]\n       [-css <Source> the path (URL) of a CSS file (\".csss\") which will be referenced from the generated HTML page]\n       [-jss <Source> the path (URL) of a JavaScript file (\".js\") which will be referenced from the generated HTML page]\n       <ClassName> name of the class for which we want to create the HTML page\nExample:\n       java \u2026Disassembler -source /Library/jre/lib/rt.jar java.util.ArrayList";
    }

    public Nothing$ handleError(String error) {
        Console$.MODULE$.err().println(new StringBuilder().append((Object)"Error: ").append((Object)error).toString());
        Console$.MODULE$.out().println("Usage: java \u2026Disassembler \n       [-o <File> the name of the file to which the generated html page should be written]\n       [-open the generated html page will be opened in a browser]\n       [-source <File> a class or jar file or a directory containg jar or class files]*\n       [-noDefaultCSS the generated html page will have on CSS styling]\n       [-css <Source> the path (URL) of a CSS file (\".csss\") which will be referenced from the generated HTML page]\n       [-jss <Source> the path (URL) of a JavaScript file (\".js\") which will be referenced from the generated HTML page]\n       <ClassName> name of the class for which we want to create the HTML page\nExample:\n       java \u2026Disassembler -source /Library/jre/lib/rt.jar java.util.ArrayList");
        return scala.sys.package$.MODULE$.exit(1);
    }

    public void main(String[] args) {
        Option option;
        block30: {
            None$ none$;
            block33: {
                block32: {
                    String xHTML;
                    block31: {
                        BoxedUnit boxedUnit;
                        ClassFile cf;
                        ClassFile classFile;
                        Some some;
                        Tuple2 tuple2;
                        None$ none$2;
                        boolean toStdOut = true;
                        None$ toFile = None$.MODULE$;
                        boolean openHTMLFile = false;
                        List sources = List$.MODULE$.empty();
                        boolean noDefaultCSS = false;
                        None$ css = None$.MODULE$;
                        None$ js = None$.MODULE$;
                        ObjectRef className = ObjectRef.create(null);
                        IntRef i = IntRef.create((int)0);
                        while (i.elem < args.length) {
                            BoxedUnit boxedUnit2;
                            String string = args[i.elem];
                            if ("-o".equals(string)) {
                                toFile = new Some((Object)this.readNextArg$1(args, i));
                                toStdOut = false;
                                boxedUnit2 = BoxedUnit.UNIT;
                            } else if ("-open".equals(string)) {
                                openHTMLFile = true;
                                toStdOut = false;
                                boxedUnit2 = BoxedUnit.UNIT;
                            } else if ("-noDefaultCSS".equals(string)) {
                                noDefaultCSS = true;
                                boxedUnit2 = BoxedUnit.UNIT;
                            } else if ("-css".equals(string)) {
                                css = new Some((Object)this.readNextArg$1(args, i));
                                boxedUnit2 = BoxedUnit.UNIT;
                            } else if ("-js".equals(string)) {
                                js = new Some((Object)this.readNextArg$1(args, i));
                                boxedUnit2 = BoxedUnit.UNIT;
                            } else if ("-source".equals(string)) {
                                sources = sources.$colon$colon((Object)this.readNextArg$1(args, i));
                                boxedUnit2 = BoxedUnit.UNIT;
                            } else {
                                className.elem = string.replace('/', '.');
                                boxedUnit2 = BoxedUnit.UNIT;
                            }
                            ++i.elem;
                        }
                        if ((String)className.elem == null) {
                            throw this.handleError("missing class name");
                        }
                        if (sources.isEmpty()) {
                            sources = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{System.getProperty("user.dir")}));
                        }
                        List sourceFiles = (List)sources.map((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            /*
                             * WARNING - void declaration
                             */
                            public final File apply(String src) {
                                File f = new File(src);
                                if (f.exists()) {
                                    if (f.canRead()) {
                                        void var2_2;
                                        return var2_2;
                                    }
                                    throw Disassembler$.MODULE$.handleError(new StringBuilder().append((Object)"cannot read: ").append((Object)src).toString());
                                }
                                throw Disassembler$.MODULE$.handleError(new StringBuilder().append((Object)"file does not exist: ").append((Object)src).toString());
                            }
                        }, List$.MODULE$.canBuildFrom());
                        String classNameAsFileName = package$.MODULE$.sanitizeFileName((String)className.elem);
                        if (openHTMLFile) {
                            if (toFile.isEmpty()) {
                                none$2 = new Some((Object)File.createTempFile(classNameAsFileName, ".html"));
                            } else {
                                File f = new File((String)toFile.get());
                                if (f.exists() && !f.canWrite()) {
                                    throw this.handleError(new StringBuilder().append((Object)"cannot update: ").append((Object)f).toString());
                                }
                                none$2 = new Some((Object)f);
                            }
                        } else if (toFile.isDefined()) {
                            File f = new File((String)toFile.get());
                            if (f.exists() && !f.canWrite()) {
                                throw this.handleError(new StringBuilder().append((Object)"cannot update: ").append((Object)f).toString());
                            }
                            none$2 = new Some((Object)f);
                        } else {
                            none$2 = None$.MODULE$;
                        }
                        None$ targetFile = none$2;
                        Traversable<Tuple2<Object, URL>> classFiles = ClassFileReader$.MODULE$.AllClassFiles((Traversable<File>)sourceFiles, ClassFileReader$.MODULE$.AllClassFiles$default$2());
                        if (classFiles.isEmpty()) {
                            throw this.handleError(sources.mkString("cannot find class files in: ", ", ", ""));
                        }
                        Option classFileOption = classFiles.find((Function1)new Serializable(className){
                            public static final long serialVersionUID = 0L;
                            private final ObjectRef className$1;

                            public final boolean apply(Tuple2<ClassFile, URL> e) {
                                Tuple2<ClassFile, URL> tuple2 = e;
                                if (tuple2 != null) {
                                    ClassFile cf;
                                    ClassFile classFile;
                                    ClassFile cf2 = classFile = (cf = (ClassFile)tuple2._1());
                                    String string = cf2.thisType();
                                    String string2 = (String)this.className$1.elem;
                                    return !(string != null ? !string.equals(string2) : string2 != null);
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                this.className$1 = className$1;
                            }
                        });
                        option = classFileOption;
                        if (None$.MODULE$.equals(option)) {
                            List allClassNames = ((TraversableOnce)classFiles.map((Function1)new Serializable(className){
                                public static final long serialVersionUID = 0L;
                                private final ObjectRef className$1;

                                public final Tuple2<Object, String> apply(Tuple2<ClassFile, URL> cf) {
                                    return new Tuple2((Object)BoxesRunTime.boxToInteger((int)StringUtils.getLevenshteinDistance((CharSequence)((String)this.className$1.elem), (CharSequence)((ClassFile)cf._1()).thisType())), (Object)((ClassFile)cf._1()).thisType());
                                }
                                {
                                    this.className$1 = className$1;
                                }
                            }, Traversable$.MODULE$.canBuildFrom())).toList();
                            List mostRelated = ((List)((List)allClassNames.sortWith((Function2)new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(Tuple2<Object, String> l, Tuple2<Object, String> r) {
                                    return l._1$mcI$sp() < r._1$mcI$sp();
                                }
                            })).map((Function1)new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final String apply(Tuple2<Object, String> x$1) {
                                    return (String)x$1._2();
                                }
                            }, List$.MODULE$.canBuildFrom())).take(15);
                            String ending = mostRelated.length() > 15 ? ", ...)" : ")";
                            String messageHeader = new StringBuilder().append((Object)"can't find: ").append((Object)((String)className.elem)).toString();
                            String message = mostRelated.mkString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " (similar: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{messageHeader})), ", ", ending);
                            throw this.handleError(message);
                        }
                        if (!(option instanceof Some) || (tuple2 = (Tuple2)(some = (Some)option).x()) == null) break block30;
                        ClassFile classFile2 = classFile = (cf = (ClassFile)tuple2._1());
                        None$ htmlCSS = noDefaultCSS ? None$.MODULE$ : new Some((Object)ClassFile$.MODULE$.TheCSS());
                        xHTML = classFile2.toXHTML((Option<String>)htmlCSS, (Option<String>)css, (Option<String>)js).toString();
                        none$ = targetFile;
                        if (!(none$ instanceof Some)) break block31;
                        Some some2 = (Some)none$;
                        File f = (File)some2.x();
                        Files.write(f.toPath(), xHTML.toString().getBytes("UTF-8"), new OpenOption[0]);
                        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"wrote: ").append((Object)f).toString());
                        if (openHTMLFile) {
                            package$.MODULE$.open(f);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit3 = boxedUnit;
                        break block32;
                    }
                    if (!None$.MODULE$.equals(none$)) break block33;
                    Console$.MODULE$.out().println(xHTML);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                return;
            }
            throw new MatchError((Object)none$);
        }
        throw new MatchError((Object)option);
    }

    private final String readNextArg$1(String[] args$1, IntRef i$1) {
        ++i$1.elem;
        if (i$1.elem < args$1.length) {
            return args$1[i$1.elem];
        }
        throw this.handleError(Predef$.MODULE$.refArrayOps((Object[])args$1).mkString("missing argument: ", " ", ""));
    }

    private Disassembler$() {
        MODULE$ = this;
        OPALLogger$.MODULE$.updateLogger((LogContext)GlobalLogContext$.MODULE$, (OPALLogger)new ConsoleOPALLogger(true, (Level)Error$.MODULE$));
    }
}

