/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.da;

import java.io.File;
import java.net.URL;
import org.opalj.da.ClassFile;
import org.opalj.da.ClassFileReader$;
import org.opalj.io.OpeningFileFailedException;
import org.opalj.log.GlobalLogContext$;
import org.opalj.log.LogContext;
import org.opalj.log.OPALLogger$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.sys.package$;

public final class Disassembler$ {
    public static final Disassembler$ MODULE$;
    private final GlobalLogContext$ logContext;
    private final String Usage;

    static {
        new Disassembler$();
    }

    public GlobalLogContext$ logContext() {
        return this.logContext;
    }

    private final String Usage() {
        return "Usage: java \u2026Disassembler \n(1) <JAR file containing class files> [<path to .class file in the JAR file>+]\n(2) <class file>\nExample:\n\tjava \u2026Disassembler /Library/jre/lib/rt.jar java/util/ArrayList.class";
    }

    public void process(String jarName, String classFileName) {
        String fileName = classFileName.endsWith(".class") ? classFileName : new StringBuilder().append((Object)classFileName.replace('.', '/')).append((Object)".class").toString();
        ClassFile classFile = (ClassFile)ClassFileReader$.MODULE$.ClassFile(jarName, fileName).head();
        this.processClassFile(classFile);
    }

    public void processClassFile(ClassFile classFile) {
        Throwable throwable2;
        block2: {
            try {
                String prefix = classFile.thisType().replace('.', '/');
                File file = org.opalj.io.package$.MODULE$.writeAndOpen(classFile.toXHTML(classFile.toXHTML$default$1()).toString(), prefix, ".html");
                OPALLogger$.MODULE$.info("progress", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"generated the HTML documentation ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file})), (LogContext)this.logContext());
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                if (!(throwable3 instanceof OpeningFileFailedException)) break block2;
                OpeningFileFailedException openingFileFailedException = (OpeningFileFailedException)throwable3;
                File file = openingFileFailedException.file();
                Throwable cause = openingFileFailedException.cause();
                String message = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Opening the html file ", " failed: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file, cause.getMessage()}));
                OPALLogger$.MODULE$.error("setup", message, (LogContext)this.logContext());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw throwable2;
    }

    public void main(String[] args) {
        if (args.length < 1) {
            Predef$.MODULE$.println((Object)"Usage: java \u2026Disassembler \n(1) <JAR file containing class files> [<path to .class file in the JAR file>+]\n(2) <class file>\nExample:\n\tjava \u2026Disassembler /Library/jre/lib/rt.jar java/util/ArrayList.class");
            throw package$.MODULE$.exit(-1);
        }
        String jarName = args[0];
        File jarFile = new File(jarName);
        if (args.length == 1) {
            List<Tuple2<Object, URL>> classFiles = ClassFileReader$.MODULE$.ClassFiles(jarFile, ClassFileReader$.MODULE$.ClassFiles$default$2());
            if (classFiles.isEmpty()) {
                if (jarFile.exists()) {
                    OPALLogger$.MODULE$.error("setup", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"no classfiles found in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{args[0]})), (LogContext)this.logContext());
                } else {
                    OPALLogger$.MODULE$.error("setup", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"the specified file does not exist ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{args[0]})), (LogContext)this.logContext());
                }
            } else {
                classFiles.foreach((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final void apply(Tuple2<ClassFile, URL> cfi) {
                        Disassembler$.MODULE$.processClassFile((ClassFile)cfi._1());
                    }
                });
            }
        } else {
            String[] classFileNames = (String[])Predef$.MODULE$.refArrayOps((Object[])args).drop(1);
            Predef$.MODULE$.refArrayOps((Object[])classFileNames).foreach((Function1)new Serializable(jarName){
                public static final long serialVersionUID = 0L;
                private final String jarName$1;

                public final void apply(String classFileName) {
                    Disassembler$.MODULE$.process(this.jarName$1, classFileName);
                }
                {
                    this.jarName$1 = jarName$1;
                }
            });
        }
    }

    private Disassembler$() {
        MODULE$ = this;
        this.logContext = GlobalLogContext$.MODULE$;
    }
}

