/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.bugpicker.core.analyses;

import org.opalj.br.ClassFile;
import org.opalj.br.Code;
import org.opalj.br.Method;
import org.opalj.br.MethodDescriptor;
import org.opalj.br.MethodDescriptor$;
import org.opalj.br.MethodWithBody$;
import org.opalj.br.ObjectType;
import org.opalj.br.ObjectType$;
import org.opalj.br.ReferenceType;
import org.opalj.br.analyses.Project;
import org.opalj.br.instructions.INVOKESTATIC;
import org.opalj.br.instructions.INVOKEVIRTUAL;
import org.opalj.br.instructions.Instruction;
import org.opalj.bugpicker.core.analyses.ManualGarbageCollection$;
import org.opalj.collection.immutable.Chain;
import org.opalj.collection.immutable.Chain$;
import org.opalj.issues.InstructionLocation;
import org.opalj.issues.InstructionLocation$;
import org.opalj.issues.Issue;
import org.opalj.issues.Issue$;
import org.opalj.issues.Relevance$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IndexedSeq$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class ManualGarbageCollection$ {
    public static final ManualGarbageCollection$ MODULE$;
    private final ObjectType Runtime;

    static {
        new ManualGarbageCollection$();
    }

    public final ObjectType Runtime() {
        return this.Runtime;
    }

    public String description() {
        return "Reports methods outside of java.lang that explicitly invoke the garbage collector.";
    }

    public Iterable<Issue> apply(Project<?> theProject, ClassFile classFile) {
        if (classFile.thisType().fqn().startsWith("java/lang")) {
            return (Iterable)Seq$.MODULE$.empty();
        }
        return (Iterable)classFile.methods().withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Method check$ifrefutable$1) {
                Method method = check$ifrefutable$1;
                Option option = MethodWithBody$.MODULE$.unapply(method);
                boolean bl = !option.isEmpty();
                return bl;
            }
        }).flatMap((Function1)new Serializable(theProject){
            public static final long serialVersionUID = 0L;
            public final Project theProject$1;

            public final Chain<Issue> apply(Method x$2) {
                Method method = x$2;
                Option option = MethodWithBody$.MODULE$.unapply(method);
                if (option.isEmpty()) {
                    throw new MatchError((Object)method);
                }
                Code body = (Code)option.get();
                Chain chain = (Chain)body.collectWithIndex((PartialFunction)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    /*
                     * Enabled aggressive block sorting
                     */
                    public final <A1 extends Tuple2<Object, Instruction>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x1;
                        if (A1 != null) {
                            int pc = A1._1$mcI$sp();
                            Instruction instruction = (Instruction)A1._2();
                            if (instruction instanceof INVOKESTATIC) {
                                INVOKESTATIC iNVOKESTATIC = (INVOKESTATIC)instruction;
                                ObjectType objectType = iNVOKESTATIC.declaringClass();
                                boolean bl = iNVOKESTATIC.isInterface();
                                String string = iNVOKESTATIC.name();
                                MethodDescriptor methodDescriptor = iNVOKESTATIC.methodDescriptor();
                                ObjectType objectType2 = ObjectType$.MODULE$.System();
                                ObjectType objectType3 = objectType;
                                if (!(objectType2 != null ? !objectType2.equals(objectType3) : objectType3 != null)) {
                                    if (!bl && "gc".equals(string)) {
                                        MethodDescriptor methodDescriptor2 = MethodDescriptor$.MODULE$.NoArgsAndReturnVoid();
                                        MethodDescriptor methodDescriptor3 = methodDescriptor;
                                        if (!(methodDescriptor2 != null ? !methodDescriptor2.equals(methodDescriptor3) : methodDescriptor3 != null)) {
                                            object = new Tuple2((Object)BoxesRunTime.boxToInteger((int)pc), (Object)"System.gc()");
                                            return (B1)object;
                                        }
                                    }
                                }
                            }
                        }
                        if (A1 != null) {
                            int pc = A1._1$mcI$sp();
                            Instruction instruction = (Instruction)A1._2();
                            if (instruction instanceof INVOKEVIRTUAL) {
                                INVOKEVIRTUAL iNVOKEVIRTUAL = (INVOKEVIRTUAL)instruction;
                                ReferenceType referenceType = iNVOKEVIRTUAL.declaringClass();
                                String string = iNVOKEVIRTUAL.name();
                                MethodDescriptor methodDescriptor = iNVOKEVIRTUAL.methodDescriptor();
                                ObjectType objectType = ManualGarbageCollection$.MODULE$.Runtime();
                                ReferenceType referenceType2 = referenceType;
                                if (!(objectType != null ? !objectType.equals(referenceType2) : referenceType2 != null) && "gc".equals(string)) {
                                    MethodDescriptor methodDescriptor4 = MethodDescriptor$.MODULE$.NoArgsAndReturnVoid();
                                    MethodDescriptor methodDescriptor5 = methodDescriptor;
                                    if (!(methodDescriptor4 != null ? !methodDescriptor4.equals(methodDescriptor5) : methodDescriptor5 != null)) {
                                        object = new Tuple2((Object)BoxesRunTime.boxToInteger((int)pc), (Object)"Runtime.gc()");
                                        return (B1)object;
                                    }
                                }
                            }
                        }
                        object = function1.apply(x1);
                        return (B1)object;
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean isDefinedAt(Tuple2<Object, Instruction> x1) {
                        Instruction instruction;
                        Tuple2<Object, Instruction> tuple2 = x1;
                        if (tuple2 != null && (instruction = (Instruction)tuple2._2()) instanceof INVOKESTATIC) {
                            INVOKESTATIC iNVOKESTATIC = (INVOKESTATIC)instruction;
                            ObjectType objectType = iNVOKESTATIC.declaringClass();
                            boolean bl = iNVOKESTATIC.isInterface();
                            String string = iNVOKESTATIC.name();
                            MethodDescriptor methodDescriptor = iNVOKESTATIC.methodDescriptor();
                            ObjectType objectType2 = ObjectType$.MODULE$.System();
                            ObjectType objectType3 = objectType;
                            if (!(objectType2 != null ? !objectType2.equals(objectType3) : objectType3 != null)) {
                                if (!bl && "gc".equals(string)) {
                                    MethodDescriptor methodDescriptor2 = MethodDescriptor$.MODULE$.NoArgsAndReturnVoid();
                                    MethodDescriptor methodDescriptor3 = methodDescriptor;
                                    if (methodDescriptor2 == null) {
                                        if (methodDescriptor3 == null) return true;
                                    } else if (methodDescriptor2.equals(methodDescriptor3)) {
                                        return true;
                                    }
                                }
                            }
                        }
                        if (tuple2 == null) return false;
                        Instruction instruction2 = (Instruction)tuple2._2();
                        if (!(instruction2 instanceof INVOKEVIRTUAL)) return false;
                        INVOKEVIRTUAL iNVOKEVIRTUAL = (INVOKEVIRTUAL)instruction2;
                        ReferenceType referenceType = iNVOKEVIRTUAL.declaringClass();
                        String string = iNVOKEVIRTUAL.name();
                        MethodDescriptor methodDescriptor = iNVOKEVIRTUAL.methodDescriptor();
                        ObjectType objectType = ManualGarbageCollection$.MODULE$.Runtime();
                        ReferenceType referenceType2 = referenceType;
                        if (objectType == null) {
                            if (referenceType2 != null) {
                                return false;
                            }
                        } else if (!objectType.equals(referenceType2)) return false;
                        if (!"gc".equals(string)) return false;
                        MethodDescriptor methodDescriptor4 = MethodDescriptor$.MODULE$.NoArgsAndReturnVoid();
                        MethodDescriptor methodDescriptor5 = methodDescriptor;
                        if (methodDescriptor4 == null) {
                            if (methodDescriptor5 == null) return true;
                            return false;
                        } else {
                            if (!methodDescriptor4.equals(methodDescriptor5)) return false;
                            return true;
                        }
                    }
                }, ClassTag$.MODULE$.apply(Tuple2.class)).withFilter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<Object, String> check$ifrefutable$2) {
                        Tuple2<Object, String> tuple2 = check$ifrefutable$2;
                        boolean bl = tuple2 != null;
                        return bl;
                    }
                }).map((Function1)new Serializable(this, method){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.apply.3 $outer;
                    private final Method x1$1;

                    public final Issue apply(Tuple2<Object, String> x$1) {
                        Tuple2<Object, String> tuple2 = x$1;
                        if (tuple2 != null) {
                            int pc = tuple2._1$mcI$sp();
                            String gcCall = (String)tuple2._2();
                            Issue issue = new Issue("ManualGarbageCollection", Relevance$.MODULE$.Low(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"contains dubious call to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{gcCall})), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"performance"})), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dubious method call"})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InstructionLocation[]{new InstructionLocation((Option)None$.MODULE$, this.$outer.theProject$1, this.x1$1, pc, InstructionLocation$.MODULE$.$lessinit$greater$default$5())})), Issue$.MODULE$.apply$default$7());
                            return issue;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.x1$1 = x1$1;
                    }
                }, Chain$.MODULE$.canBuildFrom());
                return chain;
            }
            {
                this.theProject$1 = theProject$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    private ManualGarbageCollection$() {
        MODULE$ = this;
        this.Runtime = ObjectType$.MODULE$.apply("java/lang/Runtime");
    }
}

