/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.bugpicker.core.analyses;

import org.opalj.Result;
import org.opalj.Success;
import org.opalj.br.BooleanType$;
import org.opalj.br.ClassFile;
import org.opalj.br.FieldType;
import org.opalj.br.IntegerType$;
import org.opalj.br.JVMMethod;
import org.opalj.br.Method;
import org.opalj.br.Method$;
import org.opalj.br.MethodDescriptor;
import org.opalj.br.MethodDescriptor$;
import org.opalj.br.ObjectType;
import org.opalj.br.ObjectType$;
import org.opalj.br.Type;
import org.opalj.br.analyses.Project;
import org.opalj.issues.ClassLocation;
import org.opalj.issues.ClassLocation$;
import org.opalj.issues.Issue;
import org.opalj.issues.Issue$;
import org.opalj.issues.Relevance$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.package$;

public final class CovariantEquals$ {
    public static final CovariantEquals$ MODULE$;

    static {
        new CovariantEquals$();
    }

    public String description() {
        return "Reports classes with one (or more) equals() methods but without equals(Object).";
    }

    private boolean hasEqualsButNotEqualsObject(ClassFile classFile) {
        IndexedSeq paramTypes = (IndexedSeq)classFile.methods().collect((PartialFunction)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Method, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                Option option = Method$.MODULE$.unapply(A1);
                if (!option.isEmpty()) {
                    Option option2;
                    String string = (String)((Tuple3)option.get())._2();
                    MethodDescriptor methodDescriptor = (MethodDescriptor)((Tuple3)option.get())._3();
                    if ("equals".equals(string) && !(option2 = MethodDescriptor$.MODULE$.unapply(methodDescriptor)).isEmpty()) {
                        Seq seq = (Seq)((Tuple2)option2.get())._1();
                        Type type = (Type)((Tuple2)option2.get())._2();
                        Some some = Seq$.MODULE$.unapplySeq(seq);
                        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0) {
                            FieldType paramType = (FieldType)((SeqLike)some.get()).apply(0);
                            if (BooleanType$.MODULE$.equals(type)) {
                                object = paramType;
                                return (B1)object;
                            }
                        }
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Method x1) {
                Method method = x1;
                Option option = Method$.MODULE$.unapply((JVMMethod)method);
                if (option.isEmpty()) return false;
                String string = (String)((Tuple3)option.get())._2();
                MethodDescriptor methodDescriptor = (MethodDescriptor)((Tuple3)option.get())._3();
                if (!"equals".equals(string)) return false;
                Option option2 = MethodDescriptor$.MODULE$.unapply(methodDescriptor);
                if (option2.isEmpty()) return false;
                Seq seq = (Seq)((Tuple2)option2.get())._1();
                Type type = (Type)((Tuple2)option2.get())._2();
                Some some = Seq$.MODULE$.unapplySeq(seq);
                if (some.isEmpty()) return false;
                if (some.get() == null) return false;
                if (((SeqLike)some.get()).lengthCompare(1) != 0) return false;
                if (!BooleanType$.MODULE$.equals(type)) return false;
                return true;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        return paramTypes.size() > 0 && !paramTypes.exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(FieldType x$1) {
                FieldType fieldType = x$1;
                ObjectType objectType = ObjectType$.MODULE$.Object();
                return !(fieldType != null ? !fieldType.equals(objectType) : objectType != null);
            }
        });
    }

    private boolean hasHashCode(ClassFile classFile) {
        return classFile.methods().exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(Method x0$1) {
                Method method = x0$1;
                Option option = Method$.MODULE$.unapply((JVMMethod)method);
                if (option.isEmpty()) return false;
                String string = (String)((Tuple3)option.get())._2();
                MethodDescriptor methodDescriptor = (MethodDescriptor)((Tuple3)option.get())._3();
                if (!"hashCode".equals(string)) return false;
                Option option2 = MethodDescriptor$.MODULE$.unapply(methodDescriptor);
                if (option2.isEmpty()) return false;
                Seq seq = (Seq)((Tuple2)option2.get())._1();
                Type type = (Type)((Tuple2)option2.get())._2();
                Some some = Seq$.MODULE$.unapplySeq(seq);
                if (some.isEmpty()) return false;
                if (some.get() == null) return false;
                if (((SeqLike)some.get()).lengthCompare(0) != 0) return false;
                if (!IntegerType$.MODULE$.equals(type)) return false;
                return true;
            }
        });
    }

    private boolean superClassHasCustomHashCode(ClassFile classFile, Project<?> project) {
        Success success;
        Method m;
        if (classFile.thisType() == ObjectType$.MODULE$.Object()) {
            return false;
        }
        ObjectType superclassType = (ObjectType)classFile.superclassType().get();
        if (superclassType == ObjectType$.MODULE$.Object()) {
            return false;
        }
        Result result = project.resolveClassMethodReference(superclassType, "hashCode", MethodDescriptor$.MODULE$.JustReturnsInteger());
        boolean bl = result instanceof Success ? (m = (Method)(success = (Success)result).value()).classFile().thisType() != ObjectType$.MODULE$.Object() : false;
        return bl;
    }

    public Iterable<Issue> apply(ClassFile classFile, Project<?> project) {
        Nil$ nil$;
        if (classFile.isInterfaceDeclaration()) {
            return (Iterable)package$.MODULE$.Iterable().empty();
        }
        if (this.hasEqualsButNotEqualsObject(classFile)) {
            int n;
            String message = "missing equals(Object) to override Object.equals(Object)";
            if (this.hasHashCode(classFile)) {
                message = new StringBuilder().append((Object)message).append((Object)" (the class overrides the standard hashCode method)").toString();
                n = Relevance$.MODULE$.VeryHigh();
            } else if (this.superClassHasCustomHashCode(classFile, project)) {
                message = new StringBuilder().append((Object)message).append((Object)" (a superclass overrides the standard hashCode method)").toString();
                n = Relevance$.MODULE$.High();
            } else {
                n = Relevance$.MODULE$.Low();
            }
            int relevance = n;
            nil$ = (Iterable)package$.MODULE$.Iterable().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Issue[]{new Issue("CovariantEquals", relevance, message, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"correctness"})), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dubious method definition"})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ClassLocation[]{new ClassLocation((Option)None$.MODULE$, project, classFile, ClassLocation$.MODULE$.$lessinit$greater$default$4())})), Issue$.MODULE$.apply$default$7())}));
        } else {
            nil$ = Nil$.MODULE$;
        }
        return nil$;
    }

    private CovariantEquals$() {
        MODULE$ = this;
    }
}

