/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.bugpicker.core.analyses;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigRenderOptions;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import net.ceedubs.ficus.Ficus$;
import org.opalj.ai.AIResult;
import org.opalj.ai.BoundedInterruptableAI;
import org.opalj.ai.BoundedInterruptableAI$;
import org.opalj.ai.Domain;
import org.opalj.ai.InterpretationFailedException;
import org.opalj.ai.ValuesDomain;
import org.opalj.ai.analyses.FieldValuesKey$;
import org.opalj.ai.analyses.MethodReturnValuesKey$;
import org.opalj.ai.analyses.cg.CallGraph;
import org.opalj.ai.analyses.cg.CallGraphCache;
import org.opalj.ai.analyses.cg.ComputedCallGraph;
import org.opalj.ai.analyses.cg.VTACallGraphKey$;
import org.opalj.ai.common.XHTML$;
import org.opalj.br.ClassFile;
import org.opalj.br.Code;
import org.opalj.br.Field;
import org.opalj.br.Method;
import org.opalj.br.MethodSignature;
import org.opalj.br.MethodWithBody$;
import org.opalj.br.analyses.Analysis;
import org.opalj.br.analyses.AnalysisException;
import org.opalj.br.analyses.FieldAccessInformation;
import org.opalj.br.analyses.FieldAccessInformationKey$;
import org.opalj.br.analyses.InstantiableClasses;
import org.opalj.br.analyses.InstantiableClassesKey$;
import org.opalj.br.analyses.ProgressManagement;
import org.opalj.br.analyses.Project;
import org.opalj.br.analyses.ProjectInformationKey;
import org.opalj.br.analyses.PropertyStoreKey$;
import org.opalj.br.analyses.StringConstantsInformationKey$;
import org.opalj.bugpicker.core.analyses.AnonymousInnerClassShouldBeStatic$;
import org.opalj.bugpicker.core.analyses.BugPickerAnalysis$;
import org.opalj.bugpicker.core.analyses.BugPickerAnalysis$$anonfun$7$;
import org.opalj.bugpicker.core.analyses.CollectionsUsage$;
import org.opalj.bugpicker.core.analyses.CovariantEquals$;
import org.opalj.bugpicker.core.analyses.DeadEdgesAnalysis$;
import org.opalj.bugpicker.core.analyses.FallbackBugPickerAnalysisDomain;
import org.opalj.bugpicker.core.analyses.GuardedAndUnguardedAccessAnalysis$;
import org.opalj.bugpicker.core.analyses.ManualGarbageCollection$;
import org.opalj.bugpicker.core.analyses.RootBugPickerAnalysisDomain;
import org.opalj.bugpicker.core.analyses.RootBugPickerAnalysisDomain$;
import org.opalj.bugpicker.core.analyses.ThrowsExceptionAnalysis$;
import org.opalj.bugpicker.core.analyses.UnusedFields$;
import org.opalj.bugpicker.core.analyses.UnusedLocalVariables$;
import org.opalj.bugpicker.core.analyses.UnusedMethodsAnalysis$;
import org.opalj.bugpicker.core.analyses.UselessComputationsAnalysis$;
import org.opalj.bugpicker.core.analyses.UselessReComputationsAnalysis$;
import org.opalj.collection.immutable.ConstArray;
import org.opalj.fpcf.FPCFAnalysesManager;
import org.opalj.fpcf.FPCFAnalysesManagerKey$;
import org.opalj.fpcf.FPCFAnalysesRegistry$;
import org.opalj.fpcf.FPCFAnalysisRunner;
import org.opalj.fpcf.PropertyStore;
import org.opalj.io.package$;
import org.opalj.issues.Issue;
import org.opalj.issues.IssueLocation;
import org.opalj.issues.PackageLocation;
import org.opalj.log.LogContext;
import org.opalj.log.OPALLogger$;
import org.opalj.util.Nanoseconds;
import org.opalj.util.Nanoseconds$;
import org.opalj.util.PerformanceEvaluation$;
import org.opalj.util.Seconds;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.util.control.ControlThrowable;
import scala.util.matching.Regex;
import scala.xml.Node;

@ScalaSignature(bytes="\u0006\u0001\u0005Uf\u0001B\u0001\u0003\u00015\u0011\u0011CQ;h!&\u001c7.\u001a:B]\u0006d\u0017p]5t\u0015\t\u0019A!\u0001\u0005b]\u0006d\u0017p]3t\u0015\t)a!\u0001\u0003d_J,'BA\u0004\t\u0003%\u0011Wo\u001a9jG.,'O\u0003\u0002\n\u0015\u0005)q\u000e]1mU*\t1\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u001dQ\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007\u0003B\u000b\u001a7\rj\u0011A\u0006\u0006\u0003\u0007]Q!\u0001\u0007\u0005\u0002\u0005\t\u0014\u0018B\u0001\u000e\u0017\u0005!\te.\u00197zg&\u001c\bC\u0001\u000f\"\u001b\u0005i\"B\u0001\u0010 \u0003\rqW\r\u001e\u0006\u0002A\u0005!!.\u0019<b\u0013\t\u0011SDA\u0002V%2\u0003\"\u0001\n\u0015\u000f\u0005\u00152S\"\u0001\u0002\n\u0005\u001d\u0012\u0011a\u00029bG.\fw-Z\u0005\u0003S)\u0012\u0001CQ;h!&\u001c7.\u001a:SKN,H\u000e^:\u000b\u0005\u001d\u0012\u0001\"\u0002\u0017\u0001\t\u0003i\u0013A\u0002\u001fj]&$h\bF\u0001/!\t)\u0003\u0001C\u00031\u0001\u0011\u0005\u0013'A\u0003uSRdW-F\u00013!\t\u0019dG\u0004\u0002\u0010i%\u0011Q\u0007E\u0001\u0007!J,G-\u001a4\n\u0005]B$AB*ue&twM\u0003\u00026!!)!\b\u0001C!c\u0005YA-Z:de&\u0004H/[8o\u0011\u0015a\u0004\u0001\"\u0011>\u0003\u001d\tg.\u00197zu\u0016$Ba\t D!\")qh\u000fa\u0001\u0001\u0006QA\u000f[3Qe>TWm\u0019;\u0011\u0007U\t5$\u0003\u0002C-\t9\u0001K]8kK\u000e$\bb\u0002#<!\u0003\u0005\r!R\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001c\bc\u0001$Ne9\u0011q\t\u0014\b\u0003\u0011.k\u0011!\u0013\u0006\u0003\u00152\ta\u0001\u0010:p_Rt\u0014\"A\t\n\u0005\u001d\u0002\u0012B\u0001(P\u0005\r\u0019V-\u001d\u0006\u0003OAAQ!U\u001eA\u0002I\u000ba#\u001b8jiB\u0013xn\u001a:fgNl\u0015M\\1hK6,g\u000e\u001e\t\u0005\u001fM+\u0006,\u0003\u0002U!\tIa)\u001e8di&|g.\r\t\u0003\u001fYK!a\u0016\t\u0003\u0007%sG\u000f\u0005\u0002\u00163&\u0011!L\u0006\u0002\u0013!J|wM]3tg6\u000bg.Y4f[\u0016tGoB\u0003]\u0005!\u0005Q,A\tCk\u001e\u0004\u0016nY6fe\u0006s\u0017\r\\=tSN\u0004\"!\n0\u0007\u000b\u0005\u0011\u0001\u0012A0\u0014\u0005ys\u0001\"\u0002\u0017_\t\u0003\tG#A/\t\u000f\rt&\u0019!C\u0003I\u0006\u0001\u0002K]3B]\u0006d\u0017p]3t\u0007>,h\u000e^\u000b\u0002K>\ta-H\u0001\b\u0011\u0019Ag\f)A\u0007K\u0006\t\u0002K]3B]\u0006d\u0017p]3t\u0007>,h\u000e\u001e\u0011\t\u000f)t&\u0019!C\u0003W\u0006!R*\u0019=Fm\u0006dg)Y2u_J\u0004\u0016\r\u001e;fe:,\u0012\u0001\u001c\t\u0003[Jl\u0011A\u001c\u0006\u0003_B\f\u0001\"\\1uG\"Lgn\u001a\u0006\u0003cB\tA!\u001e;jY&\u00111O\u001c\u0002\u0006%\u0016<W\r\u001f\u0005\u0007kz\u0003\u000bQ\u00027\u0002+5\u000b\u00070\u0012<bY\u001a\u000b7\r^8s!\u0006$H/\u001a:oA!9qO\u0018b\u0001\n\u000bA\u0018\u0001\u0006#fM\u0006,H\u000e^'bq\u00163\u0018\r\u001c$bGR|'/F\u0001z\u001f\u0005Q\b\u0005C }\u0002\u0001\u0001\u0001\u0001\u0001\u0001\t\rqt\u0006\u0015!\u0004z\u0003U!UMZ1vYRl\u0015\r_#wC24\u0015m\u0019;pe\u0002BqA 0C\u0002\u0013\u00151.\u0001\nNCb,e/\u00197US6,\u0007+\u0019;uKJt\u0007bBA\u0001=\u0002\u0006i\u0001\\\u0001\u0014\u001b\u0006DXI^1m)&lW\rU1ui\u0016\u0014h\u000e\t\u0005\n\u0003\u000bq&\u0019!C\u0003\u0003\u000f\t!\u0003R3gCVdG/T1y\u000bZ\fG\u000eV5nKV\u0011\u0011\u0011\u0002\t\u0005\u0003\u0017\ty!\u0004\u0002\u0002\u000e)\u0011\u0011\u000fC\u0005\u0005\u0003#\tiA\u0001\u0007NS2d\u0017n]3d_:$7\u000f\u0003\u0005\u0002\u0016y\u0003\u000bQBA\u0005\u0003M!UMZ1vYRl\u0015\r_#wC2$\u0016.\\3!\u0011!\tIB\u0018b\u0001\n\u000bY\u0017!G'bq\u000e\u000bG\u000e\\\"iC&tG*\u001a8hi\"\u0004\u0016\r\u001e;fe:Dq!!\b_A\u00035A.\u0001\u000eNCb\u001c\u0015\r\u001c7DQ\u0006Lg\u000eT3oORD\u0007+\u0019;uKJt\u0007\u0005C\u0005\u0002\"y\u0013\r\u0011\"\u0002\u0002$\u0005IB)\u001a4bk2$X*\u0019=DC2d7\t[1j]2+gn\u001a;i+\t\t)c\u0004\u0002\u0002(u\t\u0011\u0001\u0003\u0005\u0002,y\u0003\u000bQBA\u0013\u0003i!UMZ1vYRl\u0015\r_\"bY2\u001c\u0005.Y5o\u0019\u0016tw\r\u001e5!\u0011!\tyC\u0018b\u0001\n\u000bY\u0017\u0001J'bq\u000e\u000b'\u000fZ5oC2LG/_(g\u0013:$XmZ3s%\u0006tw-Z:QCR$XM\u001d8\t\u000f\u0005Mb\f)A\u0007Y\u0006)S*\u0019=DCJ$\u0017N\\1mSRLxJZ%oi\u0016<WM\u001d*b]\u001e,7\u000fU1ui\u0016\u0014h\u000e\t\u0005\n\u0003oq&\u0019!C\u0003\u0003s\tA\u0005R3gCVdG/T1y\u0007\u0006\u0014H-\u001b8bY&$\u0018p\u00144J]R,w-\u001a:SC:<Wm]\u000b\u0003\u0003wy!!!\u0010\u001f\u0003AA\u0001\"!\u0011_A\u00035\u00111H\u0001&\t\u00164\u0017-\u001e7u\u001b\u0006D8)\u0019:eS:\fG.\u001b;z\u001f\u001aLe\u000e^3hKJ\u0014\u0016M\\4fg\u0002B\u0001\"!\u0012_\u0005\u0004%)a[\u0001 \u001b\u0006D8)\u0019:eS:\fG.\u001b;z\u001f\u001aduN\\4TKR\u001c\b+\u0019;uKJt\u0007bBA%=\u0002\u0006i\u0001\\\u0001!\u001b\u0006D8)\u0019:eS:\fG.\u001b;z\u001f\u001aduN\\4TKR\u001c\b+\u0019;uKJt\u0007\u0005C\u0005\u0002Ny\u0013\r\u0011\"\u0002\u0002P\u0005yB)\u001a4bk2$X*\u0019=DCJ$\u0017N\\1mSRLxJ\u001a'p]\u001e\u001cV\r^:\u0016\u0005\u0005EsBAA*;\u0005\u0011\u0001\u0002CA,=\u0002\u0006i!!\u0015\u0002A\u0011+g-Y;mi6\u000b\u0007pQ1sI&t\u0017\r\\5us>3Gj\u001c8h'\u0016$8\u000f\t\u0005\t\u00037r&\u0019!C\u0003W\u00069b)\u001b=q_&tG/\u00118bYf\u001cXm\u001d)biR,'O\u001c\u0005\b\u0003?r\u0006\u0015!\u0004m\u0003a1\u0015\u000e\u001f9pS:$\u0018I\\1msN,7\u000fU1ui\u0016\u0014h\u000e\t\u0005\n\u0003Gr&\u0019!C\u0003\u0003K\nq\u0003R3gCVdGOR5ya>Lg\u000e^!oC2L8/Z:\u0016\u0005\u0005\u001d\u0004#BA5\u0003_\u0012TBAA6\u0015\r\ti\u0007E\u0001\u000bG>dG.Z2uS>t\u0017b\u0001(\u0002l!A\u00111\u000f0!\u0002\u001b\t9'\u0001\rEK\u001a\fW\u000f\u001c;GSb\u0004x.\u001b8u\u0003:\fG._:fg\u0002Bq!a\u001e_\t\u0003\tI(\u0001\bsKN,H\u000e^:BgbCE+\u0014'\u0015\u0015\u0005m\u0014qQAF\u0003C\u000bY\u000b\u0005\u0003\u0002~\u0005\rUBAA@\u0015\r\t\t\tE\u0001\u0004q6d\u0017\u0002BAC\u0003\u007f\u0012AAT8eK\"9\u0011\u0011RA;\u0001\u0004)\u0015AB2p]\u001aLw\r\u0003\u0005\u0002\u000e\u0006U\u0004\u0019AAH\u0003%!\b.Z%tgV,7\u000fE\u0003G\u0003#\u000b)*C\u0002\u0002\u0014>\u0013\u0001\"\u0013;fe\u0006\u0014G.\u001a\t\u0005\u0003/\u000bi*\u0004\u0002\u0002\u001a*\u0019\u00111\u0014\u0005\u0002\r%\u001c8/^3t\u0013\u0011\ty*!'\u0003\u000b%\u001b8/^3\t\u0011\u0005\r\u0016Q\u000fa\u0001\u0003K\u000b!b\u001d5poN+\u0017M]2i!\ry\u0011qU\u0005\u0004\u0003S\u0003\"a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003[\u000b)\b1\u0001\u00020\u0006a\u0011M\\1msNL7\u000fV5nKB!\u00111BAY\u0013\u0011\t\u0019,!\u0004\u0003\u00179\u000bgn\\:fG>tGm\u001d")
public class BugPickerAnalysis
implements Analysis<URL, Tuple3<Nanoseconds, Iterable<Issue>, Iterable<AnalysisException>>> {
    public static Node resultsAsXHTML(Seq<String> seq, Iterable<Issue> iterable, boolean bl, long l) {
        return BugPickerAnalysis$.MODULE$.resultsAsXHTML(seq, iterable, bl, l);
    }

    public static Seq<String> DefaultFixpointAnalyses() {
        return BugPickerAnalysis$.MODULE$.DefaultFixpointAnalyses();
    }

    public static Regex FixpointAnalysesPattern() {
        return BugPickerAnalysis$.MODULE$.FixpointAnalysesPattern();
    }

    public static int DefaultMaxCardinalityOfLongSets() {
        return BugPickerAnalysis$.MODULE$.DefaultMaxCardinalityOfLongSets();
    }

    public static Regex MaxCardinalityOfLongSetsPattern() {
        return BugPickerAnalysis$.MODULE$.MaxCardinalityOfLongSetsPattern();
    }

    public static long DefaultMaxCardinalityOfIntegerRanges() {
        return BugPickerAnalysis$.MODULE$.DefaultMaxCardinalityOfIntegerRanges();
    }

    public static Regex MaxCardinalityOfIntegerRangesPattern() {
        return BugPickerAnalysis$.MODULE$.MaxCardinalityOfIntegerRangesPattern();
    }

    public static int DefaultMaxCallChainLength() {
        return BugPickerAnalysis$.MODULE$.DefaultMaxCallChainLength();
    }

    public static Regex MaxCallChainLengthPattern() {
        return BugPickerAnalysis$.MODULE$.MaxCallChainLengthPattern();
    }

    public static long DefaultMaxEvalTime() {
        return BugPickerAnalysis$.MODULE$.DefaultMaxEvalTime();
    }

    public static Regex MaxEvalTimePattern() {
        return BugPickerAnalysis$.MODULE$.MaxEvalTimePattern();
    }

    public static double DefaultMaxEvalFactor() {
        return BugPickerAnalysis$.MODULE$.DefaultMaxEvalFactor();
    }

    public static Regex MaxEvalFactorPattern() {
        return BugPickerAnalysis$.MODULE$.MaxEvalFactorPattern();
    }

    public static int PreAnalysesCount() {
        return BugPickerAnalysis$.MODULE$.PreAnalysesCount();
    }

    public Option<String> documentationUrl() {
        return Analysis.class.documentationUrl((Analysis)this);
    }

    public String copyright() {
        return Analysis.class.copyright((Analysis)this);
    }

    public Seq<String> analyze$default$2() {
        return Analysis.class.analyze$default$2((Analysis)this);
    }

    public String title() {
        return "BugPicker";
    }

    public String description() {
        return "Finds code smells in Java (byte) code.";
    }

    public Tuple3<Nanoseconds, Iterable<Issue>, Iterable<AnalysisException>> analyze(Project<URL> theProject, Seq<String> parameters, Function1<Object, ProgressManagement> initProgressManagement) {
        Project<URL> project = theProject;
        LogContext logContext = theProject.logContext();
        int classFilesCount = theProject.projectClassFilesCount();
        ProgressManagement progressManagement = (ProgressManagement)initProgressManagement.apply((Object)BoxesRunTime.boxToInteger((int)(7 + classFilesCount)));
        Config analysisParameters = (Config)Ficus$.MODULE$.toFicusConfig(theProject.config()).as("org.opalj.bugpicker.analysisParameter", Ficus$.MODULE$.configValueReader());
        double maxEvalFactor = BoxesRunTime.unboxToDouble((Object)Ficus$.MODULE$.toFicusConfig(analysisParameters).as("maxEvalFactor", Ficus$.MODULE$.doubleValueReader()));
        long maxEvalTime = BoxesRunTime.unboxToLong((Object)Ficus$.MODULE$.toFicusConfig(analysisParameters).as("maxEvalTime", Ficus$.MODULE$.longValueReader()));
        long maxCardinalityOfIntegerRanges = BoxesRunTime.unboxToLong((Object)Ficus$.MODULE$.toFicusConfig(analysisParameters).as("maxCardinalityOfLongSets", Ficus$.MODULE$.longValueReader()));
        int maxCardinalityOfLongSets = BoxesRunTime.unboxToInt((Object)Ficus$.MODULE$.toFicusConfig(analysisParameters).as("maxCardinalityOfLongSets", Ficus$.MODULE$.intValueReader()));
        List configuredAnalyses = (List)Ficus$.MODULE$.toFicusConfig(analysisParameters).as("fpcfAnalyses", Ficus$.MODULE$.traversableReader(Ficus$.MODULE$.stringValueReader(), List$.MODULE$.canBuildFrom()));
        List fpcfAnalyses = (List)configuredAnalyses.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final FPCFAnalysisRunner apply(String a) {
                return FPCFAnalysesRegistry$.MODULE$.factory(a);
            }
        }, List$.MODULE$.canBuildFrom());
        int maxCallChainLength = BoxesRunTime.unboxToInt((Object)Ficus$.MODULE$.toFicusConfig(theProject.config()).as("org.opalj.bugpicker.analyses.RootBugPickerAnalysisDomain.maxCallChainLength", Ficus$.MODULE$.intValueReader()));
        boolean debug = parameters.contains((Object)"-debug");
        if (debug) {
            String cp = System.getProperty("java.class.path");
            String[] cpSorted = (String[])Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(cp)).split(File.pathSeparatorChar)).sorted((Ordering)Ordering.String$.MODULE$);
            ConfigRenderOptions renderingOptions = ConfigRenderOptions.defaults().setOriginComments(false).setComments(true).setJson(false);
            Config bugpickerConf = theProject.config().withOnlyPath("org.opalj");
            String settings = bugpickerConf.root().render(renderingOptions);
            OPALLogger$.MODULE$.info("configuration", new StringBuilder().append((Object)Predef$.MODULE$.refArrayOps((Object[])cpSorted).mkString("System ClassPath:\n\t", "\n\t", "\n")).append((Object)"\n").append((Object)"Settings:").append((Object)"\n").append((Object)settings).toString(), logContext);
        }
        progressManagement.step(1, "[Pre-Analysis] Identifying non-instantiable classes", (Function0)new Serializable(this, theProject){
            public static final long serialVersionUID = 0L;
            private final Project theProject$1;

            public final Tuple2<InstantiableClasses, None$> apply() {
                return new Tuple2(this.theProject$1.get((ProjectInformationKey)InstantiableClassesKey$.MODULE$), (Object)None$.MODULE$);
            }
            {
                this.theProject$1 = theProject$1;
            }
        });
        FieldAccessInformation fieldAccessInformation = (FieldAccessInformation)progressManagement.step(2, "[Pre-Analysis] Analyzing field accesses", (Function0)new Serializable(this, theProject){
            public static final long serialVersionUID = 0L;
            private final Project theProject$1;

            public final Tuple2<FieldAccessInformation, None$> apply() {
                return new Tuple2(this.theProject$1.get((ProjectInformationKey)FieldAccessInformationKey$.MODULE$), (Object)None$.MODULE$);
            }
            {
                this.theProject$1 = theProject$1;
            }
        });
        Map stringConstantsInformation = (Map)progressManagement.step(3, "[Pre-Analysis] Analyzing the usage of string constants", (Function0)new Serializable(this, theProject){
            public static final long serialVersionUID = 0L;
            private final Project theProject$1;

            public final Tuple2<Map<String, ConstArray<Tuple2<Method, Object>>>, None$> apply() {
                return new Tuple2(this.theProject$1.get((ProjectInformationKey)StringConstantsInformationKey$.MODULE$), (Object)None$.MODULE$);
            }
            {
                this.theProject$1 = theProject$1;
            }
        });
        progressManagement.step(4, "[Pre-Analysis] Analyzing field declarations to derive more precise field value information", (Function0)new Serializable(this, theProject){
            public static final long serialVersionUID = 0L;
            private final Project theProject$1;

            public final Tuple2<Map<Field, ValuesDomain.Value>, None$> apply() {
                return new Tuple2(this.theProject$1.get((ProjectInformationKey)FieldValuesKey$.MODULE$), (Object)None$.MODULE$);
            }
            {
                this.theProject$1 = theProject$1;
            }
        });
        progressManagement.step(5, "[Pre-Analysis] Analyzing methods to get more precise return type information", (Function0)new Serializable(this, theProject){
            public static final long serialVersionUID = 0L;
            private final Project theProject$1;

            public final Tuple2<Map<Method, Option<ValuesDomain.Value>>, None$> apply() {
                return new Tuple2(this.theProject$1.get((ProjectInformationKey)MethodReturnValuesKey$.MODULE$), (Object)None$.MODULE$);
            }
            {
                this.theProject$1 = theProject$1;
            }
        });
        ComputedCallGraph computedCallGraph = (ComputedCallGraph)progressManagement.step(6, "[Pre-Analysis] Creating the call graph", (Function0)new Serializable(this, theProject){
            public static final long serialVersionUID = 0L;
            private final Project theProject$1;

            public final Tuple2<ComputedCallGraph, None$> apply() {
                return new Tuple2(this.theProject$1.get((ProjectInformationKey)VTACallGraphKey$.MODULE$), (Object)None$.MODULE$);
            }
            {
                this.theProject$1 = theProject$1;
            }
        });
        CallGraph callGraph = computedCallGraph.callGraph();
        scala.collection.immutable.Set callGraphEntryPoints = ((TraversableOnce)computedCallGraph.entryPoints().apply()).toSet();
        FPCFAnalysesManager analysesManager = (FPCFAnalysesManager)theProject.get((ProjectInformationKey)FPCFAnalysesManagerKey$.MODULE$);
        PropertyStore propertyStore = (PropertyStore)theProject.get((ProjectInformationKey)PropertyStoreKey$.MODULE$);
        progressManagement.step(7, "[FPCF-Analysis] executing fixpoint analyses", (Function0)new Serializable(this, fpcfAnalyses, analysesManager, propertyStore){
            public static final long serialVersionUID = 0L;
            private final List fpcfAnalyses$1;
            public final FPCFAnalysesManager analysesManager$1;
            private final PropertyStore propertyStore$1;

            public final Tuple2<BoxedUnit, None$> apply() {
                this.fpcfAnalyses$1.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$analyze$4 $outer;

                    public final void apply(FPCFAnalysisRunner x$1) {
                        this.$outer.analysesManager$1.run(x$1, false);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.propertyStore$1.waitOnPropertyComputationCompletion(true, this.propertyStore$1.waitOnPropertyComputationCompletion$default$2());
                return new Tuple2((Object)BoxedUnit.UNIT, (Object)None$.MODULE$);
            }
            {
                this.fpcfAnalyses$1 = fpcfAnalyses$1;
                this.analysesManager$1 = analysesManager$1;
                this.propertyStore$1 = propertyStore$1;
            }
        });
        Serializable doInterrupt = new Serializable(this, progressManagement){
            public static final long serialVersionUID = 0L;
            private final ProgressManagement progressManagement$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.progressManagement$1.isInterrupted();
            }
            {
                this.progressManagement$1 = progressManagement$1;
            }
        };
        ConcurrentLinkedQueue filteredResults = new ConcurrentLinkedQueue();
        String issuesPackageFilterString = (String)Ficus$.MODULE$.toFicusConfig(theProject.config()).as("org.opalj.bugpicker.issues.packages", Ficus$.MODULE$.stringValueReader());
        Regex issuesPackageFilter = new StringOps(Predef$.MODULE$.augmentString(issuesPackageFilterString)).r();
        Map fieldValueInformation = (Map)theProject.get((ProjectInformationKey)FieldValuesKey$.MODULE$);
        Map methodReturnValueInformation = (Map)theProject.get((ProjectInformationKey)MethodReturnValuesKey$.MODULE$);
        CallGraphCache cache = new CallGraphCache(theProject);
        ConcurrentLinkedQueue exceptions = new ConcurrentLinkedQueue();
        LongRef analysisTime = LongRef.create((long)Nanoseconds$.MODULE$.None());
        Seq identifiedIssues = (Seq)PerformanceEvaluation$.MODULE$.time((Function0)new Serializable(this, theProject, project, logContext, progressManagement, maxEvalFactor, maxEvalTime, maxCardinalityOfIntegerRanges, maxCardinalityOfLongSets, maxCallChainLength, fieldAccessInformation, stringConstantsInformation, computedCallGraph, callGraph, callGraphEntryPoints, propertyStore, (Function0)doInterrupt, filteredResults, issuesPackageFilter, fieldValueInformation, methodReturnValueInformation, cache, exceptions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BugPickerAnalysis $outer;
            public final Project theProject$1;
            public final Project project$1;
            public final LogContext logContext$1;
            public final ProgressManagement progressManagement$1;
            public final double maxEvalFactor$1;
            public final long maxEvalTime$1;
            public final long maxCardinalityOfIntegerRanges$1;
            public final int maxCardinalityOfLongSets$1;
            public final int maxCallChainLength$1;
            public final FieldAccessInformation fieldAccessInformation$1;
            public final Map stringConstantsInformation$1;
            public final ComputedCallGraph computedCallGraph$1;
            public final CallGraph callGraph$1;
            public final scala.collection.immutable.Set callGraphEntryPoints$1;
            public final PropertyStore propertyStore$1;
            public final Function0 doInterrupt$1;
            public final ConcurrentLinkedQueue filteredResults$1;
            public final Regex issuesPackageFilter$1;
            public final Map fieldValueInformation$1;
            public final Map methodReturnValueInformation$1;
            public final CallGraphCache cache$1;
            public final ConcurrentLinkedQueue exceptions$1;

            public final Seq<Issue> apply() {
                AtomicInteger stepIds = new AtomicInteger(8);
                this.theProject$1.parForeachProjectClassFile(this.doInterrupt$1, (Function1)new Serializable(this, stepIds){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;
                    private final AtomicInteger stepIds$1;

                    /*
                     * WARNING - void declaration
                     */
                    public final void apply(ClassFile classFile) {
                        int stepId = this.stepIds$1.getAndIncrement();
                        try {
                            this.$outer.progressManagement$1.start(stepId, classFile.thisType().toJava());
                            this.$outer.org$opalj$bugpicker$core$analyses$BugPickerAnalysis$$anonfun$$$outer().org$opalj$bugpicker$core$analyses$BugPickerAnalysis$$addResults$1(AnonymousInnerClassShouldBeStatic$.MODULE$.apply(this.$outer.theProject$1, classFile), this.$outer.filteredResults$1, this.$outer.issuesPackageFilter$1);
                            this.$outer.org$opalj$bugpicker$core$analyses$BugPickerAnalysis$$anonfun$$$outer().org$opalj$bugpicker$core$analyses$BugPickerAnalysis$$addResults$1(ManualGarbageCollection$.MODULE$.apply(this.$outer.theProject$1, classFile), this.$outer.filteredResults$1, this.$outer.issuesPackageFilter$1);
                            this.$outer.org$opalj$bugpicker$core$analyses$BugPickerAnalysis$$anonfun$$$outer().org$opalj$bugpicker$core$analyses$BugPickerAnalysis$$addResults$1(CovariantEquals$.MODULE$.apply(classFile, this.$outer.project$1), this.$outer.filteredResults$1, this.$outer.issuesPackageFilter$1);
                            this.$outer.org$opalj$bugpicker$core$analyses$BugPickerAnalysis$$anonfun$$$outer().org$opalj$bugpicker$core$analyses$BugPickerAnalysis$$addResults$1((Iterable)UnusedFields$.MODULE$.apply(this.$outer.theProject$1, this.$outer.propertyStore$1, this.$outer.fieldAccessInformation$1, (Map<String, ConstArray<Tuple2<Method, Object>>>)this.$outer.stringConstantsInformation$1, classFile), this.$outer.filteredResults$1, this.$outer.issuesPackageFilter$1);
                            classFile.methods().withFilter((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(Method check$ifrefutable$1) {
                                    Method method = check$ifrefutable$1;
                                    Option option = MethodWithBody$.MODULE$.unapply(method);
                                    boolean bl = !option.isEmpty();
                                    return bl;
                                }
                            }).foreach((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$7$$anonfun$apply$2 $outer;

                                public final Object apply(Method x$2) {
                                    Throwable throwable2;
                                    block6: {
                                        Boolean bl;
                                        Method method = x$2;
                                        Option option = MethodWithBody$.MODULE$.unapply(method);
                                        if (option.isEmpty()) {
                                            throw new MatchError((Object)method);
                                        }
                                        Code body = (Code)option.get();
                                        try {
                                            this.$outer.org$opalj$bugpicker$core$analyses$BugPickerAnalysis$$anonfun$$anonfun$$$outer().org$opalj$bugpicker$core$analyses$BugPickerAnalysis$$anonfun$$$outer().org$opalj$bugpicker$core$analyses$BugPickerAnalysis$$analyzeMethod$1(method, body, this.$outer.org$opalj$bugpicker$core$analyses$BugPickerAnalysis$$anonfun$$anonfun$$$outer().theProject$1, this.$outer.org$opalj$bugpicker$core$analyses$BugPickerAnalysis$$anonfun$$anonfun$$$outer().logContext$1, this.$outer.org$opalj$bugpicker$core$analyses$BugPickerAnalysis$$anonfun$$anonfun$$$outer().maxEvalFactor$1, this.$outer.org$opalj$bugpicker$core$analyses$BugPickerAnalysis$$anonfun$$anonfun$$$outer().maxEvalTime$1, this.$outer.org$opalj$bugpicker$core$analyses$BugPickerAnalysis$$anonfun$$anonfun$$$outer().maxCardinalityOfIntegerRanges$1, this.$outer.org$opalj$bugpicker$core$analyses$BugPickerAnalysis$$anonfun$$anonfun$$$outer().maxCardinalityOfLongSets$1, this.$outer.org$opalj$bugpicker$core$analyses$BugPickerAnalysis$$anonfun$$anonfun$$$outer().maxCallChainLength$1, this.$outer.org$opalj$bugpicker$core$analyses$BugPickerAnalysis$$anonfun$$anonfun$$$outer().computedCallGraph$1, this.$outer.org$opalj$bugpicker$core$analyses$BugPickerAnalysis$$anonfun$$anonfun$$$outer().callGraph$1, this.$outer.org$opalj$bugpicker$core$analyses$BugPickerAnalysis$$anonfun$$anonfun$$$outer().callGraphEntryPoints$1, this.$outer.org$opalj$bugpicker$core$analyses$BugPickerAnalysis$$anonfun$$anonfun$$$outer().propertyStore$1, this.$outer.org$opalj$bugpicker$core$analyses$BugPickerAnalysis$$anonfun$$anonfun$$$outer().doInterrupt$1, this.$outer.org$opalj$bugpicker$core$analyses$BugPickerAnalysis$$anonfun$$anonfun$$$outer().filteredResults$1, this.$outer.org$opalj$bugpicker$core$analyses$BugPickerAnalysis$$anonfun$$anonfun$$$outer().issuesPackageFilter$1, this.$outer.org$opalj$bugpicker$core$analyses$BugPickerAnalysis$$anonfun$$anonfun$$$outer().fieldValueInformation$1, this.$outer.org$opalj$bugpicker$core$analyses$BugPickerAnalysis$$anonfun$$anonfun$$$outer().methodReturnValueInformation$1, this.$outer.org$opalj$bugpicker$core$analyses$BugPickerAnalysis$$anonfun$$anonfun$$$outer().cache$1);
                                            bl = BoxedUnit.UNIT;
                                        }
                                        catch (Throwable throwable2) {
                                            Boolean bl2;
                                            Throwable throwable3 = throwable2;
                                            if (throwable3 instanceof InterpretationFailedException) {
                                                Throwable throwable4 = throwable3;
                                                String ms = method.fullyQualifiedSignature();
                                                int steps = ((BoundedInterruptableAI)((InterpretationFailedException)throwable4).ai()).currentEvaluationCount();
                                                String message = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"the analysis of ", " failed/was aborted after ", " steps"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ms, BoxesRunTime.boxToInteger((int)steps)}));
                                                bl2 = BoxesRunTime.boxToBoolean((boolean)this.$outer.org$opalj$bugpicker$core$analyses$BugPickerAnalysis$$anonfun$$anonfun$$$outer().exceptions$1.add(new AnalysisException(message, throwable4)));
                                            } else {
                                                if (throwable3 instanceof ControlThrowable) {
                                                    ControlThrowable controlThrowable = (ControlThrowable)throwable3;
                                                    throw (Throwable)controlThrowable;
                                                }
                                                if (throwable3 == null) break block6;
                                                Throwable throwable5 = throwable3;
                                                String ms = method.fullyQualifiedSignature();
                                                String message = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"the analysis of ", " failed"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ms}));
                                                bl2 = BoxesRunTime.boxToBoolean((boolean)this.$outer.org$opalj$bugpicker$core$analyses$BugPickerAnalysis$$anonfun$$anonfun$$$outer().exceptions$1.add(new AnalysisException(message, throwable5)));
                                            }
                                            bl = bl2;
                                        }
                                        Boolean bl3 = bl;
                                        return bl3;
                                    }
                                    throw throwable2;
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                        }
                        catch (Throwable throwable) {
                            void var2_2;
                            try {
                                OPALLogger$.MODULE$.error("internal error", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"evaluation step ", " failed"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)var2_2)})), throwable, this.$outer.logContext$1);
                                throw throwable;
                            }
                            catch (Throwable throwable2) {
                                this.$outer.progressManagement$1.end((int)var2_2);
                                throw throwable2;
                            }
                        }
                        this.$outer.progressManagement$1.end(stepId);
                    }

                    public /* synthetic */ $anonfun$7 org$opalj$bugpicker$core$analyses$BugPickerAnalysis$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.stepIds$1 = stepIds$1;
                    }
                });
                return JavaConversions$.MODULE$.collectionAsScalaIterable((Collection)this.filteredResults$1).toSeq();
            }

            public /* synthetic */ BugPickerAnalysis org$opalj$bugpicker$core$analyses$BugPickerAnalysis$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.theProject$1 = theProject$1;
                this.project$1 = project$1;
                this.logContext$1 = logContext$1;
                this.progressManagement$1 = progressManagement$1;
                this.maxEvalFactor$1 = maxEvalFactor$1;
                this.maxEvalTime$1 = maxEvalTime$1;
                this.maxCardinalityOfIntegerRanges$1 = maxCardinalityOfIntegerRanges$1;
                this.maxCardinalityOfLongSets$1 = maxCardinalityOfLongSets$1;
                this.maxCallChainLength$1 = maxCallChainLength$1;
                this.fieldAccessInformation$1 = fieldAccessInformation$1;
                this.stringConstantsInformation$1 = stringConstantsInformation$1;
                this.computedCallGraph$1 = computedCallGraph$1;
                this.callGraph$1 = callGraph$1;
                this.callGraphEntryPoints$1 = callGraphEntryPoints$1;
                this.propertyStore$1 = propertyStore$1;
                this.doInterrupt$1 = doInterrupt$1;
                this.filteredResults$1 = filteredResults$1;
                this.issuesPackageFilter$1 = issuesPackageFilter$1;
                this.fieldValueInformation$1 = fieldValueInformation$1;
                this.methodReturnValueInformation$1 = methodReturnValueInformation$1;
                this.cache$1 = cache$1;
                this.exceptions$1 = exceptions$1;
            }
        }, (Function1)new Serializable(this, analysisTime){
            public static final long serialVersionUID = 0L;
            private final LongRef analysisTime$1;

            public final void apply(long t) {
                this.analysisTime$1.elem = t;
            }
            {
                this.analysisTime$1 = analysisTime$1;
            }
        });
        OPALLogger$.MODULE$.info("analysis progress", new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"the analysis took ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new Seconds(Nanoseconds$.MODULE$.toSeconds$extension(analysisTime.elem))}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"and found ", " unique issues"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)identifiedIssues.size())}))).toString(), logContext);
        return new Tuple3((Object)new Nanoseconds(analysisTime.elem), (Object)identifiedIssues, JavaConverters$.MODULE$.collectionAsScalaIterableConverter(exceptions).asScala());
    }

    public final void org$opalj$bugpicker$core$analyses$BugPickerAnalysis$$addResults$1(Iterable issues, ConcurrentLinkedQueue filteredResults$1, Regex issuesPackageFilter$1) {
        if (issues.nonEmpty()) {
            Iterable filteredIssues = (Iterable)issues.filter((Function1)new Serializable(this, issuesPackageFilter$1){
                public static final long serialVersionUID = 0L;
                private final Regex issuesPackageFilter$1;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean apply(Issue issue) {
                    IssueLocation issueLocation = (IssueLocation)issue.locations().head();
                    if (!(issueLocation instanceof PackageLocation)) return true;
                    PackageLocation packageLocation = (PackageLocation)issueLocation;
                    String packageName = packageLocation.thePackage();
                    Option allMatches = this.issuesPackageFilter$1.findFirstIn((CharSequence)packageName);
                    if (!allMatches.isDefined()) return false;
                    String string = packageName;
                    Object object = allMatches.get();
                    if (string != null) {
                        if (!string.equals(object)) return false;
                        return true;
                    }
                    if (object == null) return true;
                    return false;
                }
                {
                    this.issuesPackageFilter$1 = issuesPackageFilter$1;
                }
            });
            filteredResults$1.addAll(JavaConversions$.MODULE$.asJavaCollection(filteredIssues));
        }
    }

    public final void org$opalj$bugpicker$core$analyses$BugPickerAnalysis$$analyzeMethod$1(Method method, Code body, Project theProject$1, LogContext logContext$1, double maxEvalFactor$1, long maxEvalTime$1, long maxCardinalityOfIntegerRanges$1, int maxCardinalityOfLongSets$1, int maxCallChainLength$1, ComputedCallGraph computedCallGraph$1, CallGraph callGraph$1, scala.collection.immutable.Set callGraphEntryPoints$1, PropertyStore propertyStore$1, Function0 doInterrupt$1, ConcurrentLinkedQueue filteredResults$1, Regex issuesPackageFilter$1, Map fieldValueInformation$1, Map methodReturnValueInformation$1, CallGraphCache cache$1) {
        AIResult result;
        AIResult aIResult;
        ClassFile classFile = method.classFile();
        boolean debug = false;
        this.org$opalj$bugpicker$core$analyses$BugPickerAnalysis$$addResults$1(Option$.MODULE$.option2Iterable(UnusedMethodsAnalysis$.MODULE$.apply(theProject$1, computedCallGraph$1, (scala.collection.immutable.Set<Method>)callGraphEntryPoints$1, method)), filteredResults$1, issuesPackageFilter$1);
        RootBugPickerAnalysisDomain analysisDomain = new RootBugPickerAnalysisDomain((Project<URL>)theProject$1, (Map<Field, ValuesDomain.Value>)fieldValueInformation$1, (Map<Method, Option<ValuesDomain.Value>>)methodReturnValueInformation$1, (CallGraphCache<MethodSignature, Set<Method>>)cache$1, maxCardinalityOfIntegerRanges$1, maxCardinalityOfLongSets$1, maxCallChainLength$1, method, debug, RootBugPickerAnalysisDomain$.MODULE$.$lessinit$greater$default$10());
        BoundedInterruptableAI ai0 = new BoundedInterruptableAI(body, maxEvalFactor$1, maxEvalTime$1, doInterrupt$1, BoundedInterruptableAI$.MODULE$.$lessinit$greater$default$5(), logContext$1);
        AIResult result0 = ai0.apply(method, (Domain)analysisDomain);
        if (result0.wasAborted() && maxCallChainLength$1 > 0) {
            String logMessage = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"analysis of ", " with method call execution aborted "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{method.fullyQualifiedSignature()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"after ", " steps "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)ai0.currentEvaluationCount())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(code size: ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)((Code)method.body().get()).instructions().length)}))).toString();
            FallbackBugPickerAnalysisDomain fallbackAnalysisDomain = new FallbackBugPickerAnalysisDomain((Project<URL>)theProject$1, (Map<Field, ValuesDomain.Value>)fieldValueInformation$1, (Map<Method, Option<ValuesDomain.Value>>)methodReturnValueInformation$1, (CallGraphCache<MethodSignature, Set<Method>>)cache$1, maxCardinalityOfIntegerRanges$1, maxCardinalityOfLongSets$1, method);
            BoundedInterruptableAI ai1 = new BoundedInterruptableAI(body, maxEvalFactor$1, maxEvalTime$1, doInterrupt$1, BoundedInterruptableAI$.MODULE$.$lessinit$greater$default$5(), logContext$1);
            AIResult result1 = ai1.apply(method, (Domain)fallbackAnalysisDomain);
            if (result1.wasAborted()) {
                OPALLogger$.MODULE$.warn("configuration", new StringBuilder().append((Object)logMessage).append((Object)": retry without performing invocations also failed").toString(), logContext$1);
            } else {
                OPALLogger$.MODULE$.info("configuration", logMessage, logContext$1);
            }
            aIResult = result1;
        } else {
            aIResult = result = result0;
        }
        if (result.wasAborted()) {
            if (!doInterrupt$1.apply$mcZ$sp()) {
                OPALLogger$.MODULE$.error("internal error", new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"analysis of ", " aborted "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{method.fullyQualifiedSignature()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"after ", " steps "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)ai0.currentEvaluationCount())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(code size: ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)((Code)method.body().get()).instructions().length)}))).toString(), logContext$1);
            }
        } else {
            Object object;
            if (debug) {
                String domainName = result.domain().getClass().getName();
                object = package$.MODULE$.writeAndOpen(XHTML$.MODULE$.dump((Option)new Some((Object)classFile), (Option)new Some((Object)method), (Code)method.body().get(), (Option)new Some((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Created: ", "<br>Domain: ", "<br>"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new Date(), domainName}))).append((Object)org.opalj.ai.util.XHTML$.MODULE$.evaluatedInstructionsToXHTML(result.evaluated())).toString()), result.domain(), result.cfJoins(), result.operandsArray(), result.localsArray()), "AIResult", ".html");
            } else {
                object = BoxedUnit.UNIT;
            }
            this.org$opalj$bugpicker$core$analyses$BugPickerAnalysis$$addResults$1((Iterable)DeadEdgesAnalysis$.MODULE$.apply(theProject$1, method, result), filteredResults$1, issuesPackageFilter$1);
            this.org$opalj$bugpicker$core$analyses$BugPickerAnalysis$$addResults$1((Iterable)GuardedAndUnguardedAccessAnalysis$.MODULE$.apply(theProject$1, method, result), filteredResults$1, issuesPackageFilter$1);
            this.org$opalj$bugpicker$core$analyses$BugPickerAnalysis$$addResults$1(ThrowsExceptionAnalysis$.MODULE$.apply(theProject$1, method, result).toIterable(), filteredResults$1, issuesPackageFilter$1);
            this.org$opalj$bugpicker$core$analyses$BugPickerAnalysis$$addResults$1((Iterable)UselessComputationsAnalysis$.MODULE$.apply(theProject$1, method, result), filteredResults$1, issuesPackageFilter$1);
            this.org$opalj$bugpicker$core$analyses$BugPickerAnalysis$$addResults$1((Iterable)UselessReComputationsAnalysis$.MODULE$.apply(theProject$1, method, result), filteredResults$1, issuesPackageFilter$1);
            this.org$opalj$bugpicker$core$analyses$BugPickerAnalysis$$addResults$1((Iterable)UnusedLocalVariables$.MODULE$.apply(theProject$1, propertyStore$1, callGraph$1, method, result), filteredResults$1, issuesPackageFilter$1);
            this.org$opalj$bugpicker$core$analyses$BugPickerAnalysis$$addResults$1((Iterable)CollectionsUsage$.MODULE$.apply(theProject$1, propertyStore$1, callGraph$1, method, result), filteredResults$1, issuesPackageFilter$1);
        }
    }

    public BugPickerAnalysis() {
        Analysis.class.$init$((Analysis)this);
    }
}

