/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.bugpicker.core.analyses;

import org.opalj.Answer;
import org.opalj.No$;
import org.opalj.Unknown$;
import org.opalj.Yes$;
import org.opalj.br.ClassFile;
import org.opalj.br.Code;
import org.opalj.br.Field;
import org.opalj.br.FieldType;
import org.opalj.br.Method;
import org.opalj.br.MethodWithBody$;
import org.opalj.br.ObjectType;
import org.opalj.br.ObjectType$;
import org.opalj.br.analyses.Project;
import org.opalj.br.instructions.ALOAD_1$;
import org.opalj.br.instructions.FieldReadAccess;
import org.opalj.br.instructions.FieldReadAccess$;
import org.opalj.br.instructions.Instruction;
import org.opalj.bugpicker.core.analyses.AnonymousInnerClassShouldBeStatic$;
import org.opalj.issues.ClassLocation;
import org.opalj.issues.ClassLocation$;
import org.opalj.issues.Issue;
import org.opalj.issues.Issue$;
import org.opalj.issues.Relevance$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.util.matching.Regex;

public final class AnonymousInnerClassShouldBeStatic$ {
    public static final AnonymousInnerClassShouldBeStatic$ MODULE$;
    private final Regex withinAnonymousClass;

    static {
        new AnonymousInnerClassShouldBeStatic$();
    }

    public String description() {
        return "Identifies anonymous inner classes that should be made static.";
    }

    private Regex withinAnonymousClass() {
        return this.withinAnonymousClass;
    }

    private boolean isWithinAnonymousInnerClass(ClassFile classFile) {
        return this.withinAnonymousClass().findFirstIn((CharSequence)classFile.thisType().fqn()).isDefined();
    }

    private int lastIndexOfInnerClassEncoding(String fqn) {
        return package$.MODULE$.max(fqn.lastIndexOf(36), fqn.lastIndexOf(43));
    }

    private boolean isAnonymousInnerClass(ClassFile classFile) {
        String fqn = classFile.thisType().fqn();
        int lastSpecialChar = this.lastIndexOfInnerClassEncoding(fqn);
        if (lastSpecialChar < 0) {
            return false;
        }
        int digitChar = lastSpecialChar + 1;
        return digitChar < fqn.length() && Character.isDigit(fqn.charAt(digitChar));
    }

    public boolean org$opalj$bugpicker$core$analyses$AnonymousInnerClassShouldBeStatic$$isOuterThisField(Field field) {
        return field.name().startsWith("this$") || field.name().startsWith("this+");
    }

    private boolean hasMethodsReadingField(ClassFile classFile, Field field) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            boolean bl;
            Object object = new Object();
            try {
                classFile.methods().withFilter((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Method check$ifrefutable$1) {
                        Method method = check$ifrefutable$1;
                        Option option = MethodWithBody$.MODULE$.unapply(method);
                        boolean bl = !option.isEmpty();
                        return bl;
                    }
                }).foreach((Function1)new Serializable(classFile, field, object){
                    public static final long serialVersionUID = 0L;
                    public final ClassFile classFile$1;
                    public final Field field$1;
                    private final Object nonLocalReturnKey1$1;

                    public final void apply(Method x$1) {
                        Method method = x$1;
                        Option option = MethodWithBody$.MODULE$.unapply(method);
                        if (option.isEmpty()) {
                            throw new MatchError((Object)method);
                        }
                        Code body = (Code)option.get();
                        if (Predef$.MODULE$.refArrayOps((Object[])body.instructions()).exists((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.hasMethodsReadingField.2 $outer;

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final boolean apply(Instruction x0$1) {
                                Instruction instruction = x0$1;
                                if (!(instruction instanceof FieldReadAccess)) return false;
                                FieldReadAccess fieldReadAccess = (FieldReadAccess)instruction;
                                Option option = FieldReadAccess$.MODULE$.unapply(fieldReadAccess);
                                if (option.isEmpty()) return false;
                                ObjectType objectType = (ObjectType)((Tuple3)option.get())._1();
                                String string = (String)((Tuple3)option.get())._2();
                                FieldType fieldType = (FieldType)((Tuple3)option.get())._3();
                                ObjectType objectType2 = this.$outer.classFile$1.thisType();
                                ObjectType objectType3 = objectType;
                                if (objectType2 == null) {
                                    if (objectType3 != null) {
                                        return false;
                                    }
                                } else if (!objectType2.equals(objectType3)) return false;
                                String string2 = this.$outer.field$1.name();
                                String string3 = string;
                                if (string2 == null) {
                                    if (string3 != null) {
                                        return false;
                                    }
                                } else if (!string2.equals(string3)) return false;
                                FieldType fieldType2 = this.$outer.field$1.fieldType();
                                FieldType fieldType3 = fieldType;
                                if (fieldType2 == null) {
                                    if (fieldType3 == null) return true;
                                    return false;
                                } else {
                                    if (!fieldType2.equals(fieldType3)) return false;
                                    return true;
                                }
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        })) {
                            throw new NonLocalReturnControl.mcZ.sp(this.nonLocalReturnKey1$1, true);
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    {
                        this.classFile$1 = classFile$1;
                        this.field$1 = field$1;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
                bl = false;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                bl = nonLocalReturnControl2.value$mcZ$sp();
            }
            return bl;
        }
        throw nonLocalReturnControl2;
    }

    private boolean hasConstructorsWithMultipleALOAD_1s(ClassFile classFile) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            boolean bl;
            Object object = new Object();
            try {
                classFile.constructors().withFilter((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Method check$ifrefutable$2) {
                        Method method = check$ifrefutable$2;
                        Option option = MethodWithBody$.MODULE$.unapply(method);
                        boolean bl = !option.isEmpty();
                        return bl;
                    }
                }).foreach((Function1)new Serializable(object){
                    public static final long serialVersionUID = 0L;
                    public final Object nonLocalReturnKey2$1;

                    public final void apply(Method x$2) {
                        Method method = x$2;
                        Option option = MethodWithBody$.MODULE$.unapply(method);
                        if (option.isEmpty()) {
                            throw new MatchError((Object)method);
                        }
                        Code body = (Code)option.get();
                        IntRef count = IntRef.create((int)0);
                        Predef$.MODULE$.refArrayOps((Object[])body.instructions()).foreach((Function1)new Serializable(this, count){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.hasConstructorsWithMultipleALOAD_1s.2 $outer;
                            private final IntRef count$1;

                            public final void apply(Instruction x0$2) {
                                Instruction instruction = x0$2;
                                if (ALOAD_1$.MODULE$.equals(instruction)) {
                                    ++this.count$1.elem;
                                    if (this.count$1.elem > 1) {
                                        throw new NonLocalReturnControl.mcZ.sp(this.$outer.nonLocalReturnKey2$1, true);
                                    }
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                }
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.count$1 = count$1;
                            }
                        });
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    {
                        this.nonLocalReturnKey2$1 = nonLocalReturnKey2$1;
                    }
                });
                bl = false;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                bl = nonLocalReturnControl2.value$mcZ$sp();
            }
            return bl;
        }
        throw nonLocalReturnControl2;
    }

    private Answer isOuterClassReferenceUsed(ClassFile classFile) {
        Option outerClassReference = classFile.fields().find((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Field x$3) {
                return AnonymousInnerClassShouldBeStatic$.MODULE$.org$opalj$bugpicker$core$analyses$AnonymousInnerClassShouldBeStatic$$isOuterThisField(x$3);
            }
        });
        if (outerClassReference.isEmpty()) {
            return Unknown$.MODULE$;
        }
        if (this.hasConstructorsWithMultipleALOAD_1s(classFile)) {
            return Yes$.MODULE$;
        }
        if (this.hasMethodsReadingField(classFile, (Field)outerClassReference.get())) {
            return Yes$.MODULE$;
        }
        return No$.MODULE$;
    }

    public Iterable<Issue> apply(Project<?> project, ClassFile classFile) {
        if (project.isLibraryType(classFile) || classFile.isSynthetic()) {
            return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
        }
        if (this.isAnonymousInnerClass(classFile) && !this.isWithinAnonymousInnerClass(classFile) && this.isOuterClassReferenceUsed(classFile).isNo()) {
            String supertype = ((ObjectType)classFile.superclassType().get()).toJava();
            if (classFile.interfaceTypes().nonEmpty()) {
                String superInterfacetypes = ((TraversableOnce)classFile.interfaceTypes().map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(ObjectType x$4) {
                        return x$4.toJava();
                    }
                }, Seq$.MODULE$.canBuildFrom())).mkString(" with ");
                Object object = classFile.superclassType().get();
                ObjectType objectType = ObjectType$.MODULE$.Object();
                supertype = !(object != null ? !object.equals(objectType) : objectType != null) ? superInterfacetypes : new StringBuilder().append((Object)supertype).append((Object)new StringBuilder().append((Object)" implements ").append((Object)superInterfacetypes).toString()).toString();
            }
            return Option$.MODULE$.option2Iterable((Option)new Some((Object)new Issue("AnonymousInnerClassShouldBeStatic", Relevance$.MODULE$.Low(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"this inner class of type ", " should be made static"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{supertype})), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"comprehensibility", "performance"})), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"static modifier missing"})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ClassLocation[]{new ClassLocation((Option)None$.MODULE$, project, classFile, ClassLocation$.MODULE$.$lessinit$greater$default$4())})), Issue$.MODULE$.apply$default$7())));
        }
        return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
    }

    private AnonymousInnerClassShouldBeStatic$() {
        MODULE$ = this;
        this.withinAnonymousClass = new StringOps(Predef$.MODULE$.augmentString("[$][0-9].*[$]")).r();
    }
}

