/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.apk.parser;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.io.StringWriter;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.opalj.apk.ApkComponentsKey$;
import org.opalj.apk.package$;
import org.opalj.apk.parser.ApkParser;
import org.opalj.apk.parser.DexParser$;
import org.opalj.br.analyses.Project;
import org.opalj.br.analyses.Project$;
import org.opalj.log.GlobalLogContext$;
import org.opalj.log.LogContext;
import org.opalj.log.OPALLogger$;
import org.opalj.si.ProjectInformationKey;
import scala.Enumeration;
import scala.Function1;
import scala.Tuple3;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.process.ProcessLogger;
import scala.sys.process.ProcessLogger$;

public final class ApkParser$ {
    public static final ApkParser$ MODULE$ = new ApkParser$();
    private static final LogContext logContext = GlobalLogContext$.MODULE$;

    private LogContext logContext() {
        return logContext;
    }

    public Project<URL> createProject(String apkPath, Config projectConfig, Enumeration.Value dexParser) {
        ApkParser apkParser = new ApkParser(apkPath, package$.MODULE$.BaseConfig());
        Path jarDir = (Path)apkParser.parseDexCode(dexParser)._1();
        Project project = Project$.MODULE$.apply(jarDir.toFile(), (LogContext)GlobalLogContext$.MODULE$, projectConfig);
        project.updateProjectInformationKeyInitializationData((ProjectInformationKey)ApkComponentsKey$.MODULE$, (Function1 & Serializable)x$9 -> apkParser);
        project.get((ProjectInformationKey)ApkComponentsKey$.MODULE$);
        apkParser.cleanUp();
        return project;
    }

    public Enumeration.Value createProject$default$3() {
        return DexParser$.MODULE$.Enjarify();
    }

    public Tuple3<Object, StringWriter, StringWriter> org$opalj$apk$parser$ApkParser$$runCmd(String cmd, boolean logOutput) {
        String logCategory = "APK parser - command";
        OPALLogger$.MODULE$.info(logCategory, new StringBuilder(6).append("run:  ").append(cmd).toString(), this.logContext());
        StringWriter cmd_stdout = new StringWriter();
        StringWriter cmd_stderr = new StringWriter();
        ProcessLogger logger = logOutput ? ProcessLogger$.MODULE$.apply((Function1 & Serializable)o -> {
            ApkParser$.$anonfun$runCmd$1(logCategory, cmd_stdout, o);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable)e -> {
            ApkParser$.$anonfun$runCmd$2(logCategory, cmd_stderr, e);
            return BoxedUnit.UNIT;
        }) : ProcessLogger$.MODULE$.apply((Function1 & Serializable)o -> {
            cmd_stdout.write(new StringBuilder(0).append(o).append(System.lineSeparator()).toString());
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable)e -> {
            cmd_stderr.write(new StringBuilder(0).append(e).append(System.lineSeparator()).toString());
            return BoxedUnit.UNIT;
        });
        int cmd_result = scala.sys.process.package$.MODULE$.stringToProcess(cmd).$bang(logger);
        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)cmd_result), (Object)cmd_stdout, (Object)cmd_stderr);
    }

    public void org$opalj$apk$parser$ApkParser$$unzip(Path zipPath, Path outputPath) {
        ZipFile zipFile = new ZipFile(zipPath.toFile());
        CollectionConverters$.MODULE$.EnumerationHasAsScala(zipFile.entries()).asScala().foreach((Function1 & Serializable)entry -> {
            Path path = outputPath.resolve(entry.getName());
            if (entry.isDirectory()) {
                return Files.createDirectories(path, new FileAttribute[0]);
            }
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            while (Files.exists(path, new LinkOption[0])) {
                path = path.resolveSibling(new StringBuilder(1).append("_").append(((Object)path.getFileName()).toString()).toString());
                OPALLogger$.MODULE$.info("APK", new StringBuilder(12).append("Renamed ").append(entry).append(" to ").append(path.getFileName()).toString(), MODULE$.logContext());
            }
            return BoxesRunTime.boxToLong((long)Files.copy(zipFile.getInputStream((ZipEntry)entry), path, new CopyOption[0]));
        });
    }

    public String org$opalj$apk$parser$ApkParser$$getFileBaseName(String fileName) {
        return fileName.substring(fileName.lastIndexOf(47) + 1, fileName.lastIndexOf(46));
    }

    public static final /* synthetic */ void $anonfun$runCmd$1(String logCategory$1, StringWriter cmd_stdout$1, String o) {
        OPALLogger$.MODULE$.info(new StringBuilder(7).append(logCategory$1).append(" stdout").toString(), o, MODULE$.logContext());
        cmd_stdout$1.write(new StringBuilder(0).append(o).append(System.lineSeparator()).toString());
    }

    public static final /* synthetic */ void $anonfun$runCmd$2(String logCategory$1, StringWriter cmd_stderr$1, String e) {
        OPALLogger$.MODULE$.info(new StringBuilder(7).append(logCategory$1).append(" stderr").toString(), e, MODULE$.logContext());
        cmd_stderr$1.write(new StringBuilder(0).append(e).append(System.lineSeparator()).toString());
    }

    private ApkParser$() {
    }
}

