/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.issues;

import org.opalj.issues.Issue;
import org.opalj.issues.IssueLocation;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.math.PartialOrdering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class IssueOrdering$
implements Ordering<Issue> {
    public static final IssueOrdering$ MODULE$;

    static {
        new IssueOrdering$();
    }

    public Some tryCompare(Object x, Object y) {
        return Ordering.class.tryCompare((Ordering)this, (Object)x, (Object)y);
    }

    public boolean lteq(Object x, Object y) {
        return Ordering.class.lteq((Ordering)this, (Object)x, (Object)y);
    }

    public boolean gteq(Object x, Object y) {
        return Ordering.class.gteq((Ordering)this, (Object)x, (Object)y);
    }

    public boolean lt(Object x, Object y) {
        return Ordering.class.lt((Ordering)this, (Object)x, (Object)y);
    }

    public boolean gt(Object x, Object y) {
        return Ordering.class.gt((Ordering)this, (Object)x, (Object)y);
    }

    public boolean equiv(Object x, Object y) {
        return Ordering.class.equiv((Ordering)this, (Object)x, (Object)y);
    }

    public Object max(Object x, Object y) {
        return Ordering.class.max((Ordering)this, (Object)x, (Object)y);
    }

    public Object min(Object x, Object y) {
        return Ordering.class.min((Ordering)this, (Object)x, (Object)y);
    }

    public Ordering<Issue> reverse() {
        return Ordering.class.reverse((Ordering)this);
    }

    public <U> Ordering<U> on(Function1<U, Issue> f) {
        return Ordering.class.on((Ordering)this, f);
    }

    public Ordering.Ops mkOrderingOps(Object lhs) {
        return Ordering.class.mkOrderingOps((Ordering)this, (Object)lhs);
    }

    public int compare(Set<String> x, Set<String> y) {
        int n;
        if (x.size() != y.size()) {
            n = x.size() - y.size();
        } else {
            Set xUniques = (Set)x.$minus$minus(y);
            if (xUniques.isEmpty()) {
                n = 0;
            } else {
                String xUniqueHead = (String)((IterableLike)xUniques.toSeq().sorted((Ordering)Ordering.String$.MODULE$)).head();
                String yUniqueHead = (String)((IterableLike)((SetLike)y.$minus$minus(x)).toSeq().sorted((Ordering)Ordering.String$.MODULE$)).head();
                n = new StringOps(Predef$.MODULE$.augmentString(xUniqueHead)).compare(yUniqueHead);
            }
        }
        return n;
    }

    public int compare(Issue x, Issue y) {
        Object object;
        if (x.relevance() < y.relevance()) {
            return -1;
        }
        if (x.relevance() > y.relevance()) {
            return 1;
        }
        if (x.locations().size() != y.locations().size()) {
            return x.locations().size() - y.locations().size();
        }
        Option option = ((TraversableOnce)x.locations().zip(y.locations(), Seq$.MODULE$.canBuildFrom())).collectFirst((PartialFunction)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Tuple2<IssueLocation, IssueLocation>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                IssueLocation l2;
                IssueLocation l1;
                A1 A1 = x1;
                Object object = A1 != null && (l1 = (IssueLocation)A1._1()).compareTo(l2 = (IssueLocation)A1._2()) != 0 ? BoxesRunTime.boxToInteger((int)l1.compareTo(l2)) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<IssueLocation, IssueLocation> x1) {
                IssueLocation l2;
                IssueLocation l1;
                Tuple2<IssueLocation, IssueLocation> tuple2 = x1;
                boolean bl = tuple2 != null && (l1 = (IssueLocation)tuple2._1()).compareTo(l2 = (IssueLocation)tuple2._2()) != 0;
                return bl;
            }
        });
        if (option instanceof Some) {
            Some some = (Some)option;
            int result2 = BoxesRunTime.unboxToInt((Object)some.x());
            object = BoxesRunTime.boxToInteger((int)result2);
        } else {
            object = BoxedUnit.UNIT;
        }
        int categoriesComparison = this.compare(x.categories(), y.categories());
        if (categoriesComparison != 0) {
            return categoriesComparison;
        }
        int kindsComparison = this.compare(x.kinds(), y.kinds());
        if (kindsComparison != 0) {
            return kindsComparison;
        }
        if (new StringOps(Predef$.MODULE$.augmentString(x.analysis())).$less((Object)y.analysis())) {
            return -1;
        }
        if (new StringOps(Predef$.MODULE$.augmentString(x.analysis())).$greater((Object)y.analysis())) {
            return 1;
        }
        return new StringOps(Predef$.MODULE$.augmentString(x.summary())).compare(y.summary());
    }

    private Object readResolve() {
        return MODULE$;
    }

    private IssueOrdering$() {
        MODULE$ = this;
        PartialOrdering.class.$init$((PartialOrdering)this);
        Ordering.class.$init$((Ordering)this);
    }
}

