/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.ai.common;

import org.opalj.ai.Domain;
import org.opalj.ai.domain.l0.BaseDomain;
import org.opalj.ai.domain.l1.DefaultDomainWithCFGAndDefUse;
import org.opalj.ai.domain.l1.DefaultIntervalValuesDomain;
import org.opalj.ai.domain.l1.DefaultReferenceValuesDomain;
import org.opalj.ai.domain.l1.DefaultSetValuesDomain;
import org.opalj.ai.domain.l2.DefaultDomain;
import org.opalj.ai.domain.l2.DefaultPerformInvocationsDomain;
import org.opalj.br.ClassFile;
import org.opalj.br.Method;
import org.opalj.br.analyses.Project;
import scala.Function3;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.Map;

public final class DomainRegistry$ {
    public static final DomainRegistry$ MODULE$;
    private Map<String, Class<? extends Domain>> descriptions;
    private Map<Class<? extends Domain>, Function3<Project<?>, ClassFile, Method, Domain>> theRegistry;

    static {
        new DomainRegistry$();
    }

    public synchronized void register(String domainDescription, Class<? extends Domain> domainClass, Function3<Project<?>, ClassFile, Method, Domain> factory) {
        this.descriptions = this.descriptions.$plus(new Tuple2((Object)domainDescription, domainClass));
        this.theRegistry = this.theRegistry.$plus(new Tuple2(domainClass, factory));
    }

    public synchronized Iterable<String> domainDescriptions() {
        return this.descriptions.keys();
    }

    public synchronized Map<Class<? extends Domain>, Function3<Project<?>, ClassFile, Method, Domain>> registry() {
        return this.theRegistry;
    }

    public synchronized Domain newDomain(String domainDescription, Project<?> project, ClassFile classFile, Method method) {
        Class domainClass = (Class)this.descriptions.apply((Object)domainDescription);
        return this.newDomain(domainClass, project, classFile, method);
    }

    public synchronized Domain newDomain(Class<? extends Domain> domainClass, Project<?> project, ClassFile classFile, Method method) {
        return (Domain)((Function3)this.theRegistry.apply(domainClass)).apply(project, (Object)classFile, (Object)method);
    }

    private DomainRegistry$() {
        MODULE$ = this;
        this.descriptions = Predef$.MODULE$.Map().empty();
        this.theRegistry = Predef$.MODULE$.Map().empty();
        this.register("[l0.BaseDomain] The most basic domain; it does all computations at the type level.", (Class<? extends Domain>)BaseDomain.class, (Function3<Project<?>, ClassFile, Method, Domain>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BaseDomain<?> apply(Project<?> project, ClassFile classFile, Method method) {
                return new BaseDomain<?>(project, classFile, method);
            }
        });
        this.register("[l1.DefaultIntervalValuesDomain] A domain that uses intervals to represent the values of primitive values/variables.", (Class<? extends Domain>)DefaultIntervalValuesDomain.class, (Function3<Project<?>, ClassFile, Method, Domain>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DefaultIntervalValuesDomain<?> apply(Project<?> project, ClassFile classFile, Method method) {
                return new DefaultIntervalValuesDomain<?>(project, classFile, method);
            }
        });
        this.register("[l1.DefaultSetValuesDomain] A domain that represents reference values at the type level and represents int/long values using sets.", (Class<? extends Domain>)DefaultSetValuesDomain.class, (Function3<Project<?>, ClassFile, Method, Domain>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DefaultSetValuesDomain<?> apply(Project<?> project, ClassFile classFile, Method method) {
                return new DefaultSetValuesDomain<?>(project, classFile, method);
            }
        });
        this.register("[l1.DefaultReferenceValuesDomain] A domain that tracks various properties related to references values.", (Class<? extends Domain>)DefaultReferenceValuesDomain.class, (Function3<Project<?>, ClassFile, Method, Domain>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DefaultReferenceValuesDomain<?> apply(Project<?> project, ClassFile classFile, Method method) {
                return new DefaultReferenceValuesDomain<?>(project, classFile, method);
            }
        });
        this.register("[l1.DefaultDomain] A domain that tracks origin and null-ness properties of references values as well as tracks int/long values using ranges/sets.", (Class<? extends Domain>)org.opalj.ai.domain.l1.DefaultDomain.class, (Function3<Project<?>, ClassFile, Method, Domain>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final org.opalj.ai.domain.l1.DefaultDomain<?> apply(Project<?> project, ClassFile classFile, Method method) {
                return new org.opalj.ai.domain.l1.DefaultDomain<?>(project, classFile, method);
            }
        });
        this.register("[l1.DefaultDomainWithDefUse] A classical abstract domain that records the CFG and tracks the def/use relations. The null-ness properties of references values are also tracked as well as int/long values using ranges/sets.", (Class<? extends Domain>)DefaultDomainWithCFGAndDefUse.class, (Function3<Project<?>, ClassFile, Method, Domain>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DefaultDomainWithCFGAndDefUse<?> apply(Project<?> project, ClassFile classFile, Method method) {
                return new DefaultDomainWithCFGAndDefUse<?>(project, classFile, method);
            }
        });
        this.register("[l2.DefaultDomain] This abstract domain performs method invocations up to two levels deep additionally to the features of the l1.DefaultDomain.", (Class<? extends Domain>)DefaultDomain.class, (Function3<Project<?>, ClassFile, Method, Domain>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DefaultDomain<?> apply(Project<?> project, ClassFile classFile, Method method) {
                return new DefaultDomain<?>(project, classFile, method);
            }
        });
        this.register("[l2.DefaultPerformInvocationsDomain] This abstract domain performs simple method invocations additionally to the features of the l1.DefaultDomain.", (Class<? extends Domain>)DefaultPerformInvocationsDomain.class, (Function3<Project<?>, ClassFile, Method, Domain>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DefaultPerformInvocationsDomain<?> apply(Project<?> project, ClassFile classFile, Method method) {
                return new DefaultPerformInvocationsDomain<?>(project, classFile, method);
            }
        });
        this.register("[la.DefaultDomain] This abstract domain reuses information provided by some pre analyses additionally to the features of the l1.DefaultDomain.", (Class<? extends Domain>)org.opalj.ai.domain.l1.DefaultDomain.class, (Function3<Project<?>, ClassFile, Method, Domain>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final org.opalj.ai.domain.l1.DefaultDomain<?> apply(Project<?> project, ClassFile classFile, Method method) {
                return new org.opalj.ai.domain.l1.DefaultDomain<?>(project, classFile, method);
            }
        });
        this.register("[li.DefaultDomain] This domain performs some partial concrete evaluation.", (Class<? extends Domain>)org.opalj.ai.domain.la.DefaultDomain.class, (Function3<Project<?>, ClassFile, Method, Domain>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final org.opalj.ai.domain.la.DefaultDomain apply(Project<?> project, ClassFile classFile, Method method) {
                return new org.opalj.ai.domain.la.DefaultDomain(project, classFile, method);
            }
        });
    }
}

