/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.ai.analyses;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.opalj.ai.Domain;
import org.opalj.ai.InterruptableAI;
import org.opalj.ai.ValuesDomain;
import org.opalj.ai.domain.RecordReturnedValueInfrastructure;
import org.opalj.br.ClassFile;
import org.opalj.br.Method;
import org.opalj.br.Type;
import org.opalj.br.analyses.MethodInfo;
import org.opalj.br.analyses.Project;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Serializable;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.mutable.AnyRefMap$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class MethodReturnValuesAnalysis$ {
    public static final MethodReturnValuesAnalysis$ MODULE$;

    static {
        new MethodReturnValuesAnalysis$();
    }

    public String title() {
        return "tries to derive more precise information about the values returned by methods";
    }

    public String description() {
        return "Identifies methods where we can \u2013 statically \u2013 derive more precise return type/value information.";
    }

    public Map<Method, Option<ValuesDomain.Value>> doAnalyze(Project<?> theProject, Function0<Object> isInterrupted, Function2<InterruptableAI<Domain>, Method, Domain> createDomain) {
        ConcurrentHashMap results = new ConcurrentHashMap();
        AtomicInteger candidates = new AtomicInteger(0);
        theProject.parForeachMethodWithBody(isInterrupted, theProject.parForeachMethodWithBody$default$2(), (Function1)new Serializable(theProject, createDomain, results, candidates){
            public static final long serialVersionUID = 0L;
            private final Project theProject$1;
            private final Function2 createDomain$1;
            private final ConcurrentHashMap results$1;
            private final AtomicInteger candidates$1;

            public final Object apply(MethodInfo<Object> methodInfo) {
                Object object;
                ClassFile classFile = methodInfo.classFile();
                Method method = methodInfo.method();
                Type originalReturnType = method.returnType();
                if (originalReturnType.isObjectType() && BoxesRunTime.unboxToBoolean((Object)this.theProject$1.classFile(originalReturnType.asObjectType()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ClassFile x$1) {
                        return !x$1.isFinal();
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        return true;
                    }
                }))) {
                    this.candidates$1.incrementAndGet();
                    InterruptableAI<Domain> ai = new InterruptableAI<Domain>();
                    Domain domain = (Domain)this.createDomain$1.apply(ai, (Object)method);
                    ai.apply(classFile, method, domain);
                    object = ai.isInterrupted() ? BoxedUnit.UNIT : this.results$1.put(method, ((RecordReturnedValueInfrastructure)((Object)domain)).returnedValue());
                } else {
                    object = BoxedUnit.UNIT;
                }
                return object;
            }
            {
                this.theProject$1 = theProject$1;
                this.createDomain$1 = createDomain$1;
                this.results$1 = results$1;
                this.candidates$1 = candidates$1;
            }
        });
        return AnyRefMap$.MODULE$.empty().$plus$plus((GenTraversableOnce)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(results).asScala());
    }

    private MethodReturnValuesAnalysis$() {
        MODULE$ = this;
    }
}

