/* License (BSD Style License):
 * Copyright (c) 2009 - 2013
 * Software Technology Group
 * Department of Computer Science
 * Technische Universität Darmstadt
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  - Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *  - Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *  - Neither the name of the Software Technology Group or Technische
 *    Universität Darmstadt nor the names of its contributors may be used to
 *    endorse or promote products derived from this software without specific
 *    prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package org.opalj
package ai
package domain
package l1

import org.opalj.br.FieldType
import org.opalj.br.ObjectType

/**
 * Default implementation of the `AsDomainValue` trait.
 *
 * @author Frederik Buss-Joraschek
 * @author Michael Eichberg
 */
trait DefaultJavaObjectToDomainValueConversion extends AsDomainValue {
    domain: ReferenceValuesDomain ⇒

    /**
     * Converts the given Java object to a corresponding
     * `DomainValue`. By creating an `DomainValue` that represents an initialized
     * (array/object) value.
     */
    def toDomainValue(pc: PC, value: Object): DomainReferenceValue = {
        if (value eq null)
            return NullValue(pc);

        val clazz = value.getClass
        val fqnInBinaryNotation = clazz.getName.replace('.', '/')
        if (clazz.isArray) {
            val array: Array[_] = value.asInstanceOf[Array[_]]
            InitializedArrayValue(
                pc,
                FieldType(fqnInBinaryNotation).asArrayType,
                List(array.length)
            )
        } else /*if (!clazz.isPrimitive()) */ {
            InitializedObjectValue(pc, ObjectType(fqnInBinaryNotation))
        }
    }
}
