/*
 * Decompiled with CFR 0.152.
 */
package sonumina.math.graph;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import sonumina.collections.IntMapper;
import sonumina.math.graph.AbstractGraph;
import sonumina.math.graph.DirectedGraph;

public final class SlimDirectedGraphView<VertexType>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private IntMapper<VertexType> mapper;
    public int[][] vertexAncestors;
    public int[][] vertexParents;
    public int[][] vertexChildren;
    public int[][] vertexDescendants;

    public SlimDirectedGraphView() {
    }

    @Deprecated
    public SlimDirectedGraphView(DirectedGraph<VertexType> graph) {
        SlimDirectedGraphView.init(this, graph);
    }

    public int getNumberOfVertices() {
        return this.mapper.getSize();
    }

    public VertexType getVertex(int index) {
        return this.mapper.get(index);
    }

    public int getVertexIndex(VertexType v) {
        return this.mapper.getIndex(v);
    }

    public int[] getVertexIndices(Collection<VertexType> vertices) {
        int[] vertexArray = new int[vertices.size()];
        int i = 0;
        for (VertexType v : vertices) {
            vertexArray[i++] = this.mapper.getIndex(v);
        }
        return vertexArray;
    }

    public boolean isAncestor(int i, int j) {
        int[] ancs = this.vertexAncestors[j];
        int r = Arrays.binarySearch(ancs, i);
        return r >= 0;
    }

    public boolean isDescendant(int i, int j) {
        int[] descs = this.vertexDescendants[j];
        int r = Arrays.binarySearch(descs, i);
        return r >= 0;
    }

    public boolean isAncestor(VertexType i, VertexType j) {
        if (!this.isVertexInGraph(i) || !this.isVertexInGraph(j)) {
            return false;
        }
        int iIdx = this.mapper.getIndex(i);
        int jIdx = this.mapper.getIndex(j);
        return this.isAncestor(iIdx, jIdx);
    }

    public boolean isDescendant(VertexType i, VertexType j) {
        if (!this.isVertexInGraph(i) || !this.isVertexInGraph(j)) {
            return false;
        }
        int iIdx = this.mapper.getIndex(i);
        int jIdx = this.mapper.getIndex(j);
        return this.isDescendant(iIdx, jIdx);
    }

    public ArrayList<VertexType> getDescendants(VertexType t) {
        if (!this.isVertexInGraph(t)) {
            return null;
        }
        int indexOfTerm = this.getVertexIndex(t);
        int[] descendantIndices = this.vertexDescendants[indexOfTerm];
        ArrayList<VertexType> descendantObjects = new ArrayList<VertexType>(descendantIndices.length);
        for (int descendantIdx : descendantIndices) {
            VertexType descendantVertex = this.getVertex(descendantIdx);
            descendantObjects.add(descendantVertex);
        }
        return descendantObjects;
    }

    public ArrayList<VertexType> getAncestors(VertexType t) {
        int indexOfTerm = this.getVertexIndex(t);
        int[] ancestorIndices = this.vertexAncestors[indexOfTerm];
        ArrayList<VertexType> ancestorObjects = new ArrayList<VertexType>(ancestorIndices.length);
        for (int ancestorIdx : ancestorIndices) {
            VertexType ancestorVertex = this.getVertex(ancestorIdx);
            ancestorObjects.add(ancestorVertex);
        }
        return ancestorObjects;
    }

    private boolean isVertexInGraph(VertexType vertex) {
        return this.mapper.getIndex(vertex) != -1;
    }

    public ArrayList<VertexType> getParents(VertexType t) {
        int indexOfTerm = this.getVertexIndex(t);
        int[] parentIndices = this.vertexParents[indexOfTerm];
        ArrayList<VertexType> parentObjects = new ArrayList<VertexType>(parentIndices.length);
        for (int parentIdx : parentIndices) {
            VertexType parentVertex = this.getVertex(parentIdx);
            parentObjects.add(parentVertex);
        }
        return parentObjects;
    }

    public ArrayList<VertexType> getChildren(VertexType t) {
        int indexOfTerm = this.getVertexIndex(t);
        int[] childrenIndices = this.vertexChildren[indexOfTerm];
        ArrayList<VertexType> childrenObjects = new ArrayList<VertexType>(childrenIndices.length);
        for (int childIdx : childrenIndices) {
            VertexType childVertex = this.getVertex(childIdx);
            childrenObjects.add(childVertex);
        }
        return childrenObjects;
    }

    private static <V> void init(SlimDirectedGraphView<V> slim, DirectedGraph<V> graph) {
        V v;
        int i;
        slim.mapper = IntMapper.create(graph.getVertices(), graph.getNumberOfVertices());
        IntMapper<V> mapper = slim.mapper;
        slim.vertexParents = new int[mapper.getSize()][];
        for (i = 0; i < mapper.getSize(); ++i) {
            v = mapper.get(i);
            slim.vertexParents[i] = SlimDirectedGraphView.createIndicesFromIter(mapper, graph.getParentNodes(v));
        }
        slim.vertexAncestors = new int[mapper.getSize()][];
        for (i = 0; i < slim.mapper.getSize(); ++i) {
            v = mapper.get(i);
            final ArrayList ancestors = new ArrayList(20);
            graph.bfs(v, true, new AbstractGraph.IVisitor<V>(){

                @Override
                public boolean visited(V vertex) {
                    ancestors.add(vertex);
                    return true;
                }
            });
            slim.vertexAncestors[i] = SlimDirectedGraphView.createIndicesFromIter(mapper, ancestors.iterator());
            Arrays.sort(slim.vertexAncestors[i]);
        }
        slim.vertexChildren = new int[mapper.getSize()][];
        for (i = 0; i < mapper.getSize(); ++i) {
            v = mapper.get(i);
            slim.vertexChildren[i] = SlimDirectedGraphView.createIndicesFromIter(mapper, graph.getChildNodes(v));
        }
        slim.vertexDescendants = new int[mapper.getSize()][];
        for (i = 0; i < mapper.getSize(); ++i) {
            v = mapper.get(i);
            final ArrayList descendants = new ArrayList(20);
            graph.bfs(v, false, new AbstractGraph.IVisitor<V>(){

                @Override
                public boolean visited(V vertex) {
                    descendants.add(vertex);
                    return true;
                }
            });
            slim.vertexDescendants[i] = SlimDirectedGraphView.createIndicesFromIter(mapper, descendants.iterator());
            Arrays.sort(slim.vertexDescendants[i]);
        }
    }

    private static <V> int[] createIndicesFromIter(IntMapper<V> vertex2Index, Iterator<V> iterator) {
        ArrayList<Integer> indicesList = new ArrayList<Integer>(10);
        while (iterator.hasNext()) {
            V p = iterator.next();
            int idx = vertex2Index.getIndex(p);
            if (idx == -1) continue;
            indicesList.add(idx);
        }
        int[] indicesArray = new int[indicesList.size()];
        for (int i = 0; i < indicesList.size(); ++i) {
            indicesArray[i] = (Integer)indicesList.get(i);
        }
        return indicesArray;
    }

    public static <V> SlimDirectedGraphView<V> create(DirectedGraph<V> graph) {
        SlimDirectedGraphView g = new SlimDirectedGraphView();
        SlimDirectedGraphView.init(g, graph);
        return g;
    }

    public static <K, V> SlimDirectedGraphView<V> create(DirectedGraph<K> graph, final Map<K, V> map) {
        final SlimDirectedGraphView<K> kg = SlimDirectedGraphView.create(graph);
        SlimDirectedGraphView vg = new SlimDirectedGraphView();
        vg.vertexAncestors = kg.vertexAncestors;
        vg.vertexChildren = kg.vertexChildren;
        vg.vertexDescendants = kg.vertexDescendants;
        vg.vertexParents = kg.vertexParents;
        vg.mapper = IntMapper.create(new Iterable<V>(){

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(){
                    private int i = 0;
                    private int max;
                    {
                        this.max = kg.getNumberOfVertices();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i < this.max;
                    }

                    @Override
                    public V next() {
                        return map.map(kg.mapper.get(this.i++));
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        }, kg.mapper.getSize());
        return vg;
    }

    public static interface Map<K, V> {
        public V map(K var1);
    }
}

