/*
 * Decompiled with CFR 0.152.
 */
package sonumina.math.graph;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import sonumina.math.graph.AbstractGraph;
import sonumina.math.graph.Edge;
import sonumina.math.graph.VertexAttributes;

public class DirectedGraph<VertexType>
extends AbstractGraph<VertexType>
implements Iterable<VertexType>,
Serializable {
    private static final long serialVersionUID = 1L;
    private LinkedHashMap<VertexType, VertexAttributes<VertexType>> vertices = new LinkedHashMap();

    public void addVertex(VertexType vertex) {
        if (!this.vertices.containsKey(vertex)) {
            VertexAttributes va = new VertexAttributes();
            this.vertices.put(vertex, va);
        }
    }

    public void removeVertex(VertexType vertex) {
        VertexAttributes<VertexType> va = this.vertices.get(vertex);
        if (va != null) {
            Edge last;
            int lastPos;
            while (va.inEdges.size() > 0) {
                lastPos = va.inEdges.size() - 1;
                last = va.inEdges.get(lastPos);
                this.removeConnections(last.getSource(), last.getDest());
            }
            while (va.outEdges.size() > 0) {
                lastPos = va.outEdges.size() - 1;
                last = va.outEdges.get(lastPos);
                this.removeConnections(last.getSource(), last.getDest());
            }
            this.vertices.remove(vertex);
        }
    }

    private void removeVertexMaintainConnectivity(VertexType vertex) {
        VertexAttributes<VertexType> va = this.vertices.get(vertex);
        if (va != null) {
            for (Edge i : va.inEdges) {
                for (Edge o : va.outEdges) {
                    if (this.hasEdge(i.getSource(), o.getDest())) continue;
                    this.addEdge(new Edge(i.getSource(), o.getDest()));
                }
            }
            this.removeVertex(vertex);
        }
    }

    @Override
    public Iterable<VertexType> getVertices() {
        return this.vertices.keySet();
    }

    public DirectedGraph<VertexType> copyGraph() {
        DirectedGraph<VertexType> copy = new DirectedGraph<VertexType>();
        Iterator<VertexType> nodeIt = this.getVertexIterator();
        while (nodeIt.hasNext()) {
            copy.addVertex(nodeIt.next());
        }
        nodeIt = this.getVertexIterator();
        while (nodeIt.hasNext()) {
            VertexType node = nodeIt.next();
            Iterator<VertexType> descIt = this.getChildNodes(node);
            while (descIt.hasNext()) {
                copy.addEdge(new Edge<VertexType>(node, descIt.next()));
            }
        }
        return copy;
    }

    public int getNumberEdges() {
        int sum = 0;
        Iterator<VertexType> nodeIt = this.getVertexIterator();
        while (nodeIt.hasNext()) {
            VertexType node = nodeIt.next();
            sum += this.vertices.get(node).outEdges.size();
        }
        return sum;
    }

    public void addEdge(Edge<VertexType> edge) {
        VertexAttributes<VertexType> vaSource = this.vertices.get(edge.getSource());
        VertexAttributes<VertexType> vaDest = this.vertices.get(edge.getDest());
        if (vaSource == null || vaDest == null) {
            throw new IllegalArgumentException("Error when trying to add edge between source: " + vaSource + " and destination: " + vaDest + ".");
        }
        vaSource.outEdges.add(edge);
        vaDest.inEdges.add(edge);
    }

    public boolean hasEdge(VertexType source, VertexType dest) {
        VertexAttributes<VertexType> vaSource = this.vertices.get(source);
        for (Edge e : vaSource.outEdges) {
            if (!e.getDest().equals(dest)) continue;
            return true;
        }
        return false;
    }

    public void removeConnections(VertexType source, VertexType dest) {
        VertexAttributes<VertexType> vaSource = this.vertices.get(source);
        VertexAttributes<VertexType> vaDest = this.vertices.get(dest);
        if (vaSource == null || vaDest == null) {
            throw new IllegalArgumentException();
        }
        HashSet<Edge<Object>> deleteMe = new HashSet<Edge<Object>>();
        for (Edge edge : vaSource.outEdges) {
            if (!edge.getDest().equals(dest)) continue;
            deleteMe.add(edge);
        }
        if (deleteMe.size() > 1) {
            throw new RuntimeException(" found more than one edge to delete (" + deleteMe.size() + ") --> " + deleteMe);
        }
        for (Edge<Object> edge : deleteMe) {
            vaSource.outEdges.remove(edge);
        }
        deleteMe.clear();
        for (Edge<Object> edge : vaSource.inEdges) {
            if (!edge.getSource().equals(dest)) continue;
            deleteMe.add(edge);
        }
        if (deleteMe.size() > 1) {
            throw new RuntimeException(" found more than one edge to delete (" + deleteMe.size() + ") --> " + deleteMe);
        }
        for (Edge<Object> edge : deleteMe) {
            System.out.print("rem: " + edge.getSource() + " -> " + edge.getDest());
            vaSource.inEdges.remove(edge);
        }
        deleteMe.clear();
        for (Edge<Object> edge : vaDest.outEdges) {
            if (!edge.getDest().equals(source)) continue;
            deleteMe.add(edge);
        }
        if (deleteMe.size() > 1) {
            throw new RuntimeException(" found more than one edge to delete (" + deleteMe.size() + ") --> " + deleteMe);
        }
        for (Edge<Object> edge : deleteMe) {
            vaDest.outEdges.remove(edge);
        }
        deleteMe.clear();
        for (Edge<Object> edge : vaDest.inEdges) {
            if (!edge.getSource().equals(source)) continue;
            deleteMe.add(edge);
        }
        if (deleteMe.size() > 1) {
            throw new RuntimeException(" found more than one edge to delete! (" + deleteMe.size() + ") --> " + deleteMe);
        }
        for (Edge<Object> edge : deleteMe) {
            vaDest.inEdges.remove(edge);
        }
    }

    public Iterator<VertexType> getVertexIterator() {
        return this.vertices.keySet().iterator();
    }

    public Edge<VertexType> getEdge(VertexType source, VertexType dest) {
        VertexAttributes<VertexType> va = this.vertices.get(source);
        for (Edge e : va.outEdges) {
            if (!e.getDest().equals(dest)) continue;
            return e;
        }
        return null;
    }

    public int getNumberOfInEdges(VertexType v) {
        VertexAttributes<VertexType> va = this.vertices.get(v);
        assert (va != null);
        return va.inEdges.size();
    }

    public Iterator<Edge<VertexType>> getInEdges(VertexType v) {
        VertexAttributes<VertexType> va = this.vertices.get(v);
        assert (va != null);
        return va.inEdges.iterator();
    }

    @Override
    public Iterator<VertexType> getParentNodes(VertexType vt) {
        final Iterator<Edge<VertexType>> iter = this.getInEdges(vt);
        return new Iterator<VertexType>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public VertexType next() {
                return ((Edge)iter.next()).getSource();
            }

            @Override
            public void remove() {
            }
        };
    }

    public int getNumberOfOutEdges(VertexType v) {
        VertexAttributes<VertexType> va = this.vertices.get(v);
        assert (va != null);
        return va.outEdges.size();
    }

    public double getClusteringCoefficient(VertexType v) {
        VertexAttributes<VertexType> va = this.vertices.get(v);
        assert (va != null);
        HashSet<VertexType> neighborhood = new HashSet<VertexType>();
        Iterator<VertexType> neighborsIt = this.getChildNodes(v);
        while (neighborsIt.hasNext()) {
            neighborhood.add(neighborsIt.next());
        }
        int numberNeighbors = neighborhood.size();
        if (numberNeighbors < 2) {
            return 0.0;
        }
        int numEdgesNeighborhood = 0;
        for (Object neighbor : neighborhood) {
            Iterator neighborsNeighborsIt = this.getChildNodes(neighbor);
            while (neighborsNeighborsIt.hasNext()) {
                Object neighborsNeighbor = neighborsNeighborsIt.next();
                if (neighborsNeighbor == v || neighborsNeighbor == neighbor || !neighborhood.contains(neighborsNeighbor)) continue;
                ++numEdgesNeighborhood;
            }
        }
        double denominator = numberNeighbors * (numberNeighbors - 1);
        double C = (double)numEdgesNeighborhood / denominator;
        return C;
    }

    public Iterator<Edge<VertexType>> getOutEdges(VertexType v) {
        VertexAttributes<VertexType> va = this.vertices.get(v);
        assert (va != null);
        return va.outEdges.iterator();
    }

    @Override
    public Iterator<VertexType> getChildNodes(VertexType vt) {
        final Iterator<Edge<VertexType>> iter = this.getOutEdges(vt);
        return new Iterator<VertexType>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public VertexType next() {
                return ((Edge)iter.next()).getDest();
            }

            @Override
            public void remove() {
            }
        };
    }

    public Iterable<VertexType> getDescendantVertices(VertexType v) {
        VertexAttributes<VertexType> va = this.vertices.get(v);
        assert (va != null);
        ArrayList descendant = new ArrayList(va.outEdges.size());
        for (Edge e : va.outEdges) {
            descendant.add(e.getDest());
        }
        return descendant;
    }

    public void singleSourceShortestPath(VertexType vertex, boolean againstFlow, IDistanceVisitor<VertexType> visitor) {
        if (!this.vertices.containsKey(vertex)) {
            throw new IllegalArgumentException(vertex + " not found.");
        }
        PriorityQueue<VertexExtension> queue = new PriorityQueue<VertexExtension>();
        HashMap map = new HashMap();
        class VertexExtension
        implements Comparable<VertexExtension> {
            public VertexType vertex;
            public int distance;
            public VertexType parent;

            VertexExtension(VertexType vertex, int distance, VertexType parent) {
                this.vertex = vertex;
                this.distance = distance;
                this.parent = parent;
            }

            @Override
            public int compareTo(VertexExtension arg0) {
                return this.distance - arg0.distance;
            }

            public int hashCode() {
                return this.vertex.hashCode();
            }
        }
        VertexExtension ve = new VertexExtension(vertex, 0, null);
        queue.offer(ve);
        map.put(ve.vertex, ve);
        while (!queue.isEmpty()) {
            VertexExtension next = (VertexExtension)queue.poll();
            Iterator edgeIter = againstFlow ? this.getInEdges(next.vertex) : this.getOutEdges(next.vertex);
            while (edgeIter.hasNext()) {
                Edge edge = edgeIter.next();
                Object neighbour = againstFlow ? edge.getSource() : edge.getDest();
                VertexExtension neighbourExt = (VertexExtension)map.get(neighbour);
                if (neighbourExt == null) {
                    neighbourExt = new VertexExtension(neighbour, next.distance + edge.getWeight(), next.vertex);
                    map.put(neighbour, neighbourExt);
                    queue.offer(neighbourExt);
                    continue;
                }
                if (neighbourExt.distance <= next.distance + edge.getWeight()) continue;
                queue.remove(neighbourExt);
                neighbourExt.distance = next.distance + edge.getWeight();
                neighbourExt.parent = next.vertex;
                queue.offer(neighbourExt);
            }
        }
        for (Map.Entry v : map.entrySet()) {
            LinkedList ll = new LinkedList();
            VertexExtension curVe = (VertexExtension)v.getValue();
            do {
                ll.addFirst(curVe.vertex);
            } while ((curVe = (VertexExtension)map.get(curVe.parent)) != null);
            if (visitor.visit(((VertexExtension)v.getValue()).vertex, ll, ((VertexExtension)v.getValue()).distance)) continue;
            return;
        }
    }

    public void bf(VertexType source, int weightMultiplier, IDistanceVisitor<VertexType> visitor) {
        HashMap map = new HashMap();
        class VertexExtension
        implements Comparable<VertexExtension> {
            public VertexType vertex;
            public int distance;
            public VertexType parent;

            public VertexExtension(VertexType vertex, int distance, VertexType parent) {
                this.vertex = vertex;
                this.distance = distance;
                this.parent = parent;
            }

            @Override
            public int compareTo(VertexExtension arg0) {
                return this.distance - arg0.distance;
            }

            public int hashCode() {
                return this.vertex.hashCode();
            }
        }
        map.put(source, new VertexExtension(source, 0, null));
        for (int i = 0; i < this.vertices.size(); ++i) {
            boolean changed = false;
            for (Map.Entry<VertexType, VertexAttributes<VertexType>> ent : this.vertices.entrySet()) {
                VertexType u = ent.getKey();
                VertexExtension uExt = (VertexExtension)map.get(u);
                if (uExt == null) continue;
                for (Edge edge : ent.getValue().outEdges) {
                    Object v = edge.getDest();
                    VertexExtension vExt = (VertexExtension)map.get(v);
                    if (vExt == null) {
                        vExt = new VertexExtension(v, uExt.distance + edge.getWeight() * weightMultiplier, u);
                        map.put(v, vExt);
                        changed = true;
                        continue;
                    }
                    if (vExt.distance <= uExt.distance + edge.getWeight() * weightMultiplier) continue;
                    vExt.distance = uExt.distance + edge.getWeight() * weightMultiplier;
                    vExt.parent = u;
                    changed = true;
                }
            }
            if (!changed) break;
        }
        for (Map.Entry v : map.entrySet()) {
            LinkedList ll = new LinkedList();
            VertexExtension curVe = (VertexExtension)v.getValue();
            do {
                ll.addFirst(curVe.vertex);
            } while ((curVe = (VertexExtension)map.get(curVe.parent)) != null);
            if (visitor.visit(((VertexExtension)v.getValue()).vertex, ll, ((VertexExtension)v.getValue()).distance)) continue;
            return;
        }
    }

    public void singleSourceShortestPathBF(VertexType source, IDistanceVisitor<VertexType> visitor) {
        this.bf(source, 1, visitor);
    }

    public void singleSourceLongestPath(VertexType source, final IDistanceVisitor<VertexType> visitor) {
        this.bf(source, -1, new IDistanceVisitor<VertexType>(){

            @Override
            public boolean visit(VertexType vertex, List<VertexType> path, int distance) {
                return visitor.visit(vertex, path, distance * -1);
            }
        });
    }

    public int getNumberOfPaths(VertexType source, VertexType dest) {
        if (source.equals(dest)) {
            return 1;
        }
        int paths = 0;
        for (VertexType next : this.getDescendantVertices(source)) {
            paths += this.getNumberOfPaths(next, dest);
        }
        return paths;
    }

    public ArrayList<VertexType> getAllPathes(VertexType source, VertexType dest, ArrayList<VertexType> pathes) {
        if (source.equals(dest)) {
            ArrayList<VertexType> ret = new ArrayList<VertexType>();
            ret.add(dest);
            return ret;
        }
        for (VertexType next : this.getDescendantVertices(source)) {
            ArrayList<VertexType> rec = this.getAllPathes(next, dest, pathes);
            System.out.println("recur: " + rec);
            pathes.addAll(rec);
        }
        return pathes;
    }

    public VertexType getArbitaryNode() {
        return this.vertices.entrySet().iterator().next().getKey();
    }

    public int getNumberOfVertices() {
        return this.vertices.size();
    }

    @Override
    public Iterator<VertexType> iterator() {
        return this.vertices.keySet().iterator();
    }

    public int getInDegree(VertexType v) {
        VertexAttributes<VertexType> va = this.vertices.get(v);
        if (va == null) {
            return -1;
        }
        return va.inEdges.size();
    }

    public int getOutDegree(VertexType v) {
        VertexAttributes<VertexType> va = this.vertices.get(v);
        if (va == null) {
            return -1;
        }
        return va.outEdges.size();
    }

    public int getMaxDegree() {
        int max = Integer.MIN_VALUE;
        for (VertexType vertex : this.vertices.keySet()) {
            int degreeOut = this.getNumberOfOutEdges(vertex);
            int degreeIn = this.getNumberOfInEdges(vertex);
            if (degreeIn != degreeOut) {
                throw new RuntimeException("Vertex " + vertex + " has indegree:" + degreeIn + " and outdegree:" + degreeOut);
            }
            if (degreeOut <= max) continue;
            max = degreeOut;
        }
        return max;
    }

    public boolean areNeighbors(VertexType node1, VertexType node2) {
        if (node1.equals(node2)) {
            return true;
        }
        VertexAttributes<VertexType> va = this.vertices.get(node1);
        for (Edge e : va.inEdges) {
            Object ancestor = e.getSource();
            if (!ancestor.equals(node2)) continue;
            return true;
        }
        for (Edge e : va.outEdges) {
            Object desc = e.getDest();
            if (!desc.equals(node2)) continue;
            return true;
        }
        return false;
    }

    public DirectedGraph<VertexType> subGraph(Collection<VertexType> verticesToBeIncluded) {
        return this.subGraph((Set<VertexType>)new HashSet<VertexType>(verticesToBeIncluded));
    }

    public DirectedGraph<VertexType> subGraph(Set<VertexType> verticesToBeIncluded) {
        DirectedGraph<VertexType> graph = new DirectedGraph<VertexType>();
        for (VertexType v : verticesToBeIncluded) {
            graph.addVertex(v);
        }
        for (VertexType v : verticesToBeIncluded) {
            Iterator<Edge<VertexType>> edges = this.getInEdges(v);
            while (edges.hasNext()) {
                Edge<VertexType> e = edges.next();
                if (!verticesToBeIncluded.contains(e.getSource())) continue;
                graph.addEdge(e);
            }
        }
        return graph;
    }

    public DirectedGraph<VertexType> transitiveClosureOfSubGraph(final Set<VertexType> verticesToBeIncluded) {
        final DirectedGraph<VertexType> graph = new DirectedGraph<VertexType>();
        for (VertexType v : verticesToBeIncluded) {
            graph.addVertex(v);
        }
        for (final VertexType v1 : verticesToBeIncluded) {
            this.bfs(v1, false, new AbstractGraph.IVisitor<VertexType>(){

                @Override
                public boolean visited(VertexType vertex) {
                    if (verticesToBeIncluded.contains(vertex)) {
                        graph.addEdge(new Edge<Object>(v1, vertex));
                    }
                    return true;
                }
            });
        }
        return graph;
    }

    private DirectedGraph<VertexType> compactedSubgraph(Set<VertexType> verticesToBeIncluded) {
        DirectedGraph<VertexType> graph = this.copyGraph();
        for (VertexType v : this) {
            if (verticesToBeIncluded.contains(v)) continue;
            super.removeVertexMaintainConnectivity(v);
        }
        return graph;
    }

    public DirectedGraph<VertexType> pathMaintainingSubGraph(Set<VertexType> verticesToBeIncluded) {
        DirectedGraph<Object> transitivitySubGraph;
        boolean reducedInIteration;
        DirectedGraph<VertexType> transitiveClosure = this.compactedSubgraph(verticesToBeIncluded);
        do {
            reducedInIteration = false;
            transitivitySubGraph = new DirectedGraph<Object>();
            for (VertexType v : verticesToBeIncluded) {
                transitivitySubGraph.addVertex(v);
            }
            for (VertexType v : verticesToBeIncluded) {
                Set<Object> vUpperVertices = transitiveClosure.getVerticesOfUpperInducedGraph(null, v);
                LinkedList<VertexType> parents = new LinkedList<VertexType>();
                Iterator<VertexType> parentIterator = transitiveClosure.getParentNodes(v);
                while (parentIterator.hasNext()) {
                    parents.add(parentIterator.next());
                }
                for (Object p : parents) {
                    HashSet<Object> pUpperVertices = new HashSet<Object>();
                    for (Object p2 : parents) {
                        if (p.equals(p2)) continue;
                        pUpperVertices.addAll(transitiveClosure.getVerticesOfUpperInducedGraph(null, p2));
                    }
                    if (pUpperVertices.size() != vUpperVertices.size() - 1) {
                        transitivitySubGraph.addEdge(new Edge(p, v));
                        continue;
                    }
                    reducedInIteration = true;
                }
            }
            transitiveClosure = transitivitySubGraph;
        } while (reducedInIteration);
        return transitivitySubGraph;
    }

    public Set<VertexType> getVerticesOfUpperInducedGraph(final VertexType root, VertexType termID) {
        class Visitor
        implements AbstractGraph.IVisitor<VertexType> {
            public HashSet<VertexType> nodeSet = new HashSet();

            Visitor() {
            }

            @Override
            public boolean visited(VertexType vertex) {
                if (root != null) {
                    if (vertex.equals(root) || DirectedGraph.this.existsPath(root, vertex)) {
                        this.nodeSet.add(vertex);
                    }
                } else {
                    this.nodeSet.add(vertex);
                }
                return true;
            }
        }
        Visitor visitor = new Visitor();
        this.bfs(termID, true, visitor);
        return visitor.nodeSet;
    }

    public void mergeVertices(VertexType vertex1, Iterable<VertexType> eqVertices) {
        for (VertexType vertex2 : eqVertices) {
            if (!this.vertices.containsKey(vertex2)) {
                return;
            }
            VertexAttributes<VertexType> vertexTwoAttributes = this.vertices.get(vertex2);
            for (Edge e : vertexTwoAttributes.inEdges) {
                e.setDest(vertex1);
            }
            for (Edge e : vertexTwoAttributes.outEdges) {
                e.setSource(vertex1);
            }
            this.vertices.remove(vertex2);
        }
    }

    public boolean containsVertex(VertexType vertex) {
        return this.vertices.containsKey(vertex);
    }

    public static interface IDistanceVisitor<VertexType> {
        public boolean visit(VertexType var1, List<VertexType> var2, int var3);
    }
}

