/*
 * Decompiled with CFR 0.152.
 */
package sonumina.math.graph;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;
import sonumina.collections.TinyQueue;

public abstract class AbstractGraph<VertexType>
implements Serializable {
    private static final long serialVersionUID = 1L;

    public abstract Iterator<VertexType> getParentNodes(VertexType var1);

    public abstract Iterator<VertexType> getChildNodes(VertexType var1);

    public void bfs(VertexType vertex, boolean againstFlow, IVisitor<VertexType> visitor) {
        ArrayList<VertexType> initial = new ArrayList<VertexType>(1);
        initial.add(vertex);
        this.bfs((Collection<VertexType>)initial, againstFlow, visitor);
    }

    public void bfs(VertexType vertex, INeighbourGrabber<VertexType> grabber, IVisitor<VertexType> visitor) {
        ArrayList<VertexType> initial = new ArrayList<VertexType>(1);
        initial.add(vertex);
        this.bfs((Collection<VertexType>)initial, grabber, visitor);
    }

    public void bfs(Collection<VertexType> initial, final boolean againstFlow, IVisitor<VertexType> visitor) {
        this.bfs(initial, new INeighbourGrabber<VertexType>(){

            @Override
            public Iterator<VertexType> grabNeighbours(VertexType t) {
                if (againstFlow) {
                    return AbstractGraph.this.getParentNodes(t);
                }
                return AbstractGraph.this.getChildNodes(t);
            }
        }, visitor);
    }

    public void bfs(Collection<VertexType> initial, INeighbourGrabber<VertexType> grabber, IVisitor<VertexType> visitor) {
        HashSet<VertexType> visited = new HashSet<VertexType>();
        TinyQueue<VertexType> queue = new TinyQueue<VertexType>();
        for (VertexType vertex : initial) {
            queue.offer(vertex);
            visited.add(vertex);
            if (visitor.visited(vertex)) continue;
            return;
        }
        while (!queue.isEmpty()) {
            Object head = queue.poll();
            Iterator<VertexType> neighbours = grabber.grabNeighbours(head);
            while (neighbours.hasNext()) {
                VertexType neighbour = neighbours.next();
                if (visited.contains(neighbour)) continue;
                queue.offer(neighbour);
                visited.add(neighbour);
                if (visitor.visited(neighbour)) continue;
                return;
            }
        }
    }

    public void dfs(VertexType vertex, INeighbourGrabber<VertexType> grabber, IVisitor<VertexType> visitor) {
        HashSet<VertexType> visited = new HashSet<VertexType>();
        Stack<VertexType> stack = new Stack<VertexType>();
        visited.add(vertex);
        stack.push(vertex);
        while (!stack.isEmpty()) {
            Object v = stack.pop();
            visitor.visited(v);
            Iterator<VertexType> iter = grabber.grabNeighbours(v);
            while (iter.hasNext()) {
                VertexType n = iter.next();
                if (visited.contains(n)) continue;
                stack.push(n);
                visited.add(n);
            }
        }
    }

    private void getDFSShotcutLinks(VertexType v, HashMap<VertexType, VertexType> map, HashSet<VertexType> visited, ArrayList<VertexType> upwardQueue, INeighbourGrabber<VertexType> grabber, IVisitor<VertexType> visitor) {
        visitor.visited(v);
        Iterator<VertexType> iter = grabber.grabNeighbours(v);
        while (iter.hasNext()) {
            VertexType n = iter.next();
            if (visited.contains(n)) continue;
            if (upwardQueue.size() > 0) {
                for (VertexType t : upwardQueue) {
                    map.put(t, n);
                }
                upwardQueue.clear();
            }
            visited.add(n);
            this.getDFSShotcutLinks(n, map, visited, upwardQueue, grabber, visitor);
        }
        upwardQueue.add(v);
    }

    public HashMap<VertexType, VertexType> getDFSShotcutLinks(VertexType vt, INeighbourGrabber<VertexType> grabber, IVisitor<VertexType> visitor) {
        HashMap map = new HashMap();
        ArrayList upwardQueue = new ArrayList();
        this.getDFSShotcutLinks(vt, map, new HashSet(), upwardQueue, grabber, visitor);
        for (Object t : upwardQueue) {
            map.put(t, null);
        }
        return map;
    }

    public boolean existsPath(VertexType source, final VertexType dest) {
        class ExistsPathVisitor
        implements IVisitor<VertexType> {
            boolean found;

            ExistsPathVisitor() {
            }

            @Override
            public boolean visited(VertexType vertex) {
                if (vertex.equals(dest)) {
                    this.found = true;
                    return false;
                }
                return true;
            }
        }
        ExistsPathVisitor epv = new ExistsPathVisitor();
        this.bfs(source, false, epv);
        return epv.found;
    }

    public ArrayList<VertexType> topologicalOrder() {
        HashMap vertex2Children = new HashMap();
        HashMap<Object, Integer> vertex2NumParents = new HashMap<Object, Integer>();
        LinkedList<Object> verticesWithNoParents = new LinkedList<Object>();
        for (VertexType v : this.getVertices()) {
            LinkedList<VertexType> vChild = new LinkedList<VertexType>();
            Iterator<VertexType> childrenIterator = this.getChildNodes(v);
            while (childrenIterator.hasNext()) {
                vChild.add(childrenIterator.next());
            }
            vertex2Children.put(v, vChild);
            int numParents = 0;
            Iterator<VertexType> parentIterator = this.getParentNodes(v);
            while (parentIterator.hasNext()) {
                parentIterator.next();
                ++numParents;
            }
            if (numParents == 0) {
                verticesWithNoParents.add(v);
                continue;
            }
            vertex2NumParents.put(v, numParents);
        }
        int numOfVertices = vertex2Children.size();
        ArrayList order = new ArrayList(numOfVertices);
        while (!verticesWithNoParents.isEmpty()) {
            Object top = verticesWithNoParents.poll();
            order.add(top);
            for (Object p : (LinkedList)vertex2Children.get(top)) {
                int newNumParents = (Integer)vertex2NumParents.get(p) - 1;
                vertex2NumParents.put(p, newNumParents);
                if (newNumParents != 0) continue;
                verticesWithNoParents.offer(p);
            }
        }
        return order;
    }

    public abstract Iterable<VertexType> getVertices();

    public static class DotAttributesProvider<VertexType> {
        public String getDotNodeName(VertexType vt) {
            return null;
        }

        public String getDotNodeAttributes(VertexType vt) {
            return null;
        }

        public String getDotEdgeAttributes(VertexType src, VertexType dest) {
            return null;
        }

        public String getDotGraphAttributes() {
            return "nodesep=0.4; ranksep=0.4;";
        }

        public String getDotHeader() {
            return null;
        }
    }

    public static interface INeighbourGrabber<VertexType> {
        public Iterator<VertexType> grabNeighbours(VertexType var1);
    }

    public static interface IVisitor<VertexType> {
        public boolean visited(VertexType var1);
    }
}

