/*
 * Decompiled with CFR 0.152.
 */
package sonumina.collections;

import java.io.Serializable;

public class TinyQueue<Type>
implements Serializable {
    private static final long serialVersionUID = 1L;
    TinyElement<Type> head;
    TinyElement<Type> tail;
    TinyElement<Type> headOfFree;

    private TinyElement<Type> allocateElement() {
        if (this.headOfFree != null) {
            TinyElement<Type> te = this.headOfFree;
            this.headOfFree = te.next;
            te.next = null;
            return te;
        }
        return new TinyElement();
    }

    private void deallocateElement(TinyElement<Type> t) {
        t.next = this.headOfFree;
        this.headOfFree = t;
    }

    public void offer(Type t) {
        TinyElement<Type> te = this.allocateElement();
        te.t = t;
        if (this.head == null) {
            this.tail = te;
            this.head = this.tail;
        } else {
            this.tail.next = te;
            this.tail = te;
        }
    }

    public Type poll() {
        TinyElement<Type> te = this.head;
        this.head = te.next;
        if (this.head == null) {
            this.tail = null;
        }
        this.deallocateElement(te);
        return te.t;
    }

    public boolean isEmpty() {
        return this.head == null;
    }

    private static final class TinyElement<Type>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        TinyElement<Type> next;
        Type t;

        private TinyElement() {
        }
    }
}

