/*
 * Decompiled with CFR 0.152.
 */
package sonumina.collections;

import java.io.Serializable;
import java.util.Arrays;

public class ObjectIntHashMap<K>
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int EMPTY_VALUE = 0;
    private static final int OCCUPIED_DATA_RATIO = 2;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private static final Object NULL_KEY = new Object(){

        public boolean equals(Object obj) {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public int hashCode() {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public String toString() {
            return "ObjectIntHashMap.NULL_KEY";
        }
    };
    private static final Object REMOVED_KEY = new Object(){

        public boolean equals(Object obj) {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public int hashCode() {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public String toString() {
            return "ObjectIntHashMap.REMOVED_KEY";
        }
    };
    private Object[] keys;
    private int[] values;
    private int occupiedWithData;
    private int occupiedWithSentinels;

    public ObjectIntHashMap() {
        this.allocateTable(16);
    }

    public ObjectIntHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(initialCapacity * 2));
        this.allocateTable(capacity);
    }

    public ObjectIntHashMap(ObjectIntHashMap<? extends K> map) {
        this(Math.max(map.size(), 8));
        this.putAll(map);
    }

    public static <K> ObjectIntHashMap<K> newMap() {
        return new ObjectIntHashMap<K>();
    }

    public static <K> ObjectIntHashMap<K> newWithKeysValues(K key1, int value1) {
        return new ObjectIntHashMap<K>(1).withKeyValue(key1, value1);
    }

    public static <K> ObjectIntHashMap<K> newWithKeysValues(K key1, int value1, K key2, int value2) {
        return new ObjectIntHashMap<K>(2).withKeysValues(key1, value1, key2, value2);
    }

    public static <K> ObjectIntHashMap<K> newWithKeysValues(K key1, int value1, K key2, int value2, K key3, int value3) {
        return new ObjectIntHashMap<K>(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static <K> ObjectIntHashMap<K> newWithKeysValues(K key1, int value1, K key2, int value2, K key3, int value3, K key4, int value4) {
        return new ObjectIntHashMap<K>(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ObjectIntHashMap)) {
            return false;
        }
        ObjectIntHashMap other = (ObjectIntHashMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectIntHashMap.isNonSentinel(this.keys[i]) || other.containsKey(this.toNonSentinel(this.keys[i])) && this.values[i] == other.getOrThrow(this.toNonSentinel(this.keys[i]))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectIntHashMap.isNonSentinel(this.keys[i])) continue;
            result += (this.toNonSentinel(this.keys[i]) == null ? 0 : this.keys[i].hashCode()) ^ this.values[i];
        }
        return result;
    }

    public String toString() {
        StringBuilder appendable = new StringBuilder();
        appendable.append("{");
        boolean first = true;
        for (int i = 0; i < this.keys.length; ++i) {
            Object key = this.keys[i];
            if (!ObjectIntHashMap.isNonSentinel(key)) continue;
            if (!first) {
                appendable.append(", ");
            }
            appendable.append(this.toNonSentinel(key)).append("=").append(this.values[i]);
            first = false;
        }
        appendable.append("}");
        return appendable.toString();
    }

    public int size() {
        return this.occupiedWithData;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean notEmpty() {
        return this.size() != 0;
    }

    public int[] toArray() {
        int[] result = new int[this.size()];
        int index = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectIntHashMap.isNonSentinel(this.keys[i])) continue;
            result[index] = this.values[i];
            ++index;
        }
        return result;
    }

    public boolean contains(int value) {
        return this.containsValue(value);
    }

    public boolean containsAll(int ... source) {
        for (int item : source) {
            if (this.containsValue(item)) continue;
            return false;
        }
        return true;
    }

    public void clear() {
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        Arrays.fill(this.keys, null);
        Arrays.fill(this.values, 0);
    }

    public void put(K key, int value) {
        int index = this.probe(key);
        if (ObjectIntHashMap.isNonSentinel(this.keys[index]) && ObjectIntHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            this.values[index] = value;
            return;
        }
        this.addKeyValueAtIndex(key, value, index);
    }

    public void putAll(ObjectIntHashMap<? extends K> map) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectIntHashMap.isNonSentinel(this.keys[i])) continue;
            this.put(this.toNonSentinel(this.keys[i]), this.values[i]);
        }
    }

    public void removeKey(K key) {
        int index = this.probe(key);
        this.removeKeyAtIndex(key, index);
    }

    private void removeKeyAtIndex(K key, int index) {
        if (ObjectIntHashMap.isNonSentinel(this.keys[index]) && ObjectIntHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            this.keys[index] = REMOVED_KEY;
            this.values[index] = 0;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
        }
    }

    public void remove(K key) {
        this.removeKey(key);
    }

    public int removeKeyIfAbsent(K key, int value) {
        int index = this.probe(key);
        if (ObjectIntHashMap.isNonSentinel(this.keys[index]) && ObjectIntHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            this.keys[index] = REMOVED_KEY;
            int oldValue = this.values[index];
            this.values[index] = 0;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            return oldValue;
        }
        return value;
    }

    public int getIfAbsentPut(K key, int value) {
        int index = this.probe(key);
        if (ObjectIntHashMap.isNonSentinel(this.keys[index]) && ObjectIntHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    private void addKeyValueAtIndex(K key, int value, int index) {
        if (this.keys[index] == REMOVED_KEY) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = ObjectIntHashMap.toSentinelIfNull(key);
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData + this.occupiedWithSentinels > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    public int addToValue(K key, int toBeAdded) {
        int index = this.probe(key);
        if (ObjectIntHashMap.isNonSentinel(this.keys[index]) && ObjectIntHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            int n = index;
            this.values[n] = this.values[n] + toBeAdded;
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, toBeAdded, index);
        return this.values[index];
    }

    public ObjectIntHashMap<K> withKeyValue(K key1, int value1) {
        this.put(key1, value1);
        return this;
    }

    public ObjectIntHashMap<K> withKeysValues(K key1, int value1, K key2, int value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public ObjectIntHashMap<K> withKeysValues(K key1, int value1, K key2, int value2, K key3, int value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public ObjectIntHashMap<K> withKeysValues(K key1, int value1, K key2, int value2, K key3, int value3, K key4, int value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    public ObjectIntHashMap<K> withoutKey(K key) {
        this.removeKey(key);
        return this;
    }

    public ObjectIntHashMap<K> withoutAllKeys(Iterable<? extends K> keys) {
        for (K key : keys) {
            this.removeKey(key);
        }
        return this;
    }

    public int get(Object key) {
        return this.getIfAbsent(key, 0);
    }

    public int getOrThrow(Object key) {
        int index = this.probe(key);
        if (ObjectIntHashMap.isNonSentinel(this.keys[index])) {
            return this.values[index];
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public int getIfAbsent(Object key, int ifAbsent) {
        int index = this.probe(key);
        if (ObjectIntHashMap.isNonSentinel(this.keys[index]) && ObjectIntHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values[index];
        }
        return ifAbsent;
    }

    public boolean containsKey(Object key) {
        int index = this.probe(key);
        return ObjectIntHashMap.isNonSentinel(this.keys[index]) && ObjectIntHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key);
    }

    public boolean containsValue(int value) {
        for (int i = 0; i < this.values.length; ++i) {
            if (!ObjectIntHashMap.isNonSentinel(this.keys[i]) || this.values[i] != value) continue;
            return true;
        }
        return false;
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehashAndGrow() {
        this.rehash(this.keys.length << 1);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        Object[] old = this.keys;
        int[] oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!ObjectIntHashMap.isNonSentinel(old[i])) continue;
            this.put(this.toNonSentinel(old[i]), oldValues[i]);
        }
    }

    int probe(Object element) {
        int index = this.spread(element);
        int removedIndex = -1;
        if (ObjectIntHashMap.isRemovedKey(this.keys[index])) {
            removedIndex = index;
        } else if (this.keys[index] == null || ObjectIntHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), element)) {
            return index;
        }
        int nextIndex = index;
        int probe = 17;
        while (true) {
            nextIndex += probe;
            probe += 17;
            if (ObjectIntHashMap.isRemovedKey(this.keys[nextIndex &= this.keys.length - 1])) {
                if (removedIndex != -1) continue;
                removedIndex = nextIndex;
                continue;
            }
            if (ObjectIntHashMap.nullSafeEquals(this.toNonSentinel(this.keys[nextIndex]), element)) {
                return nextIndex;
            }
            if (this.keys[nextIndex] == null) break;
        }
        return removedIndex == -1 ? nextIndex : removedIndex;
    }

    int spread(Object element) {
        int h = element == null ? 0 : element.hashCode();
        h ^= h >>> 20 ^ h >>> 12;
        h ^= h >>> 7 ^ h >>> 4;
        return h & this.keys.length - 1;
    }

    private static boolean nullSafeEquals(Object value, Object other) {
        return value == null ? other == null : other == value || value.equals(other);
    }

    private void allocateTable(int sizeToAllocate) {
        this.keys = new Object[sizeToAllocate];
        this.values = new int[sizeToAllocate];
    }

    private static boolean isRemovedKey(Object key) {
        return key == REMOVED_KEY;
    }

    private static <K> boolean isNonSentinel(K key) {
        return key != null && !ObjectIntHashMap.isRemovedKey(key);
    }

    private K toNonSentinel(Object key) {
        return (K)(key == NULL_KEY ? null : key);
    }

    private static Object toSentinelIfNull(Object key) {
        return key == null ? NULL_KEY : key;
    }

    private int maxOccupiedWithData() {
        int capacity = this.keys.length;
        return Math.min(capacity - 1, capacity / 2);
    }

    public void forEachKeyValue(ObjectIntProcedure<? super K> procedure) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectIntHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.keyValue(this.toNonSentinel(this.keys[i]), this.values[i]);
        }
    }

    public static interface ObjectIntProcedure<K> {
        public void keyValue(K var1, int var2);
    }
}

