/*
 * Decompiled with CFR 0.152.
 */
package sonumina.collections;

import java.io.Serializable;
import java.util.Collection;
import sonumina.collections.ObjectIntHashMap;

public final class IntMapper<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Object[] item;
    private ObjectIntHashMap<T> item2Index;

    private IntMapper(Iterable<T> iterable, int size) {
        this.item = new Object[size];
        this.item2Index = new ObjectIntHashMap(size);
        int i = 0;
        for (T t : iterable) {
            this.item[i] = t;
            this.item2Index.put(t, i);
            ++i;
        }
    }

    public T get(int i) {
        return (T)this.item[i];
    }

    public int getIndex(T t) {
        return this.item2Index.getIfAbsent(t, -1);
    }

    public int getSize() {
        return this.item.length;
    }

    public boolean[] getDense(Collection<T> collection) {
        boolean[] d = new boolean[this.item.length];
        for (T c : collection) {
            d[this.getIndex(c)] = true;
        }
        return d;
    }

    public static <T> IntMapper<T> create(Collection<T> collection) {
        return new IntMapper<T>(collection, collection.size());
    }

    public static <T> IntMapper<T> create(Iterable<T> iterable, int size) {
        return new IntMapper<T>(iterable, size);
    }
}

