/*
 * Decompiled with CFR 0.152.
 */
package ontologizer.util;

import java.io.File;
import java.util.Arrays;

public final class Util {
    private static byte[] digits = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57};

    private Util() {
    }

    public static File getAppDataDirectory(String appName) {
        File app;
        String dirName = System.getenv("APPDATA");
        if (dirName == null) {
            dirName = System.getProperty("user.home");
        }
        if ((app = new File(dirName)).exists() && app.isDirectory()) {
            File onto = new File(app, "." + appName);
            if (!onto.exists()) {
                onto.mkdir();
            }
            if (onto.exists()) {
                return onto;
            }
            return onto;
        }
        return null;
    }

    public static String wrapLine(String line, String newline, int wrapColumn) {
        StringBuilder wrappedLine = new StringBuilder();
        while (line.length() > wrapColumn) {
            int spaceToWrapAt = line.lastIndexOf(32, wrapColumn);
            if (spaceToWrapAt >= 0) {
                wrappedLine.append(line.substring(0, spaceToWrapAt));
                wrappedLine.append(newline);
                line = line.substring(spaceToWrapAt + 1);
                continue;
            }
            spaceToWrapAt = line.indexOf(32, wrapColumn);
            if (spaceToWrapAt >= 0) {
                wrappedLine.append(line.substring(0, spaceToWrapAt));
                wrappedLine.append(newline);
                line = line.substring(spaceToWrapAt + 1);
                continue;
            }
            wrappedLine.append(line);
            line = "";
        }
        wrappedLine.append(line);
        return wrappedLine.toString();
    }

    public static int lengthOf(int value) {
        if (value < 0) {
            throw new IllegalArgumentException();
        }
        if (value <= 9) {
            return 1;
        }
        if (value <= 99) {
            return 2;
        }
        if (value <= 999) {
            return 3;
        }
        if (value <= 9999) {
            return 4;
        }
        if (value <= 99999) {
            return 5;
        }
        if (value <= 999999) {
            return 6;
        }
        if (value <= 9999999) {
            return 7;
        }
        if (value <= 99999999) {
            return 8;
        }
        if (value <= 999999999) {
            return 9;
        }
        return 10;
    }

    public static void intToByteArray(int value, byte[] dest, int offset) {
        if (value < 0) {
            throw new IllegalArgumentException();
        }
        int current = offset + Util.lengthOf(value);
        while (value > 0) {
            dest[--current] = digits[value % 10];
            value /= 10;
        }
    }

    private static int commonIntsWithResult(int[] a, int[] b, int[] c) {
        int numCommon = 0;
        int i = 0;
        int j = 0;
        while (i < a.length && j < b.length) {
            if (a[i] > b[j]) {
                ++j;
                continue;
            }
            if (a[i] < b[j]) {
                ++i;
                continue;
            }
            if (c != null) {
                c[numCommon] = a[i];
            }
            ++i;
            ++j;
            ++numCommon;
        }
        return numCommon;
    }

    public static int commonInts(int[] ... a) {
        if (a.length == 0) {
            return 0;
        }
        if (a.length == 1) {
            return a[0].length;
        }
        if (a.length == 2) {
            return Util.commonIntsWithResult(a[0], a[1], null);
        }
        int[][] newA = (int[][])Arrays.copyOfRange(a, 1, a.length);
        int[] tmp = new int[Math.max(a[0].length, a[1].length)];
        int tmpLen = Util.commonIntsWithResult(a[0], a[1], tmp);
        newA[0] = Arrays.copyOf(tmp, tmpLen);
        return Util.commonInts(newA);
    }

    public static int[] union(int[] a, int[] b) {
        int[] c = new int[a.length + b.length];
        int i = 0;
        int j = 0;
        int k = 0;
        while (i < a.length && j < b.length) {
            if (a[i] > b[j]) {
                c[k] = b[j];
                ++j;
            } else if (a[i] < b[j]) {
                c[k] = a[i];
                ++i;
            } else {
                c[k] = a[i];
                ++i;
                ++j;
            }
            ++k;
        }
        while (i < a.length) {
            c[k++] = a[i];
            ++i;
        }
        while (j < b.length) {
            c[k++] = b[j];
            ++j;
        }
        if (k != c.length) {
            int[] nc = new int[k];
            System.arraycopy(c, 0, nc, 0, k);
            return nc;
        }
        return c;
    }

    public static int commonIntsWithUnion(int[] unionCardinality, int[] a, int[] ... b) {
        if (b == null || b.length == 0) {
            return a.length;
        }
        int[] bAll = b[0];
        for (int i = 1; i < b.length; ++i) {
            bAll = Util.union(bAll, b[i]);
        }
        unionCardinality[0] = bAll.length;
        return Util.commonInts(a, bAll);
    }

    public static CommonIntSet commonIntsSet(int[] a, int[] b) {
        CommonIntSet cis = new CommonIntSet();
        cis.common = new int[Math.min(a.length, b.length)];
        cis.numberOfCommonInts = Util.commonIntsWithResult(a, b, cis.common);
        return cis;
    }

    public static <T> T d(T t, T def) {
        return t == null ? def : t;
    }

    public static class CommonIntSet {
        public int numberOfCommonInts;
        public int[] common;
    }
}

